/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityPollenPuff;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PollenPuffSpell
extends Spell {
    private static final Vec3[] DIRS = PollenPuffSpell.dirs(16);

    private static Vec3[] dirs(int amount) {
        Vec3[] arr = new Vec3[amount];
        Vec3 dir = new Vec3(2.0, 1.0, 0.0).m_82541_();
        float step = 360.0f / (float)amount;
        for (int i = 0; i < amount; ++i) {
            arr[i] = MathUtils.rotate((Vec3)MathUtils.NORMAL_Y, (Vec3)dir, (float)((float)i * step));
        }
        return arr;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        for (Vec3 dir : DIRS) {
            EntityPollenPuff puff = new EntityPollenPuff((Level)level, entity);
            puff.m_6034_(puff.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.2, puff.m_20189_());
            puff.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 0.8f));
            puff.m_6686_(dir.m_7096_(), dir.m_7098_(), dir.m_7094_(), 0.23f, 0.0f);
            level.m_7967_((Entity)puff);
        }
        PollenPuffSpell.playSound(entity, (SoundEvent)ModSounds.SPELL_GENERIC_POOF.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

