/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SimpleVanillaProjectileSpell
extends Spell {
    public static final ProjectileFactory WITHER_SKULL = (level, entity, direction) -> new WitherSkull((Level)level, entity, direction.f_82479_, direction.f_82480_, direction.f_82481_);
    public static final ProjectileFactory GHAST_FIREBALL = (level, entity, direction) -> new LargeFireball((Level)level, entity, direction.f_82479_, direction.f_82480_, direction.f_82481_, 1);
    public static final ProjectileFactory DRAGON_FIREBALL = (level, entity, direction) -> new DragonFireball((Level)level, entity, direction.f_82479_, direction.f_82480_, direction.f_82481_);
    public static final ProjectileFactory SNOWBALL = (level, entity, direction) -> {
        Snowball snowball = new Snowball((Level)level, entity);
        snowball.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 2.0f, 1.0f);
        Vec3 vec3 = entity.m_20184_();
        snowball.m_20256_(snowball.m_20184_().m_82520_(vec3.f_82479_, entity.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
        return snowball;
    };
    private final ProjectileFactory factory;
    private final SoundEvent sound;

    public SimpleVanillaProjectileSpell(ProjectileFactory factory, SoundEvent sound) {
        this.factory = factory;
        this.sound = sound;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 target = ProjectileUtil.getAimTarget(entity);
        Vec3 dir = target != null ? target.m_82546_(entity.m_146892_()) : entity.m_20154_();
        Entity proj = this.factory.create(level, entity, dir);
        proj.m_6034_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        level.m_7967_(proj);
        SimpleVanillaProjectileSpell.playSound(entity, this.sound, 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    public static interface ProjectileFactory {
        public Entity create(ServerLevel var1, LivingEntity var2, Vec3 var3);
    }
}

