/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntitySmallRaccoonLeaf;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SmallLeafSpell
extends Spell {
    private final int amount;

    public SmallLeafSpell(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 pos = new EntitySmallRaccoonLeaf((Level)level, entity).m_20182_();
        Vec3 target = ProjectileUtil.getAimTarget(entity, pos);
        Vec3 dir = target != null ? target.m_82546_(pos) : entity.m_20154_();
        float degs = this.amount < 5 ? 25.0f : 35.0f;
        for (Vector3f vec : RayTraceUtils.rotatedVecs((Vec3)dir, (Vec3)MathUtils.NORMAL_Y, (float)(-degs), (float)degs, (float)(degs * 2.0f / (float)this.amount))) {
            EntitySmallRaccoonLeaf leaf = new EntitySmallRaccoonLeaf((Level)level, entity);
            leaf.m_6034_(leaf.m_20185_() + (double)vec.m_122239_() * 0.1, leaf.m_20186_() + (double)vec.m_122260_() * 0.1, leaf.m_20189_() + (double)vec.m_122269_() * 0.1);
            leaf.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 0.9f));
            leaf.m_6686_(vec.m_122239_(), vec.m_122260_(), vec.m_122269_(), 0.75f, 0.0f);
            level.m_7967_((Entity)leaf);
        }
        SmallLeafSpell.playSound(entity, (SoundEvent)ModSounds.ENTITY_FLOWER_LILY_STEP.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.2f);
        return true;
    }
}

