/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TeleportSpell
extends Spell {
    @Override
    public boolean use(ServerLevel world, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int level) {
        Vec3 home;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.f_19853_ instanceof ServerLevel) {
                Optional mem;
                if (mob.m_21536_() && mob.m_20238_(home = Vec3.m_82512_((Vec3i)mob.m_21534_())) > 100.0) {
                    TeleportSpell.safeTeleportTo((Entity)mob, home.m_7096_(), home.m_7098_(), home.m_7094_());
                    return true;
                }
                if (mob.m_6274_().m_21874_(MemoryModuleType.f_26359_) && (mem = mob.m_6274_().m_21952_(MemoryModuleType.f_26359_)).isPresent()) {
                    ServerLevel serverLevel;
                    Vec3 home2 = Vec3.m_82512_((Vec3i)((GlobalPos)mem.get()).m_122646_());
                    ResourceKey levelKey = ((GlobalPos)mem.get()).m_122640_();
                    if (mob.f_19853_.m_46472_() != levelKey && (serverLevel = mob.m_20194_().m_129880_(levelKey)) != null) {
                        TeleportSpell.changeDimension((Entity)mob, serverLevel, home2.m_7096_(), home2.m_7098_(), home2.m_7094_());
                        return true;
                    }
                    TeleportSpell.safeTeleportTo((Entity)mob, home2.m_7096_(), home2.m_7098_(), home2.m_7094_());
                    return true;
                }
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerLevel serverLevel;
            ResourceKey levelKey;
            ServerPlayer player = (ServerPlayer)entity;
            if (player.m_8961_() != null) {
                home = Vec3.m_82512_((Vec3i)player.m_8961_());
                levelKey = player.m_8963_();
                if (player.f_19853_.m_46472_() == levelKey && player.m_20238_(home) <= 100.0) {
                    home = Vec3.m_82512_((Vec3i)player.m_20194_().m_129783_().m_8900_());
                    levelKey = player.m_20194_().m_129783_().m_46472_();
                }
            } else {
                home = Vec3.m_82512_((Vec3i)player.m_20194_().m_129783_().m_8900_());
                levelKey = player.m_20194_().m_129783_().m_46472_();
            }
            if (player.f_19853_.m_46472_() != levelKey && (serverLevel = player.m_20194_().m_129880_(levelKey)) != null) {
                TeleportSpell.changeDimension((Entity)player, serverLevel, home.m_7096_(), home.m_7098_(), home.m_7094_());
                return true;
            }
            TeleportSpell.safeTeleportTo((Entity)player, home.m_7096_(), home.m_7098_(), home.m_7094_());
            return true;
        }
        return false;
    }

    public static void safeTeleportTo(Entity entity, double x, double y, double z) {
        AABB oldBox = entity.m_142469_();
        entity.m_6021_(x, y, z);
        entity.m_183634_();
        while (!entity.f_19853_.m_45786_(entity) && entity.m_20186_() < (double)entity.f_19853_.m_151558_()) {
            entity.m_6034_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
        }
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11852_, SoundSource.MASTER, 1.0f, 1.0f);
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 32; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_(), entity.m_20186_() + serverLevel.f_46441_.nextDouble() * 2.0, entity.m_20189_(), 0, serverLevel.f_46441_.nextGaussian(), 0.0, serverLevel.f_46441_.nextGaussian(), 1.0);
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TeleportSpell.teleportNearbyImportantEntities(player, player.m_183503_(), oldBox, x, y, z);
        }
    }

    public static void changeDimension(Entity entity, ServerLevel newLevel, double x, double y, double z) {
        float yaw = entity.m_146908_();
        float pitch = entity.m_146909_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_8127_();
            AABB oldBB = player.m_142469_();
            ServerLevel oldLvl = player.m_183503_();
            player.m_8999_(newLevel, x, y, z, yaw, pitch);
            if (player.m_5803_()) {
                player.m_6145_(true, true);
            }
            TeleportSpell.teleportNearbyImportantEntities(player, oldLvl, oldBB, x, y, z);
        } else {
            entity.m_19877_();
            Entity old = entity;
            entity = old.m_6095_().m_20615_((Level)newLevel);
            if (entity != null) {
                entity.m_20361_(old);
                entity.m_7678_(x, y, z, yaw, pitch);
                old.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                newLevel.m_143334_(entity);
            } else {
                return;
            }
        }
        while (!newLevel.m_45786_(entity) && entity.m_20186_() < (double)newLevel.m_151558_()) {
            entity.m_6034_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
        }
        newLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11852_, SoundSource.MASTER, 1.0f, 1.0f);
        for (int i = 0; i < 32; ++i) {
            newLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_(), entity.m_20186_() + newLevel.f_46441_.nextDouble() * 2.0, entity.m_20189_(), 0, newLevel.f_46441_.nextGaussian(), 0.0, newLevel.f_46441_.nextGaussian(), 1.0);
        }
    }

    private static void teleportNearbyImportantEntities(ServerPlayer player, ServerLevel oldLevel, AABB oldBox, double x, double y, double z) {
        boolean crossDim = player.m_183503_().m_46472_() != oldLevel.m_46472_();
        for (Entity e2 : oldLevel.m_142425_(EntityTypeTest.m_156916_(Mob.class), oldBox.m_82400_(24.0), e -> {
            if (e instanceof BaseMonster) {
                BaseMonster monster = (BaseMonster)e;
                return player.m_142081_().equals(monster.m_142504_()) && monster.behaviourState() == BaseMonster.Behaviour.FOLLOW;
            }
            if (e instanceof EntityNPCBase) {
                EntityNPCBase npc = (EntityNPCBase)e;
                return player.m_142081_().equals(npc.getEntityToFollowUUID());
            }
            return false;
        })) {
            if (crossDim) {
                TeleportSpell.changeDimension(e2, player.m_183503_(), x + oldLevel.f_46441_.nextDouble() * 2.0 - 1.0, y, z + oldLevel.f_46441_.nextDouble() * 2.0 - 1.0);
                continue;
            }
            TeleportSpell.safeTeleportTo(e2, x + oldLevel.f_46441_.nextDouble() * 2.0 - 1.0, y, z + oldLevel.f_46441_.nextDouble() * 2.0 - 1.0);
        }
    }
}

