/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityWaterLaser;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WaterLaserSpell
extends Spell {
    private final float range;

    public WaterLaserSpell(float range) {
        this.range = range;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        EntityWaterLaser laser = new EntityWaterLaser((Level)level, entity);
        laser.setMaxTicks(entity instanceof Player ? Mth.m_14167_((float)PlayerModelAnimations.WATER_LASER_ONE.getLength()) : 15);
        laser.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 0.95f));
        laser.setRange(this.range);
        ProjectileUtil.shoot(entity, laser, 0.0f);
        level.m_7967_((Entity)laser);
        WaterLaserSpell.playSound(entity, (SoundEvent)ModSounds.SPELL_GENERIC_WATER.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    @Override
    public AttackAction useAction() {
        return (AttackAction)((Object)ModAttackActions.WATER_LASER_USE.get());
    }
}

