/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityWindBlade;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WindBladeCircle
extends Spell {
    private final int amount;

    public WindBladeCircle(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        int angle = 360 / this.amount;
        for (int i = 0; i < this.amount; ++i) {
            EntityWindBlade wind = new EntityWindBlade((Level)level, entity);
            wind.m_6034_(wind.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.4, wind.m_20189_());
            wind.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, 0.9f));
            wind.setType(EntityWindBlade.Type.PIERCING);
            wind.shoot((Entity)entity, entity.m_146909_(), entity.m_146908_() + (float)(i * angle), 0.0f, 0.35f, 0.0f);
            level.m_7967_((Entity)wind);
        }
        WindBladeCircle.playSound(entity, (SoundEvent)ModSounds.SPELL_GENERIC_WIND.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

