/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.enums.EnumDay;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.common.network.S2CCalendar;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class CalendarImpl {
    private int date = 1;
    private EnumDay day = EnumDay.MONDAY;
    private EnumSeason season = EnumSeason.SPRING;
    private EnumWeather[] todaysForecast = new EnumWeather[]{EnumWeather.CLEAR};
    private EnumWeather currentWeather = EnumWeather.CLEAR;
    private EnumWeather[] nextForecast = new EnumWeather[]{EnumWeather.CLEAR};

    public int date() {
        return this.date;
    }

    public EnumDay currentDay() {
        return this.day;
    }

    public EnumSeason currentSeason() {
        return this.season;
    }

    public void setDateDayAndSeason(int date, EnumDay day, EnumSeason season) {
        this.date = date;
        this.day = day;
        this.season = season;
    }

    public EnumWeather currentWeather() {
        return this.currentWeather;
    }

    public EnumWeather getCurrentWeatherFor(ServerLevel level) {
        int i = WorldUtils.dayTime((Level)level) / 3000;
        if (i >= 0 && i < this.todaysForecast.length) {
            return this.todaysForecast[i];
        }
        return EnumWeather.CLEAR;
    }

    public EnumWeather[] todaysForecast() {
        return this.todaysForecast;
    }

    public EnumWeather[] tomorrowsForecast() {
        return this.nextForecast;
    }

    public void setWeather(MinecraftServer server, EnumWeather weather) {
        this.currentWeather = weather;
        Platform.INSTANCE.sendToAll(new S2CCalendar(this), server);
    }

    public void updateWeathers(EnumWeather[] nextDays) {
        this.todaysForecast = this.nextForecast;
        this.nextForecast = nextDays;
    }

    public void toPacket(FriendlyByteBuf buffer) {
        buffer.writeInt(this.date);
        buffer.m_130068_((Enum)this.day);
        buffer.m_130068_((Enum)this.season);
        buffer.m_130068_((Enum)this.currentWeather);
    }

    public void fromPacket(FriendlyByteBuf buffer) {
        this.date = buffer.readInt();
        this.day = (EnumDay)buffer.m_130066_(EnumDay.class);
        this.season = (EnumSeason)buffer.m_130066_(EnumSeason.class);
        this.currentWeather = (EnumWeather)buffer.m_130066_(EnumWeather.class);
    }

    public void read(CompoundTag nbt) {
        this.date = nbt.m_128451_("Date");
        this.day = EnumDay.valueOf(nbt.m_128461_("Day"));
        this.season = EnumSeason.valueOf(nbt.m_128461_("Season"));
        this.currentWeather = EnumWeather.valueOf(nbt.m_128461_("Weather"));
        ListTag list = nbt.m_128437_("Forecast", 8);
        this.todaysForecast = (EnumWeather[])list.stream().map(t -> EnumWeather.valueOf(t.m_7916_())).limit(8L).toArray(EnumWeather[]::new);
        ListTag next = nbt.m_128437_("NextForecast", 8);
        this.nextForecast = (EnumWeather[])next.stream().map(t -> EnumWeather.valueOf(t.m_7916_())).limit(8L).toArray(EnumWeather[]::new);
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128405_("Date", this.date);
        nbt.m_128359_("Day", this.day.toString());
        nbt.m_128359_("Season", this.season.toString());
        nbt.m_128359_("Weather", this.currentWeather.toString());
        ListTag list = new ListTag();
        Arrays.stream(this.todaysForecast).forEach(w -> list.add((Object)StringTag.m_129297_((String)w.toString())));
        nbt.m_128365_("Forecast", (Tag)list);
        ListTag next = new ListTag();
        Arrays.stream(this.nextForecast).forEach(w -> next.add((Object)StringTag.m_129297_((String)w.toString())));
        nbt.m_128365_("NextForecast", (Tag)next);
        return nbt;
    }
}

