/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Registry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class CodecHelper {
    private static final Gson GSON = Deserializers.m_78798_().create();
    public static Codec<ItemPredicate> ITEM_PREDICATE_CODEC = CodecUtils.jsonCodecBuilder(CodecHelper.nullToObj(ItemPredicate::m_45048_), ItemPredicate::m_45051_, (String)"ItemPredicate");
    public static final Codec<EntityPredicate> ENTITY_PREDICATE_CODEC = CodecUtils.jsonCodecBuilder(CodecHelper.nullToObj(EntityPredicate::m_36606_), EntityPredicate::m_36614_, (String)"EntityPredicate");
    public static final Codec<NumberProvider> NUMER_PROVIDER_CODEC = CodecUtils.jsonCodecBuilder(arg_0 -> ((Gson)GSON).toJsonTree(arg_0), e -> (NumberProvider)GSON.fromJson(e, NumberProvider.class), (String)"NumberProvider");
    public static final Codec<ItemStack> ITEM_OR_STACK = Codec.either((Codec)Registry.f_122827_.m_194605_(), (Codec)ItemStack.f_41582_).xmap(e -> (ItemStack)e.map(ItemStack::new, s -> s), l -> l.m_41782_() ? Either.right((Object)l) : Either.left((Object)l.m_41720_()));

    private static <E> Function<E, JsonElement> nullToObj(Function<E, JsonElement> encode) {
        return v -> {
            JsonElement e = (JsonElement)encode.apply(v);
            if (e.isJsonNull()) {
                return new JsonObject();
            }
            return e;
        };
    }

    public static <E> Codec<List<E>> nonEmptyList(Codec<E> codec, String error) {
        Function<List, DataResult> function = list -> {
            if (list.isEmpty()) {
                return DataResult.error((String)error);
            }
            return DataResult.success((Object)list);
        };
        return codec.listOf().flatXmap(function, function);
    }

    public static <T> Codec<List<T>> listOrSingle(Codec<T> codec) {
        return Codec.either(codec, (Codec)codec.listOf()).xmap(e -> (List)e.map(List::of, l -> l), l -> l.size() == 1 ? Either.left(l.get(0)) : Either.right((Object)l));
    }

    public static <T> Codec<List<T>> itemOrStack(Codec<T> codec) {
        return Codec.either(codec, (Codec)codec.listOf()).xmap(e -> (List)e.map(List::of, l -> l), l -> l.size() == 1 ? Either.left(l.get(0)) : Either.right((Object)l));
    }
}

