/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.entities.utils.ElementalAttackMob;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.registry.ModArmorEffects;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CombatUtils {
    private static final UUID TEMP_ATTRIBUTE_MOD = UUID.fromString("5c8e5c2d-1eb0-434a-858f-8ab81f51832c");
    private static final UUID TEMP_ATTRIBUTE_MOD_MULT = UUID.fromString("e2465d35-6c65-4ec8-a13c-a305a9d34c66");

    public static double getAttributeValue(Entity entity, Attribute att) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0;
        }
        LivingEntity attacker = (LivingEntity)entity;
        double increase = 0.0;
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            increase += Platform.INSTANCE.getPlayerData(player).map(cap -> cap.getAttributeValue((Player)attacker, att)).orElse(0.0).doubleValue();
        } else if (attacker.m_21051_(att) != null) {
            increase += attacker.m_21133_(att);
        }
        int inc = (int)increase;
        double restRound = (double)Math.round((increase - (double)inc) * 2.0) / 2.0;
        return (double)inc + restRound;
    }

    public static Attribute opposing(Attribute att) {
        if (att == ModAttributes.PARA.get()) {
            return (Attribute)ModAttributes.RES_PARA.get();
        }
        if (att == ModAttributes.POISON.get()) {
            return (Attribute)ModAttributes.RES_POISON.get();
        }
        if (att == ModAttributes.SEAL.get()) {
            return (Attribute)ModAttributes.RES_SEAL.get();
        }
        if (att == ModAttributes.SLEEP.get()) {
            return (Attribute)ModAttributes.RES_SLEEP.get();
        }
        if (att == ModAttributes.FATIGUE.get()) {
            return (Attribute)ModAttributes.RES_FAT.get();
        }
        if (att == ModAttributes.COLD.get()) {
            return (Attribute)ModAttributes.RES_COLD.get();
        }
        if (att == ModAttributes.DIZZY.get()) {
            return (Attribute)ModAttributes.RES_DIZZY.get();
        }
        if (att == ModAttributes.CRIT.get()) {
            return (Attribute)ModAttributes.RES_CRIT.get();
        }
        if (att == ModAttributes.STUN.get()) {
            return (Attribute)ModAttributes.RES_STUN.get();
        }
        if (att == ModAttributes.FAINT.get()) {
            return (Attribute)ModAttributes.RES_FAINT.get();
        }
        if (att == ModAttributes.DRAIN.get()) {
            return (Attribute)ModAttributes.RES_DRAIN.get();
        }
        return null;
    }

    public static EnumSkills matchingSkill(Attribute att) {
        if (att == ModAttributes.PARA.get()) {
            return EnumSkills.RES_PARA;
        }
        if (att == ModAttributes.POISON.get()) {
            return EnumSkills.RES_POISON;
        }
        if (att == ModAttributes.SEAL.get()) {
            return EnumSkills.RES_SEAL;
        }
        if (att == ModAttributes.SLEEP.get()) {
            return EnumSkills.RES_SLEEP;
        }
        if (att == ModAttributes.FATIGUE.get()) {
            return EnumSkills.RES_FATIGUE;
        }
        if (att == ModAttributes.COLD.get()) {
            return EnumSkills.RES_COLD;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static double statusEffectValue(LivingEntity entity, Attribute att, Entity target) {
        value = CombatUtils.getAttributeValue((Entity)entity, att) * 0.01;
        opposing = CombatUtils.opposing(att);
        if (!(target instanceof LivingEntity)) ** GOTO lbl-1000
        livingTarget = (LivingEntity)target;
        if (opposing != null) {
            v0 = CombatUtils.getAttributeValue((Entity)livingTarget, opposing);
        } else lbl-1000:
        // 2 sources

        {
            v0 = res = 0.0;
        }
        if (target instanceof Player) {
            player = (Player)target;
            matchingSkill = CombatUtils.matchingSkill(att);
            if (matchingSkill != null) {
                res += Platform.INSTANCE.getPlayerData(player).map((Function<PlayerData, Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$statusEffectValue$1(io.github.flemmli97.runecraftory.api.enums.EnumSkills io.github.flemmli97.runecraftory.common.attachment.player.PlayerData ), (Lio/github/flemmli97/runecraftory/common/attachment/player/PlayerData;)Ljava/lang/Double;)((EnumSkills)matchingSkill)).orElse(0.0).doubleValue();
            }
        }
        return value * (1.0 - (res *= 0.01));
    }

    public static float reduceDamageFromStats(LivingEntity entity, DamageSource source, float amount) {
        boolean ignoreDefence;
        if (ArmorEffect.hasArmorEffect(entity, (ArmorEffect)((Object)ModArmorEffects.SHIELD_RING.get())) && (double)entity.m_21187_().nextFloat() < 0.1) {
            return 1.0f;
        }
        float reduce = 0.0f;
        switch (GeneralConfig.defenceSystem) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NO_DEFENCE: {
                boolean bl = true;
                break;
            }
            case VANILLA_IGNORE: {
                boolean bl;
                if (!(source instanceof CustomDamage)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_MOBS: {
                boolean bl;
                if (!(source instanceof CustomDamage) && source.m_7639_() instanceof Mob) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER_ATT: {
                boolean bl;
                if (!(source instanceof CustomDamage) && source.m_7639_() instanceof Player) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER_HURT: {
                boolean bl;
                if (!(source instanceof CustomDamage) && entity instanceof Player) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER: {
                boolean bl = ignoreDefence = !(source instanceof CustomDamage) && (entity instanceof Player || source.m_7639_() instanceof Player);
            }
        }
        if (!ignoreDefence) {
            if (source.m_19387_()) {
                if (!source.m_19379_()) {
                    reduce = (float)CombatUtils.getAttributeValue((Entity)entity, (Attribute)ModAttributes.MAGIC_DEFENCE.get());
                }
            } else if (!source.m_19376_()) {
                reduce = (float)CombatUtils.getAttributeValue((Entity)entity, (Attribute)ModAttributes.DEFENCE.get());
            }
        }
        float dmg = amount - reduce;
        if ((double)reduce > (double)amount * 0.8) {
            dmg = (float)Math.max(0.05 * (double)amount, (double)amount * 0.2 * Math.pow(0.997, (double)reduce - (double)amount * 0.8));
        }
        if (source instanceof CustomDamage) {
            CustomDamage custom = (CustomDamage)source;
            if (GeneralConfig.randomDamage && !custom.fixedDamage()) {
                dmg = (float)((double)dmg + entity.f_19853_.f_46441_.nextGaussian() * (double)dmg / 10.0);
            }
        }
        return CombatUtils.elementalReduction(entity, source, dmg);
    }

    public static float elementalReduction(LivingEntity entity, DamageSource source, float amount) {
        if (source instanceof CustomDamage && ((CustomDamage)source).getElement() != EnumElement.NONE) {
            EnumElement element = ((CustomDamage)source).getElement();
            double percent = 0.0;
            switch (element) {
                case DARK: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Attribute)ModAttributes.RES_DARK.get());
                    break;
                }
                case EARTH: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Attribute)ModAttributes.RES_EARTH.get());
                    break;
                }
                case FIRE: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Attribute)ModAttributes.RES_FIRE.get());
                    break;
                }
                case LIGHT: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Attribute)ModAttributes.RES_LIGHT.get());
                    break;
                }
                case LOVE: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Attribute)ModAttributes.RES_LOVE.get());
                    break;
                }
                case WATER: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Attribute)ModAttributes.RES_WATER.get());
                    break;
                }
                case WIND: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Attribute)ModAttributes.RES_WIND.get());
                    break;
                }
            }
            amount = percent < 0.0 ? (float)((double)amount * (1.0 + Math.abs(percent) / 100.0)) : (percent > 100.0 ? (float)((double)amount * -((percent - 100.0) / 100.0)) : (float)((double)amount * (1.0 - percent / 100.0)));
        }
        return amount;
    }

    public static void knockBackEntity(LivingEntity attacker, LivingEntity entity, float strength) {
        Vec3 distVec = entity.m_20182_().m_82546_(attacker.m_20182_()).m_82541_();
        CombatUtils.knockbackEntityIgnoreResistance(entity, strength, -distVec.f_82479_, -distVec.f_82481_);
    }

    public static void knockbackEntityIgnoreResistance(LivingEntity entity, double strength, double x, double z) {
        if (!entity.m_6095_().m_204039_(RunecraftoryTags.BOSSES)) {
            CombatUtils.applyTempAttribute(entity, Attributes.f_22278_, -entity.m_21133_(Attributes.f_22278_));
        }
        entity.m_147240_(strength, x, z);
        if (!entity.m_6095_().m_204039_(RunecraftoryTags.BOSSES)) {
            CombatUtils.removeTempAttribute(entity, Attributes.f_22278_);
        }
    }

    public static void knockBack(LivingEntity entity, CustomDamage source) {
        if (source.getKnockBackType() == CustomDamage.KnockBackType.NONE) {
            return;
        }
        Entity attacker = source.m_7639_();
        float strength = source.knockAmount();
        if ((strength = (float)((double)strength * (1.0 - entity.m_21133_(Attributes.f_22278_)))) == 0.0f) {
            return;
        }
        double xRatio = 0.0;
        double zRatio = 0.0;
        double yRatio = strength;
        if (attacker != null) {
            switch (source.getKnockBackType()) {
                case BACK: {
                    Vec3 distVec = entity.m_20182_().m_82546_(attacker.m_20182_()).m_82541_();
                    xRatio = distVec.f_82479_;
                    zRatio = distVec.f_82481_;
                    break;
                }
                case VANILLA: {
                    xRatio = Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180)));
                    zRatio = -Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)));
                    break;
                }
            }
        }
        if (source.getKnockBackType() == CustomDamage.KnockBackType.VANILLA) {
            entity.m_147240_((double)strength, xRatio, zRatio);
        } else {
            Vec3 mot = entity.m_20184_();
            double y = mot.f_82480_;
            entity.f_19812_ = true;
            if (xRatio != 0.0 || zRatio != 0.0) {
                float f = (float)Math.sqrt(xRatio * xRatio + zRatio * zRatio);
                mot = mot.m_82490_(0.5).m_82520_(xRatio / (double)f * (double)strength, 0.0, zRatio / (double)f * (double)strength);
            }
            if (source.getKnockBackType() != CustomDamage.KnockBackType.UP) {
                if (entity.m_20096_()) {
                    y /= 2.0;
                    if ((y += (double)strength) > (double)0.4f) {
                        y = 0.4f;
                    }
                }
            } else if (yRatio != 0.0) {
                y = yRatio;
            }
            entity.m_20256_(new Vec3(mot.f_82479_, y, mot.f_82481_));
        }
    }

    public static boolean playerAttackWithItem(Player player, Entity target, boolean resetCooldown, boolean levelSkill) {
        return CombatUtils.playerAttackWithItem(player, target, player.m_21205_(), 1.0f, resetCooldown, levelSkill);
    }

    public static boolean playerAttackWithItem(Player player, Entity target, ItemStack stack, float damageModifier, boolean resetCooldown, boolean levelSkill) {
        double damagePhys;
        if (target.m_6097_() && !target.m_7313_((Entity)player) && player.m_36335_().m_41521_(stack.m_41720_(), 0.0f) <= 0.0f && (damagePhys = CombatUtils.getAttributeValue((Entity)player, Attributes.f_22281_) * (double)damageModifier) > 0.0) {
            IItemUsable usable;
            Item item;
            boolean playSound = false;
            if (resetCooldown && (item = stack.m_41720_()) instanceof IItemUsable && (usable = (IItemUsable)item).hasCooldown()) {
                player.m_36335_().m_41524_(stack.m_41720_(), Mth.m_14165_((double)(20.0 * ItemNBT.attackSpeedModifier((LivingEntity)player))));
                playSound = true;
            }
            boolean faintChance = player.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue((LivingEntity)player, (Attribute)ModAttributes.FAINT.get(), target);
            boolean critChance = player.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue((LivingEntity)player, (Attribute)ModAttributes.CRIT.get(), target);
            CustomDamage.DamageType damageType = CustomDamage.DamageType.NORMAL;
            if (faintChance) {
                damageType = CustomDamage.DamageType.FAINT;
            } else if (critChance) {
                damageType = CustomDamage.DamageType.IGNOREDEF;
            }
            double knockbackAtt = CombatUtils.statusEffectValue((LivingEntity)player, (Attribute)ModAttributes.KNOCK.get(), target);
            int i = player.m_20142_() ? 1 : 0;
            float knockback = (float)((double)((float)(i += EnchantmentHelper.m_44894_((LivingEntity)player)) * 0.5f) + knockbackAtt * 3.0);
            if (ItemNBT.doesFixedOneDamage(stack)) {
                damageType = CustomDamage.DamageType.FIXED;
                damagePhys = 1.0;
            }
            CustomDamage.Builder source = new CustomDamage.Builder((Entity)player).element(ItemNBT.getElement(stack)).damageType(damageType).knock(CustomDamage.KnockBackType.VANILLA).knockAmount(knockback).hurtResistant(0);
            Vec3 targetMot = target.m_20184_();
            if (CombatUtils.damageWithFaintAndCrit((Entity)player, target, source, damagePhys, stack)) {
                ServerPlayer serverPlayer;
                if (levelSkill && player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CombatUtils.hitEntityWithItemPlayer(serverPlayer, stack);
                }
                if (i > 0) {
                    player.m_20256_(player.m_20184_().m_82542_(0.6, 1.0, 0.6));
                    player.m_6858_(false);
                }
                if (target instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)target;
                    if (target.f_19864_) {
                        serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket(target));
                        target.f_19864_ = false;
                        target.m_20256_(targetMot);
                    }
                }
                if (critChance) {
                    if (playSound) {
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12313_, player.m_5720_(), 1.0f, 1.0f);
                    }
                    player.m_5704_(target);
                    player.m_5700_(target);
                } else {
                    IAOEWeapon aoe;
                    Item item2 = stack.m_41720_();
                    if (item2 instanceof IAOEWeapon && (aoe = (IAOEWeapon)item2).getWidth((LivingEntity)player, stack) == 0.0f && playSound) {
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12316_, player.m_5720_(), 1.0f, 1.0f);
                    } else if (playSound) {
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
                    }
                }
            } else if (playSound) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12315_, player.m_5720_(), 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public static boolean mobAttack(LivingEntity attacker, Entity target) {
        ItemStack stack = attacker.m_21205_();
        CustomDamage.Builder source = new CustomDamage.Builder((Entity)attacker).hurtResistant(5).element(ItemNBT.getElement(stack));
        return CombatUtils.mobAttack(attacker, target, source);
    }

    public static boolean mobAttack(LivingEntity attacker, Entity target, CustomDamage.Builder source) {
        ItemStack stack = attacker.m_21205_();
        double damagePhys = CombatUtils.getAttributeValue((Entity)attacker, Attributes.f_22281_);
        Level level = attacker.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((Spell)((Object)ModSpells.STAFF_CAST.get())).use(serverLevel, attacker, stack);
        }
        if (ItemNBT.doesFixedOneDamage(stack)) {
            source.damageType(CustomDamage.DamageType.FIXED);
            damagePhys = 1.0;
        }
        return CombatUtils.mobAttack(attacker, target, source, damagePhys);
    }

    public static boolean mobAttack(LivingEntity attacker, Entity target, CustomDamage.Builder source, double dmg) {
        if (target.f_19853_.m_46791_() == Difficulty.PEACEFUL && target instanceof Player) {
            return false;
        }
        if (dmg > 0.0) {
            ElementalAttackMob mob;
            EnumElement element;
            if (attacker instanceof ElementalAttackMob && (element = (mob = (ElementalAttackMob)attacker).getAttackElement()) != null) {
                source.element(element);
            }
            return CombatUtils.damageWithFaintAndCrit((Entity)attacker, target, source, dmg, null);
        }
        return false;
    }

    public static boolean damageWithFaintAndCrit(@Nullable Entity attacker, Entity target, CustomDamage.Builder builder, double damage, @Nullable ItemStack stack) {
        return CombatUtils.damage(attacker, target, builder, damage, stack, true, true);
    }

    public static boolean damage(@Nullable Entity attacker, Entity target, CustomDamage.Builder builder, double damage, @Nullable ItemStack stack, boolean allowCrit, boolean allowFaint) {
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            builder.getAttributesChanges().forEach((att, val) -> CombatUtils.applyTempAttribute(livingAttacker, att, val));
            if (allowFaint && livingAttacker.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue(livingAttacker, (Attribute)ModAttributes.FAINT.get(), target)) {
                builder.damageType(CustomDamage.DamageType.FAINT);
            } else if (allowCrit && livingAttacker.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue(livingAttacker, (Attribute)ModAttributes.CRIT.get(), target)) {
                switch (builder.getDamageType()) {
                    case MAGIC: {
                        builder.damageType(CustomDamage.DamageType.IGNOREMAGICDEF);
                        break;
                    }
                    case NORMAL: {
                        builder.damageType(CustomDamage.DamageType.IGNOREDEF);
                    }
                }
            }
            if (builder.calculateKnockback()) {
                double knockbackAtt = CombatUtils.statusEffectValue(livingAttacker, (Attribute)ModAttributes.KNOCK.get(), target);
                int i = livingAttacker.m_20142_() ? 1 : 0;
                float knockback = (float)((double)((float)(i += EnchantmentHelper.m_44894_((LivingEntity)livingAttacker)) * 0.5f) + knockbackAtt * 3.0);
                builder.knockAmount(knockback);
            }
        }
        CustomDamage source = builder.get();
        float dmg = (float)damage;
        if (source.criticalDamage()) {
            dmg = Float.MAX_VALUE;
        } else if (!source.fixedDamage()) {
            dmg = CombatUtils.modifyDmgElement(source.getElement(), target, dmg);
        }
        boolean success = source.hurtEntity(target, dmg);
        if (success) {
            CombatUtils.spawnElementalParticle(target, source.getElement());
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                livingAttacker.m_21335_(target);
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                CombatUtils.knockBack(livingTarget, source);
                if (attacker instanceof LivingEntity) {
                    LivingEntity livingAttacker = (LivingEntity)attacker;
                    CombatUtils.applyStatusEffects(livingAttacker, livingTarget);
                    EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)livingAttacker);
                    if (stack != null && livingAttacker instanceof Player) {
                        Player player = (Player)livingAttacker;
                        ItemStack beforeHitCopy = stack.m_41777_();
                        stack.m_41640_(livingTarget, player);
                        if (stack.m_41619_()) {
                            Platform.INSTANCE.destroyItem(player, beforeHitCopy, InteractionHand.MAIN_HAND);
                            livingAttacker.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                        }
                    }
                }
            }
            CombatUtils.elementalEffects(attacker, source.getElement(), target);
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            source.getAttributesChange().forEach((att, val) -> CombatUtils.removeTempAttribute(livingAttacker, att));
        }
        return success;
    }

    public static float modifyDmgElement(EnumElement element, Entity target, float dmg) {
        LivingEntity living;
        if (!(target instanceof IBaseMob) && !(target instanceof Player) && element == EnumElement.WATER && target instanceof LivingEntity && ((living = (LivingEntity)target).m_5825_() || living.m_6126_())) {
            dmg = (float)((double)dmg * 1.1);
        }
        return dmg;
    }

    public static void elementalEffects(Entity attacker, EnumElement element, Entity target) {
        if (!(target instanceof IBaseMob) && !(target instanceof Player)) {
            switch (element) {
                case FIRE: {
                    target.m_20254_(3);
                    break;
                }
                case DARK: {
                    if (!(target instanceof LivingEntity)) break;
                    LivingEntity living = (LivingEntity)target;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200));
                    break;
                }
                case WIND: {
                    if (!(target instanceof LivingEntity)) break;
                    LivingEntity living = (LivingEntity)target;
                    if (attacker == null) break;
                    living.m_147240_(1.5, (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
                    break;
                }
                case WATER: {
                    if (!(target instanceof LivingEntity)) break;
                    LivingEntity living = (LivingEntity)target;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200));
                }
            }
        }
    }

    public static void applyStatusEffects(LivingEntity attackingEntity, LivingEntity target) {
        ServerPlayer player;
        boolean poisonChance = attackingEntity.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Attribute)ModAttributes.POISON.get(), (Entity)target);
        boolean sleepChance = attackingEntity.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Attribute)ModAttributes.SLEEP.get(), (Entity)target);
        boolean fatigueChance = attackingEntity.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Attribute)ModAttributes.FATIGUE.get(), (Entity)target);
        boolean coldChance = attackingEntity.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Attribute)ModAttributes.COLD.get(), (Entity)target);
        boolean paraChance = attackingEntity.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Attribute)ModAttributes.PARA.get(), (Entity)target);
        boolean sealChance = attackingEntity.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Attribute)ModAttributes.SEAL.get(), (Entity)target);
        boolean dizzyChance = attackingEntity.f_19853_.f_46441_.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Attribute)ModAttributes.DIZZY.get(), (Entity)target);
        double stunAmount = CombatUtils.statusEffectValue(attackingEntity, (Attribute)ModAttributes.STUN.get(), (Entity)target);
        if (poisonChance) {
            EntityUtils.applyPermanentEffect(target, (MobEffect)ModEffects.POISON.get(), 0);
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_POISON, 5.0f));
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_POISON, 15.0f));
            }
        }
        if (fatigueChance) {
            EntityUtils.applyPermanentEffect(target, (MobEffect)ModEffects.FATIGUE.get(), 0);
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_FATIGUE, 5.0f));
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_FATIGUE, 15.0f));
            }
        }
        if (coldChance) {
            EntityUtils.applyPermanentEffect(target, (MobEffect)ModEffects.COLD.get(), 0);
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_COLD, 5.0f));
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_COLD, 15.0f));
            }
        }
        if (paraChance) {
            EntityUtils.applyPermanentEffect(target, (MobEffect)ModEffects.PARALYSIS.get(), 0);
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_PARA, 5.0f));
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_PARA, 15.0f));
            }
        }
        if (sealChance) {
            EntityUtils.applyPermanentEffect(target, (MobEffect)ModEffects.SEAL.get(), 0);
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_SEAL, 5.0f));
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_SEAL, 15.0f));
            }
        }
        if (dizzyChance) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 80, 1, true, false));
        }
        if (stunAmount > 0.1 && attackingEntity.f_19853_.f_46441_.nextDouble() < stunAmount) {
            target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUNNED.get(), Mth.m_14107_((double)(Math.min(1.0, stunAmount) * 50.0)), 0, true, false));
        }
        if (sleepChance) {
            target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SLEEP.get(), 80, 0, true, false));
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_SLEEP, 5.0f));
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.RES_SLEEP, 15.0f));
            }
        }
    }

    public static void spawnElementalParticle(Entity target, EnumElement element) {
        Level level = target.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int color = 0xFFFFFF;
            switch (element) {
                case DARK: {
                    color = 1774399;
                    break;
                }
                case EARTH: {
                    color = 9201679;
                    break;
                }
                case FIRE: {
                    color = 12846855;
                    break;
                }
                case LIGHT: {
                    color = 0xFFFF47;
                    break;
                }
                case LOVE: {
                    color = 16221146;
                    break;
                }
                case WATER: {
                    color = 2781149;
                    break;
                }
                case WIND: {
                    color = 2204954;
                    break;
                }
            }
            double r = (double)(color >> 16 & 0xFF) / 255.0;
            double g = (double)(color >> 8 & 0xFF) / 255.0;
            double b = (double)(color & 0xFF) / 255.0;
            Random rand = new Random();
            for (int i = 0; i < 7; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123811_, target.m_20185_() + (rand.nextDouble() - 0.5) * (double)target.m_20205_(), target.m_20186_() + 0.3 + rand.nextDouble() * (double)target.m_20206_(), target.m_20189_() + (rand.nextDouble() - 0.5) * (double)target.m_20205_(), 0, r, g, b, 1.0);
            }
        }
    }

    public static void applyTempAttribute(LivingEntity entity, Attribute att, double val) {
        AttributeInstance inst = entity.m_21051_(att);
        if (inst != null && inst.m_22111_(TEMP_ATTRIBUTE_MOD) == null) {
            inst.m_22118_(new AttributeModifier(TEMP_ATTRIBUTE_MOD, "temp_mod", val, AttributeModifier.Operation.ADDITION));
        }
    }

    public static void applyTempAttributeMult(LivingEntity entity, Attribute att, double val) {
        AttributeInstance inst = entity.m_21051_(att);
        if (inst != null && inst.m_22111_(TEMP_ATTRIBUTE_MOD_MULT) == null) {
            inst.m_22118_(new AttributeModifier(TEMP_ATTRIBUTE_MOD_MULT, "temp_mod_mult", val - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public static void removeTempAttribute(LivingEntity entity, Attribute att) {
        AttributeInstance inst = entity.m_21051_(att);
        if (inst != null) {
            inst.m_22120_(TEMP_ATTRIBUTE_MOD);
            inst.m_22120_(TEMP_ATTRIBUTE_MOD_MULT);
        }
    }

    public static void hitEntityWithItemPlayer(ServerPlayer player, ItemStack stack) {
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)player).orElse(null);
        if (data == null) {
            return;
        }
        if (stack.m_41720_() instanceof ItemStaffBase) {
            switch (ItemNBT.getElement(stack)) {
                case WATER: {
                    LevelCalc.levelSkill(player, data, EnumSkills.WATER, 3.0f);
                    break;
                }
                case EARTH: {
                    LevelCalc.levelSkill(player, data, EnumSkills.EARTH, 3.0f);
                    break;
                }
                case WIND: {
                    LevelCalc.levelSkill(player, data, EnumSkills.WIND, 3.0f);
                    break;
                }
                case FIRE: {
                    LevelCalc.levelSkill(player, data, EnumSkills.FIRE, 3.0f);
                    break;
                }
                case LIGHT: {
                    LevelCalc.levelSkill(player, data, EnumSkills.LIGHT, 3.0f);
                    break;
                }
                case DARK: {
                    LevelCalc.levelSkill(player, data, EnumSkills.DARK, 3.0f);
                    break;
                }
                case LOVE: {
                    LevelCalc.levelSkill(player, data, EnumSkills.LOVE, 3.0f);
                }
            }
            return;
        }
        if (stack.m_204117_(RunecraftoryTags.SHORTSWORDS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.SHORTSWORD, 2.0f);
        }
        if (stack.m_204117_(RunecraftoryTags.LONGSWORDS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.LONGSWORD, 4.0f);
        }
        if (stack.m_204117_(RunecraftoryTags.SPEARS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.SPEAR, 3.0f);
        }
        if (stack.m_204117_(RunecraftoryTags.AXES) || stack.m_204117_(RunecraftoryTags.HAMMERS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.HAMMERAXE, 5.0f);
        }
        if (stack.m_204117_(RunecraftoryTags.DUALBLADES)) {
            LevelCalc.levelSkill(player, data, EnumSkills.DUAL, 2.0f);
        }
        if (stack.m_204117_(RunecraftoryTags.FISTS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.FIST, 2.0f);
        }
        if (stack.m_204117_(RunecraftoryTags.AXE_TOOLS) || stack.m_204117_(RunecraftoryTags.HAMMER_TOOLS)) {
            LevelCalc.levelSkill(player, data, EnumSkills.HAMMERAXE, 1.0f);
        }
        if (stack.m_204117_(RunecraftoryTags.HOES) || stack.m_204117_(RunecraftoryTags.WATERINGCANS) || stack.m_204117_(RunecraftoryTags.SICKLES)) {
            LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 1.0f);
        }
    }

    public static double getRange(LivingEntity entity, double bonus) {
        return EntityUtils.tryGetAttribute(entity, (Attribute)ModAttributes.ATTACK_RANGE.get()) + bonus;
    }

    public static double getWidth(LivingEntity entity, double bonus) {
        return EntityUtils.tryGetAttribute(entity, (Attribute)ModAttributes.ATTACK_WIDTH.get()) + bonus;
    }

    public static int getSpellLevelFromStack(ItemStack stack) {
        if (stack.m_41720_() instanceof ItemSpell) {
            return ItemNBT.itemLevel(stack);
        }
        return 1;
    }

    public static double getAbilityDamageBonus(ItemStack stack) {
        return CombatUtils.getAbilityDamageBonus(CombatUtils.getSpellLevelFromStack(stack), 1.0f);
    }

    public static double getAbilityDamageBonus(ItemStack stack, float origin) {
        return CombatUtils.getAbilityDamageBonus(CombatUtils.getSpellLevelFromStack(stack), origin);
    }

    public static float getAbilityDamageBonus(int level, float origin) {
        return origin * (1.0f + (float)(level - 1) * 0.025f);
    }

    public static Vec3 fromRelativeVector(Entity entity, Vec3 relative) {
        return CombatUtils.fromRelativeVector(entity.m_146908_(), relative);
    }

    public static Vec3 fromRelativeVector(float yRot, Vec3 relative) {
        Vec3 vec3 = relative.m_82541_();
        float f = Mth.m_14031_((float)(yRot * ((float)Math.PI / 180)));
        float g = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
        return new Vec3(vec3.f_82479_ * (double)g - vec3.f_82481_ * (double)f, vec3.f_82480_, vec3.f_82481_ * (double)g + vec3.f_82479_ * (double)f);
    }

    public static boolean canPerform(LivingEntity entity, EnumSkills skill, int requiredLvl) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        return player.m_7500_() || Platform.INSTANCE.getPlayerData(player).map(d -> d.getSkillLevel(skill).getLevel() >= requiredLvl).orElse(false) != false;
    }

    private static /* synthetic */ Double lambda$statusEffectValue$1(EnumSkills matchingSkill, PlayerData d) {
        return (double)d.getSkillLevel(matchingSkill).getLevel() * 0.005;
    }

    public static interface FloatMap {
        public float get(float var1);
    }

    public static class EntityAttack {
        private final LivingEntity attacker;
        private Predicate<LivingEntity> targetPred;
        private final Map<Attribute, Double> bonusAttributes = new HashMap<Attribute, Double>();
        private final Map<Attribute, Double> bonusAttributesMultiplier = new HashMap<Attribute, Double>();
        private Consumer<LivingEntity> onSuccess;
        private SoundEvent soundToPlay;
        private final BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> targets;

        protected EntityAttack(LivingEntity attacker, BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> targets) {
            this.attacker = attacker;
            this.targets = targets;
        }

        public static EntityAttack create(LivingEntity attacker, BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> targets) {
            return new EntityAttack(attacker, targets);
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> circleTargets(float startRot, float endRot, float rangeBonus) {
            return EntityAttack.circleTargets(startRot, endRot, null, rangeBonus);
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> circleTargets(float startRot, float endRot, FloatMap xRot, float rangeBonus) {
            return (attacker, predicate) -> {
                double reach = CombatUtils.getRange(attacker, rangeBonus);
                double incHalf = Math.asin(0.5 / reach) * 57.2957763671875;
                float minYRot = Math.min(startRot, endRot);
                float maxYRot = Math.max(startRot, endRot);
                AABB aabb = new AABB(-0.5, -0.02, 0.0, 0.5, (double)attacker.m_20206_() + 0.02, reach);
                int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
                float inc = (maxYRot - minYRot) / (float)rotationSteps;
                HashSet entities = new HashSet();
                for (int steps = 0; steps <= rotationSteps; ++steps) {
                    float yRot = minYRot + inc * (float)steps;
                    OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, xRot == null ? 0.0f : xRot.get((float)steps / (float)rotationSteps), attacker.m_20182_());
                    entities.addAll(RayTraceUtils.getEntitiesIn((LivingEntity)attacker, (OrientedBoundingBox)obb, (boolean)false, (EntityTypeTest)EntityTypeTest.m_156916_(LivingEntity.class), (Predicate)predicate));
                    S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)attacker);
                }
                return entities;
            };
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> circleTargetsFixedRange(float startRot, float endRot, float reach) {
            return (attacker, predicate) -> {
                double incHalf = Math.asin(0.5 / (double)reach) * 57.2957763671875;
                float minYRot = Math.min(startRot, endRot);
                float maxYRot = Math.max(startRot, endRot);
                AABB aabb = new AABB(-0.5, -0.02, 0.0, 0.5, (double)attacker.m_20206_() + 0.02, (double)reach);
                int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
                float inc = (maxYRot - minYRot) / (float)rotationSteps;
                HashSet entities = new HashSet();
                for (int steps = 0; steps <= rotationSteps; ++steps) {
                    float yRot = minYRot + inc * (float)steps;
                    OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, 0.0f, attacker.m_20182_());
                    entities.addAll(RayTraceUtils.getEntitiesIn((LivingEntity)attacker, (OrientedBoundingBox)obb, (boolean)false, (EntityTypeTest)EntityTypeTest.m_156916_(LivingEntity.class), (Predicate)predicate));
                    S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)attacker);
                }
                return entities;
            };
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> aabbTargets(AABB aabb) {
            return EntityAttack.aabbTargets(aabb, true);
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> aabbTargets(AABB aabb, boolean relative) {
            return (attacker, predicate) -> {
                OrientedBoundingBox obb = new OrientedBoundingBox(relative ? aabb.m_82383_(attacker.m_20182_().m_82490_(-1.0)) : aabb, attacker.m_146908_(), 0.0f, attacker.m_20182_());
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)attacker);
                return RayTraceUtils.getEntitiesIn((LivingEntity)attacker, (OrientedBoundingBox)obb, (boolean)true, (EntityTypeTest)EntityTypeTest.m_156916_(LivingEntity.class), (Predicate)predicate);
            };
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> obbTargets(float yRot, float xRot, double width, double range, boolean fixed) {
            return (attacker, predicate) -> {
                double reach = fixed ? range : CombatUtils.getRange(attacker, range);
                AABB aabb = new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)attacker.m_20206_(), reach);
                OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, -xRot, attacker.m_20182_());
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)attacker);
                return RayTraceUtils.getEntitiesIn((LivingEntity)attacker, (OrientedBoundingBox)obb, (boolean)false, (EntityTypeTest)EntityTypeTest.m_156916_(LivingEntity.class), (Predicate)predicate);
            };
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> obbTargets(OrientedBoundingBox obb) {
            return (attacker, predicate) -> {
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)attacker);
                return RayTraceUtils.getEntitiesIn((LivingEntity)attacker, (OrientedBoundingBox)obb, (boolean)false, (EntityTypeTest)EntityTypeTest.m_156916_(LivingEntity.class), (Predicate)predicate);
            };
        }

        public EntityAttack withTargetPredicate(Predicate<LivingEntity> targetPred) {
            this.targetPred = targetPred;
            return this;
        }

        public EntityAttack withBonusAttributes(Attribute att, double val) {
            this.bonusAttributes.put(att, val);
            return this;
        }

        public EntityAttack withBonusAttributesMultiplier(Attribute att, double val) {
            this.bonusAttributesMultiplier.put(att, val);
            return this;
        }

        public EntityAttack doOnSuccess(Consumer<LivingEntity> onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        public EntityAttack withAttackSound(SoundEvent sound) {
            this.soundToPlay = sound;
            return this;
        }

        public Collection<LivingEntity> executeAttack() {
            LivingEntity livingEntity;
            if (this.attacker.f_19853_.f_46443_) {
                return List.of();
            }
            LivingEntity livingEntity2 = this.attacker;
            if (livingEntity2 instanceof TargetableOpponent) {
                TargetableOpponent pred = (TargetableOpponent)livingEntity2;
                this.targetPred = this.targetPred == null ? pred.validTargetPredicate() : pred.validTargetPredicate().and(this.targetPred);
            }
            Collection<LivingEntity> list = this.targets.apply(this.attacker, this.targetPred);
            this.bonusAttributes.forEach((att, val) -> CombatUtils.applyTempAttribute(this.attacker, att, val));
            this.bonusAttributesMultiplier.forEach((att, val) -> CombatUtils.applyTempAttributeMult(this.attacker, att, val));
            LivingEntity livingEntity3 = this.attacker;
            if (livingEntity3 instanceof Mob) {
                Mob mob = (Mob)livingEntity3;
                livingEntity = mob.m_5448_();
            } else {
                livingEntity = null;
            }
            LivingEntity target = livingEntity;
            for (LivingEntity livingEntity4 : list) {
                boolean flag = false;
                if (target != livingEntity4 && this.attacker.m_20202_() == livingEntity4) continue;
                LivingEntity livingEntity5 = this.attacker;
                if (livingEntity5 instanceof Player) {
                    Player player = (Player)livingEntity5;
                    flag = CombatUtils.playerAttackWithItem(player, (Entity)livingEntity4, false, false);
                } else {
                    livingEntity5 = this.attacker;
                    if (livingEntity5 instanceof Mob) {
                        Mob mob = (Mob)livingEntity5;
                        flag = mob.m_7327_((Entity)livingEntity4);
                    }
                }
                if (!flag) continue;
                if (this.onSuccess != null) {
                    this.onSuccess.accept(livingEntity4);
                }
                if (this.soundToPlay == null) continue;
                this.attacker.f_19853_.m_6263_(null, this.attacker.m_20185_(), this.attacker.m_20186_(), this.attacker.m_20189_(), this.soundToPlay, this.attacker.m_5720_(), 1.0f, 1.0f);
            }
            this.bonusAttributes.forEach((att, val) -> CombatUtils.removeTempAttribute(this.attacker, att));
            this.bonusAttributesMultiplier.forEach((att, val) -> CombatUtils.removeTempAttribute(this.attacker, att));
            return list;
        }
    }
}

