/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.inventory.PlayerContainerInv;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class CraftingUtils {
    public static final Random RAND = new Random();

    public static RecipeType<SextupleRecipe> getType(EnumCrafting type) {
        return switch (type) {
            case EnumCrafting.FORGE -> (RecipeType)ModCrafting.FORGE.get();
            case EnumCrafting.ARMOR -> (RecipeType)ModCrafting.ARMOR.get();
            case EnumCrafting.CHEM -> (RecipeType)ModCrafting.CHEMISTRY.get();
            default -> (RecipeType)ModCrafting.COOKING.get();
        };
    }

    public static boolean canUpgrade(Player player, EnumCrafting type, ItemStack stack, ItemStack ingredient) {
        return CraftingUtils.upgradeCost(type, Platform.INSTANCE.getPlayerData(player).orElseThrow(EntityUtils::playerDataException), stack, ingredient, true) >= 0;
    }

    public static int upgradeCost(EnumCrafting type, PlayerData data, ItemStack stack, ItemStack ingredient) {
        return CraftingUtils.upgradeCost(type, data, stack, ingredient, false);
    }

    public static int upgradeCost(EnumCrafting type, PlayerData data, ItemStack stack, ItemStack ingredient, boolean onlyIngredient) {
        if (!GeneralConfig.useRp) {
            return 0;
        }
        return DataPackHandler.INSTANCE.itemStatManager().get(ingredient.m_41720_()).map(stat -> {
            if (stat.getDiff() <= 0) {
                return -1;
            }
            if (onlyIngredient || !stack.m_41619_()) {
                int result;
                int skillLevel;
                int n = skillLevel = type == EnumCrafting.FORGE ? data.getSkillLevel(EnumSkills.FORGING).getLevel() : data.getSkillLevel(EnumSkills.CRAFTING).getLevel();
                if (skillLevel >= stat.getDiff()) {
                    result = stat.getDiff() * 2 + (ItemNBT.itemLevel(stack) - 1) * 2;
                } else {
                    int diff = stat.getDiff() - skillLevel;
                    int equip = ItemNBT.itemLevel(stack) - 1;
                    result = (4 * diff + 2) * stat.getDiff() + 2 * stat.getDiff() * (2 * equip) + equip * 2;
                }
                return result;
            }
            return -1;
        }).orElse(-1);
    }

    public static int craftingCost(EnumCrafting type, PlayerData data, SextupleRecipe recipe, NonNullList<ItemStack> bonusItems, boolean unlocked) {
        if (!GeneralConfig.useRp) {
            return 0;
        }
        if (GeneralConfig.recipeSystem.baseCost) {
            int cost = Math.max(recipe.getCraftingLevel() * 2 + recipe.getAdditionalCost(), 10);
            int additionalMaterial = 0;
            for (ItemStack items : bonusItems) {
                additionalMaterial += DataPackHandler.INSTANCE.itemStatManager().get(items.m_41720_()).map(ItemStat::getDiff).orElse(10).intValue();
            }
            cost += additionalMaterial;
            if (!unlocked && GeneralConfig.recipeSystem.lockedCostMore) {
                cost *= 3;
            }
            return cost;
        }
        int skillLevel = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case EnumCrafting.FORGE -> data.getSkillLevel(EnumSkills.FORGING).getLevel();
            case EnumCrafting.ARMOR -> data.getSkillLevel(EnumSkills.CRAFTING).getLevel();
            case EnumCrafting.CHEM -> data.getSkillLevel(EnumSkills.CHEMISTRY).getLevel();
            case EnumCrafting.COOKING -> data.getSkillLevel(EnumSkills.COOKING).getLevel();
        };
        int lvlDifference = recipe.getCraftingLevel() - skillLevel;
        int cost = recipe.getCraftingLevel() * 2;
        cost = lvlDifference <= 0 ? Math.max(cost + lvlDifference, 10) + recipe.getAdditionalCost() : Math.max(cost + recipe.getAdditionalCost(), 10) * (int)((double)(1 + lvlDifference) * 1.5);
        int additionalMaterial = 0;
        for (ItemStack items : bonusItems) {
            additionalMaterial += DataPackHandler.INSTANCE.itemStatManager().get(items.m_41720_()).map(s -> {
                if (skillLevel >= s.getDiff()) {
                    return s.getDiff();
                }
                return (int)((double)(s.getDiff() - skillLevel) * 1.5) * (s.getDiff() - 5);
            }).orElse(10).intValue();
        }
        cost += additionalMaterial;
        if (!unlocked && GeneralConfig.recipeSystem.lockedCostMore) {
            cost *= 3;
        }
        return cost;
    }

    public static ItemStack getUpgradedStack(ItemStack stack, ItemStack ing, EnumCrafting type) {
        return ItemNBT.addUpgradeItem(stack.m_41777_(), ing, false, type);
    }

    private static float xpForCrafting(EnumSkills skill, SextupleRecipe recipe, int skillLevel) {
        float mult = LevelCalc.getSkillXpMultiplier(skill);
        float xp = (float)(recipe.getCraftingLevel() * 2 + 10) * mult;
        xp = skillLevel > recipe.getCraftingLevel() ? (xp -= (float)(2 * skillLevel - recipe.getCraftingLevel())) : (xp += (float)((recipe.getCraftingLevel() - skillLevel) * recipe.getCraftingLevel()));
        if (xp < 1.0f) {
            xp = 1.0f;
        }
        return xp;
    }

    public static void giveCraftingXPTo(ServerPlayer serverPlayer, PlayerData data, EnumSkills skill, SextupleRecipe recipe) {
        if (GeneralConfig.skillXpMultiplier == 0.0f) {
            return;
        }
        data.increaseSkill(skill, (Player)serverPlayer, CraftingUtils.xpForCrafting(skill, recipe, data.getSkillLevel(skill).getLevel()) * GeneralConfig.skillXpMultiplier);
    }

    private static float xpForUpgrade(EnumSkills skill, ItemStack equip, ItemStack upgrade, int skillLevel) {
        float mult = LevelCalc.getSkillXpMultiplier(skill) * 1.5f;
        int difficulty = DataPackHandler.INSTANCE.itemStatManager().get(upgrade.m_41720_()).map(ItemStat::getDiff).orElse(0);
        float xp = mult * (float)(10 + ItemNBT.itemLevel(equip));
        if (skillLevel < difficulty) {
            xp += (float)(2 * difficulty - skillLevel);
        }
        return xp;
    }

    public static void giveUpgradeXPTo(ServerPlayer serverPlayer, PlayerData data, EnumSkills skill, ItemStack equip, ItemStack upgrade) {
        if (GeneralConfig.skillXpMultiplier == 0.0f) {
            return;
        }
        data.increaseSkill(skill, (Player)serverPlayer, CraftingUtils.xpForUpgrade(skill, equip, upgrade, data.getSkillLevel(skill).getLevel()) * GeneralConfig.skillXpMultiplier);
    }

    public static ItemStack getCraftingOutput(ItemStack stack, PlayerContainerInv inv, Pair<NonNullList<ItemStack>, NonNullList<ItemStack>> materials, EnumCrafting type) {
        if (type == EnumCrafting.COOKING) {
            for (ItemStack base : (NonNullList)materials.getFirst()) {
                ItemNBT.addFoodBonusItem(stack, base);
            }
            for (ItemStack bonus : (NonNullList)materials.getSecond()) {
                ItemNBT.addFoodBonusItem(stack, bonus);
            }
            return stack;
        }
        int i = 0;
        for (ItemStack bonus : (NonNullList)materials.getSecond()) {
            ItemNBT.addUpgradeItem(stack, bonus, true, type);
            if (++i != 3) continue;
            break;
        }
        NonNullList recipeStacks = (NonNullList)materials.getFirst();
        Platform.INSTANCE.getPlayerData(inv.getPlayer()).ifPresent(d -> RAND.setSeed(d.getCraftingSeed(inv.getPlayer())));
        if (recipeStacks.size() > 3) {
            while (i < 3) {
                ItemStack rand = (ItemStack)recipeStacks.get(RAND.nextInt(recipeStacks.size()));
                if (!rand.m_41619_()) {
                    recipeStacks.remove((Object)rand);
                    ItemNBT.addUpgradeItem(stack, rand, true, type);
                }
                ++i;
            }
        }
        return stack;
    }
}

