/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.blocks.BlockCrop;
import io.github.flemmli97.runecraftory.common.blocks.Growable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandData;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.CropBlockAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class CropUtils {
    public static void attemptGiantize(ServerLevel level, BlockPos cropPos, Growable crop, BlockState state, float progress, CropProperties props) {
        if (crop.runecraftory$isAtMaxAge(state) && props.getGiantVersion() != Blocks.f_50016_ && (double)progress >= 0.5) {
            if (state.m_60713_(props.getGiantVersion())) {
                return;
            }
            Block block = state.m_60734_();
            if (block instanceof BlockCrop) {
                BlockCrop blockCrop = (BlockCrop)block;
                int age = (Integer)state.m_61143_((Property)blockCrop.m_7959_());
                if (age != blockCrop.getGiantAge()) {
                    level.m_7731_(cropPos, (BlockState)state.m_61124_((Property)blockCrop.m_7959_(), (Comparable)Integer.valueOf(blockCrop.getGiantAge())), 3);
                } else if (progress >= 1.0f) {
                    FarmlandHandler.get(level.m_142572_()).scheduleGiantCropMerge(level, cropPos, props.getGiantVersion().m_49966_());
                }
            } else if (progress >= 1.0f) {
                FarmlandHandler.get(level.m_142572_()).scheduleGiantCropMerge(level, cropPos, props.getGiantVersion().m_49966_());
            }
        }
    }

    public static CropProperties getPropertiesFor(CropBlock crop) {
        return DataPackHandler.INSTANCE.cropManager().get(((CropBlockAccessor)crop).getSeedItem().m_5456_());
    }

    public static void modifyCropDrops(BlockState state, LootContext.Builder builder, CropBlock block, List<ItemStack> list) {
        CropProperties prop = CropUtils.getPropertiesFor(block);
        if (prop != null) {
            int itemLevel;
            Vec3 pos = (Vec3)builder.m_78982_(LootContextParams.f_81460_);
            int n = itemLevel = pos != null ? CropUtils.getCropLevel(builder.m_78962_(), new BlockPos(pos)) : 1;
            if (block.m_52307_(state)) {
                ArrayList<ItemStack> remove = new ArrayList<ItemStack>();
                boolean removedSeed = list.size() < 2;
                for (ItemStack stack : list) {
                    if (removedSeed || !stack.m_150930_(((CropBlockAccessor)block).getSeedItem().m_5456_())) continue;
                    remove.add(stack);
                    removedSeed = true;
                }
                list.removeIf(remove::contains);
                list.forEach(s -> CropUtils.modifyStack(prop, s, itemLevel));
            } else if (block instanceof BlockCrop) {
                list.clear();
            }
        }
    }

    private static int getCropLevel(ServerLevel level, BlockPos pos) {
        return FarmlandHandler.get(level.m_142572_()).getData(level, new BlockPos((Vec3i)pos)).map(FarmlandData::getCropLevel).orElse(1);
    }

    private static void modifyStack(CropProperties props, ItemStack stack, int level) {
        if (stack.m_204117_(RunecraftoryTags.CROPS)) {
            stack.m_41764_(props.maxDrops());
            ItemNBT.getLeveledItem(stack, level);
        }
    }

    public static void harvestCropRightClick(BlockState state, Level level, BlockPos pos, Entity entity, ItemStack stack, CropProperties props, InteractionHand hand, Function<ItemStack, ItemStack> stackConsumer) {
        Block block;
        ServerLevel serverLevel;
        block11: {
            block10: {
                if (!(level instanceof ServerLevel)) break block10;
                serverLevel = (ServerLevel)level;
                block = state.m_60734_();
                if (block instanceof CropBlock) break block11;
            }
            return;
        }
        CropBlock cropBlock = (CropBlock)block;
        if (stackConsumer != null) {
            Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)entity, (ItemStack)stack).forEach(s -> {
                ItemStack rest = (ItemStack)stackConsumer.apply((ItemStack)s);
                if (!rest.m_41619_()) {
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)rest);
                }
            });
            state.m_60612_(serverLevel, pos, ItemStack.f_41583_);
        } else {
            Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)entity, (ItemStack)stack);
        }
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        if (props != null && props.regrowable()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)cropBlock.m_7959_(), (Comparable)Integer.valueOf(0)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ModCriteria.HARVEST_CROP.trigger(player, state);
            if (cropBlock.m_52307_(state)) {
                CropUtils.spawnRuney(player, pos);
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 2.0f));
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_21011_(hand, true);
        }
    }

    public static void spawnRuney(ServerPlayer player, BlockPos pos) {
        if (player.m_21187_().nextFloat() < GeneralConfig.runeyChance) {
            Entity entity = (double)player.m_21187_().nextFloat() < 0.4 ? ((EntityType)ModEntities.RUNEY.get()).m_20615_((Level)player.m_183503_()) : ((EntityType)ModEntities.STAT_BONUS.get()).m_20615_((Level)player.m_183503_());
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
            player.f_19853_.m_7967_(entity);
        }
    }
}

