/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CustomDamage
extends EntityDamageSource {
    public static final DamageSource EXHAUST = Platform.INSTANCE.createDamageSource("runecraftory.exhaust", true, true, true);
    public static final DamageSource POISON = Platform.INSTANCE.createDamageSource("runecraftory.poison", true, true, false);
    public static final String ENTITY_DAMAGE_SOURCE = "runecraftory.attack";
    private final EnumElement element;
    private final KnockBackType knock;
    private final Entity trueSourceEntity;
    private final float knockAmount;
    private final int hurtProtection;
    private final boolean faintEntity;
    private final boolean fixedDamage;
    private final ImmutableMap<Attribute, Double> attributesChange;

    public CustomDamage(Entity attacker, @Nullable Entity cause, EnumElement element, KnockBackType knock, float knockBackAmount, int hurtTimeProtection, boolean faintEntity, boolean fixedDamage, Map<Attribute, Double> attributesChange) {
        super(ENTITY_DAMAGE_SOURCE, attacker);
        this.element = element;
        this.knock = knock;
        this.trueSourceEntity = cause;
        this.knockAmount = knockBackAmount;
        this.hurtProtection = hurtTimeProtection;
        this.faintEntity = faintEntity;
        this.fixedDamage = fixedDamage;
        this.attributesChange = ImmutableMap.copyOf(attributesChange);
    }

    public EnumElement getElement() {
        return this.element;
    }

    public KnockBackType getKnockBackType() {
        return this.knock;
    }

    public float knockAmount() {
        return this.knockAmount;
    }

    public int hurtProtection() {
        return this.hurtProtection;
    }

    public boolean criticalDamage() {
        return this.faintEntity;
    }

    public boolean fixedDamage() {
        return this.fixedDamage;
    }

    public ImmutableMap<Attribute, Double> getAttributesChange() {
        return this.attributesChange;
    }

    @Nullable
    public Entity m_7639_() {
        return this.trueSourceEntity != null ? this.trueSourceEntity : this.m_7640_();
    }

    public Component m_6157_(LivingEntity entityLivingBaseIn) {
        Entity source = this.m_7639_() != null ? this.m_7639_() : this.m_7640_();
        ItemStack itemstack = source instanceof LivingEntity ? ((LivingEntity)source).m_21205_() : ItemStack.f_41583_;
        String s = "death.attack." + this.f_19326_;
        String s1 = s + ".item";
        return !itemstack.m_41619_() && itemstack.m_41788_() && I18n.m_118936_((String)s1) ? new TranslatableComponent(s1, new Object[]{entityLivingBaseIn.m_5446_(), source.m_5446_(), itemstack.m_41611_()}) : new TranslatableComponent(s, new Object[]{entityLivingBaseIn.m_5446_(), source.m_5446_()});
    }

    public Entity m_7640_() {
        return this.f_19391_;
    }

    public boolean hurtEntity(Entity target, float dmg) {
        boolean success;
        int invul = target.f_19802_;
        boolean modified = false;
        if (target.f_19802_ + this.hurtProtection() <= 20) {
            target.f_19802_ = Math.min(target.f_19802_, 10);
            modified = true;
        }
        if (!(success = target.m_6469_((DamageSource)this, dmg)) && modified) {
            target.f_19802_ = invul;
        }
        return success;
    }

    public static enum KnockBackType {
        BACK,
        UP,
        VANILLA,
        NONE;

    }

    public static class Builder {
        private final Entity cause;
        private EnumElement element = EnumElement.NONE;
        private KnockBackType knock = KnockBackType.VANILLA;
        private Entity trueSource;
        private float knockAmount;
        private int protection = 10;
        private DamageType dmg = DamageType.NORMAL;
        private final Map<Attribute, Double> attributesChange = new HashMap<Attribute, Double>();
        private boolean isProjectile;

        public Builder(Entity attacker) {
            this.cause = attacker;
        }

        public Builder(Entity attacker, Entity source) {
            this.cause = attacker;
            this.trueSource = source;
        }

        public Builder element(EnumElement el) {
            this.element = el;
            return this;
        }

        public Builder knock(KnockBackType k) {
            this.knock = k;
            return this;
        }

        public Builder knockAmount(float amount) {
            this.knockAmount = amount;
            return this;
        }

        public Builder noKnockback() {
            this.knock = KnockBackType.NONE;
            return this;
        }

        public boolean calculateKnockback() {
            return this.knock == KnockBackType.VANILLA && this.knockAmount == 0.0f;
        }

        public Builder hurtResistant(int time) {
            this.protection = time;
            return this;
        }

        public Builder magic() {
            this.dmg = DamageType.MAGIC;
            return this;
        }

        public Builder damageType(DamageType type) {
            if (this.dmg != DamageType.FAINT) {
                this.dmg = type;
            }
            return this;
        }

        public DamageType getDamageType() {
            return this.dmg;
        }

        public Builder withChangedAttribute(Attribute att, double change) {
            this.attributesChange.put(att, change);
            return this;
        }

        public Builder projectile() {
            this.isProjectile = true;
            return this;
        }

        public Map<Attribute, Double> getAttributesChanges() {
            return this.attributesChange;
        }

        public CustomDamage get() {
            CustomDamage source = new CustomDamage(this.cause, this.trueSource, this.element, this.knock, this.knockAmount, this.protection, this.dmg == DamageType.FAINT, this.dmg == DamageType.FIXED, this.attributesChange);
            switch (this.dmg) {
                case NORMAL: {
                    break;
                }
                case MAGIC: {
                    source.m_19389_();
                    break;
                }
                case FAINT: 
                case FIXED: 
                case IGNOREDEF: {
                    source.m_19380_();
                    break;
                }
                case IGNOREMAGICDEF: {
                    source.m_19389_();
                    source.m_19382_();
                }
            }
            if (this.isProjectile) {
                source.m_19366_();
            }
            return source;
        }
    }

    public static enum DamageType {
        NORMAL,
        MAGIC,
        IGNOREDEF,
        IGNOREMAGICDEF,
        FAINT,
        FIXED;

    }
}

