/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.ImmutableList;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.GateEntity;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityTreasureChest;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CUpdateAttributesWithAdditional;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    private static final List<WeightedChestTier> CHEST_TIERS = ImmutableList.of((Object)new WeightedChestTier(0, 150, 0.4f, 550), (Object)new WeightedChestTier(1, 40, 0.3f, 200), (Object)new WeightedChestTier(2, 1, 0.3f, 60), (Object)new WeightedChestTier(3, 0, 0.0f, 20));

    public static double tryGetAttribute(LivingEntity entity, Attribute attribute) {
        AttributeInstance inst = entity.m_21051_(attribute);
        if (inst == null) {
            return attribute.m_22082_();
        }
        return inst.m_22135_();
    }

    public static Rotation fromDirection(Direction direction) {
        return switch (direction) {
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }

    public static boolean isExhaust(LivingEntity entity) {
        return entity.m_21023_((MobEffect)ModEffects.FATIGUE.get());
    }

    public static void applyPermanentEffect(LivingEntity entity, MobEffect effect, int amplifier) {
        if (!entity.m_21023_(effect)) {
            entity.m_7292_(new MobEffectInstance(effect, Integer.MAX_VALUE, amplifier));
        }
    }

    public static boolean paralysed(LivingEntity entity) {
        return entity.m_21023_((MobEffect)ModEffects.PARALYSIS.get());
    }

    public static boolean sealed(LivingEntity entity) {
        return entity.m_21023_((MobEffect)ModEffects.SEAL.get());
    }

    public static boolean canMonsterTargetNPC(Entity e) {
        EntityNPCBase npc;
        if (e instanceof EntityNPCBase && (npc = (EntityNPCBase)e).getEntityToFollowUUID() != null) {
            return true;
        }
        return MobConfig.mobAttackNpc && e instanceof Npc;
    }

    public static void sendAttributesTo(LivingEntity entity, ServerPlayer player) {
        AttributeInstance att = entity.m_21051_(Attributes.f_22281_);
        if (att != null) {
            entity.m_21204_().m_22145_().add(att);
        }
        if (entity == player) {
            Platform.INSTANCE.sendToClient(new S2CUpdateAttributesWithAdditional(entity.m_21204_().m_22145_()), player);
            entity.m_21204_().m_22145_().clear();
        } else {
            player.f_8906_.m_141995_((Packet)new ClientboundUpdateAttributesPacket(entity.m_142049_(), (Collection)entity.m_21204_().m_22145_()));
            entity.m_21204_().m_22145_().clear();
        }
    }

    public static boolean shouldShowFarmlandView(LivingEntity entity) {
        ItemStack main = entity.m_21205_();
        ItemStack off = entity.m_21206_();
        return ItemNBT.canBeUsedAsMagnifyingGlass(main) || ItemNBT.canBeUsedAsMagnifyingGlass(off);
    }

    public static void foodHealing(LivingEntity entity, float amount) {
        if (amount > 0.0f) {
            entity.m_5634_(amount);
        } else if (!entity.m_6095_().m_204039_(RunecraftoryTags.BOSS_MONSTERS)) {
            entity.m_21153_(entity.m_21223_() + amount);
        }
    }

    public static float playerLuck(Player player) {
        return player.m_36336_();
    }

    public static boolean isDisabled(LivingEntity entity) {
        return entity.m_21023_((MobEffect)ModEffects.SLEEP.get()) || entity.m_21023_((MobEffect)ModEffects.STUNNED.get());
    }

    @Nullable
    public static UUID tryGetOwner(LivingEntity entity) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)entity;
            return ownableEntity.m_142504_();
        }
        return null;
    }

    public static boolean canAttackOwned(LivingEntity entity, boolean allowUuidOnly, boolean otherwise, Predicate<LivingEntity> pred) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)entity;
            if (entity.m_142081_().equals(ownableEntity.m_142504_())) {
                return false;
            }
            Entity owner = ownableEntity.m_142480_();
            if (owner instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)owner;
                return pred.test(living);
            }
            return allowUuidOnly && ownableEntity.m_142504_() != null || otherwise;
        }
        return otherwise;
    }

    public static float tamingChance(BaseMonster monster, Player player, float itemMultiplier, int brushCount, int loveAttackCount) {
        if (itemMultiplier == 0.0f || GeneralConfig.tamingMultiplier == 0.0f) {
            return 0.0f;
        }
        int lvl = Platform.INSTANCE.getPlayerData(player).map(d -> d.getPlayerLevel().getLevel()).orElse(1) + 1;
        float lvlPenalty = Math.max(0.0f, (float)(monster.level().getLevel() - lvl) * 0.02f);
        float brushBonus = (float)brushCount * 0.05f;
        float loveAttackBonus = (float)loveAttackCount * 0.002f;
        float tamingLvlBonus = (float)(Platform.INSTANCE.getPlayerData(player).map(d -> d.getSkillLevel(EnumSkills.TAMING).getLevel()).orElse(1) - 1) * 0.005f;
        float tamingBonus = 1.0f + brushBonus + loveAttackBonus + tamingLvlBonus;
        return monster.tamingChance() * GeneralConfig.tamingMultiplier * tamingBonus - lvlPenalty;
    }

    public static NullPointerException playerDataException() {
        return new NullPointerException("Player capability is null. This shouldn't be");
    }

    public static EntityType<?> trySpawnTreasureChest(GateEntity spawner) {
        if (spawner.m_21187_().nextFloat() < MobConfig.treasureChance) {
            if (spawner.m_21187_().nextFloat() < MobConfig.mimicChance) {
                if (spawner.m_21187_().nextFloat() < MobConfig.mimicStrongChance) {
                    return (EntityType)ModEntities.GOBBLE_BOX.get();
                }
                return (EntityType)ModEntities.MONSTER_BOX.get();
            }
            return (EntityType)ModEntities.TREASURE_CHEST.get();
        }
        return null;
    }

    public static void tieredTreasureChest(GateEntity spawner, EntityTreasureChest chest) {
        int max = 0;
        for (WeightedChestTier tier : CHEST_TIERS) {
            max += tier.getModifiedWeight(spawner.level().getLevel());
        }
        int rand = spawner.m_21187_().nextInt(max);
        for (WeightedChestTier tier : CHEST_TIERS) {
            if ((rand -= tier.getModifiedWeight(spawner.level().getLevel())) >= 0) continue;
            chest.setTier(tier.tier);
        }
    }

    public static int getRPFromVanillaFood(ItemStack stack) {
        FoodProperties prop = stack.m_41720_().m_41473_();
        if (prop != null) {
            return (int)((double)stack.m_41720_().m_41473_().m_38744_() * 1.5 * (1.0 + 1.8 * (double)stack.m_41720_().m_41473_().m_38745_()));
        }
        return 0;
    }

    public static Vec3 getStraightProjectileTarget(Vec3 from, Entity target) {
        AABB aabb = target.m_142469_().m_82400_((double)target.m_20206_() * 0.1);
        return EntityUtils.getStraightProjectileTarget(from, target.m_20182_(), aabb.f_82289_, aabb.f_82292_);
    }

    public static Vec3 getStraightProjectileTarget(Vec3 from, Vec3 target, double minY, double maxY) {
        return new Vec3(target.m_7096_(), Mth.m_14008_((double)from.m_7098_(), (double)minY, (double)maxY), target.m_7094_());
    }

    public static Vec3 getTargetDirection(Mob mob, EntityAnchorArgument.Anchor anchor) {
        return EntityUtils.getTargetDirection(mob, anchor, false);
    }

    public static Vec3 getTargetDirection(Mob mob, EntityAnchorArgument.Anchor anchor, boolean horizontalOnly) {
        Vec3 dir;
        Vec3 pos = anchor.m_90377_((Entity)mob);
        if (mob.m_6688_() != null) {
            dir = mob.m_6688_().m_20154_();
        } else if (mob.m_5448_() != null) {
            LivingEntity target = mob.m_5448_();
            dir = anchor.m_90377_((Entity)target).m_82546_(pos);
        } else {
            dir = mob.m_20154_();
        }
        if (horizontalOnly) {
            dir = new Vec3(dir.m_7096_(), 0.0, dir.m_7094_());
        }
        return dir.m_82541_();
    }

    public static LivingEntity ownedProjectileTarget(Entity owner, int range) {
        Mob mob;
        if (owner instanceof Mob && (mob = (Mob)owner).m_5448_() != null) {
            return mob.m_5448_();
        }
        if (owner instanceof LivingEntity) {
            Predicate predicate;
            LivingEntity livingOwner = (LivingEntity)owner;
            Function<LivingEntity, Predicate> generator = ownerEntity -> {
                Predicate<LivingEntity> predicate;
                if (ownerEntity instanceof BaseMonster) {
                    BaseMonster monster = (BaseMonster)ownerEntity;
                    predicate = monster.targetPred;
                } else {
                    predicate = e -> {
                        if (ownerEntity instanceof Player) {
                            if (e instanceof Animal) return false;
                            if (e instanceof Npc) return false;
                            if (!(e instanceof OwnableEntity)) return true;
                            OwnableEntity ownable = (OwnableEntity)e;
                            if (ownerEntity.m_142081_().equals(ownable.m_142504_())) return false;
                            return true;
                        }
                        if (!(ownerEntity instanceof Mob)) return false;
                        Mob mob = (Mob)ownerEntity;
                        if (e != mob.m_5448_()) return false;
                        return true;
                    };
                }
                return predicate;
            };
            Entity entity = owner.m_6688_();
            if (entity instanceof LivingEntity) {
                LivingEntity controller = (LivingEntity)entity;
                predicate = generator.apply(controller);
            } else {
                predicate = generator.apply(livingOwner);
            }
            Predicate pred = predicate;
            return owner.f_19853_.m_45963_(LivingEntity.class, TargetingConditions.m_148352_().m_148355_().m_26883_((double)range).m_26888_(pred), livingOwner, livingOwner.m_20185_(), livingOwner.m_20186_(), livingOwner.m_20189_(), new AABB(-10.0, -10.0, -10.0, 10.0, 10.0, 10.0).m_82383_(livingOwner.m_20182_()));
        }
        return null;
    }

    record WeightedChestTier(int tier, int weight, float modifier, int max) {
        int getModifiedWeight(int mod) {
            return Math.min(this.max, (int)((float)this.weight + this.modifier * (float)mod));
        }
    }
}

