/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemNBT {
    private static final List<ResourceLocation> WEAPON_ONLY = List.of(ModAttributes.PARA.getID(), ModAttributes.POISON.getID(), ModAttributes.SEAL.getID(), ModAttributes.SLEEP.getID(), ModAttributes.FATIGUE.getID(), ModAttributes.COLD.getID(), ModAttributes.FAINT.getID(), ModAttributes.DRAIN.getID());
    private static final List<ResourceLocation> ARMOR_ONLY = List.of(ModAttributes.RES_WATER.getID(), ModAttributes.RES_EARTH.getID(), ModAttributes.RES_WIND.getID(), ModAttributes.RES_FIRE.getID(), ModAttributes.RES_DARK.getID(), ModAttributes.RES_LIGHT.getID(), ModAttributes.RES_LOVE.getID(), ModAttributes.RES_PARA.getID(), ModAttributes.RES_POISON.getID(), ModAttributes.RES_SEAL.getID(), ModAttributes.RES_SLEEP.getID(), ModAttributes.RES_FAT.getID(), ModAttributes.RES_COLD.getID(), ModAttributes.RES_DIZZY.getID(), ModAttributes.RES_CRIT.getID(), ModAttributes.RES_STUN.getID(), ModAttributes.RES_FAINT.getID(), ModAttributes.RES_DRAIN.getID());
    private static final List<ResourceLocation> NON_INHERITABLE = List.of(ModAttributes.ATTACK_SPEED.getID(), ModAttributes.ATTACK_RANGE.getID(), ModAttributes.ATTACK_WIDTH.getID(), ModAttributes.CHARGE_TIME.getID());

    public static int itemLevel(ItemStack stack) {
        CompoundTag tag = ItemNBT.getItemNBT(stack);
        return tag != null ? Math.max(1, tag.m_128451_("ItemLevel")) : 1;
    }

    public static boolean addItemLevel(ItemStack stack) {
        CompoundTag tag;
        int level = ItemNBT.itemLevel(stack);
        if (level < 10 && (tag = ItemNBT.getItemNBT(stack)) != null) {
            tag.m_128405_("ItemLevel", level + 1);
            return true;
        }
        return false;
    }

    public static ItemStack getLeveledItem(ItemStack stack, int level) {
        if (ItemNBT.shouldHaveLevel(stack)) {
            CompoundTag compound = ItemNBT.getItemNBT(stack);
            if (compound == null) {
                compound = new CompoundTag();
            }
            compound.m_128405_("ItemLevel", Mth.m_14045_((int)level, (int)1, (int)10));
            stack.m_41784_().m_128365_("runecraftory", (Tag)compound);
        }
        return stack;
    }

    public static Map<Attribute, Double> statIncrease(ItemStack stack) {
        CompoundTag compound = ItemNBT.getItemNBT(stack);
        if (compound == null || !compound.m_128441_("BaseStats")) {
            return DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).map(ItemStat::itemStats).orElse(new TreeMap(ModAttributes.SORTED));
        }
        TreeMap<Attribute, Double> map = new TreeMap<Attribute, Double>(ModAttributes.SORTED);
        CompoundTag base = compound.m_128469_("BaseStats");
        for (String attName : base.m_128431_()) {
            Attribute att = (Attribute)Registry.f_122866_.m_7745_(new ResourceLocation(attName));
            if (!Registry.f_122866_.m_7981_((Object)att).toString().equals(attName)) continue;
            map.put(att, base.m_128459_(attName));
        }
        CompoundTag tag = compound.m_128469_("ItemStats");
        for (String attName : tag.m_128431_()) {
            Attribute att = (Attribute)Registry.f_122866_.m_7745_(new ResourceLocation(attName));
            if (!Registry.f_122866_.m_7981_((Object)att).toString().equals(attName)) continue;
            map.compute(att, (key, old) -> old == null ? tag.m_128459_(attName) : old + tag.m_128459_(attName));
        }
        return map;
    }

    public static Multimap<Attribute, AttributeModifier> getStatsAttributeMap(ItemStack stack, Multimap<Attribute, AttributeModifier> map, EquipmentSlot slot) {
        if (ItemNBT.shouldHaveStats(stack) && ItemUtils.slotOf(stack) == slot) {
            SetMultimap multimap = MultimapBuilder.treeKeys(ModAttributes.SORTED).hashSetValues().build();
            ItemNBT.statIncrease(stack).forEach((arg_0, arg_1) -> ItemNBT.lambda$getStatsAttributeMap$1((Multimap)multimap, slot, arg_0, arg_1));
            return multimap;
        }
        return map;
    }

    public static Pair<Map<Attribute, Double>, Map<Attribute, Double>> foodStats(ItemStack stack) {
        Map<Attribute, Double> mapMulti;
        Attribute att;
        Map<Attribute, Double> map;
        CompoundTag tag;
        FoodProperties props = DataPackHandler.INSTANCE.foodManager().get(stack.m_41720_());
        if (props == null) {
            return Pair.of(new TreeMap(ModAttributes.SORTED), new TreeMap(ModAttributes.SORTED));
        }
        CompoundTag compound = ItemNBT.getItemNBT(stack);
        if (compound == null) {
            return Pair.of(props.effects(), props.effectsMultiplier());
        }
        if (compound.m_128441_("FoodStats")) {
            tag = compound.m_128469_("FoodStats");
            map = new TreeMap<Attribute, Double>(ModAttributes.SORTED);
            for (String attName : tag.m_128431_()) {
                att = (Attribute)Registry.f_122866_.m_7745_(new ResourceLocation(attName));
                if (!Registry.f_122866_.m_7981_((Object)att).toString().equals(attName)) continue;
                map.put(att, tag.m_128459_(attName));
            }
        } else {
            map = props.effects();
        }
        if (compound.m_128441_("FoodStatsMultiplier")) {
            tag = compound.m_128469_("FoodStatsMultiplier");
            mapMulti = new TreeMap<Attribute, Double>(ModAttributes.SORTED);
            for (String attName : tag.m_128431_()) {
                att = (Attribute)Registry.f_122866_.m_7745_(new ResourceLocation(attName));
                if (!Registry.f_122866_.m_7981_((Object)att).toString().equals(attName)) continue;
                mapMulti.put(att, tag.m_128459_(attName));
            }
        } else {
            mapMulti = props.effectsMultiplier();
        }
        return Pair.of(map, mapMulti);
    }

    public static void setElement(EnumElement element, ItemStack stack) {
        CompoundTag tag = ItemNBT.getItemNBT(stack);
        if (tag != null) {
            if (EnumElement.valueOf(tag.m_128461_("Element")) == EnumElement.NONE) {
                tag.m_128359_("Element", element.toString());
            } else {
                tag.m_128359_("Element", EnumElement.NONE.toString());
            }
        }
    }

    public static EnumElement getElement(ItemStack stack) {
        CompoundTag tag = ItemNBT.getItemNBT(stack);
        if (tag != null) {
            try {
                return EnumElement.valueOf(tag.m_128461_("Element"));
            }
            catch (IllegalArgumentException e) {
                return EnumElement.NONE;
            }
        }
        return ItemNBT.isWeapon(stack) ? DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).map(ItemStat::element).orElse(EnumElement.NONE) : EnumElement.NONE;
    }

    public static ItemStack addUpgradeItem(ItemStack stack, ItemStack stackToAdd, boolean crafting, EnumCrafting type) {
        int level = ItemNBT.itemLevel(stack);
        if (stackToAdd.m_41619_() || !ItemNBT.shouldHaveStats(stack) || level >= 10) {
            return stack;
        }
        CompoundTag tag = ItemNBT.getItemNBT(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        ItemStat stat = DataPackHandler.INSTANCE.itemStatManager().get(stackToAdd.m_41720_()).orElse(null);
        if (ItemNBT.shouldHaveStats(stackToAdd)) {
            Object armor2;
            Object armor1;
            Item item;
            if (!crafting || tag.m_128441_("OriginItem")) {
                return stack;
            }
            boolean lightOreApplied = tag.m_128471_("LightOre");
            if (stack.m_204117_(RunecraftoryTags.EQUIPMENT)) {
                if (!stackToAdd.m_204117_(RunecraftoryTags.EQUIPMENT)) {
                    return stack;
                }
                if (lightOreApplied) {
                    return ItemNBT.changeBaseItemTo(stack, stackToAdd, type);
                }
                item = stack.m_41720_();
                if (item instanceof ArmorItem) {
                    armor1 = (ArmorItem)item;
                    item = stackToAdd.m_41720_();
                    if (item instanceof ArmorItem) {
                        armor2 = (ArmorItem)item;
                        if (armor1.m_40402_() == armor2.m_40402_()) {
                            return ItemNBT.changeBaseItemTo(stack, stackToAdd, type);
                        }
                    }
                }
            }
            if (stack.m_204117_(RunecraftoryTags.UPGRADABLE_HELD)) {
                if (!stackToAdd.m_204117_(RunecraftoryTags.UPGRADABLE_HELD)) {
                    return stack;
                }
                if (lightOreApplied) {
                    return ItemNBT.changeBaseItemTo(stack, stackToAdd, type);
                }
                item = stack.m_41720_();
                if (item instanceof IItemUsable) {
                    armor1 = (IItemUsable)item;
                    item = stackToAdd.m_41720_();
                    if (item instanceof IItemUsable) {
                        armor2 = (IItemUsable)item;
                        if (armor1.getWeaponType() == armor2.getWeaponType()) {
                            return ItemNBT.changeBaseItemTo(stack, stackToAdd, type);
                        }
                    }
                }
            }
            if (stat.getArmorEffect() != null && stat.getArmorEffect().canBeAppliedTo(stack)) {
                Platform.INSTANCE.getArmorEffects(stack).ifPresent(data -> data.addArmorEffects(stat.getArmorEffect()));
            }
            return stack;
        }
        tag.m_128405_("ItemLevel", !crafting ? level + 1 : level);
        float efficiency = 1.0f;
        if (!crafting) {
            int similar = 0;
            ListTag upgrades = tag.m_128437_("Upgrades", 10);
            for (Tag item : upgrades) {
                CompoundTag nbt = (CompoundTag)item;
                if (!Registry.f_122827_.m_7981_((Object)stackToAdd.m_41720_()).toString().equals(nbt.m_128461_("Id"))) continue;
                ++similar;
            }
            efficiency = similar > 0 ? (float)(1.0 - Math.pow(0.5, similar)) : 1.0f;
            CompoundTag upgradeItem = new CompoundTag();
            upgradeItem.m_128359_("Id", Registry.f_122827_.m_7981_((Object)stackToAdd.m_41720_()).toString());
            upgradeItem.m_128405_("Level", ItemNBT.itemLevel(stackToAdd));
            upgrades.add((Object)upgradeItem);
            tag.m_128365_("Upgrades", (Tag)upgrades);
        } else {
            ListTag bonus = tag.m_128437_("CraftingBonus", 10);
            CompoundTag bonusItem = new CompoundTag();
            bonusItem.m_128359_("Id", Registry.f_122827_.m_7981_((Object)stackToAdd.m_41720_()).toString());
            bonusItem.m_128405_("Level", ItemNBT.itemLevel(stackToAdd));
            bonus.add((Object)bonusItem);
            tag.m_128365_("CraftingBonus", (Tag)bonus);
        }
        if (stackToAdd.m_41720_() == ModItems.GLASS.get() && stack.m_41720_() instanceof IItemUsable) {
            tag.m_128379_("MagnifyingGlass", true);
        }
        if (stackToAdd.m_41720_() == ModItems.SCRAP_PLUS.get() && stack.m_41720_() instanceof IItemUsable) {
            tag.m_128379_("ScrapMetalPlus", true);
        }
        boolean hasObjectX = tag.m_128471_("ObjectX");
        if (stackToAdd.m_41720_() == ModItems.OBJECT_X.get()) {
            tag.m_128379_("ObjectX", !hasObjectX);
        }
        if (type == EnumCrafting.FORGE && stackToAdd.m_41720_() == ModItems.INVIS_STONE.get()) {
            tag.m_128379_("Invis", true);
        }
        if (type == EnumCrafting.FORGE && stackToAdd.m_204117_(RunecraftoryTags.SCALES)) {
            tag.m_128379_("DragonScale", true);
        }
        if (crafting && stackToAdd.m_41720_() == ModItems.LIGHT_ORE.get() && !tag.m_128441_("OriginItem")) {
            tag.m_128379_("LightOre", true);
        }
        if (stackToAdd.m_41720_() == ModItems.GLITTA_AUGITE.get()) {
            tag.m_128379_("GlittaAugite", true);
        }
        if (stackToAdd.m_41720_() == ModItems.RACCOON_LEAF.get()) {
            tag.m_128379_("RaccoonLeaf", true);
        }
        boolean applyDoubleSteel = tag.m_128471_("DoubleSteel");
        if (!tag.m_128441_("DoubleSteel")) {
            if (stackToAdd.m_41720_() == ModItems.STEEL_DOUBLE.get()) {
                tag.m_128379_("DoubleSteel", true);
            }
        } else if (applyDoubleSteel) {
            tag.m_128379_("DoubleSteel", false);
        }
        boolean applyTenSteel = tag.m_128471_("TenfoldSteel");
        if (!tag.m_128441_("TenfoldSteel")) {
            if (stackToAdd.m_41720_() == ModItems.STEEL_TEN.get()) {
                tag.m_128379_("TenfoldSteel", true);
            }
        } else if (applyTenSteel) {
            tag.m_128379_("TenfoldSteel", false);
        }
        if (stat != null) {
            ItemStat base;
            if (!tag.m_128441_("BaseStats") && !stat.itemStats().isEmpty() && (base = (ItemStat)DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).orElse(null)) != null) {
                CompoundTag statsTag = new CompoundTag();
                for (Map.Entry<Attribute, Double> entry : base.itemStats().entrySet()) {
                    if (entry.getKey() == ModAttributes.ATTACK_RANGE.get() && (stackToAdd.m_41720_() == ModItems.RACCOON_LEAF.get() && tag.m_128471_("RaccoonLeaf") || stackToAdd.m_41720_() == ModItems.GLITTA_AUGITE.get() && tag.m_128471_("GlittaAugite"))) continue;
                    statsTag.m_128347_(Registry.f_122866_.m_7981_((Object)entry.getKey()).toString(), entry.getValue().doubleValue());
                }
                tag.m_128365_("BaseStats", (Tag)statsTag);
            }
            List<Object> blacklist = List.of();
            if (type == EnumCrafting.FORGE) {
                blacklist = ARMOR_ONLY;
            }
            if (type == EnumCrafting.ARMOR) {
                blacklist = WEAPON_ONLY;
            }
            CompoundTag statCompound = tag.m_128469_("ItemStats");
            for (Map.Entry<Attribute, Double> entry : stat.itemStats().entrySet()) {
                if (blacklist.contains(Registry.f_122866_.m_7981_((Object)entry.getKey()))) continue;
                double amount = entry.getValue() * (double)efficiency;
                if (hasObjectX) {
                    amount *= -1.0;
                }
                if (applyDoubleSteel) {
                    amount *= 2.0;
                }
                if (applyTenSteel) {
                    amount *= 8.0;
                }
                ItemNBT.updateStatIncrease(entry.getKey(), amount, statCompound);
            }
            tag.m_128365_("ItemStats", (Tag)statCompound);
            if (!tag.m_128441_("Element")) {
                tag.m_128359_("Element", ItemNBT.getElement(stack).toString());
            }
            if (ItemNBT.isWeapon(stack)) {
                EnumElement current = ItemNBT.getElement(stack);
                if (stat.element() != EnumElement.NONE) {
                    if (current == EnumElement.NONE) {
                        tag.m_128359_("Element", stat.element().toString());
                    } else {
                        tag.m_128359_("Element", EnumElement.NONE.toString());
                    }
                }
            }
            if (stack.m_41720_() instanceof ItemStaffBase) {
                Platform.INSTANCE.getStaffData(stack).ifPresent(data -> {
                    if (stat.getTier1Spell() != null) {
                        data.setTier1Spell(stat.getTier1Spell());
                    }
                    if (stat.getTier2Spell() != null) {
                        data.setTier2Spell(stat.getTier2Spell());
                    }
                    if (stat.getTier3Spell() != null) {
                        data.setTier3Spell(stat.getTier3Spell());
                    }
                });
            }
            if (stat.getArmorEffect() != null && stat.getArmorEffect().canBeAppliedTo(stack)) {
                Platform.INSTANCE.getArmorEffects(stack).ifPresent(data -> data.addArmorEffects(stat.getArmorEffect()));
            }
        }
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_("runecraftory", (Tag)tag);
        return stack;
    }

    private static ItemStack changeBaseItemTo(ItemStack stack, ItemStack toApply, EnumCrafting crafting) {
        ItemStat stat = DataPackHandler.INSTANCE.itemStatManager().get(toApply.m_41720_()).orElse(null);
        CompoundTag tag = new CompoundTag();
        if (stat != null) {
            ItemStat base;
            if (!stat.itemStats().isEmpty() && (base = (ItemStat)DataPackHandler.INSTANCE.itemStatManager().get(toApply.m_41720_()).orElse(null)) != null) {
                CompoundTag statsTag = new CompoundTag();
                Map origin = DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).map(ItemStat::itemStats).orElse(Map.of());
                for (Map.Entry<Attribute, Double> entry : base.itemStats().entrySet()) {
                    if (NON_INHERITABLE.contains(Registry.f_122866_.m_7981_((Object)entry.getKey()))) {
                        statsTag.m_128347_(Registry.f_122866_.m_7981_((Object)entry.getKey()).toString(), origin.getOrDefault(entry.getKey(), 5.0).doubleValue());
                        continue;
                    }
                    statsTag.m_128347_(Registry.f_122866_.m_7981_((Object)entry.getKey()).toString(), entry.getValue().doubleValue());
                }
                tag.m_128365_("BaseStats", (Tag)statsTag);
            }
            tag.m_128359_("Element", stat.element().toString());
            if (stack.m_41720_() instanceof ItemStaffBase) {
                Platform.INSTANCE.getStaffData(stack).ifPresent(data -> {
                    if (stat.getTier1Spell() != null) {
                        data.setTier1Spell(stat.getTier1Spell());
                    }
                    if (stat.getTier2Spell() != null) {
                        data.setTier2Spell(stat.getTier2Spell());
                    }
                    if (stat.getTier3Spell() != null) {
                        data.setTier3Spell(stat.getTier3Spell());
                    }
                });
            }
            if (stat.getArmorEffect() != null && stat.getArmorEffect().canBeAppliedTo(stack)) {
                Platform.INSTANCE.getArmorEffects(stack).ifPresent(data -> data.addArmorEffects(stat.getArmorEffect()));
            }
        }
        tag.m_128359_("OriginItem", Registry.f_122827_.m_7981_((Object)toApply.m_41720_()).toString());
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_("runecraftory", (Tag)tag);
        CompoundTag other = ItemNBT.getItemNBT(toApply);
        if (other != null) {
            ListTag bonus = other.m_128437_("CraftingBonus", 10);
            bonus.forEach(t -> {
                CompoundTag nbt = (CompoundTag)t;
                Item item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(nbt.m_128461_("Id")));
                if (item != Items.f_41852_) {
                    ItemNBT.addUpgradeItem(stack, new ItemStack((ItemLike)item), true, crafting);
                }
            });
        }
        return stack;
    }

    public static ItemStack addFoodBonusItem(ItemStack stack, ItemStack stackToAdd) {
        if (stackToAdd.m_41619_()) {
            return stack;
        }
        CompoundTag tag = ItemNBT.getItemNBT(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        ListTag bonus = tag.m_128437_("CraftingBonus", 10);
        CompoundTag bonusItem = new CompoundTag();
        bonusItem.m_128359_("Id", Registry.f_122827_.m_7981_((Object)stackToAdd.m_41720_()).toString());
        bonusItem.m_128405_("Level", ItemNBT.itemLevel(stackToAdd));
        bonus.add((Object)bonusItem);
        tag.m_128365_("CraftingBonus", (Tag)bonus);
        FoodProperties props = DataPackHandler.INSTANCE.foodManager().get(stackToAdd.m_41720_());
        if (props != null) {
            FoodProperties base;
            if (!tag.m_128441_("FoodStats") && (base = DataPackHandler.INSTANCE.foodManager().get(stack.m_41720_())) != null) {
                CompoundTag statsTag = new CompoundTag();
                for (Map.Entry<Attribute, Double> entry : base.effects().entrySet()) {
                    statsTag.m_128347_(Registry.f_122866_.m_7981_((Object)entry.getKey()).toString(), entry.getValue().doubleValue());
                }
                tag.m_128365_("FoodStats", (Tag)statsTag);
                statsTag = new CompoundTag();
                for (Map.Entry<Attribute, Double> entry : base.effectsMultiplier().entrySet()) {
                    statsTag.m_128347_(Registry.f_122866_.m_7981_((Object)entry.getKey()).toString(), entry.getValue().doubleValue());
                }
                tag.m_128365_("FoodStatsMultiplier", (Tag)statsTag);
            }
            boolean hasObjectX = tag.m_128471_("ObjectX");
            if (stackToAdd.m_41720_() == ModItems.OBJECT_X.get()) {
                tag.m_128379_("ObjectX", !hasObjectX);
            }
            for (Map.Entry<Attribute, Double> entry : props.cookingBonus().entrySet()) {
                double amount = entry.getValue();
                if (hasObjectX) {
                    amount *= -1.0;
                }
                ItemNBT.updateStatIncrease(entry.getKey(), amount, tag.m_128469_("FoodStats"));
            }
            for (Map.Entry<Attribute, Double> entry : props.cookingBonusPercent().entrySet()) {
                double amount = entry.getValue();
                if (hasObjectX) {
                    amount *= -1.0;
                }
                ItemNBT.updateStatIncrease(entry.getKey(), amount, tag.m_128469_("FoodStatsMultiplier"));
            }
        }
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_("runecraftory", (Tag)tag);
        return stack;
    }

    public static void updateStatIncrease(Attribute attribute, double amount, CompoundTag stats) {
        String att = Registry.f_122866_.m_7981_((Object)attribute).toString();
        double oldValue = stats.m_128459_(att);
        stats.m_128347_(att, oldValue + Math.floor(amount));
    }

    public static CompoundTag getItemNBT(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("runecraftory")) {
            return stack.m_41783_().m_128469_("runecraftory");
        }
        return null;
    }

    public static boolean shouldHaveStats(ItemStack stack) {
        return stack.m_204117_(RunecraftoryTags.UPGRADABLE_HELD) || stack.m_204117_(RunecraftoryTags.EQUIPMENT);
    }

    public static boolean shouldHaveLevel(ItemStack stack) {
        return ItemNBT.shouldHaveStats(stack) || stack.m_204117_(RunecraftoryTags.SPELLS);
    }

    public static boolean isWeapon(ItemStack stack) {
        return stack.m_204117_(RunecraftoryTags.UPGRADABLE_HELD);
    }

    public static boolean canBeUsedAsMagnifyingGlass(ItemStack stack) {
        if (stack.m_41720_() == ModItems.GLASS.get()) {
            return true;
        }
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_().m_128469_("runecraftory");
            return tag.m_128471_("MagnifyingGlass");
        }
        return false;
    }

    public static boolean doesFixedOneDamage(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_().m_128469_("runecraftory");
            return tag.m_128471_("ScrapMetalPlus");
        }
        return false;
    }

    public static boolean reverseStats(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_().m_128469_("runecraftory");
            return tag.m_128471_("ObjectX");
        }
        return false;
    }

    public static boolean isInvis(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_().m_128469_("runecraftory");
            return tag.m_128471_("Invis");
        }
        return false;
    }

    public static boolean hasDragonScaleUpgrade(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_().m_128469_("runecraftory");
            return tag.m_128471_("DragonScale");
        }
        return false;
    }

    public static ItemStack getOriginItem(ItemStack stack) {
        if (ItemNBT.shouldHaveStats(stack) && stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_().m_128469_("runecraftory");
            String s = tag.m_128461_("OriginItem");
            if (s.isEmpty()) {
                return ItemStack.f_41583_;
            }
            return new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(s)));
        }
        return ItemStack.f_41583_;
    }

    public static boolean usedLightOre(ItemStack stack) {
        if (ItemNBT.shouldHaveStats(stack) && stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_().m_128469_("runecraftory");
            String s = tag.m_128461_("OriginItem");
            if (s.isEmpty()) {
                return false;
            }
            ItemStack changed = new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(s)));
            return changed.m_41619_() && tag.m_128471_("LightOre");
        }
        return false;
    }

    public static double attackSpeedModifier(LivingEntity entity) {
        return entity.m_21133_((Attribute)ModAttributes.ATTACK_SPEED.get());
    }

    private static /* synthetic */ void lambda$getStatsAttributeMap$1(Multimap multimap, EquipmentSlot slot, Attribute att, Double d) {
        multimap.put((Object)att, (Object)new AttributeModifier(LibConstants.EQUIPMENT_MODIFIERS[slot.ordinal()], "rf.stat_increase", d.doubleValue(), AttributeModifier.Operation.ADDITION));
    }
}

