/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.EnumShopResult;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    public static void starterItems(Player player) {
        ItemStack broadSword = new ItemStack((ItemLike)ModItems.BROAD_SWORD.get());
        ItemStack hammer = new ItemStack((ItemLike)ModItems.HAMMER_SCRAP.get());
        ItemUtils.spawnItemAtEntity((LivingEntity)player, broadSword);
        ItemUtils.spawnItemAtEntity((LivingEntity)player, hammer);
    }

    public static int getChargeTime(LivingEntity entity) {
        return Mth.m_14165_((double)EntityUtils.tryGetAttribute(entity, (Attribute)ModAttributes.CHARGE_TIME.get()));
    }

    public static int getChargeTime(LivingEntity entity, EnumToolTier toolTier) {
        int time = Mth.m_14165_((double)EntityUtils.tryGetAttribute(entity, (Attribute)ModAttributes.CHARGE_TIME.get()));
        if (toolTier == EnumToolTier.PLATINUM) {
            time = (int)((float)time * GeneralConfig.platinumChargeTime);
        }
        return time;
    }

    public static void spawnItemAtEntity(LivingEntity entity, ItemStack stack) {
        ItemUtils.spawnItemAt(entity.f_19853_, entity.m_142538_(), stack, entity);
    }

    public static void spawnItemAt(Level level, BlockPos pos, ItemStack stack, @Nullable LivingEntity entity) {
        if (!level.f_46443_) {
            ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
            item.m_32010_(0);
            if (entity != null) {
                item.m_32047_(entity.m_142081_());
            }
            level.m_7967_((Entity)item);
        }
    }

    public static void spawnLeveledItem(LivingEntity entity, ItemStack stack, int level) {
        if (!entity.f_19853_.f_46443_) {
            ItemEntity item = new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ItemNBT.getLeveledItem(stack, level));
            item.m_32010_(0);
            entity.f_19853_.m_7967_((Entity)item);
        }
    }

    public static int getSellPrice(ItemStack stack) {
        return DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).map(stat -> ItemUtils.getSellPrice(stack, stat)).orElse(0);
    }

    public static int getSellPrice(ItemStack stack, ItemStat stat) {
        return stat.getSell() * ItemNBT.itemLevel(stack);
    }

    public static int getBuyPrice(ItemStack stack) {
        return DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).map(stat -> ItemUtils.getBuyPrice(stack, stat)).orElse(0);
    }

    public static EnumShopResult buyItem(Player player, EntityNPCBase npc, ItemStack stack) {
        if (ItemUtils.sizeInv(player.m_150109_(), stack) < stack.m_41613_()) {
            player.m_5496_(SoundEvents.f_12507_, 1.0f, 1.0f);
            return EnumShopResult.NOSPACE;
        }
        int price = ItemUtils.getBuyPrice(stack) * stack.m_41613_();
        if (Platform.INSTANCE.getPlayerData(player).map(d -> d.useMoney(player, price)).orElse(false).booleanValue()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModCriteria.SHOP_TRIGGER.trigger(serverPlayer, npc, stack);
            }
            player.m_5496_(SoundEvents.f_12509_, 1.0f, 1.0f);
            while (stack.m_41613_() > 0) {
                ItemStack copy = stack.m_41777_();
                int count = Math.min(stack.m_41613_(), stack.m_41741_());
                copy.m_41764_(count);
                ItemUtils.spawnItemAtEntity((LivingEntity)player, copy);
                stack.m_41764_(stack.m_41613_() - count);
            }
            return EnumShopResult.SUCCESS;
        }
        player.m_5496_(SoundEvents.f_12507_, 1.0f, 1.0f);
        return EnumShopResult.NOMONEY;
    }

    private static int sizeInv(Inventory playerInv, ItemStack stack) {
        int amount = 0;
        for (ItemStack iStack : playerInv.f_35974_) {
            if (iStack.m_41619_()) {
                amount += stack.m_41741_();
                continue;
            }
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)iStack)) continue;
            amount += stack.m_41741_() - iStack.m_41613_();
        }
        return amount;
    }

    public static int getBuyPrice(ItemStack stack, ItemStat stat) {
        return stat.getBuy();
    }

    public static float getShieldEfficiency(LivingEntity entity) {
        return ItemUtils.getShieldEfficiency(entity.m_21205_());
    }

    public static float getShieldEfficiency(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IItemUsable) {
            IItemUsable usable = (IItemUsable)item;
            float eff = usable.getWeaponType().shieldEfficiency;
            if (ItemNBT.hasDragonScaleUpgrade(stack)) {
                eff = Math.min(0.5f, eff + 0.5f);
            }
            return eff;
        }
        return 1.0f;
    }

    public static EquipmentSlot slotOf(ItemStack stack) {
        if (stack.m_41720_() instanceof ShieldItem) {
            return EquipmentSlot.OFFHAND;
        }
        return LivingEntity.m_147233_((ItemStack)stack);
    }
}

