/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.Lists;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.DistanceZoningConfig;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class LevelCalc {
    private static long[] LEVEL_XP_TOTAL;
    private static long[] COMMON_SKILL_XP;
    private static long[] SLOW_SKILL_XP;
    private static long[] FAST_SKILL_XP;
    private static long[] VERY_FAST_SKILL_XP;
    private static long[] CRAFTING_SKILL_XP;
    private static long[] FRIEND_XP_TOTAL;

    public static int xpAmountForLevelUp(int level) {
        if (level <= 0) {
            return 1;
        }
        if (level >= GeneralConfig.maxLevel) {
            return 0;
        }
        return (int)(LevelCalc.totalXpForLevel(level + 1) - LevelCalc.totalXpForLevel(level));
    }

    public static long totalXpForLevel(int level) {
        if (level <= 0) {
            return 0L;
        }
        if (LEVEL_XP_TOTAL == null || LEVEL_XP_TOTAL.length < level) {
            int len = level + 10;
            LEVEL_XP_TOTAL = new long[len];
            LevelCalc.LEVEL_XP_TOTAL[0] = 50L;
            long prev = LEVEL_XP_TOTAL[0];
            for (int l = 1; l < len; ++l) {
                LevelCalc.LEVEL_XP_TOTAL[l] = (long)((double)(prev + 5L + (long)l * 10L) + 15.0 * Math.pow(l, 1.25) + (double)((long)(l / 10) * 250L) + (double)((long)(l / 20 * (l / 20)) * 1000L));
                prev = LEVEL_XP_TOTAL[l];
            }
        }
        return LEVEL_XP_TOTAL[level - 1];
    }

    public static int xpAmountForSkillLevelUp(EnumSkills skill, int level) {
        if (level <= 0) {
            return 1;
        }
        if (level >= DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel()) {
            return 0;
        }
        return (int)(LevelCalc.totalSkillXpForLevel(skill, level + 1) - LevelCalc.totalSkillXpForLevel(skill, level));
    }

    public static long totalSkillXpForLevel(EnumSkills skill, int level) {
        if (level <= 0) {
            return 0L;
        }
        long[] xps = switch (skill.gainType) {
            default -> throw new IncompatibleClassChangeError();
            case EnumSkills.GainType.COMMON -> {
                if (COMMON_SKILL_XP == null || COMMON_SKILL_XP.length < level) {
                    yield COMMON_SKILL_XP = LevelCalc.calcSkillXPs(COMMON_SKILL_XP, level, (l, prev) -> (long)((double)(prev + 35L) + 9.0 * Math.pow(l.intValue(), 2.555) - 12.0 * Math.pow(l.intValue(), 2.249) + (double)((long)l.intValue() * 21L)));
                }
                yield COMMON_SKILL_XP;
            }
            case EnumSkills.GainType.SLOW -> {
                if (SLOW_SKILL_XP == null || SLOW_SKILL_XP.length < level) {
                    SLOW_SKILL_XP = LevelCalc.calcSkillXPs(SLOW_SKILL_XP, level, (l, prev) -> prev + 25L + ((long)l.intValue() - 1L) * 15L + (long)(l / 10) * 100L + (long)(Math.pow(l.intValue(), 1.2) * 3.0 + Math.pow(l / 10, 2.0) * 50.0 + Math.pow(Math.max(0, l - 50) / 10, 1.235) * 500.0));
                    yield SLOW_SKILL_XP;
                }
                yield SLOW_SKILL_XP;
            }
            case EnumSkills.GainType.FAST -> {
                if (FAST_SKILL_XP == null || FAST_SKILL_XP.length < level) {
                    FAST_SKILL_XP = LevelCalc.calcSkillXPs(FAST_SKILL_XP, level, (l, prev) -> prev + 40L + (long)(l * 30) + (long)((int)(Math.pow(l.intValue(), 1.75) * 0.125) * 10));
                    yield FAST_SKILL_XP;
                }
                yield FAST_SKILL_XP;
            }
            case EnumSkills.GainType.VERY_FAST -> {
                if (VERY_FAST_SKILL_XP == null || VERY_FAST_SKILL_XP.length < level) {
                    VERY_FAST_SKILL_XP = LevelCalc.calcSkillXPs(VERY_FAST_SKILL_XP, level, (l, prev) -> prev + 50L + ((long)l.intValue() - 1L) * 30L);
                    yield VERY_FAST_SKILL_XP;
                }
                yield VERY_FAST_SKILL_XP;
            }
            case EnumSkills.GainType.CRAFTING -> {
                if (CRAFTING_SKILL_XP == null || CRAFTING_SKILL_XP.length < level) {
                    CRAFTING_SKILL_XP = LevelCalc.calcSkillXPs(CRAFTING_SKILL_XP, level, (l, prev) -> prev + 50L + ((long)l.intValue() - 1L) * 15L + (long)(l / 10) * 25L + (l % 10 == 0 ? (long)(l / 10) * 35L : 0L));
                    yield CRAFTING_SKILL_XP;
                }
                yield CRAFTING_SKILL_XP;
            }
        };
        return xps[level - 1];
    }

    private static long[] calcSkillXPs(long[] current, int level, BiFunction<Integer, Long, Long> levelXP) {
        if (current != null && current.length >= level) {
            return current;
        }
        int len = level + 10;
        if (current != null) {
            len = level + 50;
        }
        long[] xps = new long[len];
        xps[0] = 0L;
        long prev = xps[0];
        for (int l = 1; l < len; ++l) {
            xps[l] = levelXP.apply(l, prev);
            prev = xps[l];
        }
        return xps;
    }

    public static int friendPointsForNext(int level) {
        if (level <= 0) {
            return 1;
        }
        if (level >= 20) {
            return 0;
        }
        if (level >= 10) {
            return 1000;
        }
        return (int)(LevelCalc.totalFriendPointsForLevel(level) - LevelCalc.totalFriendPointsForLevel(level - 1));
    }

    public static long totalFriendPointsForLevel(int level) {
        if (level <= 0 || level >= 10) {
            return 0L;
        }
        if (FRIEND_XP_TOTAL == null) {
            FRIEND_XP_TOTAL = new long[10];
            LevelCalc.FRIEND_XP_TOTAL[0] = 30L;
            long prev = FRIEND_XP_TOTAL[0];
            for (int l = 1; l < 10; ++l) {
                LevelCalc.FRIEND_XP_TOTAL[l] = prev + 45L + (long)(l * 5) + (long)(l * l * 10);
                prev = FRIEND_XP_TOTAL[l];
            }
        }
        return FRIEND_XP_TOTAL[level - 1];
    }

    public static int getMoney(int base, int level) {
        return base;
    }

    public static void addXP(LivingEntity attacker, int base, int money, int level) {
        LevelCalc.addXP(attacker, base, money, level, true);
    }

    public static void addXP(LivingEntity attacker, int base, int money, int level, boolean adjustOnLevel) {
        EntityNPCBase npc;
        OwnableEntity ownable;
        Entity entity;
        if (GeneralConfig.xpMultiplier == 0.0f) {
            return;
        }
        ServerPlayer player = null;
        if (attacker instanceof ServerPlayer) {
            ServerPlayer sP;
            player = sP = (ServerPlayer)attacker;
        } else if (attacker instanceof OwnableEntity && (entity = (ownable = (OwnableEntity)attacker).m_142480_()) instanceof ServerPlayer) {
            ServerPlayer sP;
            player = sP = (ServerPlayer)entity;
        } else if (attacker instanceof EntityNPCBase && (entity = (npc = (EntityNPCBase)attacker).followEntity()) instanceof ServerPlayer) {
            ServerPlayer sP;
            player = sP = (ServerPlayer)entity;
        }
        if (player != null) {
            ServerPlayer finalPlayer = player;
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                data.addXp((Player)finalPlayer, adjustOnLevel ? LevelCalc.levelXpWith(base, data.getPlayerLevel().getLevel(), level) : (float)base);
                data.setMoney((Player)finalPlayer, data.getMoney() + LevelCalc.getMoney(money, level));
            });
            if (!(attacker instanceof Player)) {
                LevelCalc.tryAddXPTo(attacker, player, base, level, adjustOnLevel);
            }
            for (Mob e2 : player.f_19853_.m_142425_(EntityTypeTest.m_156916_(Mob.class), player.m_142469_().m_82377_(32.0, 32.0, 32.0), e -> true)) {
                if (e2 == attacker) continue;
                LevelCalc.tryAddXPTo((LivingEntity)e2, player, base, level, adjustOnLevel);
            }
        }
    }

    private static void tryAddXPTo(LivingEntity entity, ServerPlayer player, int base, int level, boolean adjustOnLevel) {
        if (entity instanceof IBaseMob) {
            IBaseMob mob = (IBaseMob)entity;
            Consumer<Float> cons = null;
            if (entity instanceof BaseMonster) {
                BaseMonster monster = (BaseMonster)entity;
                if (player.m_142081_().equals(monster.m_142504_()) && monster.behaviourState() == BaseMonster.Behaviour.FOLLOW) {
                    cons = monster::addXp;
                }
            }
            if (entity instanceof EntityNPCBase) {
                EntityNPCBase npc = (EntityNPCBase)entity;
                if (player.m_142081_().equals(npc.getEntityToFollowUUID())) {
                    cons = npc::addXp;
                }
            }
            if (cons == null) {
                return;
            }
            cons.accept(Float.valueOf(adjustOnLevel ? LevelCalc.levelXpWith(base, mob.level().getLevel(), level) : (float)base));
        }
    }

    private static float levelXpWith(int base, int level, int targetLevel) {
        float xp = ((float)base + (float)(base * (level - 1)) * 0.5f) * GeneralConfig.xpMultiplier;
        if (level <= targetLevel) {
            return xp;
        }
        int diff = level - targetLevel;
        return xp * Math.max(0.01f, 1.0f - (float)diff * 0.075f) * GeneralConfig.xpMultiplier;
    }

    public static float getSkillXpMultiplier(EnumSkills skill) {
        return DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).xpMultiplier();
    }

    public static void levelSkill(ServerPlayer player, PlayerData data, EnumSkills skill, float amount) {
        if (GeneralConfig.skillXpMultiplier == 0.0f) {
            return;
        }
        data.increaseSkill(skill, (Player)player, LevelCalc.getSkillXpMultiplier(skill) * amount * GeneralConfig.skillXpMultiplier);
    }

    public static GateLevelResult levelFromPos(ServerLevel level, Vec3 pos) {
        List<ServerPlayer> nearby = LevelCalc.playersAround((EntityGetter)level, pos, 256.0);
        return new GateLevelResult(LevelCalc.levelFromPos(level, pos, nearby), nearby);
    }

    public static int levelFromPos(ServerLevel level, Vec3 pos, List<ServerPlayer> list) {
        return Math.max(1, switch (MobConfig.gateLevelType) {
            default -> throw new IncompatibleClassChangeError();
            case MobConfig.GateLevelType.CONSTANT -> LevelCalc.randomizedLevel(level.f_46441_, LevelCalc.getLevelFor(MobConfig.baseGateLevel, list, null));
            case MobConfig.GateLevelType.DISTANCESPAWN -> LevelCalc.randomizedLevel(level.f_46441_, LevelCalc.getLevelFor(MobConfig.baseGateLevel + LevelCalc.distanceLevelFrom((Level)level, pos, level.m_8900_()), list, null));
            case MobConfig.GateLevelType.DISTANCESPAWNPLAYER -> LevelCalc.randomizedLevel(level.f_46441_, LevelCalc.getLevelFor(MobConfig.baseGateLevel, list, (player, d) -> {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos center = serverPlayer.m_8963_() != level.m_46472_() || serverPlayer.m_8961_() == null ? level.m_8900_() : serverPlayer.m_8961_();
                return LevelCalc.distanceLevelFrom((Level)level, pos, center);
            }));
            case MobConfig.GateLevelType.PLAYERLEVEL -> LevelCalc.randomizedLevel(level.f_46441_, LevelCalc.getLevelFor(MobConfig.baseGateLevel, list, (p, d) -> d.map(data -> data.getPlayerLevel().getLevel()).orElse(1)));
        });
    }

    private static int getLevelFor(int base, List<ServerPlayer> list, ToIntBiFunction<Player, Optional<PlayerData>> levelFunc) {
        if (levelFunc == null && !MobConfig.playerLevelType.increased) {
            return base;
        }
        if (list.isEmpty()) {
            return base;
        }
        int lvl = 0;
        boolean mean = MobConfig.playerLevelType.mean;
        for (Player player : list) {
            int pL;
            Optional<PlayerData> data = Platform.INSTANCE.getPlayerData(player);
            int n = pL = levelFunc != null ? levelFunc.applyAsInt(player, data) : 0;
            if (MobConfig.playerLevelType.increased) {
                pL += data.map(PlayerData::getMobLevelIncrease).orElse(0).intValue();
            }
            if (mean) {
                lvl += pL;
                continue;
            }
            if (pL <= lvl) continue;
            lvl = pL;
        }
        lvl = mean ? lvl / list.size() : lvl;
        return base + lvl;
    }

    private static int distanceLevelFrom(Level level, Vec3 pos, BlockPos center) {
        Vec3 spawn = Vec3.m_82512_((Vec3i)center);
        double dX = spawn.f_82479_ - pos.f_82479_;
        double dZ = spawn.f_82481_ - pos.f_82481_;
        double dist = Math.sqrt(dX * dX + dZ * dZ);
        Pair<Float, DistanceZoningConfig.Zone> zone = MobConfig.levelZones.get((float)dist);
        return LevelCalc.randomizedLevel(level.f_46441_, (int)((double)((DistanceZoningConfig.Zone)zone.getRight()).start() + (dist - (double)((Float)zone.getLeft()).floatValue()) * (double)((DistanceZoningConfig.Zone)zone.getRight()).increasePerBlock()));
    }

    public static List<ServerPlayer> playersAround(EntityGetter getter, Vec3 pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (Player player : getter.m_6907_()) {
            if (!EntitySelector.f_20408_.test(player) || !EntitySelector.f_20403_.test(player) || !(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!player.m_20182_().m_82509_((Position)pos, radius)) continue;
            list.add(serverPlayer);
        }
        return list;
    }

    public static int randomizedLevel(Random random, int level) {
        return level + Math.round((float)((random.nextDouble() * 2.0 - 1.0) * Math.ceil((double)level * 0.15)));
    }

    public static boolean useRP(Player player, PlayerData data, float amount, boolean hurt, float percent, boolean mean, EnumSkills ... skills) {
        int skillVal = 0;
        if (skills.length == 0) {
            skillVal = 1;
        } else if (skills.length == 1) {
            skillVal = data.getSkillLevel(skills[0]).getLevel();
        } else if (mean) {
            float l = skills.length;
            float sLvl = 0.0f;
            for (EnumSkills skill : skills) {
                sLvl += (float)data.getSkillLevel(skill).getLevel();
            }
            skillVal = (int)(sLvl / l);
        } else {
            for (EnumSkills skill : skills) {
                int lvl = data.getSkillLevel(skill).getLevel();
                if (lvl <= skillVal) continue;
                skillVal = lvl;
            }
        }
        float skillReduction = Math.max(1.0f - (float)(skillVal - 1) * 0.0065f, 0.3f);
        float val = amount * skillReduction;
        float percentAmount = percent > 0.0f ? (float)data.getMaxRunePoints() * percent * skillReduction : 0.0f;
        val = Math.max(percentAmount, val);
        int usage = Mth.m_14167_((float)val);
        return data.decreaseRunePoints(player, usage, hurt);
    }

    public static float getMultiplierInterval(int level, int interval, float max, float bonus) {
        if (level < interval || bonus == 0.0f) {
            return level - 1;
        }
        int mod = level % interval;
        int completed = level / interval;
        float multiplier = interval - 2;
        for (int i = 1; i < completed; ++i) {
            multiplier += (float)interval * Math.min(max, (float)i + bonus);
        }
        return multiplier += (float)(mod + 1) * Math.min(max, 1.0f + (float)completed * bonus);
    }

    @Nullable
    public static EnumSkills getSkillFromElement(EnumElement element) {
        return switch (element) {
            case EnumElement.WATER -> EnumSkills.WATER;
            case EnumElement.EARTH -> EnumSkills.EARTH;
            case EnumElement.WIND -> EnumSkills.WIND;
            case EnumElement.FIRE -> EnumSkills.FIRE;
            case EnumElement.LIGHT -> EnumSkills.LIGHT;
            case EnumElement.DARK -> EnumSkills.DARK;
            case EnumElement.LOVE -> EnumSkills.LOVE;
            default -> null;
        };
    }

    public record GateLevelResult(int level, List<ServerPlayer> nearby) {
    }
}

