/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.tenshilib.common.entity.EntityBeam;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class ProjectileUtil {
    public static void shoot(LivingEntity shooter, EntityProjectile projectile, float velocity, float inaccuracy) {
        Vec3 target = ProjectileUtil.getAimTarget(shooter, projectile.m_20182_());
        if (target != null) {
            projectile.shootAtPosition(target.m_7096_(), target.m_7098_(), target.m_7094_(), velocity, inaccuracy);
        } else {
            projectile.shoot((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, inaccuracy);
        }
    }

    public static void shoot(LivingEntity shooter, EntityBeam beam, float inaccuracy) {
        Mob mob;
        MobAttackExt ext;
        MobAttackExt.TargetPosition target;
        if (shooter instanceof MobAttackExt && (target = (ext = (MobAttackExt)shooter).getTargetPosition()) != null) {
            Vec3 v = target.asVec(beam.m_20182_());
            beam.setRotationTo(v.m_7096_(), v.m_7098_(), v.m_7094_(), inaccuracy);
        } else if (shooter instanceof Mob && (mob = (Mob)shooter).m_5448_() != null) {
            beam.setRotationTo((Entity)mob.m_5448_(), inaccuracy);
        } else {
            beam.m_146922_((shooter.f_20885_ - 180.0f) % 360.0f);
            beam.m_146926_(shooter.m_146909_() % 360.0f);
        }
    }

    public static Vec3 getAimTarget(LivingEntity shooter) {
        return ProjectileUtil.getAimTarget(shooter, (double)shooter.m_20192_() - 0.1);
    }

    public static Vec3 getAimTarget(LivingEntity shooter, Vec3 from) {
        return ProjectileUtil.getAimTarget(shooter, from.m_7098_() - shooter.m_20186_());
    }

    public static Vec3 getAimTarget(LivingEntity shooter, double offset) {
        Mob mob;
        MobAttackExt ext;
        MobAttackExt.TargetPosition target;
        if (shooter instanceof MobAttackExt && (target = (ext = (MobAttackExt)shooter).getTargetPosition()) != null) {
            return target.asVec(shooter.m_20182_().m_82520_(0.0, offset, 0.0));
        }
        if (shooter instanceof Mob && (mob = (Mob)shooter).m_5448_() != null) {
            return EntityUtil.getStraightProjectileTarget((Vec3)shooter.m_20182_(), (Entity)mob.m_5448_());
        }
        return null;
    }
}

