/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TeleportUtils {
    public static boolean safeDimensionTeleport(Mob entity, ServerLevel newLevel, BlockPos target) {
        BlockPos safe = null;
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = TeleportUtils.randomIntInclusive(entity.m_21187_(), -3, 3);
            BlockPos pos = TeleportUtils.isSafePos(entity, (Level)newLevel, target.m_142082_(x, y = TeleportUtils.randomIntInclusive(entity.m_21187_(), -1, 2), z = TeleportUtils.randomIntInclusive(entity.m_21187_(), -3, 3)), s -> true);
            if (pos == null) continue;
            safe = pos;
            break;
        }
        if (safe == null) {
            return false;
        }
        float yaw = entity.m_146908_();
        float pitch = entity.m_146909_();
        entity.m_19877_();
        Mob old = entity;
        entity = (Mob)old.m_6095_().m_20615_((Level)newLevel);
        if (entity == null) {
            return false;
        }
        entity.m_20361_((Entity)old);
        entity.m_7678_((double)safe.m_123341_(), (double)safe.m_123342_(), (double)safe.m_123343_(), yaw, pitch);
        old.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
        newLevel.m_143334_((Entity)entity);
        newLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11852_, SoundSource.MASTER, 1.0f, 1.0f);
        for (int i = 0; i < 32; ++i) {
            newLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_(), entity.m_20186_() + newLevel.f_46441_.nextDouble() * 2.0, entity.m_20189_(), 0, newLevel.f_46441_.nextGaussian(), 0.0, newLevel.f_46441_.nextGaussian(), 1.0);
        }
        return true;
    }

    public static boolean tryTeleportAround(Mob entity, Entity target) {
        BlockPos blockPos = target.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = TeleportUtils.randomIntInclusive(entity.m_21187_(), -3, 3);
            BlockPos pos = blockPos.m_142082_(x, y = TeleportUtils.randomIntInclusive(entity.m_21187_(), -1, 2), z = TeleportUtils.randomIntInclusive(entity.m_21187_(), -3, 3));
            if (!TeleportUtils.validTeleportPlace(entity, pos, s -> true)) continue;
            entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, entity.m_146908_(), entity.m_146909_());
            entity.m_21573_().m_26573_();
            return true;
        }
        return false;
    }

    public static boolean tryTeleportAround(Mob entity, BlockPos target) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = TeleportUtils.randomIntInclusive(entity.m_21187_(), -3, 3);
            BlockPos pos = target.m_142082_(x, y = TeleportUtils.randomIntInclusive(entity.m_21187_(), -1, 2), z = TeleportUtils.randomIntInclusive(entity.m_21187_(), -3, 3));
            if (!TeleportUtils.validTeleportPlace(entity, pos, s -> true)) continue;
            entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, entity.m_146908_(), entity.m_146909_());
            entity.m_21573_().m_26573_();
            return true;
        }
        return false;
    }

    public static boolean validTeleportPlace(Mob entity, BlockPos pos, Predicate<BlockState> validPos) {
        return TeleportUtils.isSafePos(entity, pos, validPos) != null;
    }

    public static BlockPos isSafePos(Mob entity, BlockPos pos, Predicate<BlockState> validPos) {
        return TeleportUtils.isSafePos(entity, entity.f_19853_, pos, validPos);
    }

    public static BlockPos isSafePos(Mob entity, Level level, BlockPos pos, Predicate<BlockState> validPos) {
        BlockPathTypes blockPathTypes = entity.m_21573_().m_26575_().m_8086_((BlockGetter)level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        if (blockPathTypes == BlockPathTypes.OPEN ? !entity.m_20068_() : blockPathTypes != BlockPathTypes.WALKABLE) {
            return null;
        }
        BlockState blockState = level.m_8055_(pos.m_7495_());
        if (!validPos.test(blockState)) {
            return null;
        }
        for (VoxelShape voxelShape : level.m_186434_((Entity)entity, entity.m_142469_().m_82386_((double)pos.m_123341_() + 0.5 - entity.m_20185_(), (double)pos.m_123342_() - entity.m_20186_(), (double)pos.m_123343_() + 0.5 - entity.m_20189_()))) {
            if (voxelShape.m_83281_()) continue;
            return null;
        }
        return pos;
    }

    private static int randomIntInclusive(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }
}

