/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.mixin.BiomeAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.entity.EntityInLevelCallback;

public class WorldUtils {
    public static final TicketType<ChunkPos> ENTITY_LOADER = TicketType.m_9465_((String)"runecraftory_entity_loader", Comparator.comparingLong(ChunkPos::m_45588_), (int)100);
    public static final Codec<Pair<EnumSeason, Integer>> DATE = RecordCodecBuilder.create(inst -> inst.group((App)CodecUtils.stringEnumCodec(EnumSeason.class, null).fieldOf("season").forGetter(Pair::getFirst), (App)WorldUtils.dayRange().fieldOf("day").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));

    private static Codec<Integer> dayRange() {
        Function<Integer, DataResult> function = i -> {
            if (i >= 1 && i <= 30) {
                return DataResult.success((Object)i);
            }
            return DataResult.error((String)("Date must be between 1 - 30 but is " + i));
        };
        return Codec.INT.flatXmap(function, function);
    }

    public static boolean canUpdateDaily(Level level, int lastUpdate) {
        return ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46140_)).m_46223_() && WorldUtils.day(level) != lastUpdate;
    }

    public static int dayTime(Level level) {
        return (int)(level.m_46468_() % 24000L);
    }

    public static int dayTimeTotal(Level level) {
        return (int)level.m_46468_();
    }

    public static long totalTime(Level level) {
        return level.m_46467_();
    }

    public static int day(Level level) {
        return WorldUtils.day(level, 0);
    }

    public static int day(Level world, int tickOffset) {
        return (int)((world.m_46468_() + (long)tickOffset) / 24000L % Integer.MAX_VALUE);
    }

    public static boolean canPlaceSnowAt(Level level, BlockPos pos) {
        return pos.m_123342_() >= level.m_141937_() && pos.m_123342_() < level.m_151558_() && level.m_45517_(LightLayer.BLOCK, pos) < 10 && level.m_8055_(pos).m_60795_() && Blocks.f_50125_.m_49966_().m_60710_((LevelReader)level, pos);
    }

    public static boolean coldEnoughForSnow(Level level, BlockPos pos, Biome biome) {
        if (biome.m_198904_(pos)) {
            return false;
        }
        return (double)WorldUtils.seasonBasedTemp(level, pos, biome) < 0.15;
    }

    public static float seasonBasedTemp(Level level, BlockPos pos, Biome biome) {
        EnumSeason season;
        float temp = ((BiomeAccessor)biome).biomeTemp(pos);
        if (!GeneralConfig.seasonedSnow) {
            return temp;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            season = WorldHandler.get(serverLevel.m_142572_()).currentSeason();
        } else {
            season = ClientHandlers.CLIENT_CALENDAR.currentSeason();
        }
        switch (season) {
            case SUMMER: {
                temp += 0.1f;
                break;
            }
            case FALL: {
                temp -= 0.25f;
                break;
            }
            case WINTER: {
                temp -= 0.8f;
            }
        }
        return temp;
    }

    public static <T extends Mob> EntityInLevelCallback wrappedCallbackFor(final T member, final Supplier<Player> partyOwner, final EntityInLevelCallback callback) {
        return new EntityInLevelCallback(){

            public void m_142044_() {
                callback.m_142044_();
            }

            public void m_142472_(Entity.RemovalReason reason) {
                Level level = member.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (reason == Entity.RemovalReason.UNLOADED_TO_CHUNK) {
                        WorldHandler.get(serverLevel.m_142572_()).safeUnloadedPartyMembers((LivingEntity)member);
                    } else if (reason == Entity.RemovalReason.DISCARDED || reason == Entity.RemovalReason.KILLED) {
                        Player owner = (Player)partyOwner.get();
                        if (owner instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)owner;
                            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(d -> d.party.removePartyMember((Entity)member));
                        } else {
                            WorldHandler.get(serverLevel.m_142572_()).toRemovePartyMember((LivingEntity)member);
                        }
                    }
                }
                callback.m_142472_(reason);
            }
        };
    }
}

