/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.Logger;

public class BarnData {
    public final GlobalPos pos;
    private int size = 0;
    private int roofHeight;
    private int changeCooldown;
    private final Map<UUID, Integer> monsters = new HashMap<UUID, Integer>();
    private final Set<BaseMonster> listeners = new HashSet<BaseMonster>();
    private boolean removed;

    public BarnData(GlobalPos pos) {
        this.pos = pos;
    }

    public static BarnData fromTag(CompoundTag tag) {
        DataResult dataResult = GlobalPos.f_122633_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("Pos")));
        BarnData data = new BarnData((GlobalPos)dataResult.getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)));
        data.load(tag);
        return data;
    }

    public void update(int size, int roofHeight) {
        if (this.size != size || this.roofHeight != roofHeight) {
            this.changeCooldown = 150;
        }
        this.size = size;
        this.roofHeight = roofHeight;
        --this.changeCooldown;
        this.listeners.removeIf(m -> {
            if (m.behaviourState() == BaseMonster.Behaviour.WANDER_HOME && m.f_19853_.m_46472_() == this.pos.m_122640_()) {
                m.m_21446_(this.pos.m_122646_(), this.getSize() + 1);
            }
            return m.m_146910_();
        });
    }

    public void addMonster(BaseMonster monster, int size) {
        this.monsters.put(monster.m_142081_(), size);
        this.listeners.add(monster);
    }

    public void removeMonster(BaseMonster monster) {
        this.monsters.remove(monster.m_142081_());
        this.listeners.remove(monster);
    }

    public boolean hasCapacityFor(BaseMonster monster) {
        int size = monster.getProp().size;
        boolean needsRoof = monster.getProp().needsRoof;
        if (needsRoof && this.roofHeight <= 0) {
            return false;
        }
        if ((float)this.roofHeight <= monster.m_20206_() + 1.0f) {
            return false;
        }
        return this.usedCapacity() + size <= this.getCapacity();
    }

    public int getCapacity() {
        if (this.getSize() < 2) {
            return 0;
        }
        if (this.getSize() < 4) {
            return (this.getSize() - 1) * 2;
        }
        return (this.getSize() - 3) * 4 + 2;
    }

    public int usedCapacity() {
        return this.monsters.values().stream().mapToInt(i -> i).sum();
    }

    public boolean hasRoof() {
        return this.roofHeight > 0;
    }

    public int roofHeight() {
        return this.roofHeight;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isInvalid() {
        return this.removed || this.size < 2;
    }

    public boolean isInvalidFor(BaseMonster monster) {
        if (this.isInvalid()) {
            return true;
        }
        if (this.monsters.containsKey(monster.m_142081_()) && this.changeCooldown > 0) {
            return false;
        }
        if (this.roofHeight > 0) {
            return (float)this.roofHeight < monster.m_20206_() + 1.0f;
        }
        return !monster.getProp().needsRoof;
    }

    public void remove() {
        this.removed = true;
    }

    public void load(CompoundTag tag) {
        this.size = tag.m_128451_("Size");
        this.roofHeight = tag.m_128451_("RoofHeight");
        this.changeCooldown = tag.m_128451_("ChangeCooldown");
        CompoundTag monsters = tag.m_128469_("Monsters");
        monsters.m_128431_().forEach(key -> this.monsters.put(UUID.fromString(key), monsters.m_128451_(key)));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.pos).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(t -> tag.m_128365_("Pos", t));
        tag.m_128405_("Size", this.size);
        tag.m_128405_("RoofHeight", this.roofHeight);
        tag.m_128405_("ChangeCooldown", this.changeCooldown);
        CompoundTag monsters = new CompoundTag();
        this.monsters.forEach((uuid, integer) -> monsters.m_128405_(uuid.toString(), integer.intValue()));
        tag.m_128365_("Monsters", (Tag)monsters);
        return tag;
    }

    public String toString() {
        return String.format("Barn[%s]; Size: %d, With Roof: %s, Capacity: %d, FreeCapacity: %d", this.pos, this.size, this.roofHeight, this.getCapacity(), this.getCapacity() - this.monsters.values().stream().mapToInt(i -> i).sum());
    }
}

