/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class NPCHandler {
    private final Map<UUID, Component> npcs = new HashMap<UUID, Component>();
    private final Map<ResourceLocation, Set<UUID>> uniqueNPCS = new HashMap<ResourceLocation, Set<UUID>>();
    private final Map<UUID, Set<Pair<UUID, ResourceLocation>>> resetQuestNPCS = new HashMap<UUID, Set<Pair<UUID, ResourceLocation>>>();

    public boolean doesNPCExist(UUID uuid) {
        return this.npcs.containsKey(uuid);
    }

    public void addNPC(EntityNPCBase npc) {
        this.npcs.put(npc.m_142081_(), npc.m_7755_());
    }

    public Component getName(UUID uuid) {
        return this.npcs.get(uuid);
    }

    public void removeNPC(EntityNPCBase npc, Entity.RemovalReason reason) {
        if (reason.m_146965_()) {
            npc.m_20194_().m_6846_().m_11314_().forEach(p -> QuestHandler.removeQuestFor(p, npc));
            npc.getFamily().markAsDead();
            this.npcs.remove(npc.m_142081_());
        } else {
            this.npcs.put(npc.m_142081_(), npc.m_7755_());
        }
    }

    public boolean canAssignNPC(NPCData data) {
        if (data.unique() == 0) {
            return true;
        }
        ResourceLocation res = DataPackHandler.INSTANCE.npcDataManager().getId(data);
        Set<UUID> uuids = this.uniqueNPCS.get(res);
        return uuids == null || uuids.size() < data.unique();
    }

    public boolean addUniqueNPC(UUID uuid, NPCData data) {
        if (data.unique() == 0) {
            return false;
        }
        ResourceLocation res = DataPackHandler.INSTANCE.npcDataManager().getId(data);
        return this.uniqueNPCS.computeIfAbsent(res, key -> new HashSet()).add(uuid);
    }

    public boolean removeUniqueNPC(UUID uuid, NPCData data) {
        if (data.unique() == 0) {
            return false;
        }
        ResourceLocation res = DataPackHandler.INSTANCE.npcDataManager().getId(data);
        return this.uniqueNPCS.computeIfAbsent(res, key -> new HashSet()).remove(uuid);
    }

    public void scheduleQuestTrackerReset(UUID npc, UUID player, ResourceLocation quest) {
        this.resetQuestNPCS.computeIfAbsent(npc, key -> new HashSet()).add(Pair.of((Object)player, (Object)quest));
    }

    public Set<Pair<UUID, ResourceLocation>> playersToReset(UUID npc) {
        return this.resetQuestNPCS.getOrDefault(npc, new HashSet());
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        CompoundTag npcs = new CompoundTag();
        this.npcs.forEach((uuid, comp) -> npcs.m_128365_(uuid.toString(), (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)comp))));
        tag.m_128365_("NPCs", (Tag)npcs);
        CompoundTag uniques = new CompoundTag();
        this.uniqueNPCS.forEach((res, ids) -> {
            ListTag idTag = new ListTag();
            ids.forEach(uuid -> idTag.add((Object)StringTag.m_129297_((String)uuid.toString())));
            uniques.m_128365_(res.toString(), (Tag)idTag);
        });
        tag.m_128365_("UniqueNPCs", (Tag)uniques);
        CompoundTag resetQuestTracker = new CompoundTag();
        this.resetQuestNPCS.forEach((uuid, ids) -> {
            CompoundTag pairs = new CompoundTag();
            ids.forEach(pair -> pairs.m_128359_(((UUID)pair.getFirst()).toString(), ((ResourceLocation)pair.getSecond()).toString()));
            resetQuestTracker.m_128365_(uuid.toString(), (Tag)pairs);
        });
        tag.m_128365_("ResetQuestNPCs", (Tag)resetQuestTracker);
        return tag;
    }

    public void load(CompoundTag tag) {
        CompoundTag npcs = tag.m_128469_("NPCs");
        npcs.m_128431_().forEach(key -> this.npcs.put(UUID.fromString(key), (Component)Component.Serializer.m_130701_((String)npcs.m_128461_(key))));
        CompoundTag uniques = tag.m_128469_("UniqueNPCs");
        uniques.m_128431_().forEach(key -> {
            ListTag idTag = uniques.m_128437_(key, 8);
            this.uniqueNPCS.put(new ResourceLocation(key), idTag.stream().map(t -> UUID.fromString(t.m_7916_())).collect(Collectors.toSet()));
        });
        CompoundTag resetQuestTracker = tag.m_128469_("ResetQuestNPCs");
        resetQuestTracker.m_128431_().forEach(key -> {
            CompoundTag pairs = resetQuestTracker.m_128469_(key);
            this.resetQuestNPCS.put(UUID.fromString(key), pairs.m_128431_().stream().map(t -> Pair.of((Object)UUID.fromString(t), (Object)new ResourceLocation(pairs.m_128461_(t)))).collect(Collectors.toSet()));
        });
    }
}

