/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world;

import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NPCSpawner
implements CustomSpawner {
    private int cooldown = 1200;

    public int m_7995_(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!level.m_142572_().m_6998_() || !level.m_46469_().m_46207_(GameRules.f_46134_)) {
            return 0;
        }
        if (--this.cooldown > 0) {
            return 0;
        }
        int cooldown = level.m_5822_().nextInt(MobConfig.npcSpawnRateMax - MobConfig.npcSpawnRateMin) + MobConfig.npcSpawnRateMin;
        if (this.doSpawning(level)) {
            this.cooldown = cooldown;
            return 1;
        }
        this.cooldown = (int)((double)cooldown * 0.5);
        return 0;
    }

    private boolean doSpawning(ServerLevel level) {
        ServerPlayer player = level.m_8890_();
        if (player == null || player.m_5833_()) {
            return false;
        }
        BlockPos blockPos = player.m_142538_();
        for (int i = 0; i < 10; ++i) {
            float f = level.f_46441_.nextFloat() * (float)Math.PI * 2.0f;
            int x = blockPos.m_123341_() + Mth.m_14143_((float)(Mth.m_14089_((float)f) * 32.0f));
            int z = blockPos.m_123343_() + Mth.m_14143_((float)(Mth.m_14031_((float)f) * 32.0f));
            Vec3 pos = this.findRandomSpawnPos(level, new BlockPos(x, blockPos.m_123342_(), z));
            if (pos == null) continue;
            this.trySpawn(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
            return true;
        }
        return false;
    }

    private void trySpawn(ServerLevel level, double x, double y, double z) {
        EntityNPCBase npc = new EntityNPCBase((EntityType<? extends EntityNPCBase>)((EntityType)ModEntities.NPC.get()), (Level)level);
        npc.m_6518_((ServerLevelAccessor)level, level.m_6436_(npc.m_142538_()), MobSpawnType.EVENT, null, null);
        npc.m_7678_(x, y, z, level.f_46441_.nextFloat() * 360.0f, 0.0f);
        level.m_47205_((Entity)npc);
    }

    @Nullable
    private Vec3 findRandomSpawnPos(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int x = pos.m_123341_() + level.f_46441_.nextInt(16) - 8;
            BlockPos blockPos = new BlockPos(x, level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = pos.m_123343_() + level.f_46441_.nextInt(16) - 8), z);
            if (!level.m_8802_(blockPos) || level.m_142425_(EntityTypeTest.m_156916_(EntityNPCBase.class), new AABB(blockPos).m_82400_(64.0), e -> true).size() > 3 || level.m_142425_(EntityTypeTest.m_156916_(Villager.class), new AABB(blockPos).m_82400_(48.0), e -> true).size() < 5) continue;
            return Vec3.m_82539_((Vec3i)blockPos);
        }
        return null;
    }
}

