/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.registry.ModStructures;
import io.github.flemmli97.runecraftory.mixinhelper.StructureTemplateModifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class VillageStructuresModification {
    public static final Map<ResourceLocation, Holder<StructureProcessorList>> MAP = new HashMap<ResourceLocation, Holder<StructureProcessorList>>();
    private static boolean INIT;

    public static void modifyVillagePools() {
        String[] vanillaVillages;
        if (INIT) {
            return;
        }
        INIT = true;
        Pools.m_211103_((StructureTemplatePool)new StructureTemplatePool(new ResourceLocation("runecraftory", "npc/bath_house_under"), new ResourceLocation("runecraftory", "npc/bath_house_under"), (List)ImmutableList.of((Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"runecraftory:npc/bath_house_under", (Holder)ProcessorLists.f_127198_).apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        for (String s : vanillaVillages = new String[]{"plains", "desert", "savanna", "snowy", "taiga"}) {
            if (!s.equals("savanna") && !s.equals("desert")) {
                Pools.m_211103_((StructureTemplatePool)new StructureTemplatePool(new ResourceLocation("runecraftory", "npc/big_houses_" + s), new ResourceLocation("runecraftory", "npc/big_houses_" + s), (List)ImmutableList.of((Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"runecraftory:npc/bath_house", VillageStructuresModification.get((ResourceLocation)ModNPCJobs.BATHHOUSE.getFirst())).apply(StructureTemplatePool.Projection.RIGID)), (Object)2), (Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"runecraftory:npc/restaurant", VillageStructuresModification.get((ResourceLocation)ModNPCJobs.COOK.getFirst())).apply(StructureTemplatePool.Projection.RIGID)), (Object)2))));
                VillageStructuresModification.add((StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(new ResourceLocation("village/" + s + "/streets")), List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210512_((String)("runecraftory:npc/streets/big_street_" + s), VillageStructuresModification.fromVillage(s)).apply(StructureTemplatePool.Projection.TERRAIN_MATCHING)), (Object)2)));
            }
            VillageStructuresModification.addHousesTo(s);
        }
    }

    private static Holder<StructureProcessorList> fromVillage(String villageType) {
        return switch (villageType) {
            case "plains" -> ProcessorLists.f_127207_;
            case "savanna" -> ProcessorLists.f_127208_;
            case "snowy", "taiga" -> ProcessorLists.f_127209_;
            default -> ProcessorLists.f_127198_;
        };
    }

    private static void addHousesTo(String villageType) {
        VillageStructuresModification.add((StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(new ResourceLocation("village/" + villageType + "/houses")), List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"runecraftory:npc/npc_house_generic", VillageStructuresModification.get((ResourceLocation)ModNPCJobs.GENERAL.getFirst())).apply(StructureTemplatePool.Projection.RIGID)), (Object)4), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"runecraftory:npc/npc_house_generic", VillageStructuresModification.get((ResourceLocation)ModNPCJobs.FLOWER.getFirst())).apply(StructureTemplatePool.Projection.RIGID)), (Object)4), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"runecraftory:npc/npc_house_smith", VillageStructuresModification.get((ResourceLocation)ModNPCJobs.SMITH.getFirst())).apply(StructureTemplatePool.Projection.RIGID)), (Object)4), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"runecraftory:npc/npc_house_clinic", VillageStructuresModification.get((ResourceLocation)ModNPCJobs.DOCTOR.getFirst())).apply(StructureTemplatePool.Projection.RIGID)), (Object)4), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"runecraftory:npc/npc_house_single", VillageStructuresModification.get((ResourceLocation)ModNPCJobs.MAGIC.getFirst())).apply(StructureTemplatePool.Projection.RIGID)), (Object)2), Pair.of((Object)((StructurePoolElement)StructurePoolElement.m_210531_((String)"runecraftory:npc/npc_house_single", VillageStructuresModification.get((ResourceLocation)ModNPCJobs.RUNE_SKILLS.getFirst())).apply(StructureTemplatePool.Projection.RIGID)), (Object)2)));
    }

    private static Holder<StructureProcessorList> get(ResourceLocation shop) {
        return MAP.computeIfAbsent(shop, s -> ModStructures.NPC_PROCESSOR_LIST.get(shop));
    }

    private static void add(StructureTemplatePool pool, List<Pair<StructurePoolElement, Integer>> houses) {
        if (pool == null) {
            return;
        }
        for (Pair<StructurePoolElement, Integer> p : houses) {
            ((StructureTemplateModifier)pool).runecraftory$addPoolElement(p);
        }
    }
}

