/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.IDailyUpdate;
import io.github.flemmli97.runecraftory.api.enums.EnumDay;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.network.S2CCalendar;
import io.github.flemmli97.runecraftory.common.utils.CalendarImpl;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.BarnData;
import io.github.flemmli97.runecraftory.common.world.NPCHandler;
import io.github.flemmli97.runecraftory.common.world.NPCSpawner;
import io.github.flemmli97.runecraftory.platform.Platform;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class WorldHandler
extends SavedData {
    private static final String ID_OLD = "RCCalendar";
    private static final String ID = "RunecraftorySaveData";
    private final CalendarImpl calendar = new CalendarImpl();
    private final Set<IDailyUpdate> updateTracker = Sets.newConcurrentHashSet();
    private final Map<UUID, Set<BarnData>> playerBarns = new HashMap<UUID, Set<BarnData>>();
    private final Map<ResourceKey<Level>, Long2ObjectMap<BarnData>> positionBarnMap = new HashMap<ResourceKey<Level>, Long2ObjectMap<BarnData>>();
    private final Map<UUID, Set<UnloadedPartyMember>> unloadedPartyMembers = new HashMap<UUID, Set<UnloadedPartyMember>>();
    private final Map<UUID, Set<UUID>> toRemovePartyMembers = new HashMap<UUID, Set<UUID>>();
    public final NPCHandler npcHandler = new NPCHandler();
    private final NPCSpawner npcSpawner = new NPCSpawner();
    private int updateDelay;
    private int lastUpdateDay;

    public WorldHandler() {
    }

    private WorldHandler(CompoundTag tag) {
        this.load(tag);
    }

    public static WorldHandler get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        WorldHandler newData = (WorldHandler)storage.m_164858_(WorldHandler::new, ID);
        if (newData != null) {
            return newData;
        }
        WorldHandler legacy = (WorldHandler)storage.m_164858_(WorldHandler::new, ID_OLD);
        if (legacy != null) {
            storage.m_164855_(ID_OLD, null);
            storage.m_164855_(ID, (SavedData)legacy);
            return legacy;
        }
        return (WorldHandler)storage.m_164861_(WorldHandler::new, WorldHandler::new, ID);
    }

    public static boolean canUpdateWeather(Level level) {
        return GeneralConfig.modifyWeather && level.m_46469_().m_46207_(GameRules.f_46140_);
    }

    public static boolean shouldUpdateWeather(Level level, EnumWeather currentWeather) {
        if (currentWeather == EnumWeather.RUNEY || currentWeather == EnumWeather.STORM) {
            return WorldUtils.dayTime(level) == 1;
        }
        long time = WorldUtils.dayTime(level);
        return time % 3000L == 1L;
    }

    public CalendarImpl getCalendar() {
        return this.calendar;
    }

    public void setDateDayAndSeason(MinecraftServer server, int date, EnumDay day, EnumSeason season) {
        this.calendar.setDateDayAndSeason(date, day, season);
        Platform.INSTANCE.sendToAll(new S2CCalendar(this.calendar), server);
        this.m_77762_();
    }

    public void increaseDay(ServerLevel level) {
        int date = WorldUtils.day((Level)level);
        EnumDay day = EnumDay.values()[Math.floorMod(date, EnumDay.values().length)];
        EnumSeason season = EnumSeason.values()[Math.floorMod(date / 30, EnumSeason.values().length)];
        this.calendar.setDateDayAndSeason(date % 30 + 1, day, season);
        Platform.INSTANCE.sendToAll(new S2CCalendar(this.calendar), level.m_142572_());
        this.m_77762_();
    }

    public EnumSeason currentSeason() {
        return this.calendar.currentSeason();
    }

    public int date() {
        return this.calendar.date();
    }

    public EnumDay currentDay() {
        return this.calendar.currentDay();
    }

    public EnumWeather currentWeather() {
        return this.calendar.currentWeather();
    }

    public EnumWeather[] tomorrowsWeather() {
        return this.calendar.tomorrowsForecast();
    }

    public void update(ServerLevel level) {
        boolean doWeather = WorldHandler.canUpdateWeather((Level)level);
        if (WorldUtils.canUpdateDaily((Level)level, this.lastUpdateDay)) {
            this.increaseDay(level);
            this.updateTracker.removeIf(IDailyUpdate::inValid);
            this.updateTracker.forEach(update -> update.update(level));
            this.createDailyWeather(level);
            if (doWeather) {
                this.updateWeatherTo(level, this.calendar.getCurrentWeatherFor(level));
            }
            this.lastUpdateDay = WorldUtils.day((Level)level);
            return;
        }
        if (doWeather && WorldHandler.shouldUpdateWeather((Level)level, this.currentWeather())) {
            this.updateWeatherTo(level, this.calendar.getCurrentWeatherFor(level));
        }
        this.npcSpawner.m_7995_(level, true, true);
    }

    public void updateWeatherTo(ServerLevel level, EnumWeather weather) {
        this.calendar.setWeather(level.m_142572_(), weather);
        this.setMCWeather(level);
        this.updateDelay = 100;
        this.m_77762_();
    }

    private void createDailyWeather(ServerLevel level) {
        EnumWeather[] nextWeather = new EnumWeather[8];
        EnumSeason season = this.currentSeason();
        int rainCount = 0;
        for (int i = 0; i < nextWeather.length; ++i) {
            float rainAdd;
            float chance = level.f_46441_.nextFloat();
            if (i != 0) {
                if (nextWeather[0].wholeDay) {
                    nextWeather[i] = nextWeather[0];
                    return;
                }
            } else {
                float stormAdd;
                float f = stormAdd = season == EnumSeason.SUMMER || season == EnumSeason.WINTER ? 0.04f : 0.0f;
                if (chance < 0.03f) {
                    nextWeather[i] = EnumWeather.RUNEY;
                } else if (chance < 0.015f + stormAdd) {
                    nextWeather[i] = EnumWeather.STORM;
                }
                if (nextWeather[i] != null) {
                    return;
                }
            }
            float f = rainAdd = rainCount > 0 ? 0.5f - (float)(rainCount - 1) * 0.2f : 0.0f;
            if (i < 3) {
                rainAdd = (float)((double)rainAdd + (season == EnumSeason.SUMMER ? 0.1 : 0.05));
            }
            if (chance < 0.1f + rainAdd) {
                nextWeather[i] = EnumWeather.RAIN;
                ++rainCount;
                continue;
            }
            nextWeather[i] = EnumWeather.CLEAR;
        }
        this.calendar.updateWeathers(nextWeather);
    }

    private void setMCWeather(ServerLevel level) {
        this.currentWeather().setWeather.accept(level);
    }

    private boolean isCorrectWeather(ServerLevel level) {
        return switch (this.currentWeather()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumWeather.RAIN -> level.m_46471_();
            case EnumWeather.CLEAR, EnumWeather.RUNEY, EnumWeather.CLOUDY -> {
                if (!level.m_46471_() && !level.m_46470_()) {
                    yield true;
                }
                yield false;
            }
            case EnumWeather.STORM -> level.m_46471_() && level.m_46470_();
        };
    }

    public void addToTracker(IDailyUpdate update) {
        this.updateTracker.add(update);
    }

    public boolean removeFromTracker(IDailyUpdate update) {
        return this.updateTracker.remove(update);
    }

    public BarnData getOrCreateFor(UUID player, Level level, BlockPos pos) {
        BarnData data = (BarnData)this.positionBarnMap.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> new Long2ObjectOpenHashMap()).computeIfAbsent(pos.m_121878_(), l -> new BarnData(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos)));
        this.playerBarns.computeIfAbsent(player, uuid -> new HashSet()).add(data);
        this.m_77762_();
        return data;
    }

    public Set<BarnData> barnsOf(UUID player) {
        return ImmutableSet.copyOf((Collection)this.playerBarns.getOrDefault(player, Set.of()));
    }

    @Nullable
    public BarnData barnAt(GlobalPos pos) {
        Long2ObjectMap<BarnData> map = this.positionBarnMap.get(pos.m_122640_());
        if (map != null) {
            return (BarnData)map.get(pos.m_122646_().m_121878_());
        }
        return null;
    }

    @Nullable
    public BarnData findFittingBarn(BaseMonster monster, UUID owner) {
        return this.barnsOf(owner).stream().filter(b -> b.hasCapacityFor(monster)).findFirst().orElse(null);
    }

    @Nullable
    public BarnData findNearestFittingBarn(BaseMonster monster, int radius) {
        if (monster.m_142504_() == null) {
            return null;
        }
        return this.barnsOf(monster.m_142504_()).stream().filter(b -> b.pos.m_122640_() == monster.f_19853_.m_46472_() && new AABB(monster.m_142538_()).m_82400_((double)radius).m_82390_(Vec3.m_82512_((Vec3i)b.pos.m_122646_())) && b.hasCapacityFor(monster)).findFirst().orElse(null);
    }

    @Nullable
    public BarnData findFittingBarn(BaseMonster monster) {
        if (monster.m_142504_() == null) {
            return null;
        }
        return this.findFittingBarn(monster, monster.m_142504_());
    }

    public void removeMonsterFromPlayer(UUID player, BaseMonster monster) {
        this.playerBarns.getOrDefault(player, Set.of()).forEach(b -> b.removeMonster(monster));
    }

    public void removeBarn(UUID player, GlobalPos pos) {
        Long2ObjectMap<BarnData> map = this.positionBarnMap.get(pos.m_122640_());
        if (map != null) {
            BarnData old = (BarnData)map.remove(pos.m_122646_().m_121878_());
            this.playerBarns.computeIfAbsent(player, uuid -> new HashSet()).remove(old);
            old.remove();
            this.m_77762_();
        }
    }

    public void safeUnloadedPartyMembers(LivingEntity entity) {
        EntityNPCBase npc;
        BaseMonster monster;
        if (entity instanceof BaseMonster && (monster = (BaseMonster)entity).m_142504_() != null) {
            this.unloadedPartyMembers.computeIfAbsent(monster.m_142504_(), o -> new HashSet()).add(new UnloadedPartyMember(entity.m_142081_(), GlobalPos.m_122643_((ResourceKey)entity.f_19853_.m_46472_(), (BlockPos)entity.m_142538_())));
        } else if (entity instanceof EntityNPCBase && (npc = (EntityNPCBase)entity).getEntityToFollowUUID() != null) {
            this.unloadedPartyMembers.computeIfAbsent(npc.getEntityToFollowUUID(), o -> new HashSet()).add(new UnloadedPartyMember(entity.m_142081_(), GlobalPos.m_122643_((ResourceKey)entity.f_19853_.m_46472_(), (BlockPos)entity.m_142538_())));
        }
    }

    public Set<UnloadedPartyMember> getUnloadedPartyMembersFor(Player player) {
        return this.unloadedPartyMembers.computeIfAbsent(player.m_142081_(), o -> new HashSet());
    }

    public void toRemovePartyMember(LivingEntity entity) {
        EntityNPCBase npc;
        BaseMonster monster;
        if (entity instanceof BaseMonster && (monster = (BaseMonster)entity).m_142504_() != null) {
            this.toRemovePartyMembers.computeIfAbsent(monster.m_142504_(), o -> new HashSet()).add(entity.m_142081_());
        } else if (entity instanceof EntityNPCBase && (npc = (EntityNPCBase)entity).getEntityToFollowUUID() != null) {
            this.toRemovePartyMembers.computeIfAbsent(npc.getEntityToFollowUUID(), o -> new HashSet()).add(entity.m_142081_());
        }
    }

    public Set<UUID> removedPartyMembersFor(Player player) {
        return this.toRemovePartyMembers.computeIfAbsent(player.m_142081_(), o -> new HashSet());
    }

    public void load(CompoundTag compoundNBT) {
        this.calendar.read(compoundNBT);
        this.lastUpdateDay = compoundNBT.m_128451_("LastUpdateDay");
        CompoundTag barns = compoundNBT.m_128469_("PlayerBarns");
        barns.m_128431_().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            ListTag list = barns.m_128437_(key, 10);
            Set map = this.playerBarns.computeIfAbsent(uuid, u -> new HashSet());
            list.forEach(t -> {
                BarnData data = BarnData.fromTag((CompoundTag)t);
                map.add(data);
                this.positionBarnMap.computeIfAbsent((ResourceKey<Level>)data.pos.m_122640_(), k -> new Long2ObjectOpenHashMap()).put(data.pos.m_122646_().m_121878_(), (Object)data);
            });
        });
        CompoundTag unloadedParties = compoundNBT.m_128469_("UnloadedParties");
        unloadedParties.m_128431_().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            ListTag list = unloadedParties.m_128437_(key, 10);
            Set map = this.unloadedPartyMembers.computeIfAbsent(uuid, u -> new HashSet());
            list.forEach(t -> {
                CompoundTag cTag = (CompoundTag)t;
                map.add(new UnloadedPartyMember(UUID.fromString(cTag.m_128461_("UUID")), (GlobalPos)GlobalPos.f_122633_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)cTag.m_128423_("Pos"))).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
            });
        });
        CompoundTag removedPartyMembers = compoundNBT.m_128469_("RemovedPartyMembers");
        removedPartyMembers.m_128431_().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            ListTag list = removedPartyMembers.m_128437_(key, 11);
            Set uuids = this.toRemovePartyMembers.computeIfAbsent(uuid, u -> new HashSet());
            list.forEach(t -> uuids.add(NbtUtils.m_129233_((Tag)t)));
        });
        this.npcHandler.load(compoundNBT.m_128469_("NPCHandler"));
    }

    public CompoundTag m_7176_(CompoundTag compoundNBT) {
        this.calendar.write(compoundNBT);
        compoundNBT.m_128405_("LastUpdateDay", this.lastUpdateDay);
        CompoundTag barns = new CompoundTag();
        this.playerBarns.forEach((uuid, pB) -> {
            ListTag pBTag = new ListTag();
            pB.forEach(b -> {
                if (!b.isInvalid()) {
                    pBTag.add((Object)b.save());
                }
            });
            barns.m_128365_(uuid.toString(), (Tag)pBTag);
        });
        compoundNBT.m_128365_("PlayerBarns", (Tag)barns);
        CompoundTag unloadedParties = new CompoundTag();
        this.unloadedPartyMembers.forEach((uuid, pairs) -> {
            if (!pairs.isEmpty()) {
                ListTag pTags = new ListTag();
                pairs.forEach(p -> {
                    CompoundTag pTag = new CompoundTag();
                    pTag.m_128359_("UUID", p.uuid().toString());
                    GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)p.pos()).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(t -> pTag.m_128365_("Pos", t));
                    pTags.add((Object)pTag);
                });
                unloadedParties.m_128365_(uuid.toString(), (Tag)pTags);
            }
        });
        compoundNBT.m_128365_("UnloadedParties", (Tag)unloadedParties);
        CompoundTag removedPartyMembers = new CompoundTag();
        this.toRemovePartyMembers.forEach((uuid, uuids) -> {
            if (!uuids.isEmpty()) {
                ListTag pTags = new ListTag();
                uuids.forEach(member -> pTags.add((Object)NbtUtils.m_129226_((UUID)member)));
                removedPartyMembers.m_128365_(uuid.toString(), (Tag)pTags);
            }
        });
        compoundNBT.m_128365_("RemovedPartyMembers", (Tag)removedPartyMembers);
        compoundNBT.m_128365_("NPCHandler", (Tag)this.npcHandler.save());
        return compoundNBT;
    }

    public record UnloadedPartyMember(UUID uuid, GlobalPos pos) {
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UnloadedPartyMember) {
                UnloadedPartyMember other = (UnloadedPartyMember)obj;
                return other.uuid.equals(this.uuid);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.uuid.hashCode();
        }
    }
}

