/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.family;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.world.family.FamilyHandler;
import io.github.flemmli97.runecraftory.common.world.family.SyncedFamilyData;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class FamilyEntry {
    public static final int DEPTH = 3;
    private UUID father;
    private UUID mother;
    private final Set<UUID> siblings = new HashSet<UUID>();
    private final Set<UUID> children = new HashSet<UUID>();
    private Component name;
    private NPCData.Gender gender;
    private UUID self;
    private UUID partner;
    private Relationship relationship = Relationship.NONE;
    private EntityState entityState;
    private final FamilyHandler familyHandler;

    public FamilyEntry(FamilyHandler familyHandler, UUID self, Component name, NPCData.Gender gender, boolean player) {
        this.familyHandler = familyHandler;
        this.self = self;
        this.name = name;
        this.gender = gender;
        this.entityState = player ? EntityState.PLAYER : EntityState.ALIVE;
    }

    public FamilyEntry(FamilyHandler familyHandler, CompoundTag tag) {
        this.familyHandler = familyHandler;
        this.load(tag);
    }

    public void setFather(UUID father) {
        if (this.father != null) {
            this.familyHandler.getFamily(this.father).ifPresent(e -> {
                e.children.forEach(child -> this.familyHandler.getFamily((UUID)child).ifPresent(ce -> ce.siblings.remove(this.self)));
                e.removeChild(this.self);
            });
        }
        this.father = father;
        this.familyHandler.getFamily(this.father).ifPresent(e -> e.addChild(this.self));
        this.familyHandler.m_77762_();
    }

    public void setMother(UUID mother) {
        if (this.mother != null) {
            this.familyHandler.getFamily(this.mother).ifPresent(e -> {
                e.children.forEach(child -> this.familyHandler.getFamily((UUID)child).ifPresent(ce -> ce.siblings.remove(this.self)));
                e.removeChild(this.self);
            });
        }
        this.mother = mother;
        this.familyHandler.getFamily(this.mother).ifPresent(e -> e.addChild(this.self));
        this.familyHandler.m_77762_();
    }

    public void addChild(UUID uuid) {
        if (this.partner != null) {
            this.familyHandler.getFamily(this.partner).ifPresent(e -> e.children.add(this.self));
        }
        this.children.add(uuid);
        this.children.forEach(child -> this.familyHandler.getFamily((UUID)child).ifPresent(e -> e.siblings.add(this.self)));
        this.familyHandler.m_77762_();
    }

    public void removeChild(UUID uuid) {
        if (this.partner != null) {
            this.familyHandler.getFamily(this.partner).ifPresent(e -> e.children.remove(this.self));
        }
        this.children.remove(uuid);
        this.children.forEach(child -> this.familyHandler.getFamily((UUID)child).ifPresent(e -> e.siblings.remove(this.self)));
        this.familyHandler.m_77762_();
    }

    public void addSibling(UUID uuid) {
        if (this.father != null) {
            this.familyHandler.getFamily(this.father).ifPresent(e -> e.children.add(this.self));
        }
        if (this.mother != null) {
            this.familyHandler.getFamily(this.mother).ifPresent(e -> e.children.add(this.self));
        }
        this.siblings.forEach(sibling -> this.familyHandler.getFamily((UUID)sibling).ifPresent(e -> e.siblings.add(uuid)));
        this.siblings.add(uuid);
        this.familyHandler.m_77762_();
    }

    public void removeSibling(UUID uuid) {
        if (this.father != null) {
            this.familyHandler.getFamily(this.father).ifPresent(e -> e.children.remove(this.self));
        }
        if (this.mother != null) {
            this.familyHandler.getFamily(this.mother).ifPresent(e -> e.children.remove(this.self));
        }
        this.siblings.remove(uuid);
        this.siblings.forEach(sibling -> this.familyHandler.getFamily((UUID)sibling).ifPresent(e -> e.siblings.remove(uuid)));
        this.familyHandler.m_77762_();
    }

    public void updateName(Entity entity) {
        this.name = entity.m_7755_();
        this.familyHandler.m_77762_();
    }

    public void updateRelationship(Relationship relationship, UUID partner) {
        if (this.partner != null) {
            this.familyHandler.getFamily(this.partner).ifPresent(e -> {
                e.partner = null;
                e.relationship = Relationship.NONE;
            });
        }
        this.relationship = relationship;
        this.partner = partner;
        if (this.partner != null) {
            this.familyHandler.getFamily(this.partner).ifPresent(e -> {
                e.partner = this.self;
                e.relationship = relationship;
            });
        }
        this.familyHandler.m_77762_();
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public UUID getPartner() {
        return this.partner;
    }

    public boolean hasPlayerRelationShip() {
        if (this.partner == null) {
            return false;
        }
        return this.familyHandler.getFamily(this.partner).map(FamilyEntry::isPlayer).orElse(false);
    }

    public boolean isRelated(UUID uuid) {
        return this.findRelativesRecursive(3, uuid);
    }

    @Nullable
    public FamilyRelation getRelativeState(UUID toFind) {
        return this.findRelativeStateRecursive(2, FamilyRelation.NONE, toFind);
    }

    private FamilyRelation findRelativeStateRecursive(int depth, FamilyRelation current, UUID toFind) {
        if (depth > 0) {
            FamilyRelation relation;
            FamilyRelation relation2;
            FamilyRelation next;
            if (this.father != null) {
                next = FamilyRelation.MAP.get((Object)((Object)current)).father;
                if (this.father.equals(toFind)) {
                    return next;
                }
                relation2 = this.familyHandler.getFamily(this.father).map(e -> this.findRelativeStateRecursive(depth - 1, next, toFind)).orElse(null);
                if (relation2 != null) {
                    return relation2;
                }
            }
            if (this.mother != null) {
                next = FamilyRelation.MAP.get((Object)((Object)current)).mother;
                if (this.mother.equals(toFind)) {
                    return next;
                }
                relation2 = this.familyHandler.getFamily(this.mother).map(e -> this.findRelativeStateRecursive(depth - 1, next, toFind)).orElse(null);
                if (relation2 != null) {
                    return relation2;
                }
            }
            for (UUID sibling : this.siblings) {
                relation = this.familyHandler.getFamily(sibling).map(e -> {
                    FamilyRelation next;
                    FamilyRelation familyRelation = next = e.gender == NPCData.Gender.MALE ? FamilyRelation.MAP.get((Object)((Object)((Object)current))).maleSibling : FamilyRelation.MAP.get((Object)((Object)((Object)current))).femaleSibling;
                    if (sibling.equals(toFind)) {
                        return next;
                    }
                    return this.findRelativeStateRecursive(depth - 1, next, toFind);
                }).orElse(null);
                if (relation == null) continue;
                return relation;
            }
            for (UUID child : this.children) {
                relation = this.familyHandler.getFamily(child).map(e -> {
                    FamilyRelation next;
                    FamilyRelation familyRelation = next = e.gender == NPCData.Gender.MALE ? FamilyRelation.MAP.get((Object)((Object)((Object)current))).maleChild : FamilyRelation.MAP.get((Object)((Object)((Object)current))).femaleChild;
                    if (child.equals(toFind)) {
                        return next;
                    }
                    return this.findRelativeStateRecursive(depth - 1, next, toFind);
                }).orElse(null);
                if (relation == null) continue;
                return relation;
            }
        }
        return null;
    }

    private boolean findRelativesRecursive(int depth, UUID toFind) {
        if (depth > 0) {
            if (this.father != null) {
                if (this.father.equals(toFind)) {
                    return true;
                }
                if (this.familyHandler.getFamily(this.father).map(e -> this.findRelativesRecursive(depth - 1, toFind)).orElse(false).booleanValue()) {
                    return true;
                }
            }
            if (this.mother != null) {
                if (this.mother.equals(toFind)) {
                    return true;
                }
                if (this.familyHandler.getFamily(this.mother).map(e -> this.findRelativesRecursive(depth - 1, toFind)).orElse(false).booleanValue()) {
                    return true;
                }
            }
            for (UUID sibling : this.siblings) {
                if (sibling.equals(toFind)) {
                    return true;
                }
                if (!this.familyHandler.getFamily(sibling).map(e -> this.findRelativesRecursive(depth - 1, toFind)).orElse(false).booleanValue()) continue;
                return true;
            }
            for (UUID child : this.children) {
                if (child.equals(toFind)) {
                    return true;
                }
                if (!this.familyHandler.getFamily(child).map(e -> this.findRelativesRecursive(depth - 1, toFind)).orElse(false).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPlayer() {
        return this.entityState == EntityState.PLAYER;
    }

    public void markAsDead() {
        if (this.entityState != EntityState.PLAYER) {
            this.entityState = EntityState.DEAD;
        }
        this.familyHandler.m_77762_();
    }

    public boolean shouldPersist() {
        return this.shouldPersist(3);
    }

    private boolean shouldPersist(int depth) {
        if (this.entityState == EntityState.ALIVE || this.entityState == EntityState.PLAYER) {
            return true;
        }
        if (depth > 0) {
            if (this.partner != null && this.familyHandler.getFamily(this.partner).map(e -> {
                if (e.entityState == EntityState.ALIVE || e.entityState == EntityState.PLAYER) {
                    return true;
                }
                return e.shouldPersist(depth - 2);
            }).orElse(false).booleanValue()) {
                return true;
            }
            if (this.father != null && this.familyHandler.getFamily(this.father).map(e -> {
                if (e.entityState == EntityState.ALIVE || e.entityState == EntityState.PLAYER) {
                    return true;
                }
                return e.shouldPersist(depth - 2);
            }).orElse(false).booleanValue()) {
                return true;
            }
            if (this.mother != null && this.familyHandler.getFamily(this.mother).map(e -> {
                if (e.entityState == EntityState.ALIVE || e.entityState == EntityState.PLAYER) {
                    return true;
                }
                return e.shouldPersist(depth - 2);
            }).orElse(false).booleanValue()) {
                return true;
            }
            for (UUID sibling : this.siblings) {
                if (!this.familyHandler.getFamily(sibling).map(e -> {
                    if (e.entityState == EntityState.ALIVE || e.entityState == EntityState.PLAYER) {
                        return true;
                    }
                    return e.shouldPersist(depth - 2);
                }).orElse(false).booleanValue()) continue;
                return true;
            }
            for (UUID child : this.children) {
                if (!this.familyHandler.getFamily(child).map(e -> {
                    if (e.entityState == EntityState.ALIVE || e.entityState == EntityState.PLAYER) {
                        return true;
                    }
                    return e.shouldPersist(depth - 2);
                }).orElse(false).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        if (this.father != null) {
            tag.m_128362_("Father", this.father);
        }
        if (this.mother != null) {
            tag.m_128362_("Mother", this.mother);
        }
        ListTag siblings = new ListTag();
        this.siblings.forEach(uuid -> siblings.add((Object)NbtUtils.m_129226_((UUID)uuid)));
        tag.m_128365_("Siblings", (Tag)siblings);
        ListTag children = new ListTag();
        this.children.forEach(uuid -> children.add((Object)NbtUtils.m_129226_((UUID)uuid)));
        tag.m_128365_("Children", (Tag)children);
        tag.m_128359_("Name", Component.Serializer.m_130703_((Component)this.name));
        tag.m_128405_("Gender", this.gender.ordinal());
        tag.m_128362_("OwnID", this.self);
        if (this.partner != null) {
            tag.m_128362_("Partner", this.partner);
        }
        tag.m_128405_("RelationShip", this.relationship.ordinal());
        tag.m_128405_("EntityState", this.entityState.ordinal());
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.m_128403_("Father")) {
            this.father = tag.m_128342_("Father");
        }
        if (tag.m_128403_("Mother")) {
            this.mother = tag.m_128342_("Mother");
        }
        ListTag siblings = tag.m_128437_("Siblings", 11);
        siblings.forEach(sibling -> this.siblings.add(NbtUtils.m_129233_((Tag)sibling)));
        ListTag children = tag.m_128437_("Children", 11);
        children.forEach(sibling -> this.children.add(NbtUtils.m_129233_((Tag)sibling)));
        this.name = Component.Serializer.m_130701_((String)tag.m_128461_("Name"));
        this.gender = NPCData.Gender.values()[tag.m_128451_("Gender")];
        this.self = tag.m_128342_("OwnID");
        this.gender = NPCData.Gender.values()[tag.m_128451_("Gender")];
        if (tag.m_128403_("Partner")) {
            this.partner = tag.m_128342_("Partner");
        }
        this.relationship = Relationship.values()[tag.m_128451_("RelationShip")];
        this.entityState = EntityState.values()[tag.m_128451_("EntityState")];
    }

    public SyncedFamilyData forSyncing(EntityNPCBase npc, ServerPlayer player) {
        Component father = this.father != null ? (Component)this.familyHandler.getFamily(this.father).map(e -> e.name).orElse(null) : null;
        Component mother = this.mother != null ? (Component)this.familyHandler.getFamily(this.mother).map(e -> e.name).orElse(null) : null;
        Component partner = this.partner != null ? (Component)this.familyHandler.getFamily(this.partner).map(e -> e.name).orElse(null) : null;
        return new SyncedFamilyData(father, mother, partner, this.relationship, player.m_142081_().equals(this.partner) && npc.canProcreate());
    }

    public static enum Relationship {
        NONE,
        DATING,
        MARRIED;

    }

    public static enum EntityState {
        ALIVE,
        DEAD,
        PLAYER;

    }

    public static enum FamilyRelation {
        NONE,
        FATHER,
        MOTHER,
        BROTHER,
        SISTER,
        SON,
        DAUGHTER,
        GRAND_SON,
        GRAND_DAUGHTER,
        NEPHEW,
        NIECE,
        UNCLE,
        AUNT,
        GRAND_FATHER,
        GRAND_MOTHER;

        private static final EnumMap<FamilyRelation, FamilyRelationRelation> MAP;

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            builder.put((Object)NONE, (Object)new FamilyRelationRelation(FATHER, MOTHER, BROTHER, SISTER, SON, DAUGHTER));
            builder.put((Object)FATHER, (Object)new FamilyRelationRelation(GRAND_FATHER, GRAND_MOTHER, UNCLE, AUNT, BROTHER, SISTER));
            builder.put((Object)MOTHER, (Object)new FamilyRelationRelation(GRAND_FATHER, GRAND_MOTHER, UNCLE, AUNT, BROTHER, SISTER));
            builder.put((Object)BROTHER, (Object)new FamilyRelationRelation(FATHER, MOTHER, BROTHER, SISTER, NEPHEW, NIECE));
            builder.put((Object)SISTER, (Object)new FamilyRelationRelation(FATHER, MOTHER, BROTHER, SISTER, NEPHEW, NIECE));
            builder.put((Object)SON, (Object)new FamilyRelationRelation(NONE, NONE, SON, DAUGHTER, GRAND_SON, GRAND_DAUGHTER));
            builder.put((Object)DAUGHTER, (Object)new FamilyRelationRelation(NONE, NONE, SON, DAUGHTER, GRAND_SON, GRAND_DAUGHTER));
            builder.put((Object)GRAND_SON, (Object)new FamilyRelationRelation(null, null, null, null, null, null));
            builder.put((Object)GRAND_DAUGHTER, (Object)new FamilyRelationRelation(null, null, null, null, null, null));
            builder.put((Object)NEPHEW, (Object)new FamilyRelationRelation(BROTHER, SISTER, NEPHEW, NIECE, null, null));
            builder.put((Object)NIECE, (Object)new FamilyRelationRelation(BROTHER, SISTER, NEPHEW, NIECE, null, null));
            builder.put((Object)UNCLE, (Object)new FamilyRelationRelation(GRAND_FATHER, GRAND_MOTHER, UNCLE, AUNT, null, null));
            builder.put((Object)AUNT, (Object)new FamilyRelationRelation(GRAND_FATHER, GRAND_MOTHER, UNCLE, AUNT, null, null));
            builder.put((Object)GRAND_FATHER, (Object)new FamilyRelationRelation(null, null, null, null, null, null));
            builder.put((Object)GRAND_MOTHER, (Object)new FamilyRelationRelation(null, null, null, null, null, null));
            MAP = new EnumMap(builder.build());
        }

        record FamilyRelationRelation(FamilyRelation father, FamilyRelation mother, FamilyRelation maleSibling, FamilyRelation femaleSibling, FamilyRelation maleChild, FamilyRelation femaleChild) {
        }
    }
}

