/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.family;

import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.world.family.FamilyEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class FamilyHandler
extends SavedData {
    private static final String ID = "RunecraftoryFamilyHandler";
    private final Map<UUID, FamilyEntry> families = new HashMap<UUID, FamilyEntry>();

    public FamilyHandler() {
    }

    private FamilyHandler(CompoundTag tag) {
        this.load(tag);
    }

    public static FamilyHandler get(MinecraftServer server) {
        return (FamilyHandler)server.m_129783_().m_8895_().m_164861_(FamilyHandler::new, FamilyHandler::new, ID);
    }

    public Optional<FamilyEntry> getFamily(UUID uuid) {
        return Optional.ofNullable(this.families.get(uuid));
    }

    public FamilyEntry getOrCreateEntry(Player player) {
        FamilyEntry entry = this.families.computeIfAbsent(player.m_142081_(), id -> new FamilyEntry(this, player.m_142081_(), player.m_7755_(), NPCData.Gender.UNDEFINED, true));
        this.m_77762_();
        return entry;
    }

    public FamilyEntry getOrCreateEntry(EntityNPCBase npc) {
        FamilyEntry entry = this.families.computeIfAbsent(npc.m_142081_(), id -> new FamilyEntry(this, npc.m_142081_(), npc.m_7755_(), npc.isMale() ? NPCData.Gender.MALE : NPCData.Gender.FEMALE, false));
        this.m_77762_();
        return entry;
    }

    public void load(CompoundTag compoundNBT) {
        CompoundTag data = compoundNBT.m_128469_("Families");
        data.m_128431_().forEach(id -> this.families.put(UUID.fromString(id), new FamilyEntry(this, data.m_128469_(id))));
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        CompoundTag data = new CompoundTag();
        this.families.forEach((uuid, entry) -> {
            if (entry.shouldPersist()) {
                data.m_128365_(uuid.toString(), (Tag)entry.save());
            }
        });
        compoundTag.m_128365_("Families", (Tag)data);
        return compoundTag;
    }
}

