/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.farming;

import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.common.blocks.BlockCrop;
import io.github.flemmli97.runecraftory.common.blocks.Growable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.utils.GrassRegrowUtil;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FarmlandData {
    public static final float DEFAULT_SPEED = 1.0f;
    public static final float DEFAULT_QUALITY = 0.0f;
    public static final float DEFAULT_SIZE = 0.0f;
    public static final int DEFAULT_DEFENCE = 0;
    public static final int DEFAULT_HEALTH = 32;
    public static final float MAX_SPEED = 5.0f;
    public static final float MAX_QUALITY = 2.0f;
    public static final float MAX_SIZE = 2.0f;
    public static final int MAX_DEFENCE = 64;
    public static final int MAX_HEALTH = 255;
    public final BlockPos pos;
    private float growth = 1.0f;
    private float quality;
    private float size;
    private int health = 32;
    private int defence;
    private float cropAge;
    private float cropSize;
    private float cropLevel = 1.0f;
    private int cropProgress;
    private int lastUpdateDay;
    private int scheduledStormTicks;
    private int scheduledWatering;
    private int lastWeatherDay;
    private final List<ExternalModifiers> scheduledData = new ArrayList<ExternalModifiers>();
    private boolean isLoaded;
    private boolean isFarmBlock;

    public FarmlandData(BlockPos pos) {
        this.pos = pos;
    }

    public static FarmlandData fromTag(CompoundTag tag, BlockPos pos) {
        FarmlandData data = new FarmlandData(pos);
        data.load(tag);
        return data;
    }

    public float getGrowth() {
        return this.growth;
    }

    public void applyGrowthFertilizer(@Nullable ServerLevel level, float amount) {
        this.growth = Mth.m_14036_((float)(this.growth + amount), (float)0.1f, (float)5.0f);
        if (level != null) {
            FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
        }
    }

    public boolean canUseBonemeal() {
        return (double)this.growth < 2.25;
    }

    public void applyBonemeal(@Nullable ServerLevel level) {
        if ((double)this.growth < 2.25) {
            this.applyGrowthFertilizer(level, Math.min(2.25f - this.growth, 0.15f));
        }
    }

    public float getQuality() {
        return this.quality;
    }

    public void modifyQuality(@Nullable ServerLevel level, float amount) {
        this.quality = Mth.m_14036_((float)(this.quality + amount), (float)0.0f, (float)2.0f);
        if (level != null) {
            FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
        }
    }

    public float getSize() {
        return this.size;
    }

    public void applySizeFertilizer(@Nullable ServerLevel level, boolean growGiant) {
        float mod = growGiant ? 1 : -1;
        this.size = Mth.m_14036_((float)(this.size + mod), (float)-2.0f, (float)2.0f);
        if (level != null) {
            FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
        }
    }

    public int getHealth() {
        return this.health;
    }

    public void modifyHealth(@Nullable ServerLevel level, int amount) {
        this.health = Mth.m_14045_((int)(this.health + amount), (int)0, (int)255);
        if (level != null) {
            FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
        }
    }

    public int getDefence() {
        return this.defence;
    }

    public void modifyDefence(@Nullable ServerLevel level, int amount) {
        this.defence = Mth.m_14045_((int)(this.defence + amount), (int)0, (int)64);
        if (level != null) {
            FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
        }
    }

    public float getCropAge() {
        return (int)this.cropAge;
    }

    private int growthPercent(ServerLevel level, BlockState crop) {
        if (!(crop.m_60734_() instanceof Growable)) {
            return 0;
        }
        CropProperties props = DataPackHandler.INSTANCE.cropManager().get(crop.m_60734_().m_7397_((BlockGetter)level, this.pos, crop).m_41720_());
        if (props != null) {
            return Math.min((int)(this.cropAge / (float)props.growth() * 100.0f), 100);
        }
        return 0;
    }

    public float getCropSize() {
        return this.cropSize;
    }

    public int getCropLevel() {
        return (int)this.cropLevel;
    }

    public boolean hasDefaultStats() {
        return this.growth == 1.0f && this.quality == 0.0f && this.size == 0.0f && this.health == 32;
    }

    protected void updateFarmBlock(boolean isFarmBlock) {
        this.isFarmBlock = isFarmBlock;
    }

    public boolean isFarmBlock() {
        return this.isFarmBlock;
    }

    public boolean shouldBeRemoved() {
        if (this.isFarmBlock) {
            return false;
        }
        return this.hasDefaultStats();
    }

    public void onRegrowableHarvest(ServerLevel level, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (!(block instanceof Growable)) {
            this.resetCrop();
            return;
        }
        Growable crop = (Growable)block;
        CropProperties props = DataPackHandler.INSTANCE.cropManager().get(state.m_60734_().m_7397_((BlockGetter)level, pos, state).m_41720_());
        if (props == null || !props.regrowable()) {
            this.resetCrop();
            return;
        }
        float max = props.growth();
        this.cropAge = max * 0.5f;
        int maxAge = crop.runecraftory$getGrowableMaxAge();
        int stage = Math.round(this.cropAge * (float)maxAge) / props.growth();
        BlockState newState = crop.runecraftory$getGrowableStateForAge(state, Math.min(stage, maxAge));
        level.m_142572_().m_6937_((Runnable)new TickTask(1, () -> level.m_7731_(pos, newState, 3)));
        this.cropProgress = this.growthPercent(level, state);
        FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
    }

    public void onCropRemove(ServerLevel level, BlockPos pos, BlockState state) {
        this.resetCrop();
        FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
    }

    public void onWatering(ServerLevel level, int currentDay) {
        if (!this.isFarmBlock || this.lastWeatherDay == currentDay) {
            return;
        }
        this.lastWeatherDay = currentDay;
        if (!this.isLoaded) {
            ++this.scheduledWatering;
            return;
        }
        BlockState farm = level.m_8055_(this.pos);
        if ((Integer)farm.m_61143_((Property)FarmBlock.f_53243_) < 7) {
            level.m_7731_(this.pos, (BlockState)farm.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7)), 3);
        }
    }

    public void onStorming(ServerLevel level, int currentDay) {
        if (!this.isFarmBlock || this.lastWeatherDay == currentDay) {
            return;
        }
        if (!this.isLoaded) {
            this.onWatering(level, currentDay);
            ++this.scheduledStormTicks;
            return;
        }
        this.onWatering(level, currentDay);
        this.doStormingLogic(level, 1);
    }

    private void doStormingLogic(ServerLevel level, int amount) {
        if (!this.isFarmBlock) {
            return;
        }
        BlockState state = null;
        BlockPos cropPos = this.pos.m_7494_();
        for (int i = 0; i < amount; ++i) {
            boolean destroyChance;
            --this.defence;
            if (this.defence > 0) continue;
            state = state == null ? level.m_8055_(cropPos) : state;
            boolean bl = destroyChance = level.f_46441_.nextFloat() < 0.4f;
            if (!destroyChance) continue;
            if (state.m_60734_() instanceof Growable) {
                if (level.f_46441_.nextFloat() < 0.6f) {
                    state = Blocks.f_50016_.m_49966_();
                    level.m_46961_(cropPos, true);
                    continue;
                }
                state = ((Block)ModBlocks.WITHERED_GRASS.get()).m_49966_();
                continue;
            }
            state = Blocks.f_50493_.m_49966_();
            break;
        }
        FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
        if (state != null) {
            if (state.m_60734_() == Blocks.f_50493_) {
                level.m_7731_(this.pos, state, 3);
            } else if (state.m_60734_() == Blocks.f_50016_) {
                level.m_46961_(cropPos, true);
            } else {
                level.m_7731_(cropPos, state, 3);
            }
        }
    }

    public void tick(ServerLevel level, boolean onLoad) {
        Block block;
        if (!this.isLoaded && !GeneralConfig.tickUnloadedFarmland) {
            return;
        }
        if (!this.isFarmBlock) {
            this.lastUpdateDay = WorldUtils.day((Level)level);
            this.handleNotFarmblock(level);
            return;
        }
        WorldHandler handler = WorldHandler.get(level.m_142572_());
        ExternalModifiers ext = new ExternalModifiers(handler.currentSeason(), handler.currentWeather());
        if (!this.isLoaded) {
            this.scheduledData.add(ext);
            return;
        }
        this.lastUpdateDay = WorldUtils.day((Level)level);
        BlockState farm = level.m_8055_(this.pos);
        this.isFarmBlock = FarmlandHandler.isFarmBlock(farm);
        boolean isWet = this.isFarmBlock && (Integer)farm.m_61143_((Property)FarmBlock.f_53243_) > 0;
        boolean canRainAt = FarmlandHandler.canRainingAt((Level)level, this.pos);
        if (!onLoad) {
            this.scheduledData.add(ext);
        } else {
            this.doStormingLogic(level, this.scheduledStormTicks);
            if (!this.isFarmBlock) {
                this.handleNotFarmblock(level);
                return;
            }
            if (!isWet && canRainAt && this.scheduledWatering > 0 && farm.m_60734_() instanceof FarmBlock) {
                --this.scheduledWatering;
                isWet = true;
            }
        }
        boolean ignoreWater = FarmlandHandler.get(level.m_142572_()).hasWater(level, this.pos);
        if (ignoreWater) {
            isWet = true;
        }
        BlockPos cropPos = this.pos.m_7494_();
        BlockState cropState = level.m_8055_(cropPos);
        ArrayList<Runnable> run = new ArrayList<Runnable>();
        if (isWet) {
            run.add(() -> level.m_7731_(this.pos, (BlockState)farm.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(0)), 3));
        }
        boolean growHerb = false;
        boolean cropRecalc = false;
        CropProperties props = cropState.m_60734_() instanceof Growable ? DataPackHandler.INSTANCE.cropManager().get(cropState.m_60734_().m_7397_((BlockGetter)level, this.pos, cropState).m_41720_()) : null;
        int wiltStage = 0;
        for (ExternalModifiers modifiers : this.scheduledData) {
            boolean hasGiantVersion;
            Block block2 = cropState.m_60734_();
            if (!(block2 instanceof Growable)) {
                this.normalizeLand();
                this.resetCrop();
                if (!growHerb && cropState.m_60795_()) {
                    if ((double)level.f_46441_.nextFloat() < 0.02) {
                        run.add(() -> GrassRegrowUtil.tryGrowHerb(level, cropPos));
                        growHerb = true;
                    } else {
                        growHerb = true;
                    }
                }
                if (!growHerb || !this.hasDefaultStats()) continue;
                break;
            }
            Growable crop = (Growable)block2;
            boolean bl = hasGiantVersion = props != null && props.getGiantVersion() != Blocks.f_50016_ && !cropState.m_60713_(props.getGiantVersion());
            if (crop.runecraftory$isAtMaxAge(cropState) && (!hasGiantVersion || this.size == 0.0f || this.size < 0.0f && this.cropSize <= 0.0f)) break;
            boolean didCropGrow = false;
            boolean maxAgeStop = false;
            if (props != null) {
                if (!cropRecalc) {
                    cropRecalc = true;
                    if (crop.canGrow(level, cropPos, cropState)) {
                        run.add(() -> {
                            int maxAge = crop.runecraftory$getGrowableMaxAge();
                            int stage = Mth.m_14143_((float)(this.cropAge * (float)maxAge)) / props.growth();
                            BlockState newState = crop.runecraftory$getGrowableStateForAge(cropState, Math.min(stage, maxAge));
                            Block patt14090$temp = newState.m_60734_();
                            if (patt14090$temp instanceof Growable) {
                                Growable newGrowable = (Growable)patt14090$temp;
                                newGrowable.onGrow(level, cropPos, newState, cropState);
                            } else {
                                level.m_7731_(cropPos, newState, 3);
                            }
                            Platform.INSTANCE.cropGrowEvent((Level)level, cropPos, level.m_8055_(cropPos));
                        });
                    } else {
                        run.add(() -> CropUtils.attemptGiantize(level, cropPos, crop, cropState, this.cropSize, props));
                    }
                }
                if (!isWet && level.f_46441_.nextFloat() < GeneralConfig.witherChance && !cropState.m_61138_((Property)BlockCrop.WILTED) && ++wiltStage > 1) break;
                float season = props.seasonMultiplier(modifiers.season);
                float runeyBonus = modifiers.weather == EnumWeather.RUNEY ? 5.0f : 1.0f;
                float speed = this.growth * season * runeyBonus;
                if (!isWet) {
                    speed *= 0.5f;
                }
                this.cropAge += Math.min((float)props.growth(), speed);
                this.cropLevel = (float)((double)this.cropLevel + (double)this.quality * ((double)level.m_5822_().nextFloat() * 0.5 + 0.5));
                if (crop.runecraftory$isAtMaxAge(cropState) && hasGiantVersion) {
                    if (this.size != 0.0f) {
                        this.cropSize = (float)((double)this.cropSize + (double)this.size * ((double)level.m_5822_().nextFloat() * 0.2 + 0.1));
                        didCropGrow = this.size > 0.0f ? this.cropSize < 1.0f : this.cropSize > 0.0f;
                    }
                } else {
                    didCropGrow = true;
                }
                if (!didCropGrow) {
                    maxAgeStop = true;
                }
            }
            if (!ignoreWater && canRainAt) {
                isWet = this.scheduledWatering > 0;
            }
            this.scheduledWatering = Math.max(0, --this.scheduledWatering);
            if (didCropGrow) {
                if (level.f_46441_.nextInt(3) != 0) {
                    this.modifyHealth(null, -1);
                }
                if (level.f_46441_.nextBoolean()) {
                    this.applyGrowthFertilizer(null, this.growth > 1.0f ? -0.1f : -0.05f);
                }
                if (level.f_46441_.nextBoolean()) {
                    this.modifyQuality(null, -0.05f);
                }
            } else {
                this.normalizeLand();
            }
            if (!maxAgeStop) continue;
            break;
        }
        this.resetScheduledData();
        run.forEach(Runnable::run);
        if (wiltStage > 0 && (block = cropState.m_60734_()) instanceof BlockCrop) {
            BlockCrop blockCrop = (BlockCrop)block;
            blockCrop.onWither(wiltStage, (Level)level, cropState, cropPos);
        }
        this.cropProgress = this.growthPercent(level, cropState);
        FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
    }

    private void handleNotFarmblock(ServerLevel level) {
        this.normalizeLand();
        this.resetCrop();
        FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
        this.resetScheduledData();
    }

    private void resetScheduledData() {
        this.scheduledData.clear();
        this.scheduledWatering = 0;
        this.scheduledStormTicks = 0;
    }

    private void normalizeLand() {
        this.growth = this.growth > 1.0f ? Math.max(this.growth - 0.1f, 1.0f) : Math.min(this.growth + 0.1f, 1.0f);
        this.modifyQuality(null, -0.1f);
        this.size = Mth.m_14036_((float)(this.size - 0.05f), (float)0.0f, (float)2.0f);
        this.health = this.health > 32 ? Math.max(this.health - 1, 32) : Math.min(this.health + 1, 32);
    }

    private void resetCrop() {
        this.cropAge = 0.0f;
        this.cropLevel = 1.0f;
        this.cropSize = 0.0f;
        this.cropProgress = 0;
    }

    public void onLoad(ServerLevel level, boolean tick) {
        if (tick && this.lastUpdateDay != WorldUtils.day((Level)level)) {
            level.m_142572_().m_6937_((Runnable)new TickTask(1, () -> this.tick(level, true)));
        }
        this.isLoaded = true;
    }

    public void onUnload(ServerLevel level) {
        this.isLoaded = false;
        FarmlandHandler.get(level.m_142572_()).scheduleUpdate(level, this);
    }

    public void load(CompoundTag nbt) {
        this.growth = nbt.m_128457_("Growth");
        this.quality = nbt.m_128457_("Quality");
        this.size = nbt.m_128457_("Size");
        this.defence = nbt.m_128451_("Defence");
        this.health = nbt.m_128451_("Health");
        this.cropAge = nbt.m_128457_("CropAge");
        this.cropLevel = nbt.m_128457_("CropLevel");
        this.cropSize = nbt.m_128457_("CropSize");
        this.cropProgress = nbt.m_128451_("CropProgress");
        this.lastUpdateDay = nbt.m_128451_("LastUpdate");
        this.lastWeatherDay = nbt.m_128451_("LastWeatherDay");
        this.scheduledStormTicks = nbt.m_128451_("ScheduledStormTicks");
        this.scheduledWatering = nbt.m_128451_("ScheduledWaterAmount");
        ListTag scheduledDataTag = nbt.m_128437_("ScheduledData", 10);
        scheduledDataTag.forEach(t -> {
            CompoundTag lT = (CompoundTag)t;
            this.scheduledData.add(new ExternalModifiers(EnumSeason.valueOf(lT.m_128461_("Season")), EnumWeather.valueOf(lT.m_128461_("Weather"))));
        });
        this.isLoaded = nbt.m_128471_("IsLoaded");
        this.isFarmBlock = nbt.m_128471_("IsFarmBlock");
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("Growth", this.growth);
        nbt.m_128350_("Quality", this.quality);
        nbt.m_128350_("Size", this.size);
        nbt.m_128405_("Health", this.health);
        nbt.m_128405_("Defence", this.defence);
        nbt.m_128350_("CropAge", this.cropAge);
        nbt.m_128350_("CropLevel", this.cropLevel);
        nbt.m_128350_("CropSize", this.cropSize);
        nbt.m_128405_("CropProgress", this.cropProgress);
        nbt.m_128405_("LastUpdate", this.lastUpdateDay);
        nbt.m_128405_("LastWeatherDay", this.lastWeatherDay);
        nbt.m_128405_("ScheduledStormTicks", this.scheduledStormTicks);
        nbt.m_128405_("ScheduledWaterAmount", this.scheduledWatering);
        ListTag scheduledDataTag = new ListTag();
        this.scheduledData.forEach(mod -> {
            CompoundTag lT = new CompoundTag();
            lT.m_128359_("Season", mod.season.name());
            lT.m_128359_("Weather", mod.weather.name());
            scheduledDataTag.add((Object)lT);
        });
        nbt.m_128365_("ScheduledData", (Tag)scheduledDataTag);
        nbt.m_128379_("IsLoaded", this.isLoaded);
        nbt.m_128379_("IsFarmBlock", this.isFarmBlock);
        return nbt;
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeFloat(this.growth);
        buf.writeFloat(this.quality);
        buf.writeFloat(this.size);
        buf.writeInt(this.health);
        buf.writeInt(this.defence);
        buf.writeInt(this.cropProgress);
        buf.writeInt(Math.min(100, (int)this.cropSize * 100));
        buf.writeFloat(this.cropLevel);
    }

    public String toString() {
        return String.format("Farmland[%s, Loaded:%s, IsFarm:%s]", this.pos, this.isLoaded, this.isFarmBlock);
    }

    public String toStringFull() {
        return String.format("Farmland[%s, Loaded:%s, IsFarm:%s]: Growth:%s;Quality:%s;Size:%s;Health:%s;Defence:%s - Schedules:[StormTicks:%s;Watering:%s], Data: %s", this.pos, this.isLoaded, this.isFarmBlock, Float.valueOf(this.growth), Float.valueOf(this.quality), Float.valueOf(this.size), this.health, this.defence, this.scheduledStormTicks, this.scheduledWatering, this.scheduledData);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FarmlandData) {
            FarmlandData data = (FarmlandData)obj;
            return data.pos.equals((Object)this.pos);
        }
        return false;
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    protected record ExternalModifiers(EnumSeason season, EnumWeather weather) {
    }
}

