/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.farming;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.common.blocks.BlockCrop;
import io.github.flemmli97.runecraftory.common.blocks.BlockGiantCrop;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CFarmlandRemovePacket;
import io.github.flemmli97.runecraftory.common.network.S2CFarmlandUpdatePacket;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandData;
import io.github.flemmli97.runecraftory.platform.Platform;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.Logger;

public class FarmlandHandler
extends SavedData {
    private static final String ID = "FarmlandData";
    private static final int CHUNK_SECTION_SIZE = 4096;
    private final Map<ResourceKey<Level>, Long2ObjectMap<FarmlandData>> farmland = new HashMap<ResourceKey<Level>, Long2ObjectMap<FarmlandData>>();
    private final Map<ResourceKey<Level>, Long2ObjectMap<Set<FarmlandData>>> farmlandChunks = new HashMap<ResourceKey<Level>, Long2ObjectMap<Set<FarmlandData>>>();
    private final Map<ResourceKey<Level>, Long2ObjectMap<Set<FarmlandData>>> scheduledUpdates = new HashMap<ResourceKey<Level>, Long2ObjectMap<Set<FarmlandData>>>();
    private final Map<ResourceKey<Level>, Long2ObjectMap<Set<BlockPos>>> scheduledRemoveUpdates = new HashMap<ResourceKey<Level>, Long2ObjectMap<Set<BlockPos>>>();
    private final Map<ResourceKey<Level>, Set<PendingGiantCrops>> pendingGiantGrowth = new HashMap<ResourceKey<Level>, Set<PendingGiantCrops>>();
    private final Map<ResourceKey<Level>, Map<UUID, IrrigationPOI>> irrigationPOI = new HashMap<ResourceKey<Level>, Map<UUID, IrrigationPOI>>();
    private int lastUpdateDay;

    public FarmlandHandler() {
    }

    private FarmlandHandler(CompoundTag tag) {
        this.load(tag);
    }

    public static FarmlandHandler get(MinecraftServer server) {
        return (FarmlandHandler)server.m_129783_().m_8895_().m_164861_(FarmlandHandler::new, FarmlandHandler::new, ID);
    }

    public static boolean isFarmBlock(BlockState state) {
        return state.m_204336_(RunecraftoryTags.FARMLAND) && state.m_61138_((Property)FarmBlock.f_53243_);
    }

    public static void waterLand(ServerLevel level, BlockPos pos, BlockState state) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123816_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 4, 0.0, 0.01, 0.0, 0.1);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7)), 3);
        level.m_5594_(null, pos, SoundEvents.f_11707_, SoundSource.BLOCKS, 1.0f, 1.1f);
        BlockPos up = pos.m_7494_();
        BlockState crop = level.m_8055_(up);
        Block block = crop.m_60734_();
        if (block instanceof BlockCrop) {
            BlockCrop blockCrop = (BlockCrop)block;
            if (((Boolean)crop.m_61143_((Property)BlockCrop.WILTED)).booleanValue()) {
                blockCrop.onWiltedWatering((Level)level, up, crop);
            }
        }
    }

    public static boolean canRainingAt(Level level, BlockPos position) {
        if (!level.m_45527_(position)) {
            return false;
        }
        if (level.m_5452_(Heightmap.Types.MOTION_BLOCKING, position).m_123342_() > position.m_123342_()) {
            return false;
        }
        Biome biome = (Biome)level.m_204166_(position).m_203334_();
        return biome.m_47530_() == Biome.Precipitation.RAIN && biome.m_198906_(position);
    }

    public static void sendChangesTo(ServerLevel level, ChunkPos pos, List<FarmlandData> data) {
        Platform.INSTANCE.sendToTracking(new S2CFarmlandUpdatePacket(pos.m_45588_(), data), level, pos);
    }

    public static void onFarmRemoveChange(ServerLevel level, ChunkPos pos, List<BlockPos> data) {
        Platform.INSTANCE.sendToTracking(new S2CFarmlandRemovePacket(pos.m_45588_(), data), level, pos);
    }

    public static void unloadChunk(ServerLevel level, ChunkPos pos) {
        Platform.INSTANCE.sendToTracking(new S2CFarmlandRemovePacket(pos.m_45588_()), level, pos);
    }

    public static boolean isNearWater(LevelReader level, BlockPos pos) {
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-4, 0, -4), (BlockPos)pos.m_142082_(4, 1, 4))) {
            if (!level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    public void onFarmlandPlace(ServerLevel level, BlockPos pos) {
        FarmlandData data = (FarmlandData)this.farmland.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), old -> new Long2ObjectOpenHashMap()).computeIfAbsent(pos.m_121878_(), old -> new FarmlandData(pos));
        ((Set)this.farmlandChunks.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), old -> new Long2ObjectOpenHashMap()).computeIfAbsent(new ChunkPos(pos).m_45588_(), old -> new HashSet())).add(data);
        data.updateFarmBlock(true);
        data.onLoad(level, false);
        this.scheduleUpdate(level, data);
        this.m_77762_();
    }

    public void onFarmlandRemove(ServerLevel level, BlockPos pos) {
        FarmlandData data;
        Long2ObjectMap<FarmlandData> farms = this.farmland.get(level.m_46472_());
        if (farms != null && (data = (FarmlandData)farms.get(pos.m_121878_())) != null) {
            data.updateFarmBlock(false);
            this.scheduleRemoveUpdate(level, data);
            if (data.shouldBeRemoved()) {
                farms.remove(pos.m_121878_());
                ((Set)this.farmlandChunks.get(level.m_46472_()).get(new ChunkPos(pos).m_45588_())).remove(data);
            }
            this.m_77762_();
        }
    }

    public void onChunkLoad(ServerLevel level, ChunkPos pos) {
        Set farms;
        Long2ObjectMap<Set<FarmlandData>> chunkFarms = this.farmlandChunks.get(level.m_46472_());
        if (chunkFarms != null && (farms = (Set)chunkFarms.get(pos.m_45588_())) != null) {
            farms.forEach(d -> {
                d.onLoad(level, true);
                this.scheduleUpdate(level, (FarmlandData)d);
            });
            this.m_77762_();
        }
    }

    public void onChunkUnLoad(ServerLevel level, ChunkPos pos) {
        Long2ObjectMap<Set<FarmlandData>> chunkFarms = this.farmlandChunks.get(level.m_46472_());
        if (chunkFarms != null) {
            Set farms = (Set)chunkFarms.get(pos.m_45588_());
            if (farms != null) {
                farms.forEach(d -> d.onUnload(level));
                this.m_77762_();
            }
            FarmlandHandler.unloadChunk(level, pos);
        }
    }

    public Optional<FarmlandData> getData(ServerLevel level, BlockPos pos) {
        Long2ObjectMap<FarmlandData> farms = this.farmland.get(level.m_46472_());
        if (farms != null) {
            return Optional.ofNullable((FarmlandData)farms.get(pos.m_121878_()));
        }
        return Optional.empty();
    }

    public void scheduleUpdate(ServerLevel level, FarmlandData data) {
        ((Set)this.scheduledUpdates.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new Long2ObjectOpenHashMap()).computeIfAbsent(new ChunkPos(data.pos).m_45588_(), key -> new HashSet())).add(data);
    }

    public void scheduleRemoveUpdate(ServerLevel level, FarmlandData data) {
        ((Set)this.scheduledRemoveUpdates.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new Long2ObjectOpenHashMap()).computeIfAbsent(new ChunkPos(data.pos).m_45588_(), key -> new HashSet())).add(data.pos);
    }

    public void scheduleGiantCropMerge(ServerLevel level, BlockPos pos, BlockState state) {
        Set set = this.pendingGiantGrowth.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new HashSet());
        ArrayList<PendingGiantCrops> overlap = new ArrayList<PendingGiantCrops>();
        for (PendingGiantCrops pending : set) {
            if (pending.contains(pos)) {
                overlap.add(pending);
            }
            if (overlap.size() <= 1) continue;
            ((PendingGiantCrops)overlap.get(0)).add(pos, state);
            ((PendingGiantCrops)overlap.get(0)).combine((PendingGiantCrops)overlap.get(1));
            break;
        }
        if (!overlap.isEmpty()) {
            if (overlap.size() == 1) {
                ((PendingGiantCrops)overlap.get(0)).add(pos, state);
            } else {
                set.remove(overlap.get(1));
            }
            return;
        }
        PendingGiantCrops newData = new PendingGiantCrops();
        newData.add(pos, state);
        set.add(newData);
    }

    public void sendChangesTo(ServerPlayer player, ChunkPos pos) {
        Set farms;
        Long2ObjectMap<Set<FarmlandData>> chunkFarms = this.farmlandChunks.get(player.m_183503_().m_46472_());
        if (chunkFarms != null && (farms = (Set)chunkFarms.get(pos.m_45588_())) != null) {
            Platform.INSTANCE.sendToTracking(new S2CFarmlandUpdatePacket(pos.m_45588_(), new ArrayList<FarmlandData>(farms)), player.m_183503_(), pos);
        }
    }

    public void addIrrigationPOI(ServerLevel level, UUID id, BlockPos pos) {
        MonsterCropIrrigation poi = new MonsterCropIrrigation(level.m_46467_(), pos);
        this.irrigationPOI.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), old -> new HashMap()).put(id, poi);
        this.m_77762_();
    }

    public void removeIrrigationPOI(ServerLevel level, UUID id) {
        Map<UUID, IrrigationPOI> map = this.irrigationPOI.get(level.m_46472_());
        if (map != null) {
            map.remove(id);
            this.m_77762_();
        }
    }

    public boolean hasWater(ServerLevel level, BlockPos pos) {
        if (!GeneralConfig.unloadedFarmlandCheckWater || !GeneralConfig.disableFarmlandRandomtick && FarmlandHandler.isNearWater((LevelReader)level, pos)) {
            return true;
        }
        Map<UUID, IrrigationPOI> map = this.irrigationPOI.get(level.m_46472_());
        if (map != null) {
            for (IrrigationPOI poi : map.values()) {
                if (level.m_46467_() - poi.getStartTime() <= 1200L || !poi.isInside(pos)) continue;
                return true;
            }
        }
        return false;
    }

    public void tick(ServerLevel level) {
        if (WorldUtils.canUpdateDaily((Level)level, this.lastUpdateDay)) {
            ArrayList<ResourceKey> empty = new ArrayList<ResourceKey>();
            this.farmlandChunks.forEach((dim, m) -> {
                ServerLevel actualLevel = level.m_46472_().equals(dim) ? level : level.m_142572_().m_129880_(dim);
                ArrayList<FarmlandData> removed = new ArrayList<FarmlandData>();
                LongArraySet toRemove = new LongArraySet();
                for (Long2ObjectMap.Entry entry : m.long2ObjectEntrySet()) {
                    if (entry.getValue() == null) {
                        toRemove.add(entry.getLongKey());
                        continue;
                    }
                    ((Set)entry.getValue()).removeIf(d -> {
                        d.tick(actualLevel, false);
                        boolean remove = d.shouldBeRemoved();
                        if (remove) {
                            removed.add((FarmlandData)d);
                        }
                        return remove;
                    });
                    if (!((Set)entry.getValue()).isEmpty()) continue;
                    toRemove.add(entry.getLongKey());
                }
                toRemove.forEach(arg_0 -> ((Long2ObjectMap)m).remove(arg_0));
                if (m.isEmpty()) {
                    empty.add((ResourceKey)dim);
                } else {
                    removed.forEach(d -> {
                        Long2ObjectMap<FarmlandData> land = this.farmland.get(dim);
                        if (land != null) {
                            land.remove(d.pos.m_121878_());
                        }
                    });
                }
            });
            empty.forEach(dim -> {
                this.farmland.remove(dim);
                this.farmlandChunks.remove(dim);
            });
            this.lastUpdateDay = WorldUtils.day((Level)level);
        }
        this.farmlandChunks.forEach((dim, m) -> {
            ServerLevel actualLevel;
            ServerLevel serverLevel = actualLevel = level.m_46472_().equals(dim) ? level : level.m_142572_().m_129880_(dim);
            if (actualLevel != null) {
                this.randomTick(actualLevel, (Long2ObjectMap<Set<FarmlandData>>)m);
            }
        });
        this.scheduledUpdates.forEach((dim, m) -> {
            ServerLevel actualLevel;
            ServerLevel serverLevel = actualLevel = level.m_46472_().equals(dim) ? level : level.m_142572_().m_129880_(dim);
            if (actualLevel != null) {
                m.forEach((l, data) -> FarmlandHandler.sendChangesTo(actualLevel, new ChunkPos(l.longValue()), new ArrayList<FarmlandData>((Collection<FarmlandData>)data)));
            }
        });
        this.scheduledUpdates.clear();
        this.scheduledRemoveUpdates.forEach((dim, m) -> {
            ServerLevel actualLevel;
            ServerLevel serverLevel = actualLevel = level.m_46472_().equals(dim) ? level : level.m_142572_().m_129880_(dim);
            if (actualLevel != null) {
                m.forEach((l, data) -> FarmlandHandler.onFarmRemoveChange(actualLevel, new ChunkPos(l.longValue()), new ArrayList<BlockPos>((Collection<BlockPos>)data)));
            }
        });
        this.scheduledRemoveUpdates.clear();
        this.pendingGiantGrowth.forEach((dim, m) -> {
            ServerLevel actualLevel;
            ServerLevel serverLevel = actualLevel = level.m_46472_().equals(dim) ? level : level.m_142572_().m_129880_(dim);
            if (actualLevel != null) {
                m.forEach(data -> data.tryMerge(actualLevel));
            }
        });
        this.pendingGiantGrowth.clear();
        this.m_77762_();
    }

    private void randomTick(ServerLevel level, Long2ObjectMap<Set<FarmlandData>> m) {
        EnumWeather weather = WorldHandler.get(level.m_142572_()).currentWeather();
        Consumer<FarmlandData> cons = null;
        int day = WorldUtils.day((Level)level);
        if (weather == EnumWeather.STORM) {
            cons = d -> d.onStorming(level, day);
        } else if (level.m_46471_()) {
            cons = d -> d.onWatering(level, day);
        }
        if (cons == null) {
            return;
        }
        int randomTickSpeed = level.m_46469_().m_46215_(GameRules.f_46143_);
        Consumer<FarmlandData> finalCons = cons;
        m.forEach((packedChunk, data) -> {
            ArrayList list;
            if (data != null && !(list = new ArrayList(data)).isEmpty()) {
                int size = list.size();
                int chance = Mth.m_14167_((float)(4096.0f / (float)size));
                for (int l = 0; l < randomTickSpeed; ++l) {
                    if (level.f_46441_.nextInt(chance) != 0) continue;
                    finalCons.accept((FarmlandData)list.get(level.f_46441_.nextInt(size)));
                }
            }
        });
    }

    public void load(CompoundTag compoundTag) {
        this.lastUpdateDay = compoundTag.m_128451_("LastUpdateDay");
        CompoundTag farmTag = compoundTag.m_128469_("Farms");
        farmTag.m_128431_().forEach(levelKey -> {
            CompoundTag levelTag = farmTag.m_128469_(levelKey);
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(levelKey));
            levelTag.m_128431_().forEach(l -> {
                long packedPos = Long.parseLong(l);
                FarmlandData data = FarmlandData.fromTag(levelTag.m_128469_(l), BlockPos.m_122022_((long)packedPos));
                this.addDataOnRead((ResourceKey<Level>)key, data);
            });
        });
        CompoundTag irrigationTag = compoundTag.m_128469_("Irrigation");
        irrigationTag.m_128431_().forEach(levelKey -> {
            CompoundTag t = irrigationTag.m_128469_(levelKey);
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(levelKey));
            t.m_128431_().forEach(uuidKey -> {
                UUID uuid = UUID.fromString(uuidKey);
                this.irrigationPOI.computeIfAbsent((ResourceKey<Level>)key, old -> new HashMap()).put(uuid, IrrigationPOI.load(t.m_128469_(uuidKey)));
            });
        });
    }

    private void addDataOnRead(ResourceKey<Level> key, FarmlandData data) {
        this.farmland.computeIfAbsent(key, old -> new Long2ObjectOpenHashMap()).put(data.pos.m_121878_(), (Object)data);
        ((Set)this.farmlandChunks.computeIfAbsent(key, old -> new Long2ObjectOpenHashMap()).computeIfAbsent(new ChunkPos(data.pos).m_45588_(), old -> new HashSet())).add(data);
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        compoundTag.m_128405_("LastUpdateDay", this.lastUpdateDay);
        CompoundTag farmTag = new CompoundTag();
        this.farmland.forEach((key, map) -> {
            CompoundTag levelTag = new CompoundTag();
            map.forEach((l, data) -> levelTag.m_128365_(l.toString(), (Tag)data.save()));
            farmTag.m_128365_(key.m_135782_().toString(), (Tag)levelTag);
        });
        compoundTag.m_128365_("Farms", (Tag)farmTag);
        CompoundTag irrigationTag = new CompoundTag();
        this.irrigationPOI.forEach((key, map) -> {
            CompoundTag t = new CompoundTag();
            map.forEach((uuid, poi) -> t.m_128365_(uuid.toString(), (Tag)poi.save()));
            farmTag.m_128365_(key.m_135782_().toString(), (Tag)t);
        });
        compoundTag.m_128365_("Irrigation", (Tag)irrigationTag);
        return compoundTag;
    }

    public static class PendingGiantCrops {
        private static final PositionDirection[] OFFSETS = new PositionDirection[]{new PositionDirection(new BlockPos(1, 0, 0), Direction.WEST), new PositionDirection(new BlockPos(1, 0, 1), Direction.NORTH), new PositionDirection(new BlockPos(0, 0, 1), Direction.EAST)};
        private AABB inner;
        private AABB outer;
        private final Long2ObjectMap<BlockState> crops = new Long2ObjectOpenHashMap();

        public boolean contains(BlockPos pos) {
            return this.outer != null && this.outer.m_82393_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }

        public void add(BlockPos pos, BlockState state) {
            this.crops.put(pos.m_121878_(), (Object)state);
            this.inner = this.inner == null ? new AABB(pos) : this.inner.m_82367_(new AABB(pos));
            this.outer = this.inner.m_82377_(1.0, 0.0, 1.0);
        }

        public void combine(PendingGiantCrops other) {
            this.inner = this.inner.m_82367_(other.inner);
            this.outer = this.inner.m_82377_(1.0, 0.0, 1.0);
            this.crops.putAll(other.crops);
        }

        public void tryMerge(ServerLevel level) {
            int minX = Mth.m_14107_((double)this.inner.f_82288_);
            int minZ = Mth.m_14107_((double)this.inner.f_82290_);
            int y = Mth.m_14107_((double)this.inner.f_82289_);
            int maxX = Mth.m_14107_((double)(this.inner.f_82291_ - 1.0));
            int maxZ = Mth.m_14107_((double)(this.inner.f_82293_ - 1.0));
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    BlockState s = (BlockState)this.crops.get(BlockPos.m_121882_((int)x, (int)y, (int)z));
                    if (s == null) continue;
                    BlockPos p = new BlockPos(x, y, z);
                    ArrayList<Pair> list = new ArrayList<Pair>();
                    if (s.m_60734_() instanceof BlockGiantCrop) {
                        s = (BlockState)s.m_61124_(BlockGiantCrop.DIRECTION, (Comparable)Direction.SOUTH);
                    }
                    for (PositionDirection offset : OFFSETS) {
                        BlockPos newPos = p.m_141952_((Vec3i)offset.pos());
                        BlockState s2 = (BlockState)this.crops.get(newPos.m_121878_());
                        if (s2 == null || !s2.m_60713_(s.m_60734_())) continue;
                        if (s2.m_60734_() instanceof BlockGiantCrop) {
                            s2 = (BlockState)s2.m_61124_(BlockGiantCrop.DIRECTION, (Comparable)offset.direction());
                        }
                        list.add(Pair.of((Object)newPos, (Object)s2));
                    }
                    list.add(Pair.of((Object)p, (Object)s));
                    if (list.size() != 4) continue;
                    for (Pair pair : list) {
                        this.crops.remove(((BlockPos)pair.getFirst()).m_121878_());
                        level.m_7731_((BlockPos)pair.getFirst(), (BlockState)pair.getSecond(), 3);
                    }
                }
            }
        }
    }

    public record MonsterCropIrrigation(long startTime, BlockPos pos) implements IrrigationPOI
    {
        public static final String ID = "MonsterIrrigation";

        public MonsterCropIrrigation(CompoundTag tag) {
            this(tag.m_128454_("Start"), (BlockPos)BlockPos.f_121852_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("Pos")).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)));
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public boolean isInside(BlockPos pos) {
            int radius = MobConfig.farmRadius;
            int dX = this.pos.m_123341_() - pos.m_123341_();
            int dY = this.pos.m_123342_() - pos.m_123342_();
            int dZ = this.pos.m_123343_() - pos.m_123343_();
            return Math.abs(dY) < 2 && Math.abs(dX) < radius && Math.abs(dZ) < radius;
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("ID", ID);
            tag.m_128356_("Start", this.getStartTime());
            tag.m_128365_("Pos", (Tag)BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.pos).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)));
            return tag;
        }
    }

    public static interface IrrigationPOI {
        public static IrrigationPOI load(CompoundTag tag) {
            String id = tag.m_128461_("ID");
            if (id.equals("MonsterIrrigation")) {
                return new MonsterCropIrrigation(tag);
            }
            throw new IllegalStateException("Couldn't parse!");
        }

        public long getStartTime();

        public boolean isInside(BlockPos var1);

        public CompoundTag save();
    }

    record PositionDirection(BlockPos pos, Direction direction) {
    }
}

