/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.world.features.HerbFeatureConfig;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class HerbFeature
extends Feature<HerbFeatureConfig> {
    public HerbFeature(Codec<HerbFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<HerbFeatureConfig> ctx) {
        BlockPos blockPos = ctx.m_159777_();
        HerbFeatureConfig randomPatchConfiguration = (HerbFeatureConfig)ctx.m_159778_();
        Holder biome = ctx.m_159774_().m_204166_(blockPos);
        List<Entry> bakedList = randomPatchConfiguration.entries().stream().filter(p -> p.m_142631_().m_146281_() > 0).filter(e -> this.match((Entry)e, (Holder<Biome>)biome)).toList();
        Random random = ctx.m_159776_();
        Entry entry = WeightedRandom.m_146317_((Random)random, bakedList).orElse(null);
        if (entry == null) {
            return false;
        }
        WorldGenLevel worldGenLevel = ctx.m_159774_();
        int i = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int j = randomPatchConfiguration.radius() + 1;
        int k = randomPatchConfiguration.ySpread() + 1;
        BlockState state = entry.block.m_49966_();
        for (int l = 0; l < randomPatchConfiguration.tries(); ++l) {
            mutableBlockPos.m_122154_((Vec3i)blockPos, random.nextInt(j) - random.nextInt(j), random.nextInt(k) - random.nextInt(k), random.nextInt(j) - random.nextInt(j));
            if (!worldGenLevel.m_46859_((BlockPos)mutableBlockPos) || !state.m_60710_((LevelReader)worldGenLevel, (BlockPos)mutableBlockPos)) continue;
            worldGenLevel.m_7731_((BlockPos)mutableBlockPos, state, 3);
            ++i;
        }
        return i > 0;
    }

    private boolean match(Entry cfg, Holder<Biome> biome) {
        return !(cfg.whitelist != null && !biome.m_203656_(cfg.whitelist) || cfg.blacklist != null && biome.m_203656_(cfg.blacklist));
    }

    public static class Entry
    implements WeightedEntry {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Registry.f_122824_.m_194605_().fieldOf("block").forGetter(cb -> cb.block), (App)TagKey.m_203877_((ResourceKey)Registry.f_122885_).optionalFieldOf("biome_tag_whitelist").forGetter(cb -> Optional.ofNullable(cb.whitelist)), (App)TagKey.m_203877_((ResourceKey)Registry.f_122885_).optionalFieldOf("biome_tag_blacklist").forGetter(cb -> Optional.ofNullable(cb.blacklist)), (App)Codec.INT.fieldOf("weight").orElse((Object)3).forGetter(cb -> cb.weight.m_146281_())).apply((Applicative)codec, (block, whitelist, blacklist, weight) -> new Entry((Block)block, (TagKey<Biome>)((TagKey)whitelist.orElse(null)), (TagKey<Biome>)((TagKey)blacklist.orElse(null)), (int)weight)));
        public final Block block;
        public final TagKey<Biome> whitelist;
        public final TagKey<Biome> blacklist;
        public final Weight weight;

        public Entry(Block block, int weight) {
            this.block = block;
            this.weight = Weight.m_146282_((int)weight);
            ResourceLocation res = Registry.f_122824_.m_7981_((Object)block);
            this.whitelist = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("runecraftory", "herb/in_" + res.m_135815_()));
            this.blacklist = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("runecraftory", "herb/not_" + res.m_135815_()));
        }

        public Entry(Block block, TagKey<Biome> whitelist, TagKey<Biome> blacklist, int weight) {
            this.block = block;
            this.weight = Weight.m_146282_((int)weight);
            this.whitelist = whitelist;
            this.blacklist = blacklist;
        }

        public Weight m_142631_() {
            return this.weight;
        }
    }
}

