/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.features.trees;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.blocks.BlockTreeBase;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.registry.ModFeatures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class FruitTreeTrunkPlacer
extends TrunkPlacer {
    public static final Codec<FruitTreeTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("base_height").forGetter(d -> d.f_70263_), (App)Codec.INT.fieldOf("height_rand_a").forGetter(d -> d.f_70264_), (App)Codec.INT.fieldOf("min_branches").forGetter(d -> d.minBranches), (App)Codec.INT.fieldOf("max_branches").forGetter(d -> d.maxBranches)).apply((Applicative)instance, FruitTreeTrunkPlacer::new));
    private final int minBranches;
    private final int maxBranches;

    public FruitTreeTrunkPlacer(int baseHeight, int heightRandA, int minBranches, int maxBranches) {
        super(baseHeight, heightRandA, 0);
        this.minBranches = minBranches;
        this.maxBranches = maxBranches;
    }

    protected static boolean placeIfFree(LevelSimulatedReader level, Map<BlockPos, BlockState> blockSetter, BlockPos pos, BlockState state) {
        if (level.m_7433_(pos, BlockTreeBase::isAirOrReplaceable)) {
            blockSetter.put(pos, state);
            return true;
        }
        return false;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)ModFeatures.FRUIT_TRUNK_PLACER.get();
    }

    public int m_70309_(Random random) {
        return random.nextInt(1 + this.f_70264_) + this.f_70263_;
    }

    public List<FoliagePlacer.FoliageAttachment> m_142625_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, Random random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        BlockPos soil = pos.m_7495_();
        HashMap<BlockPos, BlockState> placements = new HashMap<BlockPos, BlockState>();
        if (level.m_7433_(soil, s -> !s.m_60713_((Block)ModBlocks.TREE_SOIL.get()))) {
            placements.put(soil, ((Block)ModBlocks.TREE_SOIL.get()).m_49966_());
        }
        ArrayList<FoliagePlacer.FoliageAttachment> foliagePos = new ArrayList<FoliagePlacer.FoliageAttachment>();
        for (int i = 1; i <= freeTreeHeight; ++i) {
            BlockPos log = pos.m_6630_(i);
            if (!FruitTreeTrunkPlacer.placeIfFree(level, placements, log, config.f_68185_.m_7112_(random, log))) {
                return List.of();
            }
            if (i != freeTreeHeight || freeTreeHeight > 3) continue;
            foliagePos.add(new FoliagePlacer.FoliageAttachment(log.m_7494_(), -1, false));
        }
        ArrayList dirs = new ArrayList(Direction.Plane.HORIZONTAL.m_122557_().toList());
        float chance = 1.0f;
        for (int i = 0; i < dirs.size(); ++i) {
            int offset;
            Direction dir = (Direction)dirs.remove(random.nextInt(dirs.size()));
            if (!(random.nextFloat() < chance)) continue;
            int n = offset = freeTreeHeight <= 3 || random.nextInt(3) == 0 ? 1 : 0;
            if (!this.growBranch(pos.m_6630_(freeTreeHeight + offset), dir, config, level, placements, random, random.nextInt(this.minBranches, this.maxBranches + 1), foliagePos)) {
                return List.of();
            }
            chance = (float)((double)chance - 0.3);
        }
        placements.forEach(blockSetter);
        return foliagePos;
    }

    private boolean growBranch(BlockPos pos, Direction dir, TreeConfiguration config, LevelSimulatedReader level, Map<BlockPos, BlockState> blockSetter, Random rand, int amount, List<FoliagePlacer.FoliageAttachment> logs) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || dir.m_122429_() != 0 && i == -dir.m_122429_() || dir.m_122431_() != 0 && j == -dir.m_122431_()) continue;
                list.add(new BlockPos(i, 0, j));
            }
        }
        BlockPos.MutableBlockPos mut = pos.m_122032_();
        for (int i = 0; i < amount; ++i) {
            BlockPos d = (BlockPos)list.get(rand.nextInt(list.size()));
            Direction direction = d.m_123341_() == 0 || d.m_123343_() == 0 ? Direction.m_175360_((BlockPos)d) : (dir = rand.nextBoolean() ? dir.m_122427_() : dir);
            if (i != 0 && (mut.m_123342_() == pos.m_123342_() ? rand.nextInt(2) == 0 : rand.nextInt(3) == 0)) {
                d = d.m_7494_();
            }
            mut.m_122193_((Vec3i)d);
            BlockPos newPos = mut.m_7949_();
            if (!FruitTreeTrunkPlacer.placeIfFree(level, blockSetter, newPos, (BlockState)config.f_68185_.m_7112_(rand, newPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_()))) {
                return false;
            }
            logs.add(new FoliagePlacer.FoliageAttachment(newPos.m_7494_(), 0, false));
        }
        return true;
    }
}

