/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.structure;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class NetherJigsawStructure
extends StructureFeature<JigsawConfiguration> {
    private static final WorldgenRandom RANDOM = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));

    public NetherJigsawStructure(Codec<JigsawConfiguration> codec, int min, int max) {
        super(codec, ctx -> NetherJigsawStructure.createPiecesGenerator((PieceGeneratorSupplier.Context<JigsawConfiguration>)ctx, context -> NetherJigsawStructure.tryFindFittingPos((PieceGeneratorSupplier.Context<JigsawConfiguration>)context, min, max)), PostPlacementProcessor.f_192427_);
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context, Function<PieceGeneratorSupplier.Context<JigsawConfiguration>, BlockPos> positionFinder) {
        BlockPos pos = positionFinder.apply(context);
        if (pos == null) {
            return Optional.empty();
        }
        return JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)pos, (boolean)false, (boolean)false);
    }

    public static BlockPos tryFindFittingPos(PieceGeneratorSupplier.Context<JigsawConfiguration> context, int min, int max) {
        BlockPos center = context.f_197355_().m_151394_(0);
        NoiseColumn column = context.f_197352_().m_141914_(center.m_123341_(), center.m_123343_(), context.f_197357_());
        ArrayList<BlockPos> matching = new ArrayList<BlockPos>();
        for (int i = min; i < max; ++i) {
            BlockState state = column.m_183556_(i);
            if (state.m_60795_() || !column.m_183556_(i + 1).m_60795_()) continue;
            matching.add(new BlockPos(center.m_123341_(), i, center.m_123343_()));
        }
        if (matching.isEmpty()) {
            return null;
        }
        RANDOM.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        return (BlockPos)matching.get(RANDOM.nextInt(matching.size()));
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.TOP_LAYER_MODIFICATION;
    }
}

