/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.structure.processors;

import com.mojang.serialization.Codec;
import io.github.flemmli97.runecraftory.common.blocks.BlockBossSpawner;
import io.github.flemmli97.runecraftory.common.blocks.tile.BossSpawnerBlockEntity;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.registry.ModStructures;
import io.github.flemmli97.runecraftory.common.world.structure.processors.DataStructureBlockProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BossSpawnerProcessor
extends DataStructureBlockProcessor {
    public static final Codec<BossSpawnerProcessor> CODEC = ResourceLocation.f_135803_.fieldOf("boss").xmap(BossSpawnerProcessor::new, d -> d.boss).codec();
    protected final ResourceLocation boss;

    public BossSpawnerProcessor(ResourceLocation boss) {
        super("BOSS", false);
        this.boss = boss;
    }

    public BossSpawnerProcessor(TagKey<EntityType<?>> boss) {
        super("BOSS", false);
        this.boss = new ResourceLocation(boss.f_203868_().toString());
    }

    @Override
    protected StructureTemplate.StructureBlockInfo handleDataMarker(String data, StructureTemplate.StructureBlockInfo origin, LevelReader level, StructurePlaceSettings settings) {
        String[] s = data.split("#");
        int off = -2;
        if (s.length != 1) {
            try {
                off = Integer.parseInt(s[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        BlockPos pos = origin.f_74675_.m_6630_(off);
        BlockState state = ((BlockState)((Block)ModBlocks.BOSS_SPAWNER.get()).m_49966_().m_61124_((Property)BlockBossSpawner.FACING, (Comparable)Direction.SOUTH)).m_60715_(settings.m_74401_()).m_60717_(settings.m_74404_());
        return new StructureTemplate.StructureBlockInfo(pos, state, BossSpawnerBlockEntity.creatTagFor(this.boss));
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)ModStructures.BOSS_PROCESSOR.get();
    }
}

