/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.config;

import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.network.S2CSyncConfig;
import io.github.flemmli97.runecraftory.forge.config.ClientConfigSpec;
import io.github.flemmli97.runecraftory.forge.config.GeneralConfigSpec;
import io.github.flemmli97.runecraftory.forge.config.MobConfigSpec;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.server.ServerLifecycleHooks;

public record ConfigHolder<T>(ModConfig.Type configType, String configName, T configSpec, Consumer<T> loader) {
    public static final Map<ForgeConfigSpec, ConfigHolder<?>> CONFIGS = new LinkedHashMap();

    public static void loadGeneral(GeneralConfigSpec spec) {
        GeneralConfig.defenceSystem = (GeneralConfig.DefenceSystem)((Object)spec.defenceSystem.get());
        GeneralConfig.gateSpawning = (Boolean)spec.gateSpawning.get();
        GeneralConfig.disableVanillaSpawning = (Boolean)spec.disableVanillaSpawning.get();
        GeneralConfig.randomDamage = (Boolean)spec.randomDamage.get();
        GeneralConfig.recipeSystem = (GeneralConfig.RecipeSystem)((Object)spec.recipeSystem.get());
        GeneralConfig.useRp = (Boolean)spec.useRP.get();
        GeneralConfig.deathHpPercent = ((Double)spec.deathHPPercent.get()).floatValue();
        GeneralConfig.deathRpPercent = ((Double)spec.deathRPPercent.get()).floatValue();
        GeneralConfig.disableHunger = (Boolean)spec.disableHunger.get();
        GeneralConfig.modifyWeather = (Boolean)spec.modifyWeather.get();
        GeneralConfig.modifyBed = (Boolean)spec.modifyBed.get();
        GeneralConfig.healOnWakeUp = (Boolean)spec.healOnWakeUp.get();
        GeneralConfig.disableFoodSystem = (Boolean)spec.disableFoodSystem.get();
        GeneralConfig.disableItemStatSystem = (Boolean)spec.disableItemStatSystem.get();
        GeneralConfig.disableCropSystem = (Boolean)spec.disableCropSystem.get();
        GeneralConfig.seasonedSnow = (Boolean)spec.seasonedSnow.get();
        GeneralConfig.maxPartySize = (Integer)spec.maxPartySize.get();
        GeneralConfig.witherChance = ((Double)spec.witherChance.get()).floatValue();
        GeneralConfig.runeyChance = ((Double)spec.runeyChance.get()).floatValue();
        GeneralConfig.disableFarmlandRandomtick = (Boolean)spec.disableFarmlandRandomtick.get();
        GeneralConfig.disableFarmlandTrample = (Boolean)spec.disableFarmlandTrample.get();
        GeneralConfig.tickUnloadedFarmland = (Boolean)spec.tickUnloadedFarmland.get();
        GeneralConfig.unloadedFarmlandCheckWater = (Boolean)spec.unloadedFarmlandCheckWater.get();
        GeneralConfig.maxLevel = (Integer)spec.maxLevel.get();
        GeneralConfig.startingHealth = (Integer)spec.startingHealth.get();
        GeneralConfig.startingRp = (Integer)spec.startingRP.get();
        GeneralConfig.startingMoney = (Integer)spec.startingMoney.get();
        GeneralConfig.startingStr = (Integer)spec.startingStr.get();
        GeneralConfig.startingVit = (Integer)spec.startingVit.get();
        GeneralConfig.startingIntel = (Integer)spec.startingIntel.get();
        GeneralConfig.hpPerLevel = ((Double)spec.hpPerLevel.get()).floatValue();
        GeneralConfig.rpPerLevel = ((Double)spec.rpPerLevel.get()).floatValue();
        GeneralConfig.strPerLevel = ((Double)spec.strPerLevel.get()).floatValue();
        GeneralConfig.vitPerLevel = ((Double)spec.vitPerLevel.get()).floatValue();
        GeneralConfig.intPerLevel = ((Double)spec.intPerLevel.get()).floatValue();
        GeneralConfig.shortSwordUltimate = ((Double)spec.shortSwordUltimate.get()).floatValue();
        GeneralConfig.longSwordUltimate = ((Double)spec.longSwordUltimate.get()).floatValue();
        GeneralConfig.spearUltimate = ((Double)spec.spearUltimate.get()).floatValue();
        GeneralConfig.hammerAxeUltimate = ((Double)spec.hammerAxeUltimate.get()).floatValue();
        GeneralConfig.dualBladeUltimate = ((Double)spec.dualBladeUltimate.get()).floatValue();
        GeneralConfig.gloveUltimate = ((Double)spec.gloveUltimate.get()).floatValue();
        GeneralConfig.platinumChargeTime = ((Double)spec.platinumChargeTime.get()).floatValue();
        GeneralConfig.scrapWateringCanWater = (Integer)spec.scrapWateringCanWater.get();
        GeneralConfig.ironWateringCanWater = (Integer)spec.ironWateringCanWater.get();
        GeneralConfig.silverWateringCanWater = (Integer)spec.silverWateringCanWater.get();
        GeneralConfig.goldWateringCanWater = (Integer)spec.goldWateringCanWater.get();
        GeneralConfig.platinumWateringCanWater = (Integer)spec.platinumWateringCanWater.get();
        GeneralConfig.moveSpeedAttack.read((Double)spec.moveSpeedAttack.get());
        GeneralConfig.xpMultiplier = ((Double)spec.xpMultiplier.get()).floatValue();
        GeneralConfig.skillXpMultiplier = ((Double)spec.skillXpMultiplier.get()).floatValue();
        GeneralConfig.tamingMultiplier = ((Double)spec.tamingMultiplier.get()).floatValue();
        GeneralConfig.debugAttack = (Boolean)spec.debugAttack.get();
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            Platform.INSTANCE.sendToAll(new S2CSyncConfig(), ServerLifecycleHooks.getCurrentServer());
        }
    }

    public static void loadClient(ClientConfigSpec spec) {
        ClientConfig.healthBarWidgetX = (Integer)spec.healthBarWidgetX.get();
        ClientConfig.healthBarWidgetY = (Integer)spec.healthBarWidgetY.get();
        ClientConfig.healthBarWidgetPosition = (ClientConfig.DisplayPosition)((Object)spec.healthBarWidgetPosition.get());
        ClientConfig.seasonDisplayX = (Integer)spec.seasonDisplayX.get();
        ClientConfig.seasonDisplayY = (Integer)spec.seasonDisplayY.get();
        ClientConfig.seasonDisplayPosition = (ClientConfig.DisplayPosition)((Object)spec.seasonDisplayPosition.get());
        ClientConfig.inventoryOffsetX = (Integer)spec.inventoryOffsetX.get();
        ClientConfig.inventoryOffsetY = (Integer)spec.inventoryOffsetY.get();
        ClientConfig.creativeInventoryOffsetX = (Integer)spec.creativeInventoryOffsetX.get();
        ClientConfig.creativeInventoryOffsetY = (Integer)spec.creativeInventoryOffsetY.get();
        ClientConfig.farmlandX = (Integer)spec.farmlandX.get();
        ClientConfig.farmlandY = (Integer)spec.farmlandY.get();
        ClientConfig.farmlandPosition = (ClientConfig.DisplayPosition)((Object)spec.farmlandPosition.get());
        ClientConfig.renderHealthRpBar = (ClientConfig.HealthRPRenderType)((Object)spec.renderHealthRPBar.get());
        ClientConfig.renderCalendar = (Boolean)spec.renderCalendar.get();
        ClientConfig.inventoryButton = (Boolean)spec.inventoryButton.get();
        ClientConfig.grassColor = (Boolean)spec.grassColor.get();
        ClientConfig.foliageColor = (Boolean)spec.foliageColor.get();
        ClientConfig.bossMusic = (Boolean)spec.bossMusic.get();
        ClientConfig.bossMusicFadeDelay = (Integer)spec.bossMusicFadeDelay.get();
    }

    public static void loadMobs(MobConfigSpec spec) {
        MobConfig.disableNaturalSpawn = (Boolean)spec.disableNaturalSpawn.get();
        MobConfig.farmRadius = (Integer)spec.farmRadius.get();
        MobConfig.mobAttackNpc = (Boolean)spec.mobAttackNPC.get();
        MobConfig.vanillaGiveXp = (Boolean)spec.vanillaGiveXp.get();
        MobConfig.monsterNeedBarn = (Boolean)spec.monsterNeedBarn.get();
        MobConfig.bellRadius = (Integer)spec.bellRadius.get();
        MobConfig.gateHealth = (Double)spec.gateHealth.get();
        MobConfig.gateDef = (Double)spec.gateDef.get();
        MobConfig.gateMDef = (Double)spec.gateMDef.get();
        MobConfig.gateHealthGain = (Double)spec.gateHealthGain.get();
        MobConfig.gateDefGain = (Double)spec.gateDefGain.get();
        MobConfig.gateMDefGain = (Double)spec.gateMDefGain.get();
        MobConfig.gateXp = (Integer)spec.gateXP.get();
        MobConfig.gateMoney = (Integer)spec.gateMoney.get();
        MobConfig.minSpawnDelay = (Integer)spec.minSpawnDelay.get();
        MobConfig.maxSpawnDelay = Math.max(MobConfig.minSpawnDelay, (Integer)spec.maxSpawnDelay.get());
        MobConfig.minDist = (Double)spec.minDist.get();
        MobConfig.maxGroup = (Integer)spec.maxGroup.get();
        MobConfig.minNearby = (Integer)spec.minNearby.get();
        MobConfig.maxNearby = (Integer)spec.maxNearby.get();
        MobConfig.baseGateLevel = (Integer)spec.baseGateLevel.get();
        MobConfig.gateLevelType = (MobConfig.GateLevelType)((Object)spec.gateLevelType.get());
        MobConfig.levelZones.readFromString((List)spec.levelZones.get());
        MobConfig.playerLevelType = (MobConfig.PlayerLevelType)((Object)spec.playerLevelType.get());
        MobConfig.treasureChance = ((Double)spec.treasureChance.get()).floatValue();
        MobConfig.mimicChance = ((Double)spec.mimicChance.get()).floatValue();
        MobConfig.mimicStrongChance = ((Double)spec.mimicStrongChance.get()).floatValue();
        MobConfig.npcSpawnRateMin = (Integer)spec.npcSpawnRateMin.get();
        MobConfig.npcSpawnRateMax = (Integer)spec.npcSpawnRateMax.get();
        MobConfig.initialProcreationCooldown = (Integer)spec.initialProcreationCooldown.get();
        MobConfig.procreationCooldown = (Integer)spec.procreationCooldown.get();
    }

    public void reloadConfig() {
        this.loader.accept(this.configSpec);
    }

    static {
        CONFIGS.put((ForgeConfigSpec)GeneralConfigSpec.SPEC.getRight(), new ConfigHolder<GeneralConfigSpec>(ModConfig.Type.COMMON, "runecraftory" + File.separator + "general.toml", (GeneralConfigSpec)GeneralConfigSpec.SPEC.getLeft(), ConfigHolder::loadGeneral));
        CONFIGS.put((ForgeConfigSpec)ClientConfigSpec.SPEC.getRight(), new ConfigHolder<ClientConfigSpec>(ModConfig.Type.CLIENT, "runecraftory" + File.separator + "client.toml", (ClientConfigSpec)ClientConfigSpec.SPEC.getLeft(), ConfigHolder::loadClient));
        CONFIGS.put((ForgeConfigSpec)MobConfigSpec.SPEC.getRight(), new ConfigHolder<MobConfigSpec>(ModConfig.Type.COMMON, "runecraftory" + File.separator + "mobs.toml", (MobConfigSpec)MobConfigSpec.SPEC.getLeft(), ConfigHolder::loadMobs));
    }
}

