/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.advancements.CropHarvestTrigger;
import io.github.flemmli97.runecraftory.common.advancements.LevelTrigger;
import io.github.flemmli97.runecraftory.common.advancements.MoneyTrigger;
import io.github.flemmli97.runecraftory.common.advancements.ShippingTrigger;
import io.github.flemmli97.runecraftory.common.advancements.ShopTrigger;
import io.github.flemmli97.runecraftory.common.advancements.SimpleTrigger;
import io.github.flemmli97.runecraftory.common.advancements.SkillLevelTrigger;
import io.github.flemmli97.runecraftory.common.advancements.TameMonsterTrigger;
import io.github.flemmli97.runecraftory.common.lib.LibAdvancements;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class AdvancementGen
implements DataProvider {
    private final DataGenerator generator;

    public AdvancementGen(DataGenerator dataGenerator) {
        this.generator = dataGenerator;
    }

    public void advancements(Consumer<Advancement> cons) {
        Advancement root = Advancement.Builder.m_138353_().m_138371_((ItemLike)ModItems.MEDICINAL_HERB.get(), (Component)new TranslatableComponent("runecraftory.advancements.root.title"), (Component)new TranslatableComponent("runecraftory.advancements.root.description"), new ResourceLocation("textures/block/dirt.png"), FrameType.TASK, false, false, false).m_138386_("crafting_table", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50091_})).m_138389_(cons, LibAdvancements.ROOT.toString());
        Advancement tameFirst = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)ModEntities.WOOLY.get())).get(), (Component)new TranslatableComponent("runecraftory.advancements.tame.first.title"), (Component)new TranslatableComponent("runecraftory.advancements.tame.first.description"), null, FrameType.TASK, true, true, false).m_138386_("tame_monster", (CriterionTriggerInstance)TameMonsterTrigger.TriggerInstance.of(1)).m_138389_(cons, LibAdvancements.TAME_FIRST.toString());
        Advancement tameTen = TameMonsterTrigger.TriggerInstance.amountOfSteps(Advancement.Builder.m_138353_().m_138398_(tameFirst).m_138371_((ItemLike)ModItems.MONSTER_BARN.get(), (Component)new TranslatableComponent("runecraftory.advancements.tame.ten.title"), (Component)new TranslatableComponent("runecraftory.advancements.tame.ten.description"), null, FrameType.GOAL, true, true, false), "tame_monster", 10, false).m_138389_(cons, LibAdvancements.TAME_TEN.toString());
        Advancement tameBoss = Advancement.Builder.m_138353_().m_138398_(tameFirst).m_138371_((ItemLike)ModItems.AMBROSIAS_THORNS.get(), (Component)new TranslatableComponent("runecraftory.advancements.tame.boss.title"), (Component)new TranslatableComponent("runecraftory.advancements.tame.boss.description"), null, FrameType.TASK, true, true, false).m_138386_("tame_boss_monster", (CriterionTriggerInstance)TameMonsterTrigger.TriggerInstance.bossOf(1)).m_138389_(cons, LibAdvancements.TAME_BOSS_FIRST.toString());
        Advancement tameBossFive = TameMonsterTrigger.TriggerInstance.amountOfSteps(Advancement.Builder.m_138353_().m_138398_(tameBoss).m_138362_(AdvancementGen.glowing((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)ModEntities.AMBROSIA.get())).get()), (Component)new TranslatableComponent("runecraftory.advancements.tame.boss.five.title"), (Component)new TranslatableComponent("runecraftory.advancements.tame.boss.five.description"), null, FrameType.GOAL, true, true, false), "tame_bosses", 5, true).m_138389_(cons, LibAdvancements.TAME_BOSS_FIVE.toString());
        Advancement tameBossAll = AdvancementGen.allBosses(Advancement.Builder.m_138353_().m_138398_(tameBossFive).m_138371_((ItemLike)ModItems.SCALE_LEGEND.get(), (Component)new TranslatableComponent("runecraftory.advancements.tame.boss.all.title"), (Component)new TranslatableComponent("runecraftory.advancements.tame.boss.all.description"), null, FrameType.CHALLENGE, true, true, false)).m_138389_(cons, LibAdvancements.TAME_BOSS_ALL.toString());
        Advancement shipping = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)ModItems.SHIPPING_BIN.get(), (Component)new TranslatableComponent("runecraftory.advancements.shipping.title"), (Component)new TranslatableComponent("runecraftory.advancements.shipping.description"), null, FrameType.TASK, true, true, false).m_138386_("ship_item", (CriterionTriggerInstance)ShippingTrigger.TriggerInstance.shipAny(1)).m_138389_(cons, LibAdvancements.SHIP_FIRST.toString());
        Advancement shippingFifty = Advancement.Builder.m_138353_().m_138398_(shipping).m_138371_((ItemLike)ModItems.SHIPPING_BIN.get(), (Component)new TranslatableComponent("runecraftory.advancements.shipping.fifty.title"), (Component)new TranslatableComponent("runecraftory.advancements.shipping.fifty.description"), null, FrameType.GOAL, true, true, false).m_138386_("ship_item", (CriterionTriggerInstance)ShippingTrigger.TriggerInstance.shipAny(50)).m_138389_(cons, LibAdvancements.SHIP_FIFTY.toString());
        Advancement shop = Advancement.Builder.m_138353_().m_138398_(shipping).m_138371_((ItemLike)Items.f_42417_, (Component)new TranslatableComponent("runecraftory.advancements.shop.title"), (Component)new TranslatableComponent("runecraftory.advancements.shop.description"), null, FrameType.TASK, true, true, false).m_138386_("buy_item", (CriterionTriggerInstance)ShopTrigger.TriggerInstance.buyAny()).m_138389_(cons, LibAdvancements.SHOP.toString());
        Advancement hundred_k = Advancement.Builder.m_138353_().m_138398_(shop).m_138371_((ItemLike)Items.f_41912_, (Component)new TranslatableComponent("runecraftory.advancements.100k.title"), (Component)new TranslatableComponent("runecraftory.advancements.100k.description"), null, FrameType.GOAL, true, true, false).m_138386_("have_money", (CriterionTriggerInstance)MoneyTrigger.TriggerInstance.of(100000)).m_138389_(cons, LibAdvancements.MONEY_100K.toString());
        Advancement million = Advancement.Builder.m_138353_().m_138398_(hundred_k).m_138371_((ItemLike)ModItems.EMERY_FLOWER.get(), (Component)new TranslatableComponent("runecraftory.advancements.million.title"), (Component)new TranslatableComponent("runecraftory.advancements.million.description"), null, FrameType.CHALLENGE, true, true, false).m_138386_("have_money", (CriterionTriggerInstance)MoneyTrigger.TriggerInstance.of(1000000)).m_138389_(cons, LibAdvancements.MONEY_1M.toString());
        Advancement skill = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)ModEntities.WOOLY.get())).get(), (Component)new TranslatableComponent("runecraftory.advancements.skill.weapon.5.title"), (Component)new TranslatableComponent("runecraftory.advancements.skill.weapon.5.description"), null, FrameType.TASK, true, true, false).m_138360_(RequirementsStrategy.f_15979_).m_138386_("short_sword", (CriterionTriggerInstance)SkillLevelTrigger.TriggerInstance.of(5, EnumSkills.SHORTSWORD)).m_138386_("long_sword", (CriterionTriggerInstance)SkillLevelTrigger.TriggerInstance.of(5, EnumSkills.LONGSWORD)).m_138386_("spear", (CriterionTriggerInstance)SkillLevelTrigger.TriggerInstance.of(5, EnumSkills.SPEAR)).m_138386_("axes_hammer", (CriterionTriggerInstance)SkillLevelTrigger.TriggerInstance.of(5, EnumSkills.HAMMERAXE)).m_138386_("first", (CriterionTriggerInstance)SkillLevelTrigger.TriggerInstance.of(5, EnumSkills.FIST)).m_138389_(cons, LibAdvancements.SKILL_5.toString());
        Advancement skill10 = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)Items.f_42612_, (Component)new TranslatableComponent("runecraftory.advancements.skill.10.title"), (Component)new TranslatableComponent("runecraftory.advancements.skill.10.description"), null, FrameType.TASK, true, true, false).m_138386_("skill", (CriterionTriggerInstance)SkillLevelTrigger.TriggerInstance.of(10)).m_138389_(cons, LibAdvancements.SKILL_10.toString());
        Advancement skill25 = Advancement.Builder.m_138353_().m_138398_(skill10).m_138371_((ItemLike)Items.f_42612_, (Component)new TranslatableComponent("runecraftory.advancements.skill.25.title"), (Component)new TranslatableComponent("runecraftory.advancements.skill.25.description"), null, FrameType.TASK, true, true, false).m_138386_("skill", (CriterionTriggerInstance)SkillLevelTrigger.TriggerInstance.of(25)).m_138389_(cons, LibAdvancements.SKILL_25.toString());
        Advancement skill50 = Advancement.Builder.m_138353_().m_138398_(skill25).m_138371_((ItemLike)Items.f_42612_, (Component)new TranslatableComponent("runecraftory.advancements.skill.50.title"), (Component)new TranslatableComponent("runecraftory.advancements.skill.50.description"), null, FrameType.GOAL, true, true, false).m_138386_("skill", (CriterionTriggerInstance)SkillLevelTrigger.TriggerInstance.of(50)).m_138389_(cons, LibAdvancements.SKILL_50.toString());
        Advancement skill100 = Advancement.Builder.m_138353_().m_138398_(skill50).m_138371_((ItemLike)Items.f_42612_, (Component)new TranslatableComponent("runecraftory.advancements.skill.100.title"), (Component)new TranslatableComponent("runecraftory.advancements.skill.100.description"), null, FrameType.CHALLENGE, true, true, false).m_138386_("skill", (CriterionTriggerInstance)SkillLevelTrigger.TriggerInstance.of(100)).m_138389_(cons, LibAdvancements.SKILL_100.toString());
        Advancement level10 = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)ModItems.LEVELISER.get(), (Component)new TranslatableComponent("runecraftory.advancements.level.10.title"), (Component)new TranslatableComponent("runecraftory.advancements.level.10.description"), null, FrameType.TASK, true, true, false).m_138386_("level", (CriterionTriggerInstance)LevelTrigger.TriggerInstance.of(10)).m_138389_(cons, LibAdvancements.LEVEL_10.toString());
        Advancement level25 = Advancement.Builder.m_138353_().m_138398_(level10).m_138371_((ItemLike)ModItems.LEVELISER.get(), (Component)new TranslatableComponent("runecraftory.advancements.level.25.title"), (Component)new TranslatableComponent("runecraftory.advancements.level.25.description"), null, FrameType.TASK, true, true, false).m_138386_("level", (CriterionTriggerInstance)LevelTrigger.TriggerInstance.of(25)).m_138389_(cons, LibAdvancements.LEVEL_25.toString());
        Advancement level50 = Advancement.Builder.m_138353_().m_138398_(level25).m_138362_(AdvancementGen.glowing((ItemLike)ModItems.LEVELISER.get()), (Component)new TranslatableComponent("runecraftory.advancements.level.50.title"), (Component)new TranslatableComponent("runecraftory.advancements.level.50.description"), null, FrameType.TASK, true, true, false).m_138386_("level", (CriterionTriggerInstance)LevelTrigger.TriggerInstance.of(50)).m_138389_(cons, LibAdvancements.LEVEL_50.toString());
        Advancement level100 = Advancement.Builder.m_138353_().m_138398_(level50).m_138362_(AdvancementGen.glowing((ItemLike)ModItems.LEVELISER.get()), (Component)new TranslatableComponent("runecraftory.advancements.level.100.title"), (Component)new TranslatableComponent("runecraftory.advancements.level.100.description"), null, FrameType.CHALLENGE, true, true, false).m_138386_("level", (CriterionTriggerInstance)LevelTrigger.TriggerInstance.of(100)).m_138389_(cons, LibAdvancements.LEVEL_100.toString());
        Advancement forgingItem = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)ModItems.ITEM_BLOCK_FORGE.get(), (Component)new TranslatableComponent("runecraftory.advancements.crafting.forging.title"), (Component)new TranslatableComponent("runecraftory.advancements.crafting.forging.description"), null, FrameType.TASK, true, true, false).m_138386_("craft", (CriterionTriggerInstance)SimpleTrigger.TriggerInstance.of(ModCriteria.FORGING)).m_138389_(cons, LibAdvancements.FORGE_ITEM.toString());
        Advancement craftingItem = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)ModItems.ITEM_BLOCK_ACCESS.get(), (Component)new TranslatableComponent("runecraftory.advancements.crafting.armor.title"), (Component)new TranslatableComponent("runecraftory.advancements.crafting.armor.description"), null, FrameType.TASK, true, true, false).m_138386_("craft", (CriterionTriggerInstance)SimpleTrigger.TriggerInstance.of(ModCriteria.CRAFTING)).m_138389_(cons, LibAdvancements.CRAFT_ARMOR.toString());
        Advancement brewingItem = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)ModItems.ITEM_BLOCK_CHEM.get(), (Component)new TranslatableComponent("runecraftory.advancements.crafting.chemistry.title"), (Component)new TranslatableComponent("runecraftory.advancements.crafting.chemistry.description"), null, FrameType.TASK, true, true, false).m_138386_("craft", (CriterionTriggerInstance)SimpleTrigger.TriggerInstance.of(ModCriteria.MEDICINE)).m_138389_(cons, LibAdvancements.MAKE_MEDICINE.toString());
        Advancement cookingItem = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)ModItems.ITEM_BLOCK_COOKING.get(), (Component)new TranslatableComponent("runecraftory.advancements.crafting.cooking.title"), (Component)new TranslatableComponent("runecraftory.advancements.crafting.cooking.description"), null, FrameType.TASK, true, true, false).m_138386_("craft", (CriterionTriggerInstance)SimpleTrigger.TriggerInstance.of(ModCriteria.COOKING)).m_138389_(cons, LibAdvancements.COOK.toString());
        Advancement upgradeItem = Advancement.Builder.m_138353_().m_138398_(craftingItem).m_138371_((ItemLike)ModItems.CHEAP_BRACELET.get(), (Component)new TranslatableComponent("runecraftory.advancements.upgrade.title"), (Component)new TranslatableComponent("runecraftory.advancements.upgrade.description"), null, FrameType.TASK, true, true, false).m_138386_("upgrade", (CriterionTriggerInstance)SimpleTrigger.TriggerInstance.of(ModCriteria.UPGRADE_ITEM)).m_138389_(cons, LibAdvancements.UPGRADE_ITEM.toString());
        Advancement changeElement = Advancement.Builder.m_138353_().m_138398_(forgingItem).m_138371_((ItemLike)ModItems.CRYSTAL_LOVE.get(), (Component)new TranslatableComponent("runecraftory.advancements.change.element.title"), (Component)new TranslatableComponent("runecraftory.advancements.change.element.description"), null, FrameType.TASK, true, true, false).m_138386_("element", (CriterionTriggerInstance)SimpleTrigger.TriggerInstance.of(ModCriteria.CHANGE_ELEMENT)).m_138389_(cons, LibAdvancements.CHANGE_ELEMENT.toString());
        Advancement lightOre = Advancement.Builder.m_138353_().m_138398_(changeElement).m_138371_((ItemLike)ModItems.LIGHT_ORE.get(), (Component)new TranslatableComponent("runecraftory.advancements.lightore.title"), (Component)new TranslatableComponent("runecraftory.advancements.lightore.description"), null, FrameType.GOAL, true, true, false).m_138386_("light_ore", (CriterionTriggerInstance)SimpleTrigger.TriggerInstance.of(ModCriteria.LIGHT_ORE)).m_138389_(cons, LibAdvancements.LIGHT_ORE.toString());
        Advancement spell = Advancement.Builder.m_138353_().m_138398_(forgingItem).m_138371_((ItemLike)ModItems.FIRE_BALL_SMALL.get(), (Component)new TranslatableComponent("runecraftory.advancements.spell.title"), (Component)new TranslatableComponent("runecraftory.advancements.spell.description"), null, FrameType.TASK, true, true, false).m_138386_("spell", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(RunecraftoryTags.SPELLS).m_45077_()})).m_138389_(cons, LibAdvancements.SPELL.toString());
        Advancement changeSpell = Advancement.Builder.m_138353_().m_138398_(forgingItem).m_138371_((ItemLike)ModItems.ROD.get(), (Component)new TranslatableComponent("runecraftory.advancements.change.spell.title"), (Component)new TranslatableComponent("runecraftory.advancements.change.spell.description"), null, FrameType.TASK, true, true, false).m_138386_("spell", (CriterionTriggerInstance)SimpleTrigger.TriggerInstance.of(ModCriteria.CHANGE_SPELL)).m_138389_(cons, LibAdvancements.CHANGE_SPELL.toString());
        Advancement fertilizer = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)ModItems.FORMULAR_A.get(), (Component)new TranslatableComponent("runecraftory.advancements.fertilizer.title"), (Component)new TranslatableComponent("runecraftory.advancements.fertilizer.description"), null, FrameType.TASK, true, true, false).m_138386_("fertilizer", (CriterionTriggerInstance)SimpleTrigger.TriggerInstance.of(ModCriteria.FERTILIZE_FARM)).m_138389_(cons, LibAdvancements.FERTILIZER.toString());
        Advancement giantCrop = Advancement.Builder.m_138353_().m_138398_(fertilizer).m_138371_((ItemLike)ModItems.TURNIP_GIANT.get(), (Component)new TranslatableComponent("runecraftory.advancements.giant_crop.title"), (Component)new TranslatableComponent("runecraftory.advancements.giant_crop.description"), null, FrameType.GOAL, true, true, false).m_138386_("giant_crop", (CriterionTriggerInstance)CropHarvestTrigger.TriggerInstance.harvest(RunecraftoryTags.GIANT_CROP_BLOCKS)).m_138389_(cons, LibAdvancements.GIANT_CROPS.toString());
        Advancement helper = Advancement.Builder.m_138353_().m_138398_(fertilizer).m_138371_((ItemLike)ModItems.MOB_STAFF.get(), (Component)new TranslatableComponent("runecraftory.advancements.monster.help.title"), (Component)new TranslatableComponent("runecraftory.advancements.monster.help.description"), null, FrameType.TASK, true, true, false).m_138386_("farming", (CriterionTriggerInstance)SimpleTrigger.TriggerInstance.of(ModCriteria.COMMAND_FARMING)).m_138389_(cons, LibAdvancements.HELPER.toString());
        Advancement hightTierTool = Advancement.Builder.m_138353_().m_138398_(helper).m_138371_((ItemLike)ModItems.WATERING_CAN_PLATINUM.get(), (Component)new TranslatableComponent("runecraftory.advancements.final.tool.title"), (Component)new TranslatableComponent("runecraftory.advancements.final.tool.description"), null, FrameType.CHALLENGE, true, true, false).m_138386_("final_tool", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(RunecraftoryTags.HIGH_TIER_TOOLS).m_45077_()})).m_138389_(cons, LibAdvancements.HIGH_TIER_TOOL.toString());
        Advancement rootProgression = Advancement.Builder.m_138353_().m_138371_((ItemLike)ModItems.SHORT_DAGGER.get(), (Component)new TranslatableComponent("runecraftory.advancements.progression.root.title"), (Component)new TranslatableComponent("runecraftory.advancements.progression.root.description"), new ResourceLocation("textures/block/dirt.png"), FrameType.TASK, false, false, false).m_138386_("crafting_table", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50091_})).m_138389_(cons, LibAdvancements.ROOT_PROGRESSION.toString());
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138371_((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)ModEntities.WOOLY.get())).get(), (Component)new TranslatableComponent("runecraftory.advancements.progression.boss.greater_demon.title"), (Component)new TranslatableComponent("runecraftory.advancements.progression.boss.greater_demon.description"), new ResourceLocation("textures/block/dirt.png"), FrameType.TASK, true, true, false).m_138386_("dummy", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
        Advancement greater_demon = builder.m_138389_(cons, LibAdvancements.GREATER_DEMON.toString());
        Advancement chimera = AdvancementGen.bossProgression(ModEntities.CHIMERA, cons, LibAdvancements.CHIMERA, greater_demon);
        Advancement rafflesia = AdvancementGen.bossProgression(ModEntities.RAFFLESIA, cons, LibAdvancements.RAFFLESIA, chimera);
        Advancement grimoire = AdvancementGen.bossProgression(ModEntities.GRIMOIRE, cons, LibAdvancements.GRIMOIRE, rafflesia);
        Advancement deadTree = AdvancementGen.bossProgression(ModEntities.DEAD_TREE, cons, LibAdvancements.DEAD_TREE, rootProgression);
        Advancement raccoon = AdvancementGen.bossProgression(ModEntities.RACCOON, cons, LibAdvancements.RACCOON, rootProgression);
        Advancement skelefang = AdvancementGen.bossProgression(ModEntities.SKELEFANG, cons, LibAdvancements.SKELEFANG, raccoon);
        Advancement ambrosia = AdvancementGen.bossProgression(ModEntities.AMBROSIA, cons, LibAdvancements.AMBROSIA, rootProgression);
        Advancement thunderbolt = AdvancementGen.bossProgression(ModEntities.THUNDERBOLT, cons, LibAdvancements.THUNDERBOLT, ambrosia);
        Advancement marionetta = AdvancementGen.bossProgression(ModEntities.MARIONETTA, cons, LibAdvancements.MARIONETTA, thunderbolt);
        Advancement handonetta = AdvancementGen.bossProgression(ModEntities.HANDONETTA, cons, LibAdvancements.HANDONETTA, thunderbolt);
        builder = Advancement.Builder.m_138353_().m_138371_((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)ModEntities.SANO.get())).get(), (Component)new TranslatableComponent("runecraftory.advancements.progression.boss.sano_uno.title"), (Component)new TranslatableComponent("runecraftory.advancements.progression.boss.sano_uno.description"), new ResourceLocation("textures/block/dirt.png"), FrameType.TASK, true, true, false).m_138386_("boss1", (CriterionTriggerInstance)new KilledTrigger.TriggerInstance(CriteriaTriggers.f_10568_.m_7295_(), EntityPredicate.Composite.m_36673_((EntityPredicate)LibAdvancements.playerAdvancementCheck(marionetta.m_138327_()).m_36662_()), EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)ModEntities.SANO.get()).m_36662_()), DamageSourcePredicate.f_25420_)).m_138386_("boss2", (CriterionTriggerInstance)new KilledTrigger.TriggerInstance(CriteriaTriggers.f_10568_.m_7295_(), EntityPredicate.Composite.m_36673_((EntityPredicate)LibAdvancements.playerAdvancementCheck(marionetta.m_138327_()).m_36662_()), EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)ModEntities.UNO.get()).m_36662_()), DamageSourcePredicate.f_25420_)).m_138398_(marionetta);
        Advancement sano_uno = builder.m_138389_(cons, LibAdvancements.SANO_UNO.toString());
        Advancement sarcophagus = AdvancementGen.bossProgression(ModEntities.SARCOPHAGUS, cons, LibAdvancements.SARCOPHAGUS, sano_uno);
    }

    private static ItemStack glowing(ItemLike itemLike) {
        ItemStack stack = new ItemStack((ItemLike)itemLike.m_5456_());
        stack.m_41663_(Enchantments.f_44986_, 1);
        return stack;
    }

    public static RequirementsStrategy amount(int amount) {
        return collection -> {
            String[][] strings = new String[amount][];
            for (int i = 0; i < amount; ++i) {
                strings[i] = collection.toArray(new String[0]);
            }
            return strings;
        };
    }

    private static Path createPath(Path path, Advancement advancement) {
        return path.resolve("data/" + advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
    }

    protected static Advancement.Builder allBosses(Advancement.Builder builder) {
        for (RegistryEntrySupplier<EntityType<?>> sup : ModEntities.getBosses()) {
            builder.m_138386_(sup.getID().toString(), (CriterionTriggerInstance)new TameMonsterTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, new EntityPredicate.Builder().m_36636_((EntityType)sup.get()).m_36662_(), 1, false));
        }
        return builder;
    }

    private static <T extends Entity> Advancement bossProgression(RegistryEntrySupplier<EntityType<T>> entity, Consumer<Advancement> cons, ResourceLocation id, Advancement parent) {
        return AdvancementGen.bossProgression(entity, cons, id, parent, false);
    }

    private static <T extends Entity> Advancement bossProgression(RegistryEntrySupplier<EntityType<T>> entity, Consumer<Advancement> cons, ResourceLocation id, Advancement parent, boolean hidden) {
        KilledTrigger.TriggerInstance trigger = parent != null ? new KilledTrigger.TriggerInstance(CriteriaTriggers.f_10568_.m_7295_(), EntityPredicate.Composite.m_36673_((EntityPredicate)LibAdvancements.playerAdvancementCheck(parent.m_138327_()).m_36662_()), EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)entity.get()).m_36662_()), DamageSourcePredicate.f_25420_) : KilledTrigger.TriggerInstance.m_152124_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)entity.get()).m_36662_());
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138371_((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)entity.get())).get(), (Component)new TranslatableComponent(String.format("runecraftory.advancements.progression.boss.%s.title", entity.getID().m_135815_())), (Component)new TranslatableComponent(String.format("runecraftory.advancements.progression.boss.%s.description", entity.getID().m_135815_())), new ResourceLocation("textures/block/dirt.png"), FrameType.TASK, true, true, hidden).m_138386_("boss", (CriterionTriggerInstance)trigger);
        if (parent != null) {
            builder.m_138398_(parent);
        }
        return builder.m_138389_(cons, id.toString());
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + String.valueOf(advancement.m_138327_()));
            }
            Path path2 = AdvancementGen.createPath(path, advancement);
            try {
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path2);
            }
            catch (IOException iOException) {
                RuneCraftory.LOGGER.error("Couldn't save advancement {}", (Object)path2, (Object)iOException);
            }
        };
        this.advancements(consumer);
    }

    public String m_6055_() {
        return "Advancements";
    }
}

