/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.data;

import io.github.flemmli97.runecraftory.common.blocks.BlockCrafting;
import io.github.flemmli97.runecraftory.common.blocks.BlockCrop;
import io.github.flemmli97.runecraftory.common.blocks.BlockFruitTreeLeaf;
import io.github.flemmli97.runecraftory.common.blocks.BlockGiantCrop;
import io.github.flemmli97.runecraftory.common.blocks.BlockHerb;
import io.github.flemmli97.runecraftory.common.blocks.BlockQuestboard;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStatesGen
extends BlockStateProvider {
    private static final ResourceLocation CROP_TINTED = new ResourceLocation("runecraftory", "block/crop_tinted");
    private static final ResourceLocation CROP_BIG = new ResourceLocation("runecraftory", "block/big_crop");
    private static final ResourceLocation CROP_GIANT_1 = new ResourceLocation("runecraftory", "block/giant_crop_1");
    private static final ResourceLocation CROP_GIANT_2 = new ResourceLocation("runecraftory", "block/giant_crop_2");
    private static final ResourceLocation FLOWER_BIG = new ResourceLocation("runecraftory", "block/big_flower");
    private static final ResourceLocation FLOWER_GIANT = new ResourceLocation("runecraftory", "block/giant_flower");
    private static final ResourceLocation CROSS_TINTED = new ResourceLocation("runecraftory", "block/cross_tinted");

    public BlockStatesGen(DataGenerator gen, ExistingFileHelper helper) {
        super(gen, "runecraftory", helper);
    }

    protected void registerStatesAndModels() {
        ModBlocks.HERBS.forEach(reg -> {
            Block block = (Block)reg.get();
            if (block == ModBlocks.MEDICINAL_HERB.get()) {
                this.simpleBlock(block, (ModelFile)this.models().withExistingParent(block.getRegistryName().toString(), new ResourceLocation("runecraftory:item/medicinal_herb")));
            } else if (block instanceof BlockHerb) {
                ResourceLocation texture = this.itemTexture(block);
                this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(block.getRegistryName().toString(), texture)).texture("particle", texture));
            }
        });
        for (RegistryEntrySupplier<Block> reg2 : ModBlocks.FLOWERS) {
            Block block = (Block)reg2.get();
            if (reg2 == ModBlocks.SWORD_CROP || reg2 == ModBlocks.SHIELD_CROP) {
                this.getVariantBuilder(block).forAllStatesExcept(state -> {
                    int stage = (Integer)state.m_61143_((Property)BlockCrop.AGE);
                    ResourceLocation text = stage == 3 || stage == 4 ? this.blockTexture("runecraftory", reg2.getID().m_135815_()) : this.blockTexture("runecraftory", "plant_gear_" + stage);
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(text.toString(), CROSS_TINTED, "cross", text)).build();
                }, new Property[]{BlockCrop.WILTED});
                continue;
            }
            if (block instanceof BlockGiantCrop) {
                BlockGiantCrop giant = (BlockGiantCrop)block;
                this.getVariantBuilder(block).forAllStatesExcept(state -> {
                    ResourceLocation texture = this.itemTexture(giant.getCrop());
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(block.getRegistryName().toString(), FLOWER_GIANT, "0", texture)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
                }, new Property[]{BlockCrop.WILTED, BlockGiantCrop.AGE});
                continue;
            }
            if (!(block instanceof BlockCrop)) continue;
            this.getVariantBuilder(block).forAllStatesExcept(state -> {
                String name;
                int stage = (Integer)state.m_61143_((Property)BlockCrop.AGE);
                boolean defaultFlowerState = stage == 0 && reg2 != ModBlocks.EMERY_FLOWER && reg2 != ModBlocks.IRONLEAF && reg2 != ModBlocks.NOEL_GRASS && reg2 != ModBlocks.LAMP_GRASS;
                String string = name = defaultFlowerState ? "runecraftory:flower_stage_0" : block.getRegistryName().toString() + "_" + stage;
                ResourceLocation texture = defaultFlowerState ? this.blockTexture("runecraftory", "flower_stage_0") : (stage == 3 ? this.itemCropTexture(block) : this.blockTexture("runecraftory", block.getRegistryName().m_135815_() + "_" + stage));
                ResourceLocation parent = CROSS_TINTED;
                if (stage == 4) {
                    Object patt5613$temp;
                    parent = FLOWER_BIG;
                    RegistryEntrySupplier<Block> giant = ModBlocks.GIANT_CROP_MAP.get(reg2);
                    if (giant != null && (patt5613$temp = giant.get()) instanceof BlockGiantCrop) {
                        BlockGiantCrop giantCrop = (BlockGiantCrop)((Object)((Object)patt5613$temp));
                        texture = this.itemTexture(giantCrop.getCrop());
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(name, parent, "cross", texture)).build();
            }, new Property[]{BlockCrop.WILTED});
        }
        ModBlocks.CROPS.forEach(reg -> {
            Block block = (Block)reg.get();
            if (block instanceof BlockGiantCrop) {
                this.getVariantBuilder(block).forAllStatesExcept(state -> {
                    ResourceLocation texture = this.blockTexture("runecraftory", block.getRegistryName().m_135815_());
                    ResourceLocation parent = CROP_GIANT_1;
                    int rot = 0;
                    Object file = block.getRegistryName().toString();
                    switch ((Direction)state.m_61143_(BlockGiantCrop.DIRECTION)) {
                        case EAST: {
                            parent = CROP_GIANT_2;
                            file = (String)file + "_2";
                            break;
                        }
                        case SOUTH: {
                            rot = 180;
                            break;
                        }
                        case WEST: {
                            parent = CROP_GIANT_2;
                            file = (String)file + "_2";
                            rot = 180;
                        }
                    }
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture((String)file, parent, "crop", texture)).rotationY(rot).build();
                }, new Property[]{BlockCrop.WILTED, BlockGiantCrop.AGE});
            } else if (block instanceof BlockCrop) {
                this.getVariantBuilder(block).forAllStatesExcept(state -> {
                    int stage = (Integer)state.m_61143_((Property)BlockCrop.AGE);
                    String name = block.getRegistryName().toString() + "_" + stage;
                    ResourceLocation texture = this.blockTexture("runecraftory", block.getRegistryName().m_135815_() + "_" + stage);
                    ResourceLocation parent = CROP_TINTED;
                    if (stage == 4) {
                        parent = CROP_BIG;
                        RegistryEntrySupplier<Block> giant = ModBlocks.GIANT_CROP_MAP.get(reg);
                        if (giant != null) {
                            texture = this.blockTexture((Block)giant.get());
                        }
                    }
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(name, parent, "crop", texture)).build();
                }, new Property[]{BlockCrop.WILTED});
            }
        });
        ModBlocks.MINERAL_MAP.values().forEach(reg -> {
            Block block = (Block)reg.get();
            this.getVariantBuilder(block).forAllStatesExcept(state -> {
                BlockModelBuilder file = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getRegistryName().toString(), "runecraftory:block/ore")).texture("ore", this.blockTexture(block));
                if (block == ModBlocks.MINERAL_DRAGONIC.get()) {
                    file = (BlockModelBuilder)file.texture("0", new ResourceLocation("block/end_stone"));
                }
                return ConfiguredModel.builder().modelFile((ModelFile)file).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() % 360).build();
            }, new Property[]{BlockStateProperties.f_61362_});
        });
        ModBlocks.BROKEN_MINERAL_MAP.values().forEach(reg -> {
            Block block = (Block)reg.get();
            this.getVariantBuilder(block).forAllStatesExcept(state -> {
                BlockModelBuilder file = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getRegistryName().toString(), "runecraftory:block/ore_broken")).texture("ore", this.mineralTexture(block));
                if (block == ModBlocks.BROKEN_MINERAL_DRAGONIC.get()) {
                    file = (BlockModelBuilder)file.texture("0", new ResourceLocation("block/end_stone"));
                }
                return ConfiguredModel.builder().modelFile((ModelFile)file).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() % 360).build();
            }, new Property[]{BlockStateProperties.f_61362_});
        });
        this.craftingModel((Block)ModBlocks.FORGE.get());
        this.craftingModel((Block)ModBlocks.ACCESSORY.get());
        this.craftingModel((Block)ModBlocks.COOKING.get());
        this.craftingModel((Block)ModBlocks.CHEMISTRY.get());
        this.simpleBlock((Block)ModBlocks.BOSS_SPAWNER.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_50085_.getRegistryName().m_135815_())));
        this.simpleBlock((Block)ModBlocks.SINGLE_SPAWN_BLOCK.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_50085_.getRegistryName().m_135815_())));
        this.simpleBlock((Block)ModBlocks.MONSTER_BARN.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("runecraftory", "block/" + ModBlocks.MONSTER_BARN.getID().m_135815_())));
        this.getVariantBuilder((Block)ModBlocks.SNOW.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) == 8 ? new ResourceLocation("block/snow_block") : new ResourceLocation("block/snow_height" + (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) * 2))).build());
        this.getVariantBuilder((Block)ModBlocks.SHIPPING.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().orientableVertical(ModBlocks.SHIPPING.getID().m_135815_(), this.modLoc("block/shipping_bin"), this.modLoc("block/shipping_bin_top"))).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() % 360).build());
        this.getVariantBuilder((Block)ModBlocks.CASH_REGISTER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation("runecraftory", "block/" + ModBlocks.CASH_REGISTER.getID().m_135815_()))).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() % 360).build());
        this.getVariantBuilder((Block)ModBlocks.QUEST_BOARD.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation("runecraftory", "block/" + ModBlocks.QUEST_BOARD.getID().m_135815_() + "_" + ((BlockQuestboard.Part)((Object)((Object)state.m_61143_(BlockQuestboard.PART)))).m_7912_()))).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() % 360).build());
        this.simpleBlock((Block)ModBlocks.TREE_SOIL.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_50493_.getRegistryName().m_135815_())));
        this.axisBlock((RotatedPillarBlock)ModBlocks.APPLE_TREE.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_49999_.getRegistryName().m_135815_())), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_49999_.getRegistryName().m_135815_() + "_horizontal")));
        this.simpleBlock((Block)ModBlocks.APPLE_SAPLING.get(), (ModelFile)this.models().cross(ModBlocks.APPLE_SAPLING.getID().toString(), this.itemTexture((Item)ModItems.APPLE_SAPLING.get())));
        this.axisBlock((RotatedPillarBlock)ModBlocks.APPLE_WOOD.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_49999_.getRegistryName().m_135815_())), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_49999_.getRegistryName().m_135815_() + "_horizontal")));
        this.simpleBlock((Block)ModBlocks.APPLE_LEAVES.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_50050_.getRegistryName().m_135815_())));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)ModBlocks.APPLE.get()).partialState().with((Property)BlockFruitTreeLeaf.HAS_FRUIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.APPLE.getID().toString(), this.modLoc("fruit_leaves"))).texture("base", this.blockTexture(Blocks.f_50050_))).texture("particle", this.blockTexture(Blocks.f_50050_))).texture("overlay", this.blockTexture((Block)ModBlocks.APPLE.get()))).addModel()).partialState().with((Property)BlockFruitTreeLeaf.HAS_FRUIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.APPLE.getID().toString() + "_fruitless", "block/leaves")).texture("all", this.blockTexture(Blocks.f_50050_))).addModel();
        this.axisBlock((RotatedPillarBlock)ModBlocks.ORANGE_TREE.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_49999_.getRegistryName().m_135815_())), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_49999_.getRegistryName().m_135815_() + "_horizontal")));
        this.simpleBlock((Block)ModBlocks.ORANGE_SAPLING.get(), (ModelFile)this.models().cross(ModBlocks.ORANGE_SAPLING.getID().toString(), this.itemTexture((Item)ModItems.ORANGE_SAPLING.get())));
        this.axisBlock((RotatedPillarBlock)ModBlocks.ORANGE_WOOD.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_49999_.getRegistryName().m_135815_())), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_49999_.getRegistryName().m_135815_() + "_horizontal")));
        this.simpleBlock((Block)ModBlocks.ORANGE_LEAVES.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_50050_.getRegistryName().m_135815_())));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)ModBlocks.ORANGE.get()).partialState().with((Property)BlockFruitTreeLeaf.HAS_FRUIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.ORANGE.getID().toString(), this.modLoc("fruit_leaves"))).texture("base", this.blockTexture(Blocks.f_50050_))).texture("particle", this.blockTexture(Blocks.f_50050_))).texture("overlay", this.blockTexture((Block)ModBlocks.ORANGE.get()))).addModel()).partialState().with((Property)BlockFruitTreeLeaf.HAS_FRUIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.ORANGE.getID().toString() + "_fruitless", "block/leaves")).texture("all", this.blockTexture(Blocks.f_50050_))).addModel();
        this.axisBlock((RotatedPillarBlock)ModBlocks.GRAPE_TREE.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_50000_.getRegistryName().m_135815_())), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_50000_.getRegistryName().m_135815_() + "_horizontal")));
        this.simpleBlock((Block)ModBlocks.GRAPE_SAPLING.get(), (ModelFile)this.models().cross(ModBlocks.GRAPE_SAPLING.getID().toString(), this.itemTexture((Item)ModItems.GRAPE_SAPLING.get())));
        this.axisBlock((RotatedPillarBlock)ModBlocks.GRAPE_WOOD.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_50000_.getRegistryName().m_135815_())), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_50000_.getRegistryName().m_135815_() + "_horizontal")));
        this.simpleBlock((Block)ModBlocks.GRAPE_LEAVES.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/" + Blocks.f_50051_.getRegistryName().m_135815_())));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)ModBlocks.GRAPE.get()).partialState().with((Property)BlockFruitTreeLeaf.HAS_FRUIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.GRAPE.getID().toString(), this.modLoc("fruit_leaves"))).texture("base", this.blockTexture(Blocks.f_50051_))).texture("particle", this.blockTexture(Blocks.f_50051_))).texture("overlay", this.blockTexture((Block)ModBlocks.GRAPE.get()))).addModel()).partialState().with((Property)BlockFruitTreeLeaf.HAS_FRUIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.GRAPE.getID().toString() + "_fruitless", "block/leaves")).texture("all", this.blockTexture(Blocks.f_50051_))).addModel();
    }

    public ResourceLocation blockTexture(Block block) {
        ResourceLocation name = block.getRegistryName();
        return new ResourceLocation(name.m_135827_(), "block/" + name.m_135815_());
    }

    public ResourceLocation mineralTexture(Block block) {
        ResourceLocation name = block.getRegistryName();
        return new ResourceLocation(name.m_135827_(), "block/" + name.m_135815_().replace("broken_", ""));
    }

    private void craftingModel(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation(block.getRegistryName().m_135827_(), "block/" + block.getRegistryName().m_135815_() + "_" + ((BlockCrafting.EnumPart)((Object)((Object)state.m_61143_(BlockCrafting.PART)))).m_7912_()))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build(), new Property[0]);
    }

    public ResourceLocation blockTexture(String nameSpace, String block) {
        return new ResourceLocation(nameSpace, "block/" + block);
    }

    public ResourceLocation itemTexture(Block block) {
        ResourceLocation name = block.getRegistryName();
        return new ResourceLocation(name.m_135827_(), "item/" + name.m_135815_());
    }

    public ResourceLocation itemTexture(Item item) {
        ResourceLocation name = item.getRegistryName();
        return new ResourceLocation(name.m_135827_(), "item/" + name.m_135815_());
    }

    public ResourceLocation itemCropTexture(Block block) {
        ResourceLocation name = block.getRegistryName();
        return new ResourceLocation(name.m_135827_(), "item/" + name.m_135815_().replace("plant", "crop"));
    }
}

