/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.github.flemmli97.runecraftory.client.ItemModelProps;
import io.github.flemmli97.runecraftory.common.items.consumables.ItemGiantCrops;
import io.github.flemmli97.runecraftory.common.items.consumables.ItemRecipeBread;
import io.github.flemmli97.runecraftory.common.items.creative.ItemProp;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolAxe;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolFishingRod;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolHammer;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolHoe;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolSickle;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolWateringCan;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemAxeBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemDualBladeBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemGloveBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemHammerBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemLongSwordBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpearBase;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.forge.item.StaffItem;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModels
extends ItemModelProvider {
    private final Map<RegistryEntrySupplier<Item>, ResourceLocation> dualItemMapping = this.getDualItemMapping();
    private final Set<RegistryEntrySupplier<Item>> existingSameGloveItems = this.generateSameGloveItemMapping();

    public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "runecraftory", existingFileHelper);
    }

    protected void registerModels() {
        ((ItemModelBuilder)this.withExistingParent("fist_s", this.modLoc("fist"))).transforms().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(-2.5f, 0.0f, 0.0f).scale(0.25f, 0.3f, 0.3f).translation(0.0f, -1.86f, 1.6f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(-2.5f, 0.0f, 0.0f).scale(0.25f, 0.3f, 0.3f).translation(0.0f, -1.86f, 1.6f).end();
        ((ItemModelBuilder)this.withExistingParent("fist_s_left", this.modLoc("fist_left"))).transforms().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(-2.5f, 0.0f, 0.0f).scale(0.25f, 0.3f, 0.3f).translation(0.0f, -1.86f, 1.6f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(-2.5f, 0.0f, 0.0f).scale(0.25f, 0.3f, 0.3f).translation(0.0f, -1.86f, 1.6f).end();
        List<RegistryEntrySupplier<Item>> ribbons = ModItems.ribbons();
        List<RegistryEntrySupplier<Item>> hats = ModItems.hatItems();
        for (RegistryEntrySupplier sup : ModItems.ITEMS.getEntries()) {
            if (sup == ModItems.MEDICINAL_HERB || sup == ModItems.ITEM_BLOCK_FORGE || sup == ModItems.ITEM_BLOCK_ACCESS || sup == ModItems.ITEM_BLOCK_CHEM || sup == ModItems.ITEM_BLOCK_COOKING || sup == ModItems.QUEST_BOARD || sup == ModItems.ORC_MAZE || sup == ModItems.STRAW_HAT || sup == ModItems.FANCY_HAT || hats.contains(sup)) continue;
            if (ribbons.contains(sup)) {
                ((ItemModelBuilder)this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/generated"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_()))).transforms().transform(ItemTransforms.TransformType.HEAD).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 5.0f, -6.75f).scale(0.35f);
                continue;
            }
            if (sup.get() instanceof ShieldItem) {
                if (sup == ModItems.UMBRELLA) {
                    ((ItemModelBuilder)this.withExistingParent(sup.getID().m_135815_() + "_blocking", this.modLoc(sup.getID().m_135815_()))).transforms().transform(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).rotation(-21.0f, 0.0f, 17.0f).translation(0.0f, 0.0f, 0.0f).end().transform(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND).rotation(-21.0f, 0.0f, 17.0f).translation(0.0f, 0.0f, 0.0f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(-44.0f, 0.0f, -20.0f).translation(3.0f, 4.5f, -3.0f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(-44.0f, 0.0f, -20.0f).translation(3.0f, 4.5f, -3.0f).end();
                    continue;
                }
                ((ItemModelBuilder)this.withExistingParent(sup.getID().m_135815_() + "_blocking", this.modLoc(sup.getID().m_135815_()))).transforms().transform(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).rotation(15.0f, 0.0f, 10.0f).translation(0.5f, -4.0f, 0.0f).end().transform(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND).rotation(15.0f, 0.0f, 10.0f).translation(0.5f, -4.0f, 0.0f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(50.0f, -45.0f, 0.0f).translation(4.5f, -1.5f, -3.0f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(50.0f, -45.0f, 0.0f).translation(4.5f, -1.5f, -3.0f).end();
                continue;
            }
            if (sup == ModItems.SPAWNER) {
                this.withExistingParent(sup.getID().m_135815_(), "block/spawner");
                continue;
            }
            if (sup == ModItems.DEBUG) {
                this.withExistingParent(sup.getID().m_135815_(), this.modLoc("item/" + ModItems.UNKNOWN.getID().m_135815_()));
                continue;
            }
            if (sup == ModItems.TAME) {
                this.withExistingParent(sup.getID().m_135815_(), this.mcLoc("item/template_spawn_egg"));
                continue;
            }
            if (sup.get() instanceof ItemDualBladeBase) {
                if (this.dualItemMapping.containsKey(sup)) {
                    ((ItemModelBuilder)this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/handheld"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_()))).override().predicate(ItemModelProps.HELD_ID, 1.0f).model((ModelFile)this.getExistingFile(this.dualItemMapping.get(sup)));
                    continue;
                }
                this.singleTexture(sup.getID().m_135815_() + "_single", this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + sup.getID().m_135815_() + "_single"));
                ((ItemModelBuilder)this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/handheld"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_()))).override().predicate(ItemModelProps.HELD_ID, 1.0f).model((ModelFile)this.getExistingFile(new ResourceLocation(sup.getID().m_135827_(), sup.getID().m_135815_() + "_single")));
                continue;
            }
            if (sup.get() instanceof ItemGloveBase) {
                this.createGloveModels((RegistryEntrySupplier<Item>)sup);
                continue;
            }
            if (sup.get() instanceof ItemToolHammer) {
                this.singleTexture(sup.getID().m_135815_(), new ResourceLocation("runecraftory", "item/hammer_tool"), "layer0", this.modLoc("item/" + sup.getID().m_135815_()));
                continue;
            }
            if (sup.get() instanceof ItemToolSickle) {
                this.singleTexture(sup.getID().m_135815_(), new ResourceLocation("runecraftory", "item/sickle"), "layer0", this.modLoc("item/" + sup.getID().m_135815_()));
                continue;
            }
            if (sup.get() instanceof ItemToolWateringCan) {
                this.singleTexture(sup.getID().m_135815_(), new ResourceLocation("runecraftory", "item/watering_can"), "layer0", this.modLoc("item/" + sup.getID().m_135815_()));
                continue;
            }
            if (sup.get() instanceof ItemToolHoe) {
                this.singleTexture(sup.getID().m_135815_(), new ResourceLocation("runecraftory", "item/hoe"), "layer0", this.modLoc("item/" + sup.getID().m_135815_()));
                continue;
            }
            if (sup.get() instanceof ItemToolAxe) {
                this.singleTexture(sup.getID().m_135815_(), new ResourceLocation("runecraftory", "item/axe_tool"), "layer0", this.modLoc("item/" + sup.getID().m_135815_()));
                continue;
            }
            if (sup.get() instanceof ItemToolFishingRod) {
                ((ItemModelBuilder)this.singleTexture(sup.getID().m_135815_(), new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/" + sup.getID().m_135815_()))).override().predicate(this.modLoc("fishing"), 1.0f).model((ModelFile)this.singleTexture(sup.getID().m_135815_() + "_cast", new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/" + sup.getID().m_135815_() + "_cast")));
                continue;
            }
            if (sup.get() instanceof ItemRecipeBread) {
                this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/generated"), "layer0", this.mcLoc("item/bread"));
                continue;
            }
            if (sup.get() instanceof SpawnEgg) {
                this.withExistingParent(sup.getID().m_135815_(), ModelLocationUtils.m_125583_((String)"template_spawn_egg"));
                continue;
            }
            if (sup.get() instanceof ItemLongSwordBase) {
                this.createBigWeaponModel((RegistryEntrySupplier<Item>)sup, this.modLoc("item/handheld_long_sword"));
                continue;
            }
            if (sup.get() instanceof ItemAxeBase || sup.get() instanceof ItemHammerBase) {
                this.createBigWeaponModel((RegistryEntrySupplier<Item>)sup, this.modLoc("item/handheld_big"));
                continue;
            }
            if (sup.get() instanceof ItemSpearBase) {
                this.createBigWeaponModel((RegistryEntrySupplier<Item>)sup, this.modLoc("item/handheld_big"));
                continue;
            }
            if (sup.get() instanceof TieredItem || sup.get() instanceof StaffItem) {
                this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/handheld"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_()));
                continue;
            }
            Object object = sup.get();
            if (object instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)object;
                if (sup.getID().m_135815_().startsWith("ore_") || sup == ModItems.SHIPPING_BIN || sup == ModItems.CASH_REGISTER || sup == ModItems.MONSTER_BARN) {
                    this.withExistingParent(sup.getID().m_135815_(), new ResourceLocation(blockItem.getRegistryName().m_135827_(), "block/" + blockItem.m_40614_().getRegistryName().m_135815_()));
                    continue;
                }
            }
            if (sup.get() instanceof ItemProp) {
                this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/generated"), "layer0", new ResourceLocation("runecraftory", "item/" + ModItems.UNKNOWN.getID().m_135815_()));
                continue;
            }
            if (sup.get() instanceof ItemGiantCrops) {
                this.singleTexture(sup.getID().m_135815_(), this.modLoc("item/double_sized_item"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_()));
                continue;
            }
            if (sup == ModItems.NPC_BABY) {
                ((ItemModelBuilder)this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/generated"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_() + "_boy"))).override().predicate(ItemModelProps.BABY_GENDER, 1.0f).model((ModelFile)this.singleTexture(sup.getID().m_135815_() + "_girl", this.mcLoc("item/generated"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_() + "_girl"))).end();
                continue;
            }
            this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/generated"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_()));
        }
    }

    private void createBigWeaponModel(RegistryEntrySupplier<Item> sup, ResourceLocation heldModel) {
        ((ItemModelBuilder)this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/handheld"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_()))).override().predicate(ItemModelProps.HELD_ID, 1.0f).model((ModelFile)this.singleTexture(sup.getID().m_135815_() + "_held", heldModel, "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_() + "_held"))).end();
    }

    private Map<RegistryEntrySupplier<Item>, ResourceLocation> getDualItemMapping() {
        ImmutableMap.Builder map = new ImmutableMap.Builder();
        map.put(ModItems.SHORT_DAGGER, (Object)ModItems.BROAD_SWORD.getID());
        map.put(ModItems.STEEL_EDGE, (Object)ModItems.STEEL_SWORD.getID());
        map.put(ModItems.IRON_EDGE, (Object)ModItems.STEEL_SWORD_PLUS.getID());
        map.put(ModItems.FROST_EDGE, (Object)ModItems.AQUA_SWORD.getID());
        return map.build();
    }

    private Set<RegistryEntrySupplier<Item>> generateSameGloveItemMapping() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.add(ModItems.BRASS_KNUCKLES);
        builder.add(ModItems.BEAR_CLAWS);
        builder.add(ModItems.DRAGON_CLAWS);
        return builder.build();
    }

    private void createGloveModels(RegistryEntrySupplier<Item> sup) {
        if (this.existingSameGloveItems.contains(sup)) {
            ResourceLocation modelFile = this.modLoc("item/" + sup.getID().m_135815_() + "_held");
            ((ItemModelBuilder)this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/handheld"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_()))).override().predicate(ItemModelProps.GLOVE_HELD_ID, 0.25f).model((ModelFile)this.getExistingFile(modelFile)).end().override().predicate(ItemModelProps.GLOVE_HELD_ID, 0.5f).model((ModelFile)this.withExistingParent(sup.getID().m_135815_() + "_held_left", modelFile)).end().override().predicate(ItemModelProps.GLOVE_HELD_ID, 0.75f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(sup.getID().m_135815_() + "_held_s", modelFile)).transforms().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(-2.5f, 0.0f, 0.0f).scale(0.25f, 0.3f, 0.3f).translation(0.0f, -1.86f, 1.6f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(-2.5f, 0.0f, 0.0f).scale(0.25f, 0.3f, 0.3f).translation(0.0f, -1.86f, 1.6f).end().end()).end().override().predicate(ItemModelProps.GLOVE_HELD_ID, 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(sup.getID().m_135815_() + "_held_s_left", modelFile)).transforms().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(-2.5f, 0.0f, 0.0f).scale(0.25f, 0.3f, 0.3f).translation(0.0f, -1.86f, 1.6f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(-2.5f, 0.0f, 0.0f).scale(0.25f, 0.3f, 0.3f).translation(0.0f, -1.86f, 1.6f).end().end()).end();
        } else {
            ((ItemModelBuilder)this.singleTexture(sup.getID().m_135815_(), this.mcLoc("item/handheld"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_()))).override().predicate(ItemModelProps.GLOVE_HELD_ID, 0.25f).model((ModelFile)this.singleTexture(sup.getID().m_135815_() + "_held", this.modLoc("item/fist"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_() + "_held"))).end().override().predicate(ItemModelProps.GLOVE_HELD_ID, 0.5f).model((ModelFile)this.singleTexture(sup.getID().m_135815_() + "_held_left", this.modLoc("item/fist_left"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_() + "_held"))).end().override().predicate(ItemModelProps.GLOVE_HELD_ID, 0.75f).model((ModelFile)this.singleTexture(sup.getID().m_135815_() + "_held_s", this.modLoc("item/fist_s"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_() + "_held"))).end().override().predicate(ItemModelProps.GLOVE_HELD_ID, 1.0f).model((ModelFile)this.singleTexture(sup.getID().m_135815_() + "_held_s_left", this.modLoc("item/fist_s_left"), "layer0", new ResourceLocation("runecraftory", "item/" + sup.getID().m_135815_() + "_held"))).end();
        }
    }
}

