/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.data;

import com.google.common.collect.Lists;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.provider.AdditionalLanguages;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.api.enums.EnumDay;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolAxe;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolFishingRod;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolHammer;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolHoe;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolSickle;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolWateringCan;
import io.github.flemmli97.runecraftory.common.network.C2SNPCInteraction;
import io.github.flemmli97.runecraftory.common.network.C2SSetMonsterBehaviour;
import io.github.flemmli97.runecraftory.common.quests.QuestData;
import io.github.flemmli97.runecraftory.common.quests.tasks.LevelTask;
import io.github.flemmli97.runecraftory.common.quests.tasks.NPCTalkTask;
import io.github.flemmli97.runecraftory.common.quests.tasks.ShippingTask;
import io.github.flemmli97.runecraftory.common.quests.tasks.SkillLevelTask;
import io.github.flemmli97.runecraftory.common.quests.tasks.TamingTask;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;

public class LangGen
implements DataProvider {
    private static final Comparator<String> ORDER = Comparator.comparingInt(o -> LangType.get(o).ordinal());
    private final Map<String, String> data = new LinkedHashMap<String, String>();
    private final DataGenerator gen;
    private final String modid;
    private final String locale;
    private final AdditionalLanguages[] additionalLanguages;

    public LangGen(DataGenerator gen, AdditionalLanguages ... additionalLanguages) {
        this.gen = gen;
        this.modid = "runecraftory";
        this.locale = "en_us";
        this.additionalLanguages = additionalLanguages;
    }

    protected void addTranslations() {
        this.add((Item)ModItems.HOE_SCRAP.get(), "Cheap Hoe");
        this.add((Item)ModItems.HOE_IRON.get(), "Sturdy Hoe");
        this.add((Item)ModItems.HOE_SILVER.get(), "Seasoned Hoe");
        this.add((Item)ModItems.HOE_GOLD.get(), "Shiny Hoe");
        this.add((Item)ModItems.HOE_PLATINUM.get(), "Blessed Hoe");
        this.add((Item)ModItems.WATERING_CAN_SCRAP.get(), "Cheap Waterpot");
        this.add((Item)ModItems.WATERING_CAN_IRON.get(), "Tin Waterpot");
        this.add((Item)ModItems.WATERING_CAN_SILVER.get(), "Lion Waterpot");
        this.add((Item)ModItems.WATERING_CAN_GOLD.get(), "Rainbow Waterpot");
        this.add((Item)ModItems.WATERING_CAN_PLATINUM.get(), "Joy Waterpot");
        this.add((Item)ModItems.SICKLE_SCRAP.get(), "Cheap Sickle");
        this.add((Item)ModItems.SICKLE_IRON.get(), "Iron Sickle");
        this.add((Item)ModItems.SICKLE_SILVER.get(), "Quality Sickle");
        this.add((Item)ModItems.SICKLE_GOLD.get(), "Super Sickle");
        this.add((Item)ModItems.SICKLE_PLATINUM.get(), "Legendary Sickle");
        this.add((Item)ModItems.HAMMER_SCRAP.get(), "Cheap Hammer");
        this.add((Item)ModItems.HAMMER_IRON.get(), "Iron Hammer");
        this.add((Item)ModItems.HAMMER_SILVER.get(), "Silver Hammer");
        this.add((Item)ModItems.HAMMER_GOLD.get(), "Golden Hammer");
        this.add((Item)ModItems.HAMMER_PLATINUM.get(), "Platinum Hammer");
        this.add((Item)ModItems.AXE_SCRAP.get(), "Cheap Axe");
        this.add((Item)ModItems.AXE_IRON.get(), "Chopping Axe");
        this.add((Item)ModItems.AXE_SILVER.get(), "Lumber Axe");
        this.add((Item)ModItems.AXE_GOLD.get(), "Mountain Axe");
        this.add((Item)ModItems.AXE_PLATINUM.get(), "Miracle Axe");
        this.add((Item)ModItems.FISHING_ROD_SCRAP.get(), "Cheap Pole");
        this.add((Item)ModItems.FISHING_ROD_IRON.get(), "Beginner's Pole");
        this.add((Item)ModItems.FISHING_ROD_SILVER.get(), "Skilled Pole");
        this.add((Item)ModItems.FISHING_ROD_GOLD.get(), "Famous Pole");
        this.add((Item)ModItems.FISHING_ROD_PLATINUM.get(), "Sacred Pole");
        for (RegistryEntrySupplier sup : ModItems.ITEMS.getEntries()) {
            if (sup.get() instanceof ItemToolAxe || sup.get() instanceof ItemToolHoe || sup.get() instanceof ItemToolWateringCan || sup.get() instanceof ItemToolSickle || sup.get() instanceof ItemToolHammer || sup.get() instanceof ItemToolFishingRod) continue;
            if (sup == ModItems.STEEL_TEN) {
                this.add((Item)sup.get(), "10-Fold Steel");
                continue;
            }
            if (sup == ModItems.MTGU_PLATE) {
                this.add((Item)sup.get(), "MGTU Plate");
                continue;
            }
            if (sup == ModItems.FUR_SMALL) {
                this.add((Item)sup.get(), "Fur (S)");
                continue;
            }
            if (sup == ModItems.FUR_MEDIUM) {
                this.add((Item)sup.get(), "Fur (M)");
                continue;
            }
            if (sup == ModItems.FUR_LARGE) {
                this.add((Item)sup.get(), "Fur (L)");
                continue;
            }
            if (sup == ModItems.EGG_S) {
                this.add((Item)sup.get(), "Egg (S)");
                continue;
            }
            if (sup == ModItems.EGG_M) {
                this.add((Item)sup.get(), "Egg (M)");
                continue;
            }
            if (sup == ModItems.EGG_L) {
                this.add((Item)sup.get(), "Egg (L)");
                continue;
            }
            if (sup == ModItems.MILK_S) {
                this.add((Item)sup.get(), "Milk (S)");
                continue;
            }
            if (sup == ModItems.MILK_M) {
                this.add((Item)sup.get(), "Milk (M)");
                continue;
            }
            if (sup == ModItems.MILK_L) {
                this.add((Item)sup.get(), "Milk (L)");
                continue;
            }
            if (sup == ModItems.GRAPE_SAPLING) {
                this.add((Item)sup.get(), "Grape Sapling?");
                continue;
            }
            if (sup.get() instanceof SpawnEgg) {
                this.add((Item)sup.get(), "%s Spawn Egg");
                continue;
            }
            Object object = sup.get();
            if (object instanceof RecordItem) {
                RecordItem record = (RecordItem)object;
                this.add((Item)sup.get(), "Music Disc");
                this.add(record.m_5524_() + ".desc", this.simpleTranslation(sup.getID().m_135815_().replace("music_disc_", "").replace("-", "_")));
                continue;
            }
            this.add((Item)sup.get(), this.simpleTranslation(sup.getID()));
        }
        this.add("runecraftory.item.creative.tooltip", "Debug item used for testing things");
        this.add("runecraftory.item.creative.tooltip.mode", "Mode: %s");
        this.add("runecraftory.item.creative.tooltip.mode.default", "Default");
        this.add("runecraftory.item.creative.tooltip.mode.animation", "Entity Animations");
        for (RegistryEntrySupplier sup : ModBlocks.BLOCKS.getEntries()) {
            this.add((Block)sup.get(), this.simpleTranslation(sup.getID()));
        }
        this.add("runecraftory.container.crafting." + EnumCrafting.FORGE.getId(), "Forging");
        this.add("runecraftory.container.crafting." + EnumCrafting.ARMOR.getId(), "Crafting");
        this.add("runecraftory.container.crafting." + EnumCrafting.CHEM.getId(), "Chemistry");
        this.add("runecraftory.container.crafting." + EnumCrafting.COOKING.getId(), "Cooking");
        this.add("runecraftory.container.shipping_bin", "Shipping Bin");
        this.add("runecraftory.container.info", "Info Screen");
        this.add("runecraftory.container.info.sub", "Info Screen");
        for (RegistryEntrySupplier sup : ModEntities.ENTITIES.getEntries()) {
            if (sup.get() == ModEntities.SARCOPHAGUS_TELEPORTER.get()) {
                this.add((EntityType)sup.get(), "Teleporter");
                continue;
            }
            this.add((EntityType)sup.get(), this.simpleTranslation(sup.getID()));
        }
        this.add(((Attribute)ModAttributes.HEALTHGAIN.get()).m_22087_(), "HP");
        this.add(((Attribute)ModAttributes.RPGAIN.get()).m_22087_(), "RP");
        this.add(((Attribute)ModAttributes.RPINCREASE.get()).m_22087_(), "RP Max");
        this.add(((Attribute)ModAttributes.DEFENCE.get()).m_22087_(), "DEF");
        this.add(((Attribute)ModAttributes.MAGIC.get()).m_22087_(), "M. ATT");
        this.add(((Attribute)ModAttributes.MAGIC_DEFENCE.get()).m_22087_(), "M. DEF");
        this.add(((Attribute)ModAttributes.PARA.get()).m_22087_(), "Para");
        this.add(((Attribute)ModAttributes.POISON.get()).m_22087_(), "Poison");
        this.add(((Attribute)ModAttributes.SEAL.get()).m_22087_(), "Sealing");
        this.add(((Attribute)ModAttributes.SLEEP.get()).m_22087_(), "Sleep");
        this.add(((Attribute)ModAttributes.FATIGUE.get()).m_22087_(), "Fatigue");
        this.add(((Attribute)ModAttributes.COLD.get()).m_22087_(), "Cold");
        this.add(((Attribute)ModAttributes.DIZZY.get()).m_22087_(), "Dizz");
        this.add(((Attribute)ModAttributes.CRIT.get()).m_22087_(), "Crit");
        this.add(((Attribute)ModAttributes.STUN.get()).m_22087_(), "Stun");
        this.add(((Attribute)ModAttributes.FAINT.get()).m_22087_(), "Faint");
        this.add(((Attribute)ModAttributes.DRAIN.get()).m_22087_(), "Drain");
        this.add(((Attribute)ModAttributes.RES_WATER.get()).m_22087_(), "Water Res");
        this.add(((Attribute)ModAttributes.RES_EARTH.get()).m_22087_(), "Earth Res");
        this.add(((Attribute)ModAttributes.RES_WIND.get()).m_22087_(), "Wind Res");
        this.add(((Attribute)ModAttributes.RES_FIRE.get()).m_22087_(), "Fire Res");
        this.add(((Attribute)ModAttributes.RES_DARK.get()).m_22087_(), "Dark Res");
        this.add(((Attribute)ModAttributes.RES_LIGHT.get()).m_22087_(), "Light Res");
        this.add(((Attribute)ModAttributes.RES_LOVE.get()).m_22087_(), "Love Res");
        this.add(((Attribute)ModAttributes.RES_PARA.get()).m_22087_(), "Paralysis Res");
        this.add(((Attribute)ModAttributes.RES_POISON.get()).m_22087_(), "Poison Res");
        this.add(((Attribute)ModAttributes.RES_SEAL.get()).m_22087_(), "Seal Res");
        this.add(((Attribute)ModAttributes.RES_SLEEP.get()).m_22087_(), "Sleep Res");
        this.add(((Attribute)ModAttributes.RES_FAT.get()).m_22087_(), "Fatigue Res");
        this.add(((Attribute)ModAttributes.RES_COLD.get()).m_22087_(), "Cold Res");
        this.add(((Attribute)ModAttributes.RES_DIZZY.get()).m_22087_(), "Diz Res");
        this.add(((Attribute)ModAttributes.RES_CRIT.get()).m_22087_(), "Crit Res");
        this.add(((Attribute)ModAttributes.RES_STUN.get()).m_22087_(), "Stun Res");
        this.add(((Attribute)ModAttributes.RES_FAINT.get()).m_22087_(), "Faint Res");
        this.add(((Attribute)ModAttributes.RES_DRAIN.get()).m_22087_(), "Drain Res");
        this.add(((Attribute)ModAttributes.ATTACK_SPEED.get()).m_22087_(), "Attack Speed");
        this.add(((Attribute)ModAttributes.ATTACK_RANGE.get()).m_22087_(), "Attack Range");
        this.add(((Attribute)ModAttributes.ATTACK_WIDTH.get()).m_22087_(), "Attack Width");
        this.add(((Attribute)ModAttributes.CHARGE_TIME.get()).m_22087_(), "Charge Time");
        for (RegistryEntrySupplier reg : ModEffects.EFFECTS.getEntries()) {
            this.add((MobEffect)reg.get(), this.simpleTranslation(reg.getID()));
        }
        for (EnumDay enumDay : EnumDay.values()) {
            this.add(enumDay.translation(), enumDay.toString().substring(0, 3));
            String d = enumDay.toString().toLowerCase(Locale.ROOT);
            this.add(enumDay.translationFull(), d.substring(0, 1).toUpperCase(Locale.ROOT) + d.substring(1));
        }
        for (Enum enum_ : EnumElement.values()) {
            this.add(((EnumElement)enum_).getTranslation(), "Attribute: " + this.simpleTranslation(((EnumElement)enum_).getTranslation().replace("runecraftory.element.", "")));
        }
        for (Enum enum_ : EnumSeason.values()) {
            this.add(((EnumSeason)enum_).translationKey(), this.simpleTranslation(((EnumSeason)enum_).translationKey().replace("runecraftory.season.", "")));
        }
        for (Enum enum_ : EnumWeather.values()) {
            this.add(((EnumWeather)enum_).translation, this.simpleTranslation(((EnumWeather)enum_).translation.replace("runecraftory.weather.", "")));
        }
        for (Enum enum_ : EnumSkills.values()) {
            this.add(((EnumSkills)enum_).getTranslation(), this.capitalize(((EnumSkills)enum_).getTranslation().replace("runecraftory.skill.", "").replace("_", " "), Lists.newArrayList((Object[])new String[]{"and"})));
        }
        this.add("runecraftory.tooltip.item.level", "Level: %s");
        this.add("runecraftory.tooltip.item.buy", "Buy: %s$");
        this.add("runecraftory.tooltip.item.sell", "Sell: %s$");
        this.add("runecraftory.tooltip.item.difficulty", "Upgrade Difficulty: %s");
        this.add("runecraftory.tooltip.item.equipped", "When equipped");
        this.add("runecraftory.tooltip.item.upgrade", "Upgrade");
        this.add("runecraftory.tooltip.item.eaten", "When eaten");
        this.add("runecraftory.tooltip.item.spawn", "Right click in air to change mob level");
        this.add("runecraftory.tooltip.item.prop", "A prop item. Takes on the items look when in another entities hand");
        this.add("runecraftory.tooltip.item.treasure_chest", "Shift-right-click to cycle through loot tier");
        this.add("runecraftory.tooltip.item.treasure_level", "Chest tier lvl: %s");
        this.add("runecraftory.tooltip.debug.stat", "Itemstat-ID: %s");
        this.add("runecraftory.tooltip.debug.crop", "Cropdata-ID: %s");
        this.add("runecraftory.tooltip.debug.food", "Fooddata-ID: %s");
        this.add("runecraftory.tooltip.item.npc", "Shift-right-click to change profession");
        this.add("runecraftory.tooltip.sapling", "Needs to be placed on farmland");
        this.add("runecraftory.tooltip.growth", "Growth: %sd");
        this.add("runecraftory.tooltip.harvested", "Harvest Amount: %s");
        this.add("runecraftory.tooltip.season.best", "Good Season");
        this.add("runecraftory.tooltip.season.bad", "Bad Season");
        this.add("runecraftory.tooltip.baby.boy", "Boy");
        this.add("runecraftory.tooltip.baby.girl", "Girl");
        this.add("runecraftory.tooltip.baby.owner", "Parent: %s");
        this.add("death.attack." + CustomDamage.EXHAUST.f_19326_, "%1$s fainted");
        this.add("death.attack.runecraftory.attack", "%1$s was knocked down by %2$s");
        this.add("death.attack." + CustomDamage.POISON.f_19326_, "%1$s was to weak and died of poison");
        this.add(BaseMonster.Behaviour.WANDER_HOME.interactKey, "You send %s home");
        this.add(BaseMonster.Behaviour.FOLLOW.interactKey, "%s is now following you");
        this.add(BaseMonster.Behaviour.FOLLOW_DISTANCE.interactKey, "%s is now following you with distance");
        this.add(BaseMonster.Behaviour.STAY.interactKey, "%s is now staying");
        this.add(BaseMonster.Behaviour.WANDER.interactKey, "%s is now wandering around in this area");
        this.add(BaseMonster.Behaviour.FARM.interactKey, "%s is now tending the crops");
        this.add("runecraftory.monster.interact.notowner", "This is not your monster!");
        this.add("runecraftory.monster.interact.party.full", "Your party is full");
        this.add("runecraftory.monster.interact.ride.no", "You can't ride this monster");
        this.add("runecraftory.monster.interact.barn.no", "%s has no barn");
        this.add("runecraftory.monster.interact.barn.no.ext", "%1$s [%2$s] has no home to go to.");
        this.add("runecraftory.barn.interact.not.owner", "This barn belongs to %s.");
        this.add("runecraftory.barn.interact.block", "Barn with capacity %1$s (Free: %2$s).");
        this.add("runecraftory.barn.interact.block.roofed", "Roofed barn with capacity %1$s (Free: %2$s).");
        this.add("itemGroup.runecraftory.weapons_tools", "Weapons and Tools");
        this.add("itemGroup.runecraftory.equipment", "Armor");
        this.add("itemGroup.runecraftory.upgrade", "Materials");
        this.add("itemGroup.runecraftory.blocks", "Rune Craftory Blocks");
        this.add("itemGroup.runecraftory.medicine", "Medicine");
        this.add("itemGroup.runecraftory.cast", "Spells and Rune-Skills");
        this.add("itemGroup.runecraftory.food", "Food");
        this.add("itemGroup.runecraftory.crops", "Farming");
        this.add("itemGroup.runecraftory.monsters", "Monsters");
        this.add("runecraftory.keycategory", "Runecraftory");
        this.add("runecraftory.key.spell_1", "Interaction Key 1");
        this.add("runecraftory.key.spell_2", "Interaction Key 2");
        this.add("runecraftory.key.spell_3", "Interaction Key 3");
        this.add("runecraftory.key.spell_4", "Interaction Key 4");
        this.add("runecraftory.command.skill.no", "No such skill %s!");
        this.add("runecraftory.command.skill.lvl.add", "Added %3$s %1$s skill level to %2$s");
        this.add("runecraftory.command.skill.xp.add", "Added %3$s %1$s skill xp points to %2$s");
        this.add("runecraftory.command.skill.lvl.set", "Set level of skill %1$s to %3$s for %2$s");
        this.add("runecraftory.command.lvl.xp.add", "Added %1$s xp points to %2$s");
        this.add("runecraftory.command.lvl.set", "Set level of %1$s to %2$s");
        this.add("runecraftory.command.reset.all", "Reset all player data for %s");
        this.add("runecraftory.command.unlock.recipes", "Unlocked all crafting recipes for %s");
        this.add("runecraftory.command.unlock.recipe", "Unlockeded crafting %2$s recipes for %1$s");
        this.add("runecraftory.command.reset.recipe", "Locked all crafting recipes for %s again");
        this.add("runecraftory.command.weather.no", "No such weather %s");
        this.add("runecraftory.command.set.weather", "Set current weather to %s");
        this.add("runecraftory.command.recalc.stats", "Recalculated level stats for %s entities");
        this.add("runecraftory.recipe_integration.locked", "Unknown Recipe");
        this.add("runecraftory.recipe_integration.crafting_level", "Lvl: %s");
        this.add(C2SSetMonsterBehaviour.Type.HOME.translation, "Send home");
        this.add(C2SSetMonsterBehaviour.Type.FOLLOW.translation, "Follow");
        this.add(C2SSetMonsterBehaviour.Type.FOLLOW_DISTANCE.translation, "Stay back");
        this.add(C2SSetMonsterBehaviour.Type.STAY.translation, "Stay");
        this.add(C2SSetMonsterBehaviour.Type.WANDER.translation, "Wander");
        this.add(C2SSetMonsterBehaviour.Type.FARM.translation, "Tend the crops");
        this.add(C2SSetMonsterBehaviour.Type.HARVESTINV.translation, "Crop Inventory");
        this.add(C2SSetMonsterBehaviour.Type.SEEDINV.translation, "Seed Inventory");
        this.add(C2SSetMonsterBehaviour.Type.RIDE.translation, "Ride");
        this.add(C2SSetMonsterBehaviour.Type.CENTER.translation, "Set center");
        this.add("runecraftory.behaviour.home.position", "Updated restriction center");
        this.add("runecraftory.behaviour.inventory.harvest", "Updated crop inventory position");
        this.add("runecraftory.behaviour.inventory.harvest.invalid", "Position is too far away");
        this.add("runecraftory.behaviour.inventory.seed", "Updated seed inventory position");
        this.add("runecraftory.behaviour.inventory.seed.invalid", "Position is too far away");
        this.add("runecraftory.tamed.monster.knockout.by", "%1$s got knocked out by %5$s at [%2$s, %3$s, %4$s]");
        this.add("runecraftory.tamed.monster.knockout", "%1$s got knocked out at [%2$s, %3$s, %4$s]");
        this.add("runecraftory.magnifying_glass.view.crop.growth", "Growth: %s");
        this.add("runecraftory.magnifying_glass.view.crop.level", "Level: %s");
        this.add("runecraftory.magnifying_glass.view.crop.giant", "Giant prog.: %s");
        this.add("runecraftory.magnifying_glass.view.speed", "Speed: %s");
        this.add("runecraftory.magnifying_glass.view.health", "Health: %s");
        this.add("runecraftory.magnifying_glass.view.level", "Quality: %s");
        this.add("runecraftory.magnifying_glass.view.giant", "Size: %s");
        this.add("runecraftory.magnifying_glass.view.defence", "Defence: %s");
        this.add(C2SNPCInteraction.Type.TALK.translation, "Talk");
        this.add(C2SNPCInteraction.Type.FOLLOW.translation, "Follow me");
        this.add(C2SNPCInteraction.Type.FOLLOWDISTANCE.translation, "Stay back a bit");
        this.add(C2SNPCInteraction.Type.STAY.translation, "Stay here");
        this.add(C2SNPCInteraction.Type.STOPFOLLOW.translation, "Stop following");
        this.add(C2SNPCInteraction.Type.SHOP.translation, "I want to shop");
        this.add("runecraftory.gui.level", "Level");
        this.add("runecraftory.gui.npc.id", "Npc data-id");
        this.add("runecraftory.gui.npc.profession", "Npc Profession");
        this.add("runecraftory.gui.save", "Save");
        this.add("runecraftory.gui.crafting.rpMax.missing", "Missing total rp");
        this.add("runecraftory.gui.display.level", "Level: %s");
        this.add("runecraftory.gui.npc.shop.owner", "Owner of %s");
        this.add("runecraftory.gui.npc.bed.no", "I don't have a bed");
        this.add("runecraftory.gui.npc.workplace.no", "I don't have a work place. Valid workplaces are [%s]");
        this.add("runecraftory.gui.npc.parent", "Parent:");
        this.add("runecraftory.gui.npc.parents", "Parents:");
        this.add("runecraftory.gui.npc.relationship.dating", "Dating %s");
        this.add("runecraftory.gui.npc.relationship.married", "Married to %s");
        this.add("runecraftory.gui.npc.procreate", "Procreate");
        this.add("runecraftory.gui.quests.accept", "Accept");
        this.add("runecraftory.gui.quests.reset", "Cancel");
        this.add("runecraftory.gui.quest.submit.button", "Submit");
        this.add("runecraftory.gui.quest.button", "Requests");
        this.add("runecraftory.advancements.root.title", "Runecraftory");
        this.add("runecraftory.advancements.root.description", "A minecrafty harvest moon");
        this.add("runecraftory.advancements.tame.first.title", "First buddy");
        this.add("runecraftory.advancements.tame.first.description", "Tame your first monster");
        this.add("runecraftory.advancements.tame.ten.title", "Monster tamer");
        this.add("runecraftory.advancements.tame.ten.description", "Tame 10 monster");
        this.add("runecraftory.advancements.tame.boss.title", "Boss tamer");
        this.add("runecraftory.advancements.tame.boss.description", "Tame a boss monster");
        this.add("runecraftory.advancements.tame.boss.five.title", "More Bosses");
        this.add("runecraftory.advancements.tame.boss.five.description", "Tame 5 boss monster");
        this.add("runecraftory.advancements.tame.boss.all.title", "Legendary Hunter!");
        this.add("runecraftory.advancements.tame.boss.all.description", "Tame all the boss monsters");
        this.add("runecraftory.advancements.shipping.title", "First earnings");
        this.add("runecraftory.advancements.shipping.description", "Ship your first item");
        this.add("runecraftory.advancements.shipping.fifty.title", "Shipping Milestone");
        this.add("runecraftory.advancements.shipping.fifty.description", "Ship 50 different items");
        this.add("runecraftory.advancements.shop.title", "Time for shopping");
        this.add("runecraftory.advancements.shop.description", "Buy your first item");
        this.add("runecraftory.advancements.100k.title", "10 OK!");
        this.add("runecraftory.advancements.100k.description", "Reach 100k gold");
        this.add("runecraftory.advancements.million.title", "One Million!");
        this.add("runecraftory.advancements.million.description", "Have one million gold");
        this.add("runecraftory.advancements.skill.weapon.5.title", "Gotta start somewhere");
        this.add("runecraftory.advancements.skill.weapon.5.description", "Get to level 5 in any weapon skill");
        this.add("runecraftory.advancements.skill.10.title", "Skill Level 10");
        this.add("runecraftory.advancements.skill.10.description", "Get to level 10 in any skill");
        this.add("runecraftory.advancements.skill.25.title", "Skill Level 25");
        this.add("runecraftory.advancements.skill.25.description", "Get to level 25 in any skill");
        this.add("runecraftory.advancements.skill.50.title", "Skill Level 50");
        this.add("runecraftory.advancements.skill.50.description", "Get to level 50 in any skill");
        this.add("runecraftory.advancements.skill.100.title", "Skill Level 100");
        this.add("runecraftory.advancements.skill.100.description", "Get to level 100 in any skill");
        this.add("runecraftory.advancements.level.10.title", "Small steps");
        this.add("runecraftory.advancements.level.10.description", "Get to level 10");
        this.add("runecraftory.advancements.level.25.title", "Level 25");
        this.add("runecraftory.advancements.level.25.description", "Get to level 25");
        this.add("runecraftory.advancements.level.50.title", "Level 50");
        this.add("runecraftory.advancements.level.50.description", "Get to level 50");
        this.add("runecraftory.advancements.level.100.title", "Level 100");
        this.add("runecraftory.advancements.level.100.description", "Get to level 100");
        this.add("runecraftory.advancements.crafting.forging.title", "Art of Forging");
        this.add("runecraftory.advancements.crafting.forging.description", "Craft a weapon using the forge");
        this.add("runecraftory.advancements.crafting.armor.title", "Art of Protection");
        this.add("runecraftory.advancements.crafting.armor.description", "Craft an armor piece using the accessory workbench");
        this.add("runecraftory.advancements.crafting.chemistry.title", "Art of Alchemy");
        this.add("runecraftory.advancements.crafting.chemistry.description", "Make some medicine using the chemistry set");
        this.add("runecraftory.advancements.crafting.cooking.title", "Culinary Art");
        this.add("runecraftory.advancements.crafting.cooking.description", "Make some food using the cooking table");
        this.add("runecraftory.advancements.upgrade.title", "Better equipment");
        this.add("runecraftory.advancements.upgrade.description", "Upgrade any equipment");
        this.add("runecraftory.advancements.change.element.title", "Its super effective!");
        this.add("runecraftory.advancements.change.element.description", "Change an element of a weapon");
        this.add("runecraftory.advancements.spell.title", "Magick");
        this.add("runecraftory.advancements.spell.description", "Find or craft a spell");
        this.add("runecraftory.advancements.change.spell.title", "Staff power");
        this.add("runecraftory.advancements.change.spell.description", "Change or add a spell to a staff");
        this.add("runecraftory.advancements.lightore.title", "Faker");
        this.add("runecraftory.advancements.lightore.description", "Transfer the stats of a weapon to another using a light ore");
        this.add("runecraftory.advancements.fertilizer.title", "Increased production");
        this.add("runecraftory.advancements.fertilizer.description", "Use a fertilizer to improve your farmland");
        this.add("runecraftory.advancements.giant_crop.title", "Big Boy");
        this.add("runecraftory.advancements.giant_crop.description", "Grow and harvest a giant crop");
        this.add("runecraftory.advancements.monster.help.title", "Useful helper");
        this.add("runecraftory.advancements.monster.help.description", "Command a monster to help you out with farming");
        this.add("runecraftory.advancements.final.tool.title", "The best");
        this.add("runecraftory.advancements.final.tool.description", "Obtain a final tier tool");
        this.add("runecraftory.advancements.progression.root.title", "Runecraftory - Milestones");
        this.add("runecraftory.advancements.progression.root.description", "Defeating them will increase overall mob levels!");
        this.add("runecraftory.advancements.progression.boss.greater_demon.title", "Monke!");
        this.add("runecraftory.advancements.progression.boss.greater_demon.description", "Defeat the greater demon. But I don't think he exists yet!");
        this.add("runecraftory.advancements.progression.boss.chimera.title", "What is this creature!");
        this.add("runecraftory.advancements.progression.boss.chimera.description", "Defeat a chimera in a water ruin");
        this.add("runecraftory.advancements.progression.boss.rafflesia.title", "Status gallore");
        this.add("runecraftory.advancements.progression.boss.rafflesia.description", "Defeat rafflesia in the nether");
        this.add("runecraftory.advancements.progression.boss.grimoire.title", "Don't get blown away");
        this.add("runecraftory.advancements.progression.boss.grimoire.description", "Defeat a grimoire at a mountain top");
        this.add("runecraftory.advancements.progression.boss.dead_tree.title", "Whispies cousin");
        this.add("runecraftory.advancements.progression.boss.dead_tree.description", "Defeat the dead tree in a forest grove");
        this.add("runecraftory.advancements.progression.boss.raccoon.title", "Caught thief");
        this.add("runecraftory.advancements.progression.boss.raccoon.description", "Defeat a raccon somewhere in the plains");
        this.add("runecraftory.advancements.progression.boss.skelefang.title", "Ancient bone");
        this.add("runecraftory.advancements.progression.boss.skelefang.description", "Defeat skelefang found in the desert");
        this.add("runecraftory.advancements.progression.boss.ambrosia.title", "Butterfly?");
        this.add("runecraftory.advancements.progression.boss.ambrosia.description", "Defeat ambrosia in a forest grove");
        this.add("runecraftory.advancements.progression.boss.thunderbolt.title", "Demonic Horse");
        this.add("runecraftory.advancements.progression.boss.thunderbolt.description", "Defeat thunderbolt in the water ruins");
        this.add("runecraftory.advancements.progression.boss.marionetta.title", "It's not a ghost right?");
        this.add("runecraftory.advancements.progression.boss.marionetta.description", "Defeat marionetta in the theater ruins");
        this.add("runecraftory.advancements.progression.boss.sano_uno.title", "Are you worthy?");
        this.add("runecraftory.advancements.progression.boss.sano_uno.description", "Defeat sano and uno. Now where are they...");
        this.add("runecraftory.advancements.progression.boss.sarcophagus.title", "Don't get cursed!");
        this.add("runecraftory.advancements.progression.boss.sarcophagus.description", "Defeat sarcophagus after proving your worth to sano and uno");
        this.add("runecraftory.generic.yes", "Yes");
        this.add("runecraftory.generic.no", "No");
        this.add("runecraftory.misc.recipe.eat.fail", "Didn't learn any recipe. Maybe your crafting level is too low");
        this.add("runecraftory.misc.sarcophagus.coming.soon", "This looks like a teleporter but it seems to not lead to anywhere yet...");
        this.add("runecraftory.misc.shipping.money", "Earning from shipped items: %s");
        this.add("runecraftory.misc.spawner.entry.deny", "A mystical force prevents you from entering!");
        this.add(((NPCJob)ModNPCJobs.NONE.getSecond()).getTranslationKey(), this.simpleTranslation((ResourceLocation)ModNPCJobs.NONE.getFirst()));
        this.add(((NPCJob)ModNPCJobs.GENERAL.getSecond()).getTranslationKey(), this.simpleTranslation((ResourceLocation)ModNPCJobs.GENERAL.getFirst()));
        this.add(((NPCJob)ModNPCJobs.FLOWER.getSecond()).getTranslationKey(), this.simpleTranslation((ResourceLocation)ModNPCJobs.FLOWER.getFirst()));
        this.add(((NPCJob)ModNPCJobs.SMITH.getSecond()).getTranslationKey(), this.simpleTranslation((ResourceLocation)ModNPCJobs.SMITH.getFirst()));
        this.add(((NPCJob)ModNPCJobs.DOCTOR.getSecond()).getTranslationKey(), this.simpleTranslation((ResourceLocation)ModNPCJobs.DOCTOR.getFirst()));
        this.add(((NPCJob)ModNPCJobs.COOK.getSecond()).getTranslationKey(), this.simpleTranslation((ResourceLocation)ModNPCJobs.COOK.getFirst()));
        this.add(((NPCJob)ModNPCJobs.MAGIC.getSecond()).getTranslationKey(), this.simpleTranslation((ResourceLocation)ModNPCJobs.MAGIC.getFirst()));
        this.add(((NPCJob)ModNPCJobs.RUNE_SKILLS.getSecond()).getTranslationKey(), this.simpleTranslation((ResourceLocation)ModNPCJobs.RUNE_SKILLS.getFirst()));
        this.add(((NPCJob)ModNPCJobs.BATHHOUSE.getSecond()).getTranslationKey(), this.simpleTranslation((ResourceLocation)ModNPCJobs.BATHHOUSE.getFirst()));
        this.add(((NPCJob)ModNPCJobs.RANDOM.getSecond()).getTranslationKey(), this.simpleTranslation((ResourceLocation)ModNPCJobs.RANDOM.getFirst()));
        this.add("runecraftory.npc.action.barn", "Monster barn");
        this.add("runecraftory.npc.action.barn.description", "You can buy a monster barn to house your tamed monsters. Each barn bought increases the costs of the next one");
        this.add("runecraftory.npc.action.barn.success", "Thank you %s for your purchase.");
        this.add("runecraftory.npc.action.barn.fail", "You don't have enough materials for that.");
        this.add("runecraftory.npc.shop.barn.cost", "A barn costs %1$s$ and following materials:");
        this.add("runecraftory.npc.shop.barn.cost.mat", "Logs x%1$s, Cobblestone x%2$s");
        this.add("runecraftory.npc.shop.barn.cost.fail", "Error getting the cost of a barn");
        this.add("runecraftory.npc.action.bread.forge", "Weapon bread");
        this.add("runecraftory.npc.action.bread.armor", "Accessory bread");
        this.add("runecraftory.npc.action.bread.chem", "Medicine bread");
        this.add("runecraftory.npc.action.bread.cooking", "Cooking bread");
        this.add("runecraftory.npc.action.bread.success", "Here you go");
        this.add("runecraftory.npc.action.bread.success.good", "Here you go. This one was made very well.");
        this.add("runecraftory.npc.action.bread.fail", "Seems you don't have enough money");
        this.add("runecraftory.npc.shop.bread.cost", "One loaf costs: %1$s. %2$s left");
        this.add("runecraftory.npc.action.bath", "Take a bath");
        this.add("runecraftory.npc.action.bath.success", "Have a relaxing bath.");
        this.add("runecraftory.npc.action.bath.fail", "You don't have enough money for that. You need %2$s.");
        this.add("runecraftory.npc.shop.bath.cost", "Cost: %s$");
        this.add("runecraftory.npc.action.doctor.cure", "Cure");
        this.add("runecraftory.npc.action.doctor.cure.desc", "Cure all negative status effects");
        this.add("runecraftory.npc.action.doctor.cure.success", "There you go. Please take more care in the future.");
        this.add("runecraftory.npc.action.doctor.cure.fail", "It seems you don't have enough money.");
        this.add("runecraftory.npc.shop.doctor.cure.cost", "Cost: %s$");
        this.add("runecraftory.npc.schedule.work", "From: %1$s - %2$s");
        this.add("runecraftory.npc.schedule.work.2", "And: %1$s - %2$s");
        this.add("runecraftory.npc.schedule.days.header", "Open on:");
        this.add("runecraftory.npc.schedule.days.all", "Everyday");
        this.add("runecraftory.npc.schedule.days.0", "All weekdays");
        this.add("runecraftory.npc.schedule.days.1", "All weekdays except %s");
        this.add("runecraftory.npc.schedule.days.2", "All weekdays except %1$s and %2$s");
        this.add("runecraftory.npc.schedule.days.weekend.1", "%s");
        this.add("runecraftory.npc.schedule.days.weekend.2", "%1$s and %2$s");
        this.add("runecraftory.npc.schedule.days.with", "%1$s");
        this.add("runecraftory.npc.shop.inventory.full", "You don't have enough inventory space for it");
        this.add("runecraftory.npc.shop.money.no", "You don't have enough money");
        this.add("runecraftory.npc.shop.success", "Thank you for your purchase");
        this.add("runecraftory.npc.conversation.missing", "-Missing Conversation with id %s-");
        this.add("runecraftory.npc.conversation.context.missing", "-Missing Conversation for context %s-");
        this.add("runecraftory.npc.conversation.response.missing", "-Missing quest response for quest %s-");
        this.add("runecraftory.npc.default.gift.neutral", "Thank you for your gift.");
        this.add("runecraftory.npc.spawn.name.missing", "Missing name for baby!");
        this.add("runecraftory.quest.npc.header", "Requester: %1$s [%2$s,%3$s,%4$s]");
        this.add(LevelTask.ID.toString(), "Reach level %s");
        this.add(NPCTalkTask.ID.toString(), "Talk to %s");
        this.add(String.valueOf(NPCTalkTask.ID) + ".generic", "Could not find NPC to talk to");
        this.add(String.valueOf(NPCTalkTask.ID) + ".not_resolved", "Unresolved NPC talk task");
        this.add(String.valueOf(ShippingTask.ID) + ".single", "Ship %1$s x%2$s");
        this.add(String.valueOf(ShippingTask.ID) + ".multi", "Ship any of the following x%2$s: %1$s");
        this.add(String.valueOf(ShippingTask.ID) + ".empty", "<Empty tag/items>");
        this.add(SkillLevelTask.ID.toString(), "Reach level %1$s in %s");
        this.add(TamingTask.ID.toString(), "Tame %2$s %1$s");
        for (AdditionalLanguages additionalLanguages : this.additionalLanguages) {
            if (additionalLanguages == null) continue;
            additionalLanguages.translations().forEach(this::add);
        }
        this.add(QuestData.AcceptType.MISSING.langKey(), "Data is missing");
        this.add(QuestData.AcceptType.REQUIREMENTS.langKey(), "You do not meet the requirement for this quest");
        this.add(QuestData.AcceptType.ACCEPT.langKey(), "Quest accepted");
        this.add(QuestData.AcceptType.LIMIT.langKey(), "You reached your daily quest limit");
        this.add(QuestData.AcceptType.NONPC.langKey(), "NPC for this quest does not exist anymore!");
        this.add("runecraftory.dependency.tooltips.owner.none", "Unknown owner");
        this.add("runecraftory.dependency.tooltips.owner", "Owned by: %s");
        this.add("runecraftory.dependency.tooltips.friendpoints", "FP: %s");
        this.add("runecraftory.dependency.tooltips.barn", "Barn at: %s");
        this.add("runecraftory.dependency.tooltips.barn.no", "No Barn assigned!");
        this.add("runecraftory.dependency.tooltips.behaviour", "Behaviour: %s");
        this.add("runecraftory.dependency.tooltips.npc.follow", "Party: %s");
        this.add("runecraftory.dependency.tooltips.barn.1", "No Roof - Size: %1$s");
        this.add("runecraftory.dependency.tooltips.barn.1.alt", "Roof Height: %1$s - Size: %2$s");
        this.add("runecraftory.dependency.tooltips.barn.2", "Capacity: %1$s / %2$s");
        this.add("runecraftory_book", "Runepedia");
        this.add("runecraftory.patchouli.subtitle", "");
        this.add("runecraftory.patchouli.landing", "This Guidebook will explain to you various feature of the mod and what it has to offer.");
        this.add("runecraftory.patchouli.category.main", "Introduction");
        this.add("runecraftory.patchouli.category.main.desc", "");
        this.add("runecraftory.patchouli.entry.runepoints", "Rune points");
        this.add("runecraftory.patchouli.entry.runepoints.1", "Rune points (RP) can be seen as your stamina or mana. Nearly all actions you do require rune points. Keep track of your current rune points when performing actions as running out of rune points will make use of your HP! $(br)$(br)You can replenish your rune points by either sleeping or eating food.");
        this.add("runecraftory.patchouli.entry.calendar", "Calendar");
        this.add("runecraftory.patchouli.entry.calendar.1", "On the left (by default) you can see the current date and season in the world. A year is divided by 4 seasons each with 30 days. Keeping track of the season is important in order to successfully grow crops. If its getting colder biomes which usually don't have snow can experience snowfall too.");
        this.add("runecraftory.patchouli.entry.crafting", "Crafting");
        this.add("runecraftory.patchouli.entry.crafting.1", "This mod adds 4 additional blocks that are used to craft various items. Every crafting process requires a certain amount of rp. Recipes that you haven't unlocked yet will require more rp than those you have.You will not be able to craft an item if the required rp is higher than your total rp. Crafting a locked recipe will unlock it. You can also learn new recipes by eating recipe breads.");
        this.add("runecraftory.patchouli.entry.crafting.2", "Weapon and tools can be upgraded in the forge while armor can be upgraded in the accessory table. Open the upgrade gui by shift right clicking on the crafting device. An item can be upgraded till it reaches level 10. Holding shift while hovering over an item will tell you what stat it gives. Using the same item multiple times causes a diminishing returns effect so try use different items");
        this.add("runecraftory.patchouli.entry.crafting.forge", "The forge is used to craft all weapons and tools. During crafting you can add up to 3 bonus items that will act the same as if you upgraded the weapon/tool with it.");
        this.add("runecraftory.patchouli.entry.crafting.armor", "Use the accessory table to make various armor pieces. Same as the forge you can use up to 3 additional items here to increase the stats.");
        this.add("runecraftory.patchouli.entry.crafting.cooking", "The cooking table is as the name implies used to make all kinds of food. Some items can also be used as additional items for a better end product.");
        this.add("runecraftory.patchouli.entry.crafting.chemistry", "A chemistry set allows you to create potions and other pharmacy items.");
        this.add("runecraftory.patchouli.entry.minerals", "Minerals");
        this.add("runecraftory.patchouli.entry.minerals.1", "Cluster of minerals spawn all over the world. These mineral clusters can be mined with an iron pickaxe or above but its best mined with the $(item)mining hammers$() from this mod. Better hammers and mining skill decrease the chance of the mineral breaking and increase the chance to get rarer materials from it.");
        this.add("runecraftory.patchouli.entry.minerals.2", "Some materials even are impossible to get unless you have a high enough mining skill. $(br)Minerals regenerate after a day. $(br)If you want to completly get rid of a mineral mine a broken one while shifting.");
        this.add("runecraftory.patchouli.entry.shipping", "Shipping Items");
        this.add("runecraftory.patchouli.entry.shipping.1", "You can craft a shipping bin to sell items. Every morning all sellable items in the shipping bin will be sold. The shipping bin inventory is global for each player.");
        this.add("runecraftory.patchouli.entry.entities", "Monsters");
        this.add("runecraftory.patchouli.entry.entities.1", "The mobs in this mod don't spawn by themself but through gates that appear through the world. $(br)The type of monster a gate spawns depends on the biome and a gate will continue to spawn monsters till it is destroyed. Gates can drop their corresponding crystals upon destruction. $(br)Bosses spawn in their structures only and can be fought once every day.");
        this.add("runecraftory.patchouli.entry.entities.2", "Placing a $(item)bell block$() (or other meeting POI type blocks) will prevent gates from spawning in a 48 block radius around it. $(br)$(br)Monsters are able to be tamed by having a $(l:entry.entities#barn)barn$() with enough space and throwing an item at them. This will consume the item and after a while $(bold)heart$(reset) particles appear if the taming was successful and $(bold)smoke$() particles appear if otherwise. Monsters might have one or more favorite items that ");
        this.add("runecraftory.patchouli.entry.entities.3", "doubles the taming chance and bosses can $(#ff0000)only$() be tamed by giving them their favorite items. Other ways to increase taming chance include: Brushing, leveling the taming skill and hitting it with a love attribute weapon.$(br)$(br)Tamed monster cannot die. Instead they will simply play death when reaching critical damage and healing them through any means will bring them back up. Shift right click a tamed monster with a vanilla stick will release them again.");
        this.add("runecraftory.patchouli.entry.entities.4", "You can interact with a tamed monster using the following actions: $(li)$(thing)Shift-right-clicking opens up a menu for the monster.$(li)While ridden press any of the following keys $(thing)$(k:runecraftory.key.spell_1), $(k:runecraftory.key.spell_2), $(k:runecraftory.key.spell_3), $(k:runecraftory.key.spell_4)$() to perform an attack.$(li)$(thing)Drop$() an item to it will give it the item similar to the taming process.");
        this.add("runecraftory.patchouli.entry.entities.5", "Food without additional benefits simply heals it while the other apply their benefits like they would to a player.$(br)$(br)Tamed monster can also help you with farming crops. Upon setting them into farming mode they will tend the crops in a certain radius around the initial position. The nearest inventory block will also be bound to their action and they will deposit harvested crops into that inventory and if seeds are in it they can also plant them.");
        this.add("runecraftory.patchouli.entry.entities.6", "While holding a $(item)monster command staff$() and opening the monster menu you can configure additional things like area of actions and inventory for the entity. Right clicking a block while e.g. configuring the home position will set the home position to that place.$(br)Brushing and giving tamed monster items once a day increases your friendship with them.");
        this.add("runecraftory.patchouli.entry.entities.7", "Barn blocks are needed to tame monsters and can be bought by smiths.");
        this.add("runecraftory.patchouli.entry.entities.8", "To build a successful barn you would need at least a 5x5 area of hay bales. This area can increase up to 11x11. Most monster also need a roof. All blocks (except blocks without collision) count as roofs and there needs to be at least 3 blocks of air between the ground and the roof. Bigger sized barn also need more air blocks.");
        this.add("runecraftory.patchouli.entry.gate", "Gates");
        this.add("runecraftory.patchouli.entry.gate.1", "Gates are ripples in time-space that connects this world to the forest of beginnings, the home of monsters. Through them monster will continously come out unless the gate is destroyed. Word has it that there are strong monsters in the world that when defeated causes gates around the player to get stronger.");
        this.add("runecraftory.patchouli.entry.party", "Party");
        this.add("runecraftory.patchouli.entry.party.1", "You might have noticed that sometimes you can't make monsters or npc follow you. This is due to the party system which allows only a max of 3 entities to follow you at the same time. Party members will follow you and teleport if too far regardless of where you are.");
        this.add("runecraftory.patchouli.category.farming", "Agriculture");
        this.add("runecraftory.patchouli.category.farming.desc", "An overview and guide about the agricultural aspects");
        this.add("runecraftory.patchouli.entry.farming", "Getting Started");
        this.add("runecraftory.patchouli.entry.farming.1", "To get started with growing crops you first need a $(item)hoe$(), a $(item)watering can$() and of course $(item)crop seeds$() to plant. Then simply till the land to turn it into farmland. Using a $(item)magnifying glass$() you can see the stats of the farmland.");
        this.add("runecraftory.patchouli.entry.farming.2", "After that plant the crops on the farmland and water it with a watering can. Unlike vanilla farmland nearby water will not water it. The crops will grow every day and you will also need to keep watering them each day till they are fully grown. Crops can wilt if you forget to water them and by not watering wilted crops they will turn into withered grass so make sure to keep them hydrated. You can use items to increase the soil quality (see $(l:entry.fertilizer#p1)here$()).");
        this.add("runecraftory.patchouli.entry.farming.3", "Crops will get a growth bonus if they are planted in the correct season and if planted in the wrong season will grow slower. The cropsystem can affect crops not from this mod and if affected you will not be able to grow those the vanilla way. You can see if they are affected by simply look if they have additional info attached to them.");
        this.add("runecraftory.patchouli.entry.farming.4", "One thing of note is that crops will grow REGARDLESS of if the chunk is loaded or not. While this means you don't need to be nearby for the crops to grow it also means that unless regularly watering them they have a high chance to wilt. You can mitigate this problem by having your monster companion help you out.");
        this.add("runecraftory.patchouli.entry.trees", "Trees");
        this.add("runecraftory.patchouli.entry.trees.1", "You might come accross some special saplings that are unlike the other saplings. These saplings act similar to crops instead and need to be planted on farmland. The saplings take a long time to grow but once fully grown will bear fruit everyday you can harvest. One thing to note about these trees is that they are unbreakable except for the base of the tree.");
        this.add("runecraftory.patchouli.entry.fertilizer", "Fertilizer");
        this.add("runecraftory.patchouli.entry.fertilizer.1", "There are various items to improve your farming experience. You can buy them at shops. Vanilla bonemeal will not work like normal and grow the crops, instead it will work as a very weak growth increaser for the soil");
        this.add("runecraftory.patchouli.entry.fertilizer.2", "$(li)$(2)Formular a, b and c$() acts increase the growth rate of the soil with a being the weakest and c the strongest.$(li)$(2)Wettable powder$(): Increases the soils defence. If the defence is 0 storms have a chance to destroy the crop.$(li)$(2)Giantizer/Minimizer$() are used to grow giant crops.$(li)$(2)Greenifier$(): Increases soil level and as such also crop level (Not implemented $(bold)ATM$()).");
        this.add("runecraftory.patchouli.entry.weather", "Weather");
        this.add("runecraftory.patchouli.entry.weather.1", "There are 4 types of weather conditions in this mod that only changes during certain times of the day: $(li)$(a)Sunny$(): Normal sunny day without any special properties$(li)$(9)Rain$(): Farmland will automatically get watered ");
        this.add("runecraftory.patchouli.entry.weather.2", "$(li)$(3)Stormy$(): Farmland will automatically get watered but also the defence gets reduced over time. If defence drops to 0 the crops can get destroyed so pay attention$(li)$(6)Runey$(): Like sunny days but crops get a boost in growth$(br)$(br)If it gets cold enough it might also snow in places where it normally wouldn't.");
        this.add("runecraftory.patchouli.category.equipment", "Equipments");
        this.add("runecraftory.patchouli.category.equipment.desc", "");
        this.add("runecraftory.patchouli.entry.weapon", "Weapons");
        this.add("runecraftory.patchouli.entry.weapon.1", "The mod adds a plethora of weapons and you will find a short explanation of each weapon type here. By reaching at least level 5 for a weapon type you are able to use a charge attack. Simply hold right click and release after a while to use it. This will consume a bit of runepoints though. They also have unlike vanilla swords an width effect. See it as sweeping but all mobs take equal damage.");
        this.add("runecraftory.patchouli.entry.weapon.2.title", "Short Swords");
        this.add("runecraftory.patchouli.entry.weapon.2", "Weapons with a shorter reach and attack power but quite fast with a small width effect. The closest to vanilla swords.");
        this.add("runecraftory.patchouli.entry.weapon.3.title", "Long Swords");
        this.add("runecraftory.patchouli.entry.weapon.3", "Bigger reach and more attack power but kinda slow. Has a decent width.");
        this.add("runecraftory.patchouli.entry.weapon.4.title", "Spears");
        this.add("runecraftory.patchouli.entry.weapon.4", "Big reach and fairly quick. The charge attack is special: After charging and releasing repeatedly right click to keep attacking");
        this.add("runecraftory.patchouli.entry.weapon.5.title", "Axe/Hammers");
        this.add("runecraftory.patchouli.entry.weapon.5", "Slow but strong and with bigger reach. Not to be confused with the axe and hammer tools though. Axes usually have a high crit rate while hammers a high stun chance. $(bold)ATM$() stunning will do nothing though");
        this.add("runecraftory.patchouli.entry.weapon.6.title", "Dual Blades");
        this.add("runecraftory.patchouli.entry.weapon.6", "Dual weapons. Fast but weaker than other weapons with a shorter reach. You will also not be able to use offhand items.");
        this.add("runecraftory.patchouli.entry.weapon.7.title", "Fists");
        this.add("runecraftory.patchouli.entry.weapon.7", "Dual weapons. Fast but with shorter reach and small width. Charge attack will push you into the direction you are looking and during that hitting any mobs in your way");
        this.add("runecraftory.patchouli.entry.weapon.8.title", "Staffs");
        this.add("runecraftory.patchouli.entry.weapon.8", "Magic weapon. Each staff has a base spell used per weapon swing. Additionally upgrading a staff with items can give it spells too. To use them simply hold right click. A staff can have max 3 spells attached to it.");
        this.add("runecraftory.patchouli.entry.tools", "Tools");
        this.add("runecraftory.patchouli.entry.tools.1", "Here is an overview of the tools from this mod. You can use tools as weapons but they are noticeably weaker. The higher tier the tool is the more powerful the charge ability will be.");
        this.add("runecraftory.patchouli.entry.tools.2.title", "Hoe");
        this.add("runecraftory.patchouli.entry.tools.2", "Used to till the earth turning it into farmland to grow crops.");
        this.add("runecraftory.patchouli.entry.tools.3.title", "Wateringcan");
        this.add("runecraftory.patchouli.entry.tools.3", "You need a watering can to water farmland. Right click on water blocks to fill it up.");
        this.add("runecraftory.patchouli.entry.tools.4.title", "Sickle");
        this.add("runecraftory.patchouli.entry.tools.4", "Can be used to clear out grass more easily");
        this.add("runecraftory.patchouli.entry.tools.5.title", "Hammer");
        this.add("runecraftory.patchouli.entry.tools.5", "Acts like a pickaxe but you can also use it to flatten farmland turning it back into dirt. It also gets additional benefits when breaking minerals.");
        this.add("runecraftory.patchouli.entry.tools.6.title", "Axe");
        this.add("runecraftory.patchouli.entry.tools.6", "For now acts just like vanilla axes");
        this.add("runecraftory.patchouli.entry.tools.7.title", "Fishing Rod");
        this.add("runecraftory.patchouli.entry.tools.7", "Similiar to vanilla fishing rod. Throw it into a body of water to start fishing. The body of water needs to be at least $(1)2 blocks deep and 3x3 wide$(). Higher tier fishing rods increases the speed to catch a fish while the more charge it has the easier it is to catch a fish.");
        this.add("runecraftory.patchouli.entry.tools.8", "Useful to inspect the quality of the soil. If used as upgrade material will pass on its function to the upgraded tool.");
        this.add("runecraftory.patchouli.entry.spellskills", "Spells and Skills");
        this.add("runecraftory.patchouli.entry.spellskills.1", "There are several spells and skills that can be found all over the world. Every spell and skill will require runepoints to use them. You can put both spell and skill items in the spell slots (in your inventory) and then you are able to simply press the corresponding key to cast them. The only craftable spells are the following two:");
        this.add("runecraftory.patchouli.entry.spellskills.3", "Skills require you to hold a weapon in your hand and will drop in efficiency if you hold the wrong weapon. ");
        this.add("runecraftory.patchouli.category.npc", "Villagers");
        this.add("runecraftory.patchouli.category.npc.desc", "");
        this.add("runecraftory.patchouli.entry.npc", "Villagers");
        this.add("runecraftory.patchouli.entry.npc.1", "You might come across some villagers that are different from vanilla villagers. Some can operate shops where you can buy stuff. For them to operate a shop they need a bed and workplace not too far away from eachother first. Right click allows you to interact with them and they will tell you if they are missing something.");
        this.add("runecraftory.patchouli.entry.npc.2", "Hover over the red text (if existent) to see that. Talking daily with a villager increases your friendship. You can also gift them itemby throwing it at them. If you give them equipment they will equip it too.");
        this.add("runecraftory.patchouli.entry.npc.3", "Befriending them allows you to make them follow you and also allows you to develope an relationship with them. $(br)If your friend points are high enough giving them a $(item)love letter$() can initiate a deeper relationship. $(br)Going a bit further you might even be able to propose to them with an $(item)engagement ring$()");
        this.add("runecraftory.patchouli.entry.npc.jobs", "Villager jobs");
        this.add("runecraftory.patchouli.entry.npc.jobs.1.title", "General Store");
        this.add("runecraftory.patchouli.entry.npc.jobs.1", "The general store sells mostly seeds, vegetables and fruits");
        this.add("runecraftory.patchouli.entry.npc.jobs.2.title", "Florist");
        this.add("runecraftory.patchouli.entry.npc.jobs.2", "Here you can buy flowers and seeds an also fertilizer for your crops");
        this.add("runecraftory.patchouli.entry.npc.jobs.3.title", "Smith");
        this.add("runecraftory.patchouli.entry.npc.jobs.3", "The smith sells weapons, tools and armor as well as monster barns");
        this.add("runecraftory.patchouli.entry.npc.jobs.4.title", "Doctor");
        this.add("runecraftory.patchouli.entry.npc.jobs.4", "You can buy medicine and herbs here");
        this.add("runecraftory.patchouli.entry.npc.jobs.5.title", "Cook");
        this.add("runecraftory.patchouli.entry.npc.jobs.5", "Buy food and recipe breads here. The cook only has a certain amount of recipe breads each day");
        this.add("runecraftory.patchouli.entry.npc.jobs.6.title", "Magic Shop");
        this.add("runecraftory.patchouli.entry.npc.jobs.6", "Sells various spells here. Most spells need to be shipped at least once before being sold here.");
        this.add("runecraftory.patchouli.entry.npc.jobs.7.title", "Rune skill Store");
        this.add("runecraftory.patchouli.entry.npc.jobs.7", "Sells various rune skills here. Most skills need to be shipped at least once before being sold here.");
        this.add("runecraftory.patchouli.entry.npc.jobs.8.title", "Bath house");
        this.add("runecraftory.patchouli.entry.npc.jobs.8", "Bath houses offer a way to regen your hp and rp. By talking to the bath house attendant you can obtain an effect which will regen hp+rp if you go into hot water. Water is hot if it has a campfire below, indicated by if the smoke is coming up or not. Going out of the water will remove the effect immediately!");
        this.add("runecraftory.patchouli.entry.npc.jobs.9.title", "Travelling merchant");
        this.add("runecraftory.patchouli.entry.npc.jobs.9", "Sells miscellaneous items. WIP");
        this.add("runecraftory.patchouli.entry.quests", "Quests");
        this.add("runecraftory.patchouli.entry.quests.1", "Crafting a quest board and placing it in the world will allow nearby NPCs to post quests for you to complete. Try doing them as they usually give you useful information and/or rewards. After accepting a quest talk to the NPC to progress through it. Some NPCs also require you to complete certain quests before being able to marry them. (This feature atm is WIP)");
        this.add("runecraftory.patchouli.category.entities", "Monsters");
        this.add("runecraftory.patchouli.category.entities.desc", "List of all monsters");
        ArrayList entities = new ArrayList();
        this.addPatchouliEntityDesc(entities, ModEntities.WOOLY, "Sheep like creature that is rather passive. Shearable.");
        this.addPatchouliEntityDesc(entities, ModEntities.ORC_ARCHER, "An orc but with a bow");
        this.addPatchouliEntityDesc(entities, ModEntities.BIG_MUCK, "Mushroom like create that attacks using spores");
        this.addPatchouliEntityDesc(entities, ModEntities.AMBROSIA, "Butterfly boss monster");
        this.addPatchouliEntityDesc(entities, ModEntities.THUNDERBOLT, "Horse said to be as fast as lightning");
        this.addPatchouliEntityDesc(entities, ModEntities.MARIONETTA, "Spooky old doll");
        this.addPatchouliEntityDesc(entities, ModEntities.HANDONETTA, "Whose hand is this???");
        for (RegistryEntrySupplier<EntityType<?>> sup : ModEntities.getMonsters()) {
            if (entities.contains(sup)) continue;
            this.add(LangGen.patchouliEntity(sup.getID()), "");
        }
    }

    private String simpleTranslation(ResourceLocation res) {
        String s = res.m_135815_();
        return this.simpleTranslation(s);
    }

    private String simpleTranslation(String s) {
        if (((String)s).startsWith("ore_broken")) {
            s = ((String)s).replace("ore_broken", "");
            s = "broken_" + (String)s + "_mineral";
        } else if (((String)s).startsWith("ore_")) {
            s = ((String)s).replace("ore_", "");
            s = (String)s + "_mineral";
        }
        return Stream.of(((String)s).trim().split("_")).filter(word -> !word.isEmpty()).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" ")).replaceAll("Plus($| )", "+").replace("Four Leaf", "4-Leaf").replace("Pom Pom", "Pom-Pom");
    }

    private static String patchouliEntity(ResourceLocation res) {
        return "runecraftory.patchouli.entry.entity." + String.valueOf(res);
    }

    private String capitalize(String s, List<String> dont) {
        return Stream.of(s.trim().split("\\s")).filter(word -> !word.isEmpty()).map(word -> dont.contains(word) ? word : word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.addTranslations();
        Map sort = this.data.entrySet().stream().sorted((e, e2) -> ORDER.compare((String)e.getKey(), (String)e2.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (old, v) -> old, LinkedHashMap::new));
        if (!sort.isEmpty()) {
            this.save(cache, sort, this.gen.m_123916_().resolve("assets/" + this.modid + "/lang/" + this.locale + ".json"));
        }
    }

    public String m_6055_() {
        return "Languages: " + this.locale;
    }

    private void save(HashCache cache, Object object, Path target) throws IOException {
        String data = GsonInstances.GSON.toJson(object);
        data = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)data);
        String hash = DataProvider.f_123918_.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.m_123938_(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.m_123940_(target, hash);
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Block key, String name) {
        if (!key.m_7705_().equals(key.m_5456_().m_5524_())) {
            this.add(key.m_7705_(), name);
        }
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Item key, String name) {
        this.add(key.m_5524_(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    public void add(ItemStack key, String name) {
        this.add(key.m_41778_(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Enchantment key, String name) {
        this.add(key.m_44704_(), name);
    }

    public void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get(), name);
    }

    public void add(MobEffect key, String name) {
        this.add(key.m_19481_(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.add(key.m_20675_(), name);
    }

    public void add(String key, String value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    public <T extends Entity> void addPatchouliEntityDesc(List<RegistryEntrySupplier<EntityType<?>>> list, RegistryEntrySupplier<EntityType<T>> sup, String value) {
        list.add(sup);
        this.add(LangGen.patchouliEntity(sup.getID()), value);
    }

    static enum LangType {
        ITEM,
        BLOCK,
        ENTITY,
        OTHER;


        public static LangType get(String s) {
            if (s.startsWith("item.")) {
                return ITEM;
            }
            if (s.startsWith("block.")) {
                return BLOCK;
            }
            if (s.startsWith("entity.")) {
                return ENTITY;
            }
            return OTHER;
        }
    }
}

