/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumMineralTier;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.blocks.BlockCrafting;
import io.github.flemmli97.runecraftory.common.blocks.BlockCrop;
import io.github.flemmli97.runecraftory.common.blocks.BlockGiantCrop;
import io.github.flemmli97.runecraftory.common.blocks.BlockQuestboard;
import io.github.flemmli97.runecraftory.common.entities.GateEntity;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityKingWooly;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityMineralSqueek;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityWooly;
import io.github.flemmli97.runecraftory.common.loot.CropWeaponLootFunction;
import io.github.flemmli97.runecraftory.common.loot.FirstKillCondition;
import io.github.flemmli97.runecraftory.common.loot.FriendPointCondition;
import io.github.flemmli97.runecraftory.common.loot.ItemLevelLootFunction;
import io.github.flemmli97.runecraftory.common.loot.LootingAndLuckLootFunction;
import io.github.flemmli97.runecraftory.common.loot.SkillLevelCondition;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.LootTableResources;
import io.github.flemmli97.runecraftory.forge.data.QuestGen;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class Loottables
extends LootTableProvider {
    private static final float COMMON_LUCK_BONUS = 0.05f;
    private static final float RARE_LUCK_BONUS = 0.01f;
    private static final float VERY_RARE_LUCK_BONUS = 0.005f;
    private static final float SUPER_RARE_LUCK_BONUS = 0.001f;
    private static final float LOOTING_BONUS = 0.2f;
    private static final float RARE_LOOTING_BONUS = 0.1f;
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> loot = ImmutableList.of((Object)Pair.of(EntityLoot::new, (Object)LootContextParamSets.f_81415_), (Object)Pair.of(WoolyShearedEntityLoot::new, (Object)LootContextParamSets.f_81414_), (Object)Pair.of(BlockLootData::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(FishingLootData::new, (Object)LootContextParamSets.f_81414_), (Object)Pair.of(ChestLoots::new, (Object)LootContextParamSets.f_81411_), (Object)Pair.of(() -> new QuestLootData(questGen), (Object)LootContextParamSets.f_81411_));

    public Loottables(DataGenerator gen, QuestGen questGen) {
        super(gen);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.loot;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    static class QuestLootData
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private final QuestGen questGen;

        QuestLootData(QuestGen questGen) {
            this.questGen = questGen;
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
            this.questGen.loot.forEach(biConsumer);
        }
    }

    static class FishingLootData
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        FishingLootData() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
            biConsumer.accept(LootTableResources.FISHING, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78720_))));
            biConsumer.accept(LootTableResources.SAND_FISHING, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41830_))));
        }
    }

    static class BlockLootData
    extends BlockLoot {
        private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
        private final Map<ResourceLocation, LootTable.Builder> loots = new HashMap<ResourceLocation, LootTable.Builder>();

        BlockLootData() {
        }

        protected static LootPool.Builder herbLoot(ItemLike item) {
            LootPool.Builder build = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            build.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_5577_(ItemLevelLootFunction.getDef()));
            return build;
        }

        protected static LootPool.Builder cropLoot(BlockCrop block) {
            LootPool.Builder build = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            if (block instanceof BlockGiantCrop) {
                build.m_79076_(LootItem.m_79579_((ItemLike)block.getCrop()).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(BlockGiantCrop.DIRECTION, (Comparable)Direction.NORTH))));
            } else {
                build.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block.getCrop()));
            }
            return build;
        }

        protected static LootPool.Builder cropWeaponLoot(BlockCrop block) {
            LootPool.Builder build = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            build.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block.getCrop()).m_5577_((LootItemFunction.Builder)new CropWeaponLootFunction.Builder()));
            return build;
        }

        protected static LootPool.Builder oreLootPool(EnumMineralTier tier) {
            LootPool.Builder build = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            switch (tier) {
                case IRON: {
                    build.m_79076_(BlockLootData.ore(100, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(40, 17, (ItemLike)Items.f_42416_));
                    build.m_79076_(BlockLootData.ore(5, 5, (ItemLike)ModItems.INVIS_STONE.get()));
                    build.m_79076_(BlockLootData.ore(10, 3, (ItemLike)ModItems.INVIS_STONE.get(), 10));
                    build.m_79076_(BlockLootData.ore(1, 7, (ItemLike)ModItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case TIN: {
                    build.m_79076_(BlockLootData.ore(100, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(40, 15, (ItemLike)Items.f_42416_));
                    build.m_79076_(BlockLootData.ore(25, 24, (ItemLike)Items.f_151052_));
                    build.m_79076_(BlockLootData.ore(4, 3, (ItemLike)ModItems.INVIS_STONE.get(), 5));
                    build.m_79076_(BlockLootData.ore(5, 3, (ItemLike)ModItems.INVIS_STONE.get(), 20));
                    build.m_79076_(BlockLootData.ore(3, 8, (ItemLike)ModItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case SILVER: {
                    build.m_79076_(BlockLootData.ore(100, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(40, 12, (ItemLike)Items.f_42416_));
                    build.m_79076_(BlockLootData.ore(20, 31, (ItemLike)ModItems.RAW_SILVER.get()));
                    build.m_79076_(BlockLootData.ore(2, 2, (ItemLike)ModItems.INVIS_STONE.get(), 5));
                    build.m_79076_(BlockLootData.ore(3, 2, (ItemLike)ModItems.INVIS_STONE.get(), 10));
                    build.m_79076_(BlockLootData.ore(3, 2, (ItemLike)ModItems.INVIS_STONE.get(), 15));
                    build.m_79076_(BlockLootData.ore(3, 8, (ItemLike)ModItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case GOLD: {
                    build.m_79076_(BlockLootData.ore(100, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(50, 8, (ItemLike)Items.f_42416_));
                    build.m_79076_(BlockLootData.ore(20, 31, (ItemLike)Items.f_42417_));
                    build.m_79076_(BlockLootData.ore(3, 8, (ItemLike)ModItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case DIAMOND: {
                    build.m_79076_(BlockLootData.ore(100, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(5, 7, (ItemLike)Items.f_42415_));
                    build.m_79076_(BlockLootData.ore(15, 27, (ItemLike)Items.f_42415_, 20));
                    build.m_79076_(BlockLootData.ore(3, 8, (ItemLike)ModItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case PLATINUM: {
                    build.m_79076_(BlockLootData.ore(100, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(4, 12, (ItemLike)ModItems.RAW_PLATINUM.get()));
                    build.m_79076_(BlockLootData.ore(20, 29, (ItemLike)ModItems.RAW_PLATINUM.get(), 30));
                    build.m_79076_(BlockLootData.ore(3, 8, (ItemLike)ModItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case ORICHALCUM: {
                    build.m_79076_(BlockLootData.ore(100, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(4, 8, (ItemLike)ModItems.ORICHALCUM.get(), 20));
                    build.m_79076_(BlockLootData.ore(10, 27, (ItemLike)ModItems.ORICHALCUM.get(), 40));
                    build.m_79076_(BlockLootData.ore(5, 11, (ItemLike)ModItems.CRYSTAL_BIG.get(), 40));
                    break;
                }
                case DRAGONIC: {
                    build.m_79076_(BlockLootData.ore(100, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(6, 9, (ItemLike)ModItems.DRAGONIC.get(), 20));
                    build.m_79076_(BlockLootData.ore(10, 26, (ItemLike)ModItems.DRAGONIC.get(), 50));
                    build.m_79076_(BlockLootData.ore(3, 9, (ItemLike)ModItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case AMETHYST: {
                    build.m_79076_(BlockLootData.ore(130, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(40, 15, (ItemLike)ModItems.AMETHYST.get()));
                    build.m_79076_(BlockLootData.ore(15, 17, (ItemLike)ModItems.CRYSTAL_EARTH.get()));
                    build.m_79076_(BlockLootData.ore(1, 3, (ItemLike)ModItems.LIGHT_ORE.get()));
                    build.m_79076_(BlockLootData.ore(5, 3, (ItemLike)ModItems.LIGHT_ORE.get(), 5));
                    build.m_79076_(BlockLootData.ore(7, 5, (ItemLike)ModItems.LIGHT_ORE.get(), 15));
                    break;
                }
                case AQUAMARINE: {
                    build.m_79076_(BlockLootData.ore(130, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(40, 15, (ItemLike)ModItems.AQUAMARINE.get()));
                    build.m_79076_(BlockLootData.ore(15, 17, (ItemLike)ModItems.CRYSTAL_WATER.get()));
                    build.m_79076_(BlockLootData.ore(1, 3, (ItemLike)ModItems.LIGHT_ORE.get()));
                    build.m_79076_(BlockLootData.ore(5, 3, (ItemLike)ModItems.LIGHT_ORE.get(), 5));
                    build.m_79076_(BlockLootData.ore(7, 5, (ItemLike)ModItems.LIGHT_ORE.get(), 15));
                    break;
                }
                case RUBY: {
                    build.m_79076_(BlockLootData.ore(130, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(40, 15, (ItemLike)ModItems.RUBY.get()));
                    build.m_79076_(BlockLootData.ore(15, 17, (ItemLike)ModItems.CRYSTAL_FIRE.get()));
                    build.m_79076_(BlockLootData.ore(1, 3, (ItemLike)ModItems.LIGHT_ORE.get()));
                    build.m_79076_(BlockLootData.ore(5, 3, (ItemLike)ModItems.LIGHT_ORE.get(), 5));
                    build.m_79076_(BlockLootData.ore(7, 5, (ItemLike)ModItems.LIGHT_ORE.get(), 15));
                    break;
                }
                case EMERALD: {
                    build.m_79076_(BlockLootData.ore(130, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(40, 15, (ItemLike)Items.f_42616_));
                    build.m_79076_(BlockLootData.ore(15, 17, (ItemLike)ModItems.CRYSTAL_WIND.get()));
                    build.m_79076_(BlockLootData.ore(1, 3, (ItemLike)ModItems.LIGHT_ORE.get()));
                    build.m_79076_(BlockLootData.ore(5, 3, (ItemLike)ModItems.LIGHT_ORE.get(), 5));
                    build.m_79076_(BlockLootData.ore(7, 5, (ItemLike)ModItems.LIGHT_ORE.get(), 15));
                    break;
                }
                case SAPPHIRE: {
                    build.m_79076_(BlockLootData.ore(130, 3, (ItemLike)ModItems.SCRAP.get()));
                    build.m_79076_(BlockLootData.ore(50, 15, (ItemLike)ModItems.SAPPHIRE.get()));
                    build.m_79076_(BlockLootData.ore(3, 17, (ItemLike)ModItems.CRYSTAL_LOVE.get()));
                    build.m_79076_(BlockLootData.ore(1, 3, (ItemLike)ModItems.LIGHT_ORE.get()));
                    build.m_79076_(BlockLootData.ore(5, 3, (ItemLike)ModItems.LIGHT_ORE.get(), 5));
                    build.m_79076_(BlockLootData.ore(7, 5, (ItemLike)ModItems.LIGHT_ORE.get(), 15));
                }
            }
            build.m_5577_(ItemLevelLootFunction.getDef());
            return build;
        }

        private static LootPoolSingletonContainer.Builder<?> ore(int weight, int quality, ItemLike item) {
            return LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_79711_(quality);
        }

        private static LootPoolSingletonContainer.Builder<?> ore(int weight, int quality, ItemLike item, int minMiningLevel) {
            return (LootPoolSingletonContainer.Builder)BlockLootData.ore(weight, quality, item).m_6509_(SkillLevelCondition.get(EnumSkills.MINING, minMiningLevel));
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> cons) {
            Block block2;
            this.m_124165_((Block)ModBlocks.MUSHROOM.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.MUSHROOM.get())));
            this.m_124165_((Block)ModBlocks.MONARCH_MUSHROOM.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.MONARCH_MUSHROOM.get())));
            this.m_124165_((Block)ModBlocks.ELLI_LEAVES.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.ELLI_LEAVES.get())));
            this.m_124165_((Block)ModBlocks.WITHERED_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.WITHERED_GRASS.get())));
            this.m_124165_((Block)ModBlocks.WEEDS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.WEEDS.get())));
            this.m_124165_((Block)ModBlocks.WHITE_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.WHITE_GRASS.get())));
            this.m_124165_((Block)ModBlocks.INDIGO_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.INDIGO_GRASS.get())));
            this.m_124165_((Block)ModBlocks.PURPLE_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.PURPLE_GRASS.get())));
            this.m_124165_((Block)ModBlocks.GREEN_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.GREEN_GRASS.get())));
            this.m_124165_((Block)ModBlocks.BLUE_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.BLUE_GRASS.get())));
            this.m_124165_((Block)ModBlocks.YELLOW_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.YELLOW_GRASS.get())));
            this.m_124165_((Block)ModBlocks.RED_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.RED_GRASS.get())));
            this.m_124165_((Block)ModBlocks.ORANGE_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.ORANGE_GRASS.get())));
            this.m_124165_((Block)ModBlocks.BLACK_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.BLACK_GRASS.get())));
            this.m_124165_((Block)ModBlocks.ANTIDOTE_GRASS.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.ANTIDOTE_GRASS.get())));
            this.m_124165_((Block)ModBlocks.MEDICINAL_HERB.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.MEDICINAL_HERB.get())));
            this.m_124165_((Block)ModBlocks.BAMBOO_SPROUT.get(), LootTable.m_79147_().m_79161_(BlockLootData.herbLoot((ItemLike)ModItems.BAMBOO_SPROUT.get())));
            this.m_124175_((Block)ModBlocks.FORGE.get(), block -> BlockLootData.m_124161_((Block)block, BlockCrafting.PART, (Comparable)((Object)BlockCrafting.EnumPart.LEFT)));
            this.m_124175_((Block)ModBlocks.COOKING.get(), block -> BlockLootData.m_124161_((Block)block, BlockCrafting.PART, (Comparable)((Object)BlockCrafting.EnumPart.LEFT)));
            this.m_124175_((Block)ModBlocks.CHEMISTRY.get(), block -> BlockLootData.m_124161_((Block)block, BlockCrafting.PART, (Comparable)((Object)BlockCrafting.EnumPart.LEFT)));
            this.m_124175_((Block)ModBlocks.ACCESSORY.get(), block -> BlockLootData.m_124161_((Block)block, BlockCrafting.PART, (Comparable)((Object)BlockCrafting.EnumPart.LEFT)));
            this.m_124288_((Block)ModBlocks.SHIPPING.get());
            this.m_124288_((Block)ModBlocks.CASH_REGISTER.get());
            this.m_124288_((Block)ModBlocks.MONSTER_BARN.get());
            this.m_124175_((Block)ModBlocks.QUEST_BOARD.get(), block -> BlockLootData.m_124161_((Block)block, BlockQuestboard.PART, (Comparable)((Object)BlockQuestboard.Part.BOTTOM_LEFT)));
            for (RegistryEntrySupplier<Block> reg2 : ModBlocks.CROPS) {
                block2 = (Block)reg2.get();
                if (!(block2 instanceof BlockCrop)) continue;
                this.m_124165_((Block)reg2.get(), LootTable.m_79147_().m_79161_(BlockLootData.cropLoot((BlockCrop)block2)));
            }
            for (RegistryEntrySupplier<Block> reg2 : ModBlocks.FLOWERS) {
                if (reg2 == ModBlocks.SWORD_CROP || reg2 == ModBlocks.SHIELD_CROP) {
                    block2 = (Block)reg2.get();
                    if (!(block2 instanceof BlockCrop)) continue;
                    this.m_124165_((Block)reg2.get(), LootTable.m_79147_().m_79161_(BlockLootData.cropWeaponLoot((BlockCrop)block2)));
                    continue;
                }
                block2 = (Block)reg2.get();
                if (!(block2 instanceof BlockCrop)) continue;
                this.m_124165_((Block)reg2.get(), LootTable.m_79147_().m_79161_(BlockLootData.cropLoot((BlockCrop)block2)));
            }
            ModBlocks.MINERAL_MAP.forEach((tier, reg) -> this.m_124165_((Block)reg.get(), LootTable.m_79147_().m_79161_(BlockLootData.oreLootPool(tier))));
            this.m_124175_((Block)ModBlocks.ACCESSORY.get(), block -> BlockLootData.m_124161_((Block)block, BlockCrafting.PART, (Comparable)((Object)BlockCrafting.EnumPart.LEFT)));
            this.m_124175_((Block)ModBlocks.SNOW.get(), block -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_6509_(LootItemEntityPropertyCondition.m_81862_((LootContext.EntityTarget)LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)Items.f_42452_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 1))), ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42452_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 2)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))), ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42452_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 3)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f))), ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42452_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 4)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f))), ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42452_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 5)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)5.0f))), ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42452_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 6)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)6.0f))), ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42452_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 7)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)7.0f))), LootItem.m_79579_((ItemLike)Items.f_42452_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)8.0f)))}).m_6509_(SILK_TOUCH), AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)Blocks.f_50125_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 1))), LootItem.m_79579_((ItemLike)Blocks.f_50125_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 2))), LootItem.m_79579_((ItemLike)Blocks.f_50125_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 3))), LootItem.m_79579_((ItemLike)Blocks.f_50125_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 4))), LootItem.m_79579_((ItemLike)Blocks.f_50125_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)5.0f))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 5))), LootItem.m_79579_((ItemLike)Blocks.f_50125_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)6.0f))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 6))), LootItem.m_79579_((ItemLike)Blocks.f_50125_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)7.0f))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SnowLayerBlock.f_56581_, 7))), LootItem.m_79579_((ItemLike)Blocks.f_50127_)})}))));
            this.loots.forEach(cons);
        }

        public void m_124175_(Block block, Function<Block, LootTable.Builder> function) {
            this.m_124165_(block, function.apply(block));
        }

        public void m_124165_(Block block, LootTable.Builder builder) {
            this.loots.put(block.m_60589_(), builder);
        }

        protected void registerLootTable(ResourceLocation s, LootTable.Builder builder) {
            this.loots.put(s, builder);
        }
    }

    static class ChestLoots
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        ChestLoots() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
            LootPool.Builder tier1 = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f));
            for (RegistryEntrySupplier<Item> registryEntrySupplier : ModItems.TIER_1_CHEST) {
                tier1.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)registryEntrySupplier.get())));
            }
            tier1.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.FORGING_BREAD.get())));
            tier1.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_BREAD.get())));
            tier1.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.CHEMISTRY_BREAD.get())));
            tier1.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.COOKING_BREAD.get())));
            biConsumer.accept(LootTableResources.TIER_1_LOOT, LootTable.m_79147_().m_79161_(tier1));
            LootPool.Builder tier2 = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f));
            for (RegistryEntrySupplier<Item> registryEntrySupplier : ModItems.TIER_2_CHEST) {
                tier2.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)registryEntrySupplier.get())));
            }
            tier2.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.FORGING_BREAD.get())));
            tier2.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ARMOR_BREAD.get())));
            tier2.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.CHEMISTRY_BREAD.get())));
            tier2.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.COOKING_BREAD.get())));
            biConsumer.accept(LootTableResources.TIER_2_LOOT, LootTable.m_79147_().m_79161_(tier2));
            LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f));
            for (RegistryEntrySupplier<Item> registryEntrySupplier : ModItems.TIER_3_CHEST) {
                builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)registryEntrySupplier.get())));
            }
            biConsumer.accept(LootTableResources.TIER_3_LOOT, LootTable.m_79147_().m_79161_(builder));
            LootPool.Builder builder2 = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f));
            for (RegistryEntrySupplier<Item> registryEntrySupplier : ModItems.TIER_4_CHEST) {
                builder2.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)registryEntrySupplier.get())));
            }
            biConsumer.accept(LootTableResources.TIER_4_LOOT, LootTable.m_79147_().m_79161_(builder2));
            LootPool.Builder builder3 = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)-2.0f, (float)1.0f));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.FIRE_BALL_SMALL.get())).m_79707_(140));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.FIRE_BALL_BIG.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.EXPLOSION.get())).m_79707_(20));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.WATER_LASER.get())).m_79707_(110));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PARALLEL_LASER.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.DELTA_LASER.get())).m_79707_(20));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.SCREW_ROCK.get())).m_79707_(110));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.EARTH_SPIKE.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AVENGER_ROCK.get())).m_79707_(20));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.SONIC_WIND.get())).m_79707_(110));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.DOUBLE_SONIC.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PENETRATE_SONIC.get())).m_79707_(20));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.LIGHT_BARRIER.get())).m_79707_(90));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.SHINE.get())).m_79707_(50));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PRISM.get())).m_79707_(15));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.DARK_SNAKE.get())).m_79707_(100));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.DARK_BALL.get())).m_79707_(50));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.DARKNESS.get())).m_79707_(15));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.CURE.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.CURE_ALL.get())).m_79707_(30));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.CURE_MASTER.get())).m_79707_(10));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.MEDI_POISON.get())).m_79707_(80));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.MEDI_PARA.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.MEDI_SEAL.get())).m_79707_(10));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.POWER_WAVE.get())).m_79707_(100));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.DASH_SLASH.get())).m_79707_(80));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RUSH_ATTACK.get())).m_79707_(85));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ROUND_BREAK.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.MIND_THRUST.get())).m_79707_(85));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.GUST.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.STORM.get())).m_79707_(80));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.BLITZ.get())).m_79707_(30));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.TWIN_ATTACK.get())).m_79707_(90));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RAIL_STRIKE.get())).m_79707_(50));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.WIND_SLASH.get())).m_79707_(70));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.FLASH_STRIKE.get())).m_79707_(80));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.NAIVE_BLADE.get())).m_79707_(70));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.STEEL_HEART.get())).m_79707_(40));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.DELTA_STRIKE.get())).m_79707_(80));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HURRICANE.get())).m_79707_(90));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.REAPER_SLASH.get())).m_79707_(80));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.MILLION_STRIKE.get())).m_79707_(50));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AXEL_DISASTER.get())).m_79707_(50));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.STARDUST_UPPER.get())).m_79707_(80));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.TORNADO_SWING.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.GRAND_IMPACT.get())).m_79707_(70));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.GIGA_SWING.get())).m_79707_(80));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.UPPER_CUT.get())).m_79707_(100));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.DOUBLE_KICK.get())).m_79707_(90));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.STRAIGHT_PUNCH.get())).m_79707_(80));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.NEKO_DAMASHI.get())).m_79707_(100));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RUSH_PUNCH.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.CYCLONE.get())).m_79707_(60));
            builder3.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RAPID_MOVE.get())).m_79707_(90));
            biConsumer.accept(LootTableResources.CHEST_LOOT_SPELLS, LootTable.m_79147_().m_79161_(builder3));
        }
    }

    static class WoolyShearedEntityLoot
    extends EntityLoot {
        WoolyShearedEntityLoot() {
        }

        @Override
        protected void init() {
            AlternativesEntry.Builder b = AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]);
            b.m_7170_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.FUR_LARGE.get())).m_6509_(FriendPointCondition.of(8))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)));
            b.m_7170_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.FUR_MEDIUM.get())).m_6509_(FriendPointCondition.of(5))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)));
            b.m_7170_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.FUR_SMALL.get())).m_6509_(FriendPointCondition.of(0))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)));
            this.lootTables.put(EntityWooly.shearedLootTable(LootTableResources.WOOLED_WHITE_LOOT), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)b)));
        }
    }

    static class EntityLoot
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        protected final Map<ResourceLocation, LootTable.Builder> lootTables = new HashMap<ResourceLocation, LootTable.Builder>();

        EntityLoot() {
        }

        protected void init() {
            this.lootTables.put(LootTableResources.WOOLED_WHITE_LOOT, this.table(new ItemLootData((ItemLike)ModItems.FUR_SMALL.get(), 0.6f, 0.05f, 0.2f, 2)).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)((EntityType)ModEntities.WOOLY.get()).m_20677_()))));
            this.registerLootTable((EntityType)ModEntities.WOOLY.get(), this.table(new ItemLootData((ItemLike)Items.f_42574_, 0.05f, 0.01f, 0.2f, 1)).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42658_, -3.0f, 1.0f, 1.0f))), new TamedItemLootData((ItemLike)ModItems.FUR_SMALL.get(), 1.0f, 0), new TamedItemLootData((ItemLike)ModItems.FUR_MEDIUM.get(), 1.0f, 5), new TamedItemLootData((ItemLike)ModItems.FUR_LARGE.get(), 1.0f, 8));
            this.registerLootTable((EntityType)ModEntities.ANT.get(), this.table(new ItemLootData((ItemLike)ModItems.CARAPACE_INSECT.get(), 0.5f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CARAPACE_PRETTY.get(), 0.01f, 0.005f, 0.2f, 2), new ItemLootData((ItemLike)ModItems.JAW_INSECT.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.f_41837_, 0.7f, 0.05f, 0.6f, 0, true)), new TamedItemLootData((ItemLike)ModItems.CARAPACE_INSECT.get(), 1.0f, 0));
            this.registerLootTable((EntityType)ModEntities.ORC_ARCHER.get(), this.table(new ItemLootData((ItemLike)ModItems.RECOVERY_POTION.get(), 0.03f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)Items.f_42403_, 0.6f, 0.05f, 0.7f, 0, true), new ItemLootData((ItemLike)ModItems.ARROW_HEAD.get(), 0.5f, 0.05f, 0.2f, 0)).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42412_, -1.0f, 1.0f, 1.0f))));
            this.registerLootTable((EntityType)ModEntities.ORC.get(), this.table(new ItemLootData((ItemLike)ModItems.CHEAP_BRACELET.get(), 0.05f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)ModItems.CLOTH_CHEAP.get(), 0.5f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.GLUE.get(), 0.4f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.BEETLE.get(), this.table(new ItemLootData((ItemLike)ModItems.CARAPACE_INSECT.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CARAPACE_PRETTY.get(), 0.01f, 0.005f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.HORN_INSECT.get(), 0.3f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.HORN_INSECT.get(), 1.0f, 0));
            this.registerLootTable((EntityType)ModEntities.BIG_MUCK.get(), this.table(new ItemLootData((ItemLike)ModItems.SPORE.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.POWDER_POISON.get(), 0.05f, 0.005f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.MUSHROOM.get(), 0.4f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.SPORE.get(), 1.0f, 0));
            this.registerLootTable((EntityType)ModEntities.BUFFAMOO.get(), this.table(new ItemLootData((ItemLike)ModItems.MILK_S.get(), 0.4f, 0.05f, 0.2f, 0)).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42454_, -4.0f, 1.0f, 1.0f))).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42579_, -5.0f, 2.0f, 1.0f))), new TamedItemLootData((ItemLike)ModItems.MILK_S.get(), 1.0f, 0), new TamedItemLootData((ItemLike)ModItems.MILK_M.get(), 1.0f, 5), new TamedItemLootData((ItemLike)ModItems.MILK_L.get(), 1.0f, 8));
            this.registerLootTable((EntityType)ModEntities.CHIPSQUEEK.get(), this.table(new ItemLootData((ItemLike)ModItems.FUR.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FUR_QUALITY.get(), 0.02f, 0.005f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.FUR.get(), 1.0f, 0));
            this.registerLootTable((EntityType)ModEntities.CLUCKADOODLE.get(), this.table(new ItemLootData((ItemLike)ModItems.EGG_S.get(), 0.45f, 0.05f, 0.2f, 0)).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42581_, -4.0f, 1.0f, 0.5f))).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42402_, -3.0f, 2.0f, 1.0f))), new TamedItemLootData((ItemLike)ModItems.EGG_S.get(), 1.0f, 0), new TamedItemLootData((ItemLike)ModItems.EGG_M.get(), 1.0f, 5), new TamedItemLootData((ItemLike)ModItems.EGG_L.get(), 1.0f, 8));
            this.registerLootTable((EntityType)ModEntities.POMME_POMME.get(), this.table(new ItemLootData((ItemLike)Items.f_42410_, 0.7f, 0.05f, 0.7f, 2, true), new ItemLootData((ItemLike)ModItems.BAKED_APPLE.get(), 0.05f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)ModItems.APPLE_SAPLING.get(), 0.05f, 0.005f, 0.2f, 0)), new TamedItemLootData((ItemLike)Items.f_42410_, 1.0f, 0));
            this.registerLootTable((EntityType)ModEntities.TORTAS.get(), this.table(new ItemLootData((ItemLike)ModItems.TURTLE_SHELL.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.f_42416_, 0.65f, 0.05f, 0.5f, 0), new ItemLootData((ItemLike)Items.f_151052_, 0.45f, 0.05f, 0.5f, 0)));
            this.registerLootTable((EntityType)ModEntities.SKY_FISH.get(), this.table(new ItemLootData((ItemLike)ModItems.FISH_FOSSIL.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CAN.get(), 0.03f, 0.005f, 0.1f, 1), new ItemLootData((ItemLike)ModItems.RARE_CAN.get(), 0.005f, 0.001f, 0.1f, 1)));
            this.registerLootTable((EntityType)ModEntities.WEAGLE.get(), this.table(new ItemLootData((ItemLike)Items.f_42402_, 0.5f, 0.05f, 0.55f, 0, true)), new TamedItemLootData((ItemLike)Items.f_42402_, 1.0f, 0));
            this.registerLootTable((EntityType)ModEntities.GOBLIN.get(), this.table(new ItemLootData((ItemLike)ModItems.BLADE_SHARD.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.GLUE.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.OLD_BANDAGE.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.ONIGIRI.get(), 0.07f, 0.05f, 0.2f, 1)));
            this.registerLootTable((EntityType)ModEntities.GOBLIN_ARCHER.get(), this.table(new ItemLootData((ItemLike)ModItems.ARROW_HEAD.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.OLD_BANDAGE.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.f_42403_, 0.7f, 0.05f, 0.7f, 0, true), new ItemLootData((ItemLike)ModItems.RECOVERY_POTION.get(), 0.08f, 0.05f, 0.2f, 2)).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42412_, -2.0f, 2.0f, 1.0f))));
            this.registerLootTable((EntityType)ModEntities.DUCK.get(), this.table(new ItemLootData((ItemLike)ModItems.DOWN_YELLOW.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.f_42402_, 0.8f, 0.05f, 0.6f, 0, true), new ItemLootData((ItemLike)ModItems.FEATHER_YELLOW.get(), 0.01f, 0.005f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.DOWN_YELLOW.get(), 1.0f, 0));
            this.registerLootTable((EntityType)ModEntities.FAIRY.get(), this.table(new ItemLootData((ItemLike)ModItems.FAIRY_DUST.get(), 0.5f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.FAIRY_DUST.get(), 1.0f, 0));
            this.registerLootTable((EntityType)ModEntities.GHOST.get(), this.table(new ItemLootData((ItemLike)ModItems.GHOST_HOOD.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.SKULL.get(), 0.05f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)Items.f_42678_, 0.03f, 0.01f, 0.2f, 1)));
            this.registerLootTable((EntityType)ModEntities.SPIRIT.get(), this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_DARK.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CRYSTAL_MAGIC.get(), 0.33f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.GHOST_RAY.get(), this.table(new ItemLootData((ItemLike)ModItems.GHOST_HOOD.get(), 0.5f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.SKULL.get(), 0.075f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.STICK_THICK.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)Items.f_42678_, 0.05f, 0.01f, 0.2f, 1)));
            this.registerLootTable((EntityType)ModEntities.SPIDER.get(), this.table(new ItemLootData((ItemLike)ModItems.JAW_INSECT.get(), 0.45f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.THREAD_PRETTY.get(), 0.01f, 0.005f, 0.2f, 0), new ItemLootData((ItemLike)Items.f_42401_, 0.7f, 0.05f, 0.75f, 0, true)), new TamedItemLootData((ItemLike)Items.f_42401_, 1.0f, 0));
            this.registerLootTable((EntityType)ModEntities.SHADOW_PANTHER.get(), this.table(new ItemLootData((ItemLike)ModItems.CLAW_PANTHER.get(), 0.45f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FUR.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FUR_QUALITY.get(), 0.35f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.MONSTER_BOX.get(), this.table(new ItemLootData((ItemLike)ModItems.BROKEN_HILT.get(), 0.45f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.BROKEN_BOX.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FAILED_DISH.get(), 0.25f, 0.05f, 0.2f, 1), new ItemLootData((ItemLike)ModItems.DISASTROUS_DISH.get(), 0.05f, 0.01f, 0.2f, 1)));
            this.registerLootTable((EntityType)ModEntities.GOBBLE_BOX.get(), this.table(new ItemLootData((ItemLike)ModItems.BROKEN_HILT.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.BROKEN_BOX.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FAILED_DISH.get(), 0.15f, 0.05f, 0.2f, 1), new ItemLootData((ItemLike)ModItems.DISASTROUS_DISH.get(), 0.1f, 0.005f, 0.2f, 1)));
            this.registerLootTable((EntityType)ModEntities.KILLER_ANT.get(), this.table(new ItemLootData((ItemLike)ModItems.CARAPACE_INSECT.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CARAPACE_PRETTY.get(), 0.15f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.JAW_INSECT.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.f_41837_, 0.75f, 0.05f, 0.8f, 0, true)), new TamedItemLootData((ItemLike)ModItems.CARAPACE_PRETTY.get(), 0.5f, 4));
            this.registerLootTable((EntityType)ModEntities.ORC_HUNTER.get(), this.table(new ItemLootData((ItemLike)Items.f_42403_, 0.6f, 0.05f, 1.0f, 0, true), new ItemLootData((ItemLike)ModItems.ARROW_HEAD.get(), 0.4f, 0.05f, 0.2f, 0)).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42412_, -1.0f, 1.0f, 1.0f)).m_79076_(this.addWithCount((ItemLike)Items.f_42398_, 0.0f, 4.0f, 0.5f))));
            this.registerLootTable((EntityType)ModEntities.HIGH_ORC.get(), this.table(new ItemLootData((ItemLike)ModItems.CHEAP_BRACELET.get(), 0.09f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)ModItems.CLOTH_CHEAP.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.GLUE.get(), 0.3f, 0.05f, 0.2f, 0)).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42398_, 0.0f, 4.0f, 0.5f))));
            this.registerLootTable((EntityType)ModEntities.HORNET.get(), this.table(new ItemLootData((ItemLike)ModItems.CARAPACE_INSECT.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CARAPACE_PRETTY.get(), 0.1f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.JAW_INSECT.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.f_42787_, 0.6f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)Items.f_42787_, 1.0f, 0));
            this.registerLootTable((EntityType)ModEntities.SILVER_WOLF.get(), this.table(new ItemLootData((ItemLike)ModItems.FUR.get(), 0.55f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FUR_QUALITY.get(), 0.15f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FANG_WOLF.get(), 0.25f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.FANG_WOLF.get(), 0.5f, 4));
            this.registerLootTable((EntityType)ModEntities.LEAF_BALL.get(), this.table(new ItemLootData((ItemLike)ModItems.PLANT_STEM.get(), 0.4f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.FURPY.get(), this.table(new ItemLootData((ItemLike)ModItems.FUR.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FUR_QUALITY.get(), 0.2f, 0.01f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.PALM_CAT.get(), this.table(new ItemLootData((ItemLike)ModItems.FUR.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CLAW_PALM.get(), 0.4f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.MINO.get(), this.table(new ItemLootData((ItemLike)ModItems.GRAPES.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.GRAPE_JUICE.get(), 0.05f, 0.01f, 0.2f, 1)));
            this.registerLootTable((EntityType)ModEntities.TRICKY_MUCK.get(), this.table(new ItemLootData((ItemLike)ModItems.SPORE.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.POWDER_POISON.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.MUSHROOM.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.MONARCH_MUSHROOM.get(), 0.008f, 0.01f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.POWDER_POISON.get(), 0.7f, 0));
            this.registerLootTable((EntityType)ModEntities.FLOWER_LILY.get(), this.table(new ItemLootData((ItemLike)ModItems.PLANT_STEM.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.VINE.get(), 0.3f, 0.05f, 0.2f, 0)));
            this.lootTables.put(EntityKingWooly.KING_WOOLY_WOOLED_LOOT, this.table(new ItemLootData((ItemLike)ModItems.FUR_SMALL.get(), 0.4f, 0.05f, 0.2f, 2), new ItemLootData((ItemLike)ModItems.FUR_MEDIUM.get(), 0.2f, 0.05f, 0.2f, 2), new ItemLootData((ItemLike)ModItems.FURBALL.get(), 0.05f, 0.01f, 0.2f, 2), new ItemLootData((ItemLike)Items.f_42574_, 0.01f, 0.01f, 0.0f, 0)).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)((EntityType)ModEntities.WOOLY.get()).m_20677_()))));
            this.tamedDropTable((EntityType)ModEntities.KING_WOOLY.get(), new TamedItemLootData((ItemLike)ModItems.FUR_SMALL.get(), 1.0f, 0), new TamedItemLootData((ItemLike)ModItems.FUR_MEDIUM.get(), 1.0f, 5), new TamedItemLootData((ItemLike)ModItems.FUR_LARGE.get(), 1.0f, 8));
            this.registerLootTable((EntityType)ModEntities.BUFFALOO.get(), this.table(new ItemLootData((ItemLike)ModItems.HORN_BULL.get(), 0.27f, 0.05f, 0.2f, 0)).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42454_, -4.0f, 2.0f, 1.0f))).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_42579_, -5.0f, 3.0f, 1.0f))), new TamedItemLootData((ItemLike)ModItems.HORN_BULL.get(), 0.5f, 0));
            this.registerLootTable((EntityType)ModEntities.GOBLIN_PIRATE.get(), this.table(new ItemLootData((ItemLike)ModItems.CLOTH_QUALITY.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.OIL.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.OLD_BANDAGE.get(), 0.3f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.GOBLIN_GANGSTER.get(), this.table(new ItemLootData((ItemLike)ModItems.CLOTH_QUALITY.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.OIL.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.OLD_BANDAGE.get(), 0.35f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.IGNIS.get(), this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_MAGIC.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CRYSTAL_FIRE.get(), 0.1f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.CRYSTAL_FIRE.get(), 0.4f, 0));
            this.registerLootTable((EntityType)ModEntities.SCORPION.get(), this.table(new ItemLootData((ItemLike)ModItems.TAIL_SCORPION.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CARAPACE_INSECT.get(), 0.3f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.TAIL_SCORPION.get(), 0.6f, 0));
            this.registerLootTable((EntityType)ModEntities.TROLL.get(), this.table(new ItemLootData((ItemLike)ModItems.GIANTS_NAIL.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.GLOVE_GIANT.get(), 0.05f, 0.01f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.FLOWER_LION.get(), this.table(new ItemLootData((ItemLike)ModItems.PLANT_STEM.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.VINE.get(), 0.25f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.TOMATO_GHOST.get(), this.table(new ItemLootData((ItemLike)ModItems.TOMATO_SEEDS.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.TOMATO.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.GHOST_HOOD.get(), 0.2f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.GOBLIN_CAPTAIN.get(), this.table(new ItemLootData((ItemLike)ModItems.CLOTH_QUALITY.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.WARRIORS_PROOF.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.SKULL.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CLOTH_SILK.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.WINE.get(), 0.3f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.GOBLIN_DON.get(), this.table(new ItemLootData((ItemLike)ModItems.OLD_BANDAGE.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.PROOF_OF_RANK.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.SKULL.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.WINE.get(), 0.3f, 0.05f, 0.2f, 0)));
            this.lootTables.put(EntityMineralSqueek.MINERAL_SQUEEK_HURT, new LootTable.Builder().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.STEEL_DOUBLE.get())).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.STEEL_TEN.get())).m_79707_(1))));
            this.registerLootTable((EntityType)ModEntities.NAPPIE.get(), this.table(new ItemLootData((ItemLike)ModItems.PINEAPPLE.get(), 0.6f, 0.05f, 0.5f, 2, true), new ItemLootData((ItemLike)ModItems.PINEAPPLE_JUICE.get(), 0.05f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)ModItems.PINEAPPLE_SEEDS.get(), 0.05f, 0.005f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.PINEAPPLE.get(), 0.5f, 0));
            this.registerLootTable((EntityType)ModEntities.MALM_TIGER.get(), this.table(new ItemLootData((ItemLike)ModItems.PINEAPPLE.get(), 0.6f, 0.05f, 0.5f, 2, true), new ItemLootData((ItemLike)ModItems.PINEAPPLE_JUICE.get(), 0.05f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)ModItems.PINEAPPLE_SEEDS.get(), 0.05f, 0.005f, 0.2f, 0)), new TamedItemLootData((ItemLike)ModItems.PINEAPPLE.get(), 0.5f, 0));
            this.registerLootTable((EntityType)ModEntities.MALM_TIGER.get(), this.table(new ItemLootData((ItemLike)ModItems.FUR.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FUR_QUALITY.get(), 0.2f, 0.1f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CLAW_MALM.get(), 0.3f, 0.1f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.LITTLE_EMPEROR.get(), this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_MAGIC.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.POWDER_MAGIC.get(), 0.2f, 0.1f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CRYSTAL_SMALL.get(), 0.05f, 0.005f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.DEMON.get(), this.table(new ItemLootData((ItemLike)ModItems.DEVIL_BLOOD.get(), 0.25f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.ARCH_DEMON.get(), this.table(new ItemLootData((ItemLike)ModItems.DEVIL_BLOOD.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.HORN_DEVIL.get(), 0.2f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.MINOTAUR.get(), this.table(new ItemLootData((ItemLike)ModItems.HORN_DEVIL.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.HAMMER_PIECE.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.PROTEIN.get(), 0.01f, 0.005f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.MINOTAUR_KING.get(), this.table(new ItemLootData((ItemLike)ModItems.HAMMER_PIECE.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.PROTEIN.get(), 0.01f, 0.005f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.AMBROSIA.get(), this.table(new ItemLootData((ItemLike)ModItems.AMBROSIAS_THORNS.get(), 0.65f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)ModItems.TOYHERB.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.PLANT_STEM.get(), 0.2f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.THUNDERBOLT.get(), this.table(new ItemLootData((ItemLike)ModItems.LIGHTNING_MANE.get(), 0.65f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)ModItems.FUR.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FUR_QUALITY.get(), 0.15f, 0.01f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.MARIONETTA.get(), this.table(new ItemLootData((ItemLike)ModItems.CURSED_DOLL.get(), 0.65f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)ModItems.FUR_SMALL.get(), 0.8f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FUR_MEDIUM.get(), 0.25f, 0.01f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.HANDONETTA.get(), this.table(new ItemLootData((ItemLike)ModItems.PUPPETRY_STRINGS.get(), 0.4f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)ModItems.FUR_SMALL.get(), 0.8f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.FUR_MEDIUM.get(), 0.25f, 0.01f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.DEAD_TREE.get(), this.table(new ItemLootData((ItemLike)ModItems.MOVING_BRANCH.get(), 0.6f, 0.05f, 0.1f, 2, true, false), new ItemLootData((ItemLike)Items.f_42410_, 0.8f, 0.05f, 1.0f, 0, true), new ItemLootData((ItemLike)ModItems.CRYSTAL_SMALL.get(), 0.05f, 0.01f, 0.2f, 2)));
            this.registerLootTable((EntityType)ModEntities.CHIMERA.get(), this.table(new ItemLootData((ItemLike)ModItems.CLAW_CHIMERA.get(), 0.65f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)ModItems.TAIL_CHIMERA.get(), 0.05f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)ModItems.DEVIL_BLOOD.get(), 0.6f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.RACCOON.get(), this.table(new ItemLootData((ItemLike)ModItems.RACCOON_LEAF.get(), 0.65f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)ModItems.UDON.get(), 0.05f, 0.005f, 0.2f, 1), new ItemLootData((ItemLike)ModItems.CURRY_UDON.get(), 0.02f, 0.005f, 0.2f, 1), new ItemLootData((ItemLike)ModItems.TEMPURA_UDON.get(), 0.02f, 0.005f, 0.2f, 1)));
            this.registerLootTable((EntityType)ModEntities.SKELEFANG.get(), this.table(new ItemLootData((ItemLike)ModItems.DRAGON_BONES.get(), 0.4f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)ModItems.FISH_FOSSIL.get(), 0.7f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.SKULL.get(), 0.55f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)ModEntities.RAFFLESIA.get(), this.table(new ItemLootData((ItemLike)ModItems.ROOT.get(), 0.65f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.RAFFLESIA_PETAL.get(), 0.6f, 0.05f, 0.2f, 2, true, false)));
            this.registerLootTable((EntityType)ModEntities.GRIMOIRE.get(), this.table(new ItemLootData((ItemLike)ModItems.FANG_DRAGON.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.SCALE_GRIMOIRE.get(), 0.6f, 0.05f, 0.2f, 2, true, false)));
            this.registerLootTable((EntityType)ModEntities.SANO.get(), this.table(new ItemLootData((ItemLike)ModItems.ROCK_SHARD_LEFT.get(), 0.5f, 0.05f, 0.2f, 1, true, false)).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_41905_, 0.0f, 5.0f, 1.0f))));
            this.registerLootTable((EntityType)ModEntities.UNO.get(), this.table(new ItemLootData((ItemLike)ModItems.ROCK_SHARD_RIGHT.get(), 0.5f, 0.05f, 0.2f, 1, true, false)).m_79161_(this.create().m_79076_(this.addWithCount((ItemLike)Items.f_41905_, 0.0f, 5.0f, 1.0f))));
            this.registerLootTable((EntityType)ModEntities.SARCOPHAGUS.get(), this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_MAGIC.get(), 0.6f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)ModItems.CRYSTAL_SKULL.get(), 0.5f, 0.05f, 0.2f, 1, true, false)));
            this.registerGateLoot();
        }

        private void registerGateLoot() {
            for (EnumElement element : EnumElement.values()) {
                this.lootTables.put(GateEntity.getGateLootLocation(element), this.gateLoot(element));
            }
        }

        private LootTable.Builder gateLoot(EnumElement element) {
            return switch (element) {
                case EnumElement.WATER -> this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_WATER.get(), 0.25f, 0.05f, 0.2f, 2));
                case EnumElement.EARTH -> this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_EARTH.get(), 0.25f, 0.05f, 0.2f, 2));
                case EnumElement.WIND -> this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_WIND.get(), 0.25f, 0.05f, 0.2f, 2));
                case EnumElement.FIRE -> this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_FIRE.get(), 0.25f, 0.05f, 0.2f, 2));
                case EnumElement.LIGHT -> this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_LIGHT.get(), 0.1f, 0.05f, 0.2f, 2));
                case EnumElement.DARK -> this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_DARK.get(), 0.1f, 0.05f, 0.2f, 2));
                case EnumElement.LOVE -> this.table(new ItemLootData((ItemLike)ModItems.CRYSTAL_LOVE.get(), 0.05f, 0.05f, 0.2f, 2));
                default -> this.table(new ItemLootData[0]);
            };
        }

        private LootPool.Builder create() {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
        }

        protected void registerLootTable(EntityType<?> type, LootTable.Builder builder) {
            this.lootTables.put(type.m_20677_(), builder);
        }

        protected void registerLootTable(EntityType<?> type, LootTable.Builder builder, TamedItemLootData ... datas) {
            this.lootTables.put(type.m_20677_(), builder);
            this.tamedDropTable(type, datas);
        }

        private LootTable.Builder table(ItemLootData ... datas) {
            LootTable.Builder builder = new LootTable.Builder();
            for (ItemLootData data : datas) {
                LootPoolSingletonContainer.Builder b = LootItem.m_79579_((ItemLike)data.item);
                if (data.defaultLooting) {
                    ((LootPoolSingletonContainer.Builder)b.m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)data.chance, (float)data.luckBonus))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)data.lootingBonus)).m_80806_(data.max));
                } else {
                    b.m_5577_((LootItemFunction.Builder)new LootingAndLuckLootFunction.Builder((NumberProvider)ConstantValue.m_165692_((float)data.chance)).withLuckBonus((NumberProvider)ConstantValue.m_165692_((float)data.luckBonus)).withLootingBonus((NumberProvider)ConstantValue.m_165692_((float)data.lootingBonus)).limit(data.max));
                }
                if (data.guaranteeFirst) {
                    builder.m_79161_(this.create().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)data.item).m_6509_(FirstKillCondition::new)).m_7170_((LootPoolEntryContainer.Builder)b)));
                    continue;
                }
                builder.m_79161_(this.create().m_79076_((LootPoolEntryContainer.Builder)b));
            }
            return builder;
        }

        private LootPoolSingletonContainer.Builder<?> guaranteeOnFirstKill(ItemLike item, float min, float max, float lootingCountBonus) {
            return LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)lootingCountBonus)));
        }

        private LootPoolSingletonContainer.Builder<?> addWithCount(ItemLike item, float min, float max, float lootingCountBonus) {
            return LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)lootingCountBonus)));
        }

        private void tamedDropTable(EntityType<?> entity, TamedItemLootData ... datas) {
            ResourceLocation def = entity.m_20677_();
            this.tamedDropTable(new ResourceLocation(def.m_135827_(), def.m_135815_() + "_tamed_drops"), datas);
        }

        private void tamedDropTable(ResourceLocation res, TamedItemLootData ... datas) {
            if (datas.length > 1) {
                AlternativesEntry.Builder builder = AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]);
                List<TamedItemLootData> sorted = Arrays.stream(datas).sorted((f, s) -> Integer.compare(s.friendPoints, f.friendPoints)).toList();
                for (TamedItemLootData data : sorted) {
                    LootPoolSingletonContainer.Builder b = (LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)data.item()).m_6509_(FriendPointCondition.of(data.friendPoints()));
                    if (data.chance != 1.0f) {
                        b.m_6509_(LootItemRandomChanceCondition.m_81927_((float)data.chance()));
                    }
                    builder.m_7170_((LootPoolEntryContainer.Builder)b);
                }
                this.lootTables.put(res, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)builder)));
            } else if (datas.length == 1) {
                TamedItemLootData data = datas[0];
                LootPoolEntryContainer.Builder builder = LootItem.m_79579_((ItemLike)data.item()).m_6509_(FriendPointCondition.of(data.friendPoints()));
                if (data.chance != 1.0f) {
                    builder.m_6509_(LootItemRandomChanceCondition.m_81927_((float)data.chance()));
                }
                this.lootTables.put(res, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(builder)));
            }
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> cons) {
            this.init();
            this.lootTables.forEach(cons);
        }

        record ItemLootData(ItemLike item, float chance, float luckBonus, float lootingBonus, int max, boolean guaranteeFirst, boolean defaultLooting) {
            public ItemLootData(ItemLike item, float chance, float lootingBonus, float lootingCountBonus, int lootingCountMax, boolean defaultLooting) {
                this(item, chance, lootingBonus, lootingCountBonus, lootingCountMax, false, defaultLooting);
            }

            public ItemLootData(ItemLike item, float chance, float lootingBonus, float lootingCountBonus, int lootingCountMax) {
                this(item, chance, lootingBonus, lootingCountBonus, lootingCountMax, false);
            }
        }

        record TamedItemLootData(ItemLike item, float chance, int friendPoints) {
        }
    }
}

