/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.data;

import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.forge.data.NPCDataGen;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import org.jetbrains.annotations.Nullable;

public class NPCDialogLangGen
implements DataProvider {
    private final DataGenerator gen;
    private final String modid;
    private final String locale;
    private final NPCDataGen npcDataGen;

    public NPCDialogLangGen(DataGenerator gen, @Nullable NPCDataGen npcDataGen) {
        this.gen = gen;
        this.modid = "runecraftory";
        this.locale = "en_us";
        this.npcDataGen = npcDataGen;
    }

    public void m_6865_(HashCache cache) throws IOException {
        if (this.npcDataGen != null) {
            for (Map.Entry entry : this.npcDataGen.dialogueTranslations.entrySet()) {
                this.save(cache, entry.getValue(), this.gen.m_123916_().resolve("assets/" + this.modid + "/lang/npc_conversations/" + (String)entry.getKey() + "/" + this.locale + ".json"));
            }
        }
    }

    public String m_6055_() {
        return "NPC Dialogue Translation: " + this.locale;
    }

    private void save(HashCache cache, Object object, Path target) throws IOException {
        String data = GsonInstances.GSON.toJson(object);
        data = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)data);
        String hash = DataProvider.f_123918_.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.m_123938_(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.m_123940_(target, hash);
    }
}

