/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.data;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;

public class ParticleGen
implements DataProvider {
    protected final Map<ResourceLocation, List<ResourceLocation>> particleTextures = new LinkedHashMap<ResourceLocation, List<ResourceLocation>>();
    private final DataGenerator generator;

    public ParticleGen(DataGenerator generator) {
        this.generator = generator;
    }

    public void add() {
        this.addTo((ParticleType)ModParticles.SINKING_DUST.get(), new ResourceLocation("generic_5"), new ResourceLocation("generic_6"), new ResourceLocation("generic_7"), new ResourceLocation("generic_6"), new ResourceLocation("generic_5"), new ResourceLocation("generic_4"), new ResourceLocation("generic_3"), new ResourceLocation("generic_2"), new ResourceLocation("generic_1"), new ResourceLocation("generic_0"));
        this.addTo((ParticleType)ModParticles.LIGHT.get());
        this.addTo((ParticleType)ModParticles.SHORT_LIGHT.get(), ModParticles.LIGHT.getID());
        this.addTo((ParticleType)ModParticles.STATIC_LIGHT.get(), ModParticles.LIGHT.getID());
        this.addTo((ParticleType)ModParticles.CIRCLING_LIGHT.get(), ModParticles.LIGHT.getID());
        this.addTo((ParticleType)ModParticles.VORTEX.get(), ModParticles.LIGHT.getID());
        this.addTo((ParticleType)ModParticles.CROSS.get());
        this.addTo((ParticleType)ModParticles.BLINK.get());
        this.addTo((ParticleType)ModParticles.SMOKE.get(), 4);
        this.addTo((ParticleType)ModParticles.WIND.get(), new ResourceLocation("effect_7"), new ResourceLocation("effect_6"), new ResourceLocation("effect_5"), new ResourceLocation("effect_4"), new ResourceLocation("effect_3"), new ResourceLocation("effect_2"), new ResourceLocation("effect_1"), new ResourceLocation("effect_0"));
        this.addTo((ParticleType)ModParticles.SLEEP.get());
        this.addTo((ParticleType)ModParticles.POISON.get());
        this.addTo((ParticleType)ModParticles.PARALYSIS.get(), new ResourceLocation("runecraftory", "paralysis_0"), new ResourceLocation("runecraftory", "paralysis_1"), new ResourceLocation("runecraftory", "paralysis_2"), new ResourceLocation("runecraftory", "paralysis_3"));
        this.addTo((ParticleType)ModParticles.LIGHTNING.get(), new ResourceLocation("runecraftory", "lightning_0"), new ResourceLocation("runecraftory", "lightning_1"), new ResourceLocation("runecraftory", "lightning_2"), new ResourceLocation("runecraftory", "lightning_3"));
        this.addTo((ParticleType)ModParticles.TORNADO.get(), new ResourceLocation("effect_7"), new ResourceLocation("effect_6"), new ResourceLocation("effect_5"), new ResourceLocation("effect_4"), new ResourceLocation("effect_3"), new ResourceLocation("effect_2"), new ResourceLocation("effect_1"), new ResourceLocation("effect_0"));
        this.addTo((ParticleType)ModParticles.RUNEY.get(), new ResourceLocation("runecraftory", "runey_0"), new ResourceLocation("runecraftory", "runey_1"), new ResourceLocation("runecraftory", "runey_2"), new ResourceLocation("runecraftory", "runey_3"));
        this.addTo((ParticleType)ModParticles.SKELEFANG_BONES.get());
        this.addTo((ParticleType)ModParticles.BLOCK.get());
        this.addTo((ParticleType)ModParticles.DURATIONAL_PARTICLE.get(), ModParticles.LIGHT.getID());
    }

    public void m_6865_(HashCache cache) {
        this.particleTextures.clear();
        this.add();
        this.particleTextures.forEach((particle, list) -> {
            Path path = this.getPath((ResourceLocation)particle);
            JsonObject obj = new JsonObject();
            JsonArray textures = new JsonArray();
            list.forEach(res -> textures.add(res.toString()));
            obj.add("textures", (JsonElement)textures);
            try {
                DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public String m_6055_() {
        return "Particle Jsons";
    }

    public void addTo(ParticleType<?> type, ResourceLocation ... textures) {
        this.particleTextures.put(type.getRegistryName(), Arrays.asList(textures));
    }

    public void addTo(ParticleType<?> type) {
        this.particleTextures.put(type.getRegistryName(), Lists.newArrayList((Object[])new ResourceLocation[]{type.getRegistryName()}));
    }

    public void addTo(ParticleType<?> type, int nums) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        ResourceLocation typeRes = type.getRegistryName();
        for (int i = 0; i < nums; ++i) {
            list.add(new ResourceLocation(typeRes.m_135827_(), typeRes.m_135815_() + "_" + i));
        }
        this.particleTextures.put(typeRes, list);
    }

    private Path getPath(ResourceLocation particle) {
        return this.generator.m_123916_().resolve("assets/" + particle.m_135827_() + "/particles/" + particle.m_135815_() + ".json");
    }
}

