/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.data.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.PairCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.registries.ForgeRegistries;

public class Decoder {

    public static class ConfiguredJigsawStructureFeatureData {
        public static final Codec<ConfiguredJigsawStructureFeatureData> CODEC = ForgeRegistries.STRUCTURE_FEATURES.getCodec().dispatch(d -> d.feature, f -> RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapPair((MapCodec)ResourceLocation.f_135803_.fieldOf("start_pool"), (MapCodec)Codec.intRange((int)0, (int)7).fieldOf("size")).codec().fieldOf("config").forGetter(arg -> arg.start), (App)Codec.STRING.fieldOf("biomes").forGetter(d -> "#" + String.valueOf(d.biomes.f_203868_())), (App)Codec.BOOL.optionalFieldOf("adapt_noise", (Object)false).forGetter(arg -> arg.adaptNoise), (App)Codec.simpleMap((Codec)MobCategory.f_21584_, (Codec)StructureSpawnOverride.f_210042_, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])MobCategory.values())).fieldOf("spawn_overrides").forGetter(arg -> arg.spawnOverrides)).apply((Applicative)instance, (start, biomes, noise, override) -> new ConfiguredJigsawStructureFeatureData((StructureFeature<?>)f, (ResourceLocation)start.getFirst(), (Integer)start.getSecond(), (TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(biomes)), (Map<MobCategory, StructureSpawnOverride>)override, (boolean)noise))));
        protected final StructureFeature<?> feature;
        protected final Pair<ResourceLocation, Integer> start;
        protected final TagKey<Biome> biomes;
        protected final Map<MobCategory, StructureSpawnOverride> spawnOverrides;
        protected final boolean adaptNoise;

        public ConfiguredJigsawStructureFeatureData(StructureFeature<?> feature, ResourceLocation startPool, int maxDepth, TagKey<Biome> biomes, Map<MobCategory, StructureSpawnOverride> spawnOverrides, boolean adaptNoise) {
            this.feature = feature;
            this.start = Pair.of((Object)startPool, (Object)maxDepth);
            this.biomes = biomes;
            this.spawnOverrides = spawnOverrides;
            this.adaptNoise = adaptNoise;
        }

        public ConfiguredJigsawStructureFeatureData(StructureFeature<?> feature, ResourceLocation startPool, int maxDepth, TagKey<Biome> biomes, Map<MobCategory, StructureSpawnOverride> spawnOverrides) {
            this(feature, startPool, maxDepth, biomes, spawnOverrides, false);
        }

        public ConfiguredJigsawStructureFeatureData(StructureFeature<?> feature, ResourceLocation startPool, int maxDepth, TagKey<Biome> biomes) {
            this(feature, startPool, maxDepth, biomes, Map.of(), false);
        }
    }

    public static class StructurePoolElementData {
        protected final StructurePoolElementType<?> type;
        public static final Codec<StructurePoolElementData> CODEC = Registry.f_122892_.m_194605_().dispatch("element_type", d -> d.type, StructurePoolElementData::of);
        protected final StructureTemplatePool.Projection projection;
        private static final Map<StructurePoolElementType<?>, Codec<StructurePoolElementData>> CODECS = Map.of(StructurePoolElementType.f_210545_, Codec.unit(StructurePoolElementData::new), StructurePoolElementType.f_210542_, RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("location").forGetter(d -> d.val), StructurePoolElementData.processorsCodec(), StructurePoolElementData.projectionCodec()).apply((Applicative)instance, (l, proc, proj) -> new StructurePoolElementData((StructurePoolElementType<?>)StructurePoolElementType.f_210542_, (ResourceLocation)l, (ResourceLocation)proc, (StructureTemplatePool.Projection)proj))), StructurePoolElementType.f_210546_, RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("location").forGetter(d -> d.val), StructurePoolElementData.processorsCodec(), StructurePoolElementData.projectionCodec()).apply((Applicative)instance, (l, proc, proj) -> new StructurePoolElementData((StructurePoolElementType<?>)StructurePoolElementType.f_210546_, (ResourceLocation)l, (ResourceLocation)proc, (StructureTemplatePool.Projection)proj))), StructurePoolElementType.f_210544_, RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("feature").forGetter(d -> d.val), StructurePoolElementData.processorsCodec(), StructurePoolElementData.projectionCodec()).apply((Applicative)instance, (l, proc, proj) -> new StructurePoolElementData((StructurePoolElementType<?>)StructurePoolElementType.f_210544_, (ResourceLocation)l, (ResourceLocation)proc, (StructureTemplatePool.Projection)proj))), StructurePoolElementType.f_210543_, RecordCodecBuilder.create(instance -> instance.group((App)CODEC.listOf().fieldOf("elements").forGetter(arg -> arg.list)).apply((Applicative)instance, StructurePoolElementData::new)));
        protected final ResourceLocation val;
        protected final ResourceLocation processors;
        protected final List<StructurePoolElementData> list;

        public StructurePoolElementData() {
            this.type = StructurePoolElementType.f_210545_;
            this.projection = null;
            this.val = null;
            this.list = null;
            this.processors = null;
        }

        public StructurePoolElementData(ResourceLocation val, ResourceLocation processors, StructureTemplatePool.Projection projection) {
            this.type = StructurePoolElementType.f_210542_;
            this.val = val;
            this.projection = projection;
            this.list = null;
            this.processors = processors;
        }

        public StructurePoolElementData(StructurePoolElementType<?> type, ResourceLocation val, ResourceLocation processors, StructureTemplatePool.Projection projection) {
            this.type = type;
            this.val = val;
            this.projection = projection;
            this.list = null;
            this.processors = processors;
        }

        public StructurePoolElementData(List<StructurePoolElementData> list) {
            this.type = StructurePoolElementType.f_210543_;
            this.list = list;
            this.projection = null;
            this.val = null;
            this.processors = null;
        }

        private static Codec<StructurePoolElementData> of(StructurePoolElementType<?> type) {
            return CODECS.get(type);
        }

        private static <E extends StructurePoolElementData> RecordCodecBuilder<E, ResourceLocation> processorsCodec() {
            return ResourceLocation.f_135803_.fieldOf("processors").forGetter(d -> d.processors);
        }

        private static <E extends StructurePoolElementData> RecordCodecBuilder<E, StructureTemplatePool.Projection> projectionCodec() {
            return StructureTemplatePool.Projection.f_210593_.fieldOf("projection").forGetter(d -> d.projection);
        }
    }

    public record TemplatePoolData(ResourceLocation name, ResourceLocation fallback, List<Pair<StructurePoolElementData, Integer>> rawTemplates) {
        public static final Codec<TemplatePoolData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(d -> d.name), (App)ResourceLocation.f_135803_.fieldOf("fallback").forGetter(d -> d.fallback), (App)Codec.mapPair((MapCodec)StructurePoolElementData.CODEC.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(arg -> arg.rawTemplates)).apply((Applicative)instance, TemplatePoolData::new));
    }

    public record StructureSetData(List<Pair<ResourceLocation, Integer>> structures, StructurePlacement placement) {
        public static final Codec<StructureSetData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)new PairCodec(ResourceLocation.f_135803_.fieldOf("structure").codec(), ExtraCodecs.f_144629_.fieldOf("weight").codec()).listOf().fieldOf("structures").forGetter(StructureSetData::structures), (App)StructurePlacement.f_205036_.fieldOf("placement").forGetter(StructureSetData::placement)).apply((Applicative)instance, StructureSetData::new));

        public StructureSetData(Pair<ResourceLocation, Integer> pair, StructurePlacement placement) {
            this(List.of(pair), placement);
        }
    }
}

