/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.data.worldgen;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.provider.FileVerifier;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModStructures;
import io.github.flemmli97.runecraftory.common.world.structure.processors.BossSpawnerProcessor;
import io.github.flemmli97.runecraftory.common.world.structure.processors.WaterUnlogProcessor;
import io.github.flemmli97.runecraftory.forge.data.StructureBossGen;
import io.github.flemmli97.runecraftory.forge.data.worldgen.ConfiguredFeatureGen;
import io.github.flemmli97.runecraftory.forge.data.worldgen.ConfiguredStructureFeatureGen;
import io.github.flemmli97.runecraftory.forge.data.worldgen.Decoder;
import io.github.flemmli97.runecraftory.forge.data.worldgen.ProcessorListGen;
import io.github.flemmli97.runecraftory.forge.data.worldgen.StructureSetGen;
import io.github.flemmli97.runecraftory.forge.data.worldgen.TemplatePoolGen;
import java.util.List;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class MainWorldGenData
implements DataProvider {
    private final ConfiguredStructureFeatureGen configuredStructureFeatureGen;
    private final ProcessorListGen processorListGen;
    private final StructureSetGen structureSetGen;
    private final TemplatePoolGen templatePoolGen;
    private final ConfiguredFeatureGen configuredFeatureGen;
    private final FileVerifier verifier;

    public MainWorldGenData(DataGenerator dataGenerator, FileVerifier verifier) {
        this.configuredStructureFeatureGen = new ConfiguredStructureFeatureGen(dataGenerator);
        this.processorListGen = new ProcessorListGen(dataGenerator);
        this.structureSetGen = new StructureSetGen(dataGenerator);
        this.templatePoolGen = new TemplatePoolGen(dataGenerator);
        this.configuredFeatureGen = new ConfiguredFeatureGen(dataGenerator);
        this.verifier = verifier;
    }

    public void m_6865_(HashCache cache) {
        this.addBossStructure(ModStructures.FOREST_GROVE.getID(), (StructurePlacement)new RandomSpreadStructurePlacement(23, 8, RandomSpreadType.LINEAR, 1224466880), (StructureFeature)ModStructures.FOREST_GROVE.get(), (TagKey<Biome>)BiomeTags.f_207611_, true, this.simple(StructureBossGen.FOREST_BOSSES));
        this.addBossStructure(ModStructures.WATER_RUINS.getID(), (StructurePlacement)new RandomSpreadStructurePlacement(32, 16, RandomSpreadType.LINEAR, 1224466881), (StructureFeature)ModStructures.WATER_RUINS.get(), (TagKey<Biome>)BiomeTags.f_207603_, true, this.simple(StructureBossGen.WATER_RUIN_BOSSES));
        this.addBossStructure(ModStructures.THEATER_RUINS.getID(), (StructurePlacement)new RandomSpreadStructurePlacement(21, 7, RandomSpreadType.LINEAR, 1224466882), (StructureFeature)ModStructures.THEATER_RUINS.get(), RunecraftoryTags.IS_SPOOKY, true, new StructureProcessorList(List.of(new BossSpawnerProcessor(StructureBossGen.THEATER_RUIN_BOSSES), WaterUnlogProcessor.INST)));
        this.addBossStructure(ModStructures.PLAINS_ARENA.getID(), (StructurePlacement)new RandomSpreadStructurePlacement(24, 8, RandomSpreadType.LINEAR, 1224466883), (StructureFeature)ModStructures.PLAINS_ARENA.get(), RunecraftoryTags.IS_PLAINS, true, this.simple(StructureBossGen.PLAINS_BOSSES));
        this.addBossStructure(ModStructures.DESERT_ARENA.getID(), (StructurePlacement)new RandomSpreadStructurePlacement(24, 8, RandomSpreadType.LINEAR, 1224466884), (StructureFeature)ModStructures.DESERT_ARENA.get(), RunecraftoryTags.IS_SANDY, true, this.simple(StructureBossGen.DESERT_BOSSES));
        this.addBossStructure(ModStructures.NETHER_ARENA.getID(), (StructurePlacement)new RandomSpreadStructurePlacement(20, 9, RandomSpreadType.LINEAR, 1224466885), (StructureFeature)ModStructures.NETHER_ARENA.get(), (TagKey<Biome>)BiomeTags.f_207612_, true, this.simple(StructureBossGen.NETHER_BOSSES));
        this.addBossStructure(ModStructures.WIND_SHRINE.getID(), (StructurePlacement)new RandomSpreadStructurePlacement(20, 7, RandomSpreadType.LINEAR, 1224466886), (StructureFeature)ModStructures.WIND_SHRINE.get(), RunecraftoryTags.IS_PEAK, true, this.simple(StructureBossGen.WIND_SHRINE_BOSSES));
        this.addBossStructure(ModStructures.LEON_KARNAK.getID(), (StructurePlacement)new RandomSpreadStructurePlacement(21, 8, RandomSpreadType.LINEAR, 1224466887), (StructureFeature)ModStructures.LEON_KARNAK.get(), RunecraftoryTags.IS_PEAK, true, this.simple(StructureBossGen.LEON_KARNAK_BOSSES));
        this.templatePoolGen.runExternal(cache);
        this.processorListGen.runExternal(cache);
        this.configuredStructureFeatureGen.runExternal(cache);
        this.structureSetGen.runExternal(cache);
        this.configuredFeatureGen.runExternal(cache);
    }

    public String m_6055_() {
        return "World Gen";
    }

    protected void addBossStructure(ResourceLocation id, StructurePlacement placement, StructureFeature<?> feature, TagKey<Biome> biomeTag, boolean adapt, StructureProcessorList list) {
        ResourceLocation processorID = new ResourceLocation(id.m_135827_(), id.m_135815_() + "_processor");
        this.processorListGen.addElement(processorID, list);
        this.templatePoolGen.addElement(id, new Decoder.TemplatePoolData(id, new ResourceLocation("empty"), List.of(Pair.of((Object)new Decoder.StructurePoolElementData(id, processorID, StructureTemplatePool.Projection.RIGID), (Object)1))));
        this.structureSetGen.addElement(id, new Decoder.StructureSetData((Pair<ResourceLocation, Integer>)Pair.of((Object)id, (Object)1), placement));
        this.configuredStructureFeatureGen.addElement(id, new Decoder.ConfiguredJigsawStructureFeatureData(feature, id, 1, biomeTag, Map.of(), adapt));
    }

    protected StructureProcessorList simple(ResourceLocation boss) {
        if (!this.verifier.exists(boss, PackType.SERVER_DATA, "runecraftory_bosses")) {
            throw new IllegalStateException("StructureBoss data does not exist");
        }
        return new StructureProcessorList(List.of(new BossSpawnerProcessor(boss)));
    }
}

