/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.data.worldgen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public abstract class WorldGenData<T>
implements DataProvider {
    protected final Map<ResourceLocation, T> elements = new HashMap<ResourceLocation, T>();
    private final ResourceKey<? extends Registry<?>> registryKey;
    private final Codec<T> elementCodec;
    private final DataGenerator generator;

    public WorldGenData(DataGenerator generator, ResourceKey<? extends Registry<?>> registryKey, Codec<T> elementCodec) {
        this.generator = generator;
        this.registryKey = registryKey;
        this.elementCodec = elementCodec;
    }

    protected abstract void gen();

    public T addElement(ResourceLocation res, T e) {
        this.elements.put(res, e);
        return e;
    }

    public void m_6865_(HashCache cache) {
        this.elements.clear();
        this.gen();
        this.elements.forEach((res, e) -> {
            try {
                this.save(cache, (ResourceLocation)res, (T)e);
            }
            catch (IOException ex) {
                RuneCraftory.LOGGER.error((Object)ex);
            }
        });
    }

    public String m_6055_() {
        return String.valueOf(this.registryKey) + " Data Gen";
    }

    public void runExternal(HashCache cache) {
        this.elements.forEach((res, e) -> {
            try {
                this.save(cache, (ResourceLocation)res, (T)e);
            }
            catch (IOException ex) {
                RuneCraftory.LOGGER.error((Object)ex);
            }
        });
    }

    private void save(HashCache cache, ResourceLocation res, T e) throws IOException {
        Path path = this.getPath(res);
        JsonElement obj = (JsonElement)this.elementCodec.encode(e, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).result().orElseThrow();
        DataProvider.m_123920_((Gson)GsonInstances.GSON, (HashCache)cache, (JsonElement)obj, (Path)path);
    }

    protected Path getPath(ResourceLocation id) {
        return this.generator.m_123916_().resolve("data/" + id.m_135827_() + "/" + this.registryKey.m_135782_().m_135815_().replace(":", "/") + "/" + id.m_135815_() + ".json");
    }
}

