/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.event;

import com.mojang.brigadier.CommandDispatcher;
import io.github.flemmli97.runecraftory.client.ClientFarmlandHandler;
import io.github.flemmli97.runecraftory.common.events.WorldCalls;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.forge.capability.ArmorCap;
import io.github.flemmli97.runecraftory.forge.capability.EntityCap;
import io.github.flemmli97.runecraftory.forge.capability.PlayerCap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WorldEvents {
    public static final ResourceLocation PLAYER_CAP = new ResourceLocation("runecraftory", "player_cap");
    public static final ResourceLocation ARMOR_CAP = new ResourceLocation("runecraftory", "armor_cap");
    public static final ResourceLocation ENTITY_CAP = new ResourceLocation("runecraftory", "entity_cap");

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(PLAYER_CAP, (ICapabilityProvider)new PlayerCap(player));
        }
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(ENTITY_CAP, (ICapabilityProvider)new EntityCap());
        }
    }

    @SubscribeEvent
    public void attachCapabilityStack(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).m_41720_() instanceof ArmorItem) {
            event.addCapability(ARMOR_CAP, (ICapabilityProvider)new ArmorCap());
        }
    }

    @SubscribeEvent
    public void command(RegisterCommandsEvent event) {
        WorldCalls.command((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void biomeLoad(BiomeLoadingEvent event) {
        event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GATE.get(), 100, 1, 1));
        WorldCalls.addFeatures((arg_0, arg_1) -> ((BiomeGenerationSettingsBuilder)event.getGeneration()).m_204201_(arg_0, arg_1), event.getCategory());
    }

    @SubscribeEvent
    public void daily(TickEvent.WorldTickEvent e) {
        if (e.phase == TickEvent.Phase.END && e.world.m_46472_().equals((Object)Level.f_46428_)) {
            WorldCalls.daily(e.world);
        }
    }

    @SubscribeEvent
    public void disableVanillaCrop(BlockEvent.CropGrowEvent.Pre event) {
        if (WorldCalls.disableVanillaCrop(event.getWorld(), event.getState(), event.getPos())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            FarmlandHandler.get(level.m_142572_()).onChunkLoad(level, event.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public void onChunkUnLoad(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            FarmlandHandler.get(level.m_142572_()).onChunkUnLoad(level, event.getChunk().m_7697_());
        } else if (event.getWorld().m_5776_()) {
            ClientFarmlandHandler.INSTANCE.onChunkUnLoad(event.getChunk().m_7697_());
        }
    }
}

