/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.integration.jade;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.blocks.BlockMonsterBarn;
import io.github.flemmli97.runecraftory.common.blocks.tile.MonsterBarnBlockEntity;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.MultiPartEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.world.BarnData;
import java.util.UUID;
import mcp.mobius.waila.api.Accessor;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaClientRegistration;
import mcp.mobius.waila.api.IWailaCommonRegistration;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.event.WailaRayTraceEvent;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.impl.ui.BorderStyle;
import mcp.mobius.waila.impl.ui.ProgressElement;
import mcp.mobius.waila.impl.ui.ProgressStyle;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.UsernameCache;
import org.apache.logging.log4j.Logger;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    private static IWailaClientRegistration client;

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((compoundTag, serverPlayer, level, blockEntity, b) -> {
            MonsterBarnBlockEntity barn;
            BarnData data;
            if (blockEntity instanceof MonsterBarnBlockEntity && (data = (barn = (MonsterBarnBlockEntity)((Object)blockEntity)).getBarnData()) != null) {
                compoundTag.m_128379_("Roof", data.hasRoof());
                compoundTag.m_128405_("RoofHeight", data.roofHeight());
                compoundTag.m_128405_("Size", data.getSize());
                compoundTag.m_128405_("Used", data.usedCapacity());
                compoundTag.m_128405_("Capacity", data.getCapacity());
            }
        }, MonsterBarnBlockEntity.class);
        registration.registerEntityDataProvider((compoundTag, player, level, entity, b) -> {
            BaseMonster monster;
            block11: {
                IBaseMob mob;
                block12: {
                    if (!(entity instanceof IBaseMob)) break block11;
                    mob = (IBaseMob)entity;
                    if (player.m_21205_().m_41720_() == ModItems.DEBUG.get() || player.m_7500_()) break block12;
                    if (!(entity instanceof OwnableEntity)) break block11;
                    OwnableEntity ownable = (OwnableEntity)entity;
                    if (!player.m_142081_().equals(ownable.m_142504_())) break block11;
                }
                LevelExpPair entityLevel = mob.level();
                compoundTag.m_128350_("RunecraftoryLevelPerc", entityLevel.getProgress());
                compoundTag.m_128405_("RunecraftoryLevel", entityLevel.getLevel());
            }
            if (entity instanceof BaseMonster && (monster = (BaseMonster)entity).m_142504_() != null) {
                String username = UsernameCache.getLastKnownUsername((UUID)monster.m_142504_());
                if (username == null) {
                    compoundTag.m_128379_("HasUsername", false);
                } else {
                    compoundTag.m_128379_("HasUsername", true);
                    compoundTag.m_128359_("Username", username);
                }
                if (player.m_142081_().equals(monster.m_142504_())) {
                    compoundTag.m_128405_("FP", monster.getFriendlyPoints().getLevel());
                    BarnData barn = monster.getAssignedBarn();
                    if (barn != null) {
                        compoundTag.m_128379_("HasBarn", true);
                        compoundTag.m_128365_("Barn", (Tag)BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)barn.pos.m_122646_()).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)));
                    } else {
                        compoundTag.m_128379_("HasBarn", false);
                    }
                    compoundTag.m_128359_("Behaviour", monster.behaviourState().toString());
                }
            }
            if (entity instanceof EntityNPCBase) {
                EntityNPCBase npc = (EntityNPCBase)entity;
                if (npc.followEntity() != null) {
                    compoundTag.m_128359_("NPCFollow", Component.Serializer.m_130703_((Component)npc.followEntity().m_5446_()));
                }
                compoundTag.m_128405_("FP", npc.friendPoints((Player)player));
            }
        }, Mob.class);
    }

    public static void multipartHandler(WailaRayTraceEvent event) {
        EntityAccessor entityAccessor;
        Entity entity;
        Accessor accessor = event.getAccessor();
        if (accessor instanceof EntityAccessor && (entity = (entityAccessor = (EntityAccessor)accessor).getEntity()) instanceof MultiPartEntity) {
            MultiPartEntity entity2 = (MultiPartEntity)entity;
            accessor = client.createEntityAccessor(entity2.m_142480_(), accessor.getLevel(), accessor.getPlayer(), accessor.getServerData(), (EntityHitResult)entityAccessor.getHitResult(), accessor.isServerConnected());
            event.setAccessor(accessor);
        }
    }

    public void registerClient(IWailaClientRegistration registration) {
        client = registration;
        registration.registerComponentProvider((iTooltip, blockAccessor, iPluginConfig) -> {
            CompoundTag tag = blockAccessor.getServerData();
            if (blockAccessor.getBlockEntity() instanceof MonsterBarnBlockEntity) {
                MutableComponent sizeText;
                int size = tag.m_128451_("Size");
                MutableComponent mutableComponent = sizeText = size > 1 ? new TextComponent("" + size).m_130940_(ChatFormatting.GREEN) : new TextComponent("" + size).m_130940_(ChatFormatting.DARK_RED);
                if (!tag.m_128471_("Roof")) {
                    iTooltip.add((Component)new TranslatableComponent("runecraftory.dependency.tooltips.barn.1", new Object[]{sizeText}));
                } else {
                    iTooltip.add((Component)new TranslatableComponent("runecraftory.dependency.tooltips.barn.1.alt", new Object[]{new TranslatableComponent("" + tag.m_128451_("RoofHeight")).m_130940_(ChatFormatting.YELLOW), sizeText}));
                }
                iTooltip.add((Component)new TranslatableComponent("runecraftory.dependency.tooltips.barn.2", new Object[]{tag.m_128451_("Used"), tag.m_128451_("Capacity")}));
            }
        }, TooltipPosition.BODY, BlockMonsterBarn.class);
        registration.registerComponentProvider((iTooltip, entityAccessor, iPluginConfig) -> {
            BaseMonster monster;
            Entity patt7644$temp;
            CompoundTag tag = entityAccessor.getServerData();
            if (tag.m_128441_("RunecraftoryLevel")) {
                float prog = tag.m_128457_("RunecraftoryLevelPerc");
                int lvl = tag.m_128451_("RunecraftoryLevel");
                iTooltip.add((IElement)new ProgressElement(prog, (Component)new TranslatableComponent("runecraftory.tooltip.item.level", new Object[]{lvl}), (ProgressStyle)new ProgressStyle().color(-15955563, -15955563), (BorderStyle)new BorderStyle().color(-16777216)));
            }
            if ((patt7644$temp = entityAccessor.getEntity()) instanceof BaseMonster && (monster = (BaseMonster)patt7644$temp).m_142504_() != null) {
                if (!tag.m_128471_("HasUsername")) {
                    iTooltip.add((Component)new TranslatableComponent("runecraftory.dependency.tooltips.owner.none").m_130940_(ChatFormatting.YELLOW));
                } else {
                    String username = tag.m_128461_("Username");
                    iTooltip.add((Component)new TranslatableComponent("runecraftory.dependency.tooltips.owner", new Object[]{username}).m_130940_(ChatFormatting.GOLD));
                }
                if (entityAccessor.getPlayer().m_142081_().equals(monster.m_142504_())) {
                    JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.friendpoints", (MutableComponent)new TextComponent("" + tag.m_128451_("FP")), ChatFormatting.YELLOW, new ChatFormatting[0]);
                    if (tag.m_128471_("HasBarn")) {
                        BlockPos pos = (BlockPos)BlockPos.f_121852_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("Barn")).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                        JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.barn", (MutableComponent)new TextComponent(String.format("[%s, %s, %s]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())), ChatFormatting.GREEN, new ChatFormatting[0]);
                    } else {
                        iTooltip.add((Component)new TranslatableComponent("runecraftory.dependency.tooltips.barn.no").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                    }
                    JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.behaviour", (MutableComponent)new TextComponent(tag.m_128461_("Behaviour")), ChatFormatting.YELLOW, new ChatFormatting[0]);
                }
            }
            if (entityAccessor.getEntity() instanceof EntityNPCBase) {
                if (tag.m_128441_("NPCFollow")) {
                    JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.npc.follow", Component.Serializer.m_130701_((String)tag.m_128461_("NPCFollow")), ChatFormatting.YELLOW, new ChatFormatting[0]);
                }
                JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.friendpoints", (MutableComponent)new TextComponent("" + tag.m_128451_("FP")), ChatFormatting.YELLOW, new ChatFormatting[0]);
            }
        }, TooltipPosition.BODY, Mob.class);
    }

    private static void withText(ITooltip tooltip, String key, MutableComponent other, ChatFormatting formatting, ChatFormatting ... main) {
        tooltip.add((Component)new TranslatableComponent(key, new Object[]{other.m_130940_(formatting)}).m_130944_(main));
    }
}

