/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.integration.top;

import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.BarnData;
import java.util.UUID;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.UsernameCache;

public class EntityProbeProvider
implements IProbeInfoEntityProvider {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "entity_provider");

    public String getID() {
        return ID.toString();
    }

    public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, Entity entity, IProbeHitEntityData iProbeHitEntityData) {
        BaseMonster monster;
        block11: {
            IBaseMob mob;
            block12: {
                if (!(entity instanceof IBaseMob)) break block11;
                mob = (IBaseMob)entity;
                if (probeMode == ProbeMode.DEBUG || player.m_21205_().m_41720_() == ModItems.DEBUG.get() || player.m_7500_()) break block12;
                if (!(entity instanceof OwnableEntity)) break block11;
                OwnableEntity ownable = (OwnableEntity)entity;
                if (!player.m_142081_().equals(ownable.m_142504_())) break block11;
            }
            LevelExpPair entityLevel = mob.level();
            probeInfo.progress((int)entityLevel.getXp(), LevelCalc.xpAmountForLevelUp(entityLevel.getLevel()), probeInfo.defaultProgressStyle().width(150).height(12).color(-16777216, -15955563, -15955563, -7631989).alignment(ElementAlignment.ALIGN_CENTER).prefix((Component)new TranslatableComponent("runecraftory.tooltip.item.level", new Object[]{mob.level().getLevel()})).numberFormat(NumberFormat.NONE));
        }
        if (entity instanceof BaseMonster && (monster = (BaseMonster)entity).m_142504_() != null) {
            String username = UsernameCache.getLastKnownUsername((UUID)monster.m_142504_());
            if (username == null) {
                probeInfo.text(CompoundText.create().warning((Component)new TranslatableComponent("runecraftory.dependency.tooltips.owner.none")));
            } else {
                probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text((Component)new TranslatableComponent("runecraftory.dependency.tooltips.owner", new Object[]{username})));
            }
            if (player.m_142081_().equals(monster.m_142504_())) {
                EntityProbeProvider.withText(probeInfo, "runecraftory.dependency.tooltips.friendpoints", (Component)new TextComponent("" + monster.getFriendlyPoints().getLevel()), ChatFormatting.YELLOW);
                BarnData barn = monster.getAssignedBarn();
                if (barn != null) {
                    EntityProbeProvider.withText(probeInfo, "runecraftory.dependency.tooltips.barn", (Component)new TextComponent(String.format("[%s, %s, %s]", barn.pos.m_122646_().m_123341_(), barn.pos.m_122646_().m_123342_(), barn.pos.m_122646_().m_123343_())), ChatFormatting.GREEN);
                } else {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text((Component)new TranslatableComponent("runecraftory.dependency.tooltips.barn.no")));
                }
                EntityProbeProvider.withText(probeInfo, "runecraftory.dependency.tooltips.behaviour", (Component)new TextComponent(String.valueOf((Object)monster.behaviourState())), ChatFormatting.YELLOW);
            }
        }
        if (entity instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)entity;
            if (npc.followEntity() != null) {
                EntityProbeProvider.withText(probeInfo, "runecraftory.dependency.tooltips.npc.follow", npc.followEntity().m_5446_(), ChatFormatting.YELLOW);
            }
            EntityProbeProvider.withText(probeInfo, "runecraftory.dependency.tooltips.friendpoints", (Component)new TextComponent("" + npc.friendPoints(player)), ChatFormatting.YELLOW);
        }
    }

    private static void withText(IProbeInfo info, String main, Component other, ChatFormatting formatting) {
        info.text(CompoundText.create().info((Component)new TranslatableComponent(main, new Object[]{new TextComponent("\u00a7" + formatting.m_178510_()).m_7220_(other)})));
    }
}

