/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class LootTableInjectModifier
extends LootModifier {
    private final ResourceLocation table;

    public LootTableInjectModifier(LootItemCondition[] conditions, ResourceLocation table) {
        super(conditions);
        this.table = table;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        LootTable lootTable = context.m_78940_(this.table);
        lootTable.m_79131_(context, generatedLoot::add);
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<LootTableInjectModifier> {
        public LootTableInjectModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] lootConditions) {
            return new LootTableInjectModifier(lootConditions, new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"loot_table")));
        }

        public JsonObject write(LootTableInjectModifier modifier) {
            JsonObject json = this.makeConditions(modifier.conditions);
            json.addProperty("loot_table", modifier.table.toString());
            return json;
        }
    }
}

