/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.jei;

import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.client.gui.CraftingGui;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.integration.jei.SextupleRecipeCategory;
import io.github.flemmli97.runecraftory.integration.jei.SextupleRecipeTransfer;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.recipes.collect.RecipeTypeData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@REIPluginCompatIgnore
@JeiPlugin
public class JEI
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("runecraftory", "jei_integration");
    public static IJeiRuntime JEI_RUNTIME;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), SextupleRecipeCategory.FORGECATEGORY, (Item)ModItems.ITEM_BLOCK_FORGE.get()), new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), SextupleRecipeCategory.COOKINGCATEGORY, (Item)ModItems.ITEM_BLOCK_COOKING.get()), new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), SextupleRecipeCategory.ARMORCATEGORY, (Item)ModItems.ITEM_BLOCK_ACCESS.get()), new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), SextupleRecipeCategory.CHEMISTRYCATEGORY, (Item)ModItems.ITEM_BLOCK_CHEM.get())});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        if (Minecraft.m_91087_() == null || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        reg.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, ModItems.NOTEX.stream().map(sup -> new ItemStack((ItemLike)sup.get())).toList());
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        reg.addRecipes(SextupleRecipeCategory.FORGECATEGORY, JEI.sorted(manager, (net.minecraft.world.item.crafting.RecipeType)ModCrafting.FORGE.get()));
        reg.addRecipes(SextupleRecipeCategory.ARMORCATEGORY, JEI.sorted(manager, (net.minecraft.world.item.crafting.RecipeType)ModCrafting.ARMOR.get()));
        reg.addRecipes(SextupleRecipeCategory.COOKINGCATEGORY, JEI.sorted(manager, (net.minecraft.world.item.crafting.RecipeType)ModCrafting.COOKING.get()));
        reg.addRecipes(SextupleRecipeCategory.CHEMISTRYCATEGORY, JEI.sorted(manager, (net.minecraft.world.item.crafting.RecipeType)ModCrafting.CHEMISTRY.get()));
    }

    private static <T extends SextupleRecipe> List<T> sorted(RecipeManager manager, net.minecraft.world.item.crafting.RecipeType<T> type) {
        List l = manager.m_44013_(type);
        l.sort(Comparator.comparingInt(SextupleRecipe::getCraftingLevel));
        return l;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(SextupleRecipeCategory.FORGECATEGORY));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(SextupleRecipeCategory.COOKINGCATEGORY));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(SextupleRecipeCategory.ARMORCATEGORY));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(SextupleRecipeCategory.CHEMISTRYCATEGORY));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.ITEM_BLOCK_FORGE.get()), new RecipeType[]{SextupleRecipeCategory.FORGECATEGORY});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.ITEM_BLOCK_ACCESS.get()), new RecipeType[]{SextupleRecipeCategory.ARMORCATEGORY});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.ITEM_BLOCK_COOKING.get()), new RecipeType[]{SextupleRecipeCategory.COOKINGCATEGORY});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.ITEM_BLOCK_CHEM.get()), new RecipeType[]{SextupleRecipeCategory.CHEMISTRYCATEGORY});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEI_RUNTIME = jeiRuntime;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CraftingGui.class, (IGuiContainerHandler)new IGuiContainerHandler<CraftingGui>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(CraftingGui gui, double mouseX, double mouseY) {
                RecipeType<SextupleRecipe> type = switch (gui.type()) {
                    default -> throw new IncompatibleClassChangeError();
                    case EnumCrafting.FORGE -> SextupleRecipeCategory.FORGECATEGORY;
                    case EnumCrafting.COOKING -> SextupleRecipeCategory.COOKINGCATEGORY;
                    case EnumCrafting.ARMOR -> SextupleRecipeCategory.ARMORCATEGORY;
                    case EnumCrafting.CHEM -> SextupleRecipeCategory.CHEMISTRYCATEGORY;
                };
                IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)80, (int)30, (int)26, (int)26, (RecipeType[])new RecipeType[]{type});
                return List.of(clickableArea);
            }
        });
    }

    public static <T> Stream<T> filterLocked(Stream<T> recipes, RecipeTypeData<T> recipeTypeData, IFocusGroup focusGroup) {
        if (recipeTypeData.getRecipeCategory().getRecipeType().equals(SextupleRecipeCategory.FORGECATEGORY) || recipeTypeData.getRecipeCategory().getRecipeType().equals(SextupleRecipeCategory.ARMORCATEGORY) || recipeTypeData.getRecipeCategory().getRecipeType().equals(SextupleRecipeCategory.CHEMISTRYCATEGORY) || recipeTypeData.getRecipeCategory().getRecipeType().equals(SextupleRecipeCategory.COOKINGCATEGORY)) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            boolean ingredient = focusGroup.getFocuses(RecipeIngredientRole.INPUT).findAny().isPresent();
            Predicate<Object> match = arg_0 -> JEI.lambda$filterLocked$2((Player)player, ingredient, arg_0);
            return recipes.filter(match);
        }
        return recipes;
    }

    private static /* synthetic */ boolean lambda$filterLocked$2(Player player, boolean ingredient, Object recipe) {
        return player == null || Platform.INSTANCE.getPlayerData(player).map(cap -> {
            if (ingredient) {
                return cap.getRecipeKeeper().isUnlocked((Recipe)recipe);
            }
            return cap.getRecipeKeeper().isUnlockedForCrafting((Recipe)recipe);
        }).orElse(false) != false;
    }
}

