/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.platform.Platform;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class SextupleRecipeCategory<T extends SextupleRecipe>
implements IRecipeCategory<T> {
    public static final RecipeType<SextupleRecipe> FORGECATEGORY = RecipeType.create((String)"runecraftory", (String)(EnumCrafting.FORGE.getId() + "_category"), SextupleRecipe.class);
    public static final RecipeType<SextupleRecipe> COOKINGCATEGORY = RecipeType.create((String)"runecraftory", (String)(EnumCrafting.COOKING.getId() + "_category"), SextupleRecipe.class);
    public static final RecipeType<SextupleRecipe> ARMORCATEGORY = RecipeType.create((String)"runecraftory", (String)(EnumCrafting.ARMOR.getId() + "_category"), SextupleRecipe.class);
    public static final RecipeType<SextupleRecipe> CHEMISTRYCATEGORY = RecipeType.create((String)"runecraftory", (String)(EnumCrafting.CHEM.getId() + "_category"), SextupleRecipe.class);
    public static final ResourceLocation GUI = new ResourceLocation("runecraftory", "textures/gui/crafting.png");
    private final IDrawable icon;
    private final IDrawable background;
    private final RecipeType<T> recipeType;
    private final TranslatableComponent title;

    public SextupleRecipeCategory(IGuiHelper guiHelper, RecipeType<T> recipeType, Item icon) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)icon));
        this.recipeType = recipeType;
        this.title = new TranslatableComponent("runecraftory.tile.crafting." + this.recipeType.getUid().m_135815_().replace("_category", ""));
        this.background = guiHelper.createDrawable(GUI, 19, 20, 119, 42);
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return this.recipeType.getUid();
    }

    public Class<? extends T> getRecipeClass() {
        return this.recipeType.getRecipeClass();
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        if (recipeSlotsView.getSlotViews(RecipeIngredientRole.RENDER_ONLY).isEmpty()) {
            this.drawLevel(recipe, stack);
        }
    }

    protected void drawLevel(T recipe, PoseStack poseStack) {
        TranslatableComponent level = new TranslatableComponent("runecraftory.recipe_integration.crafting_level", new Object[]{((SextupleRecipe)recipe).getCraftingLevel()});
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        int width = fontRenderer.m_92852_((FormattedText)level);
        fontRenderer.m_92889_(poseStack, (Component)level, (float)(this.background.getWidth() - width - 10), 0.0f, -8355712);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        builder.setShapeless();
        if (Platform.INSTANCE.getPlayerData((Player)player).map(cap -> cap.getRecipeKeeper().isUnlocked((Recipe<?>)recipe)).orElse(false).booleanValue()) {
            for (int i = 0; i < ((SextupleRecipe)recipe).m_7527_().size(); ++i) {
                int x = i % 3;
                int y = i / 3;
                builder.addSlot(RecipeIngredientRole.INPUT, 1 + x * 18, 6 + y * 18).addIngredients((Ingredient)((SextupleRecipe)recipe).m_7527_().get(i));
            }
        } else {
            for (Ingredient ing : ((SextupleRecipe)recipe).m_7527_()) {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(ing);
            }
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 65, 15).addItemStack(new ItemStack((ItemLike)ModItems.UNKNOWN.get()))).addTooltipCallback((view, tooltip) -> {
                tooltip.clear();
                tooltip.add(new TranslatableComponent("runecraftory.recipe_integration.locked"));
            });
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 15).addItemStack(((SextupleRecipe)recipe).m_8043_());
    }
}

