/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.rei;

import dev.architectury.event.EventResult;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.client.gui.CraftingGui;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.integration.rei.SextupleCategory;
import io.github.flemmli97.runecraftory.integration.rei.SextupleDisplay;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class ReiClientPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<SextupleDisplay> FORGING = CategoryIdentifier.of((ResourceLocation)new ResourceLocation("runecraftory", EnumCrafting.FORGE.getId() + "_category"));
    public static final CategoryIdentifier<SextupleDisplay> CHEM = CategoryIdentifier.of((ResourceLocation)new ResourceLocation("runecraftory", EnumCrafting.CHEM.getId() + "chemistry_category"));
    public static final CategoryIdentifier<SextupleDisplay> COOKING = CategoryIdentifier.of((ResourceLocation)new ResourceLocation("runecraftory", EnumCrafting.COOKING.getId() + "cooking_category"));
    public static final CategoryIdentifier<SextupleDisplay> ARMOR = CategoryIdentifier.of((ResourceLocation)new ResourceLocation("runecraftory", EnumCrafting.ARMOR.getId() + "armor_category"));

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new SextupleCategory(EnumCrafting.FORGE, FORGING));
        registry.addWorkstations(FORGING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModItems.ITEM_BLOCK_FORGE.get()))});
        registry.add((DisplayCategory)new SextupleCategory(EnumCrafting.CHEM, CHEM));
        registry.addWorkstations(CHEM, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModItems.ITEM_BLOCK_CHEM.get()))});
        registry.add((DisplayCategory)new SextupleCategory(EnumCrafting.COOKING, COOKING));
        registry.addWorkstations(COOKING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModItems.ITEM_BLOCK_COOKING.get()))});
        registry.add((DisplayCategory)new SextupleCategory(EnumCrafting.ARMOR, ARMOR));
        registry.addWorkstations(ARMOR, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModItems.ITEM_BLOCK_ACCESS.get()))});
    }

    public void registerDisplays(DisplayRegistry registry) {
        for (SextupleRecipe r : ReiClientPlugin.sorted(RecipeManagerContext.getInstance().getRecipeManager(), (RecipeType)ModCrafting.FORGE.get())) {
            registry.add((Display)new SextupleDisplay(r, EnumCrafting.FORGE), (Object)r);
        }
        for (SextupleRecipe r : ReiClientPlugin.sorted(RecipeManagerContext.getInstance().getRecipeManager(), (RecipeType)ModCrafting.ARMOR.get())) {
            registry.add((Display)new SextupleDisplay(r, EnumCrafting.ARMOR), (Object)r);
        }
        for (SextupleRecipe r : ReiClientPlugin.sorted(RecipeManagerContext.getInstance().getRecipeManager(), (RecipeType)ModCrafting.COOKING.get())) {
            registry.add((Display)new SextupleDisplay(r, EnumCrafting.COOKING), (Object)r);
        }
        for (SextupleRecipe r : ReiClientPlugin.sorted(RecipeManagerContext.getInstance().getRecipeManager(), (RecipeType)ModCrafting.CHEMISTRY.get())) {
            registry.add((Display)new SextupleDisplay(r, EnumCrafting.CHEM), (Object)r);
        }
        registry.registerVisibilityPredicate((cat, display) -> {
            if (cat.getCategoryIdentifier().equals(FORGING) || cat.getCategoryIdentifier().equals(ARMOR) || cat.getCategoryIdentifier().equals(COOKING) || cat.getCategoryIdentifier().equals(CHEM)) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null && Platform.INSTANCE.getPlayerData((Player)player).map(cap -> cap.getRecipeKeeper().isUnlockedForCrafting(((SextupleDisplay)display).recipe())).orElse(false).booleanValue()) {
                    return EventResult.pass();
                }
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
    }

    private static <T extends SextupleRecipe> List<T> sorted(RecipeManager manager, RecipeType<T> type) {
        List l = manager.m_44013_(type);
        l.sort(Comparator.comparingInt(SextupleRecipe::getCraftingLevel));
        return l;
    }

    public void registerEntries(EntryRegistry registry) {
        List<Item> list = ModItems.NOTEX.stream().map(Supplier::get).toList();
        registry.removeEntryIf(e -> e.getType() == VanillaEntryTypes.ITEM && list.contains(((ItemStack)e.castValue()).m_41720_()));
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(EnumCrafting.FORGE, new Rectangle(80, 30, 26, 26), FORGING));
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(EnumCrafting.COOKING, new Rectangle(80, 30, 26, 26), COOKING));
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(EnumCrafting.ARMOR, new Rectangle(80, 30, 26, 26), ARMOR));
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(EnumCrafting.CHEM, new Rectangle(80, 30, 26, 26), CHEM));
    }

    private static ClickArea<CraftingGui> clickAreaFor(EnumCrafting type, Rectangle rect, CategoryIdentifier<?> ... categories) {
        return ctx -> {
            CraftingGui screen = (CraftingGui)ctx.getScreen();
            Rectangle rectangle = rect.clone();
            rectangle.translate(screen.getLeft(), screen.getTop());
            if (((CraftingGui)ctx.getScreen()).type() == type && rectangle.contains(ctx.getMousePosition())) {
                return ClickArea.Result.success().categories(Arrays.asList(categories));
            }
            return ClickArea.Result.fail();
        };
    }
}

